/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.gc;

import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValue;
import com.sap.jvm.profiling.snapshot.util.Value;
import java.io.IOException;
import java.util.List;

public class GcEventStatisticValue
implements Value<GcEventStatisticValue> {
    private static final int VERSION = 0;
    private long[] valueData;
    private long[][] valueArrayData;
    private String[] valueStringData;
    private GcStatisticValue statisticData;
    private final List<GcEventStatisticValueElement> valueElements;

    public GcEventStatisticValue(List<GcEventStatisticValueElement> valueElements) {
        this.valueElements = valueElements;
        int size = valueElements.size();
        this.valueData = new long[size];
        this.valueArrayData = new long[size][];
        this.valueStringData = new String[size];
        this.statisticData = GcStatisticValue.EMPTY;
    }

    public GcEventStatisticValue(List<GcEventStatisticValueElement> valueElements, GcStatistic gcStatistic, int eventId) {
        this(valueElements);
        this.statisticData = new GcStatisticValue(gcStatistic);
        GcEventBase event = gcStatistic.getEvents()[eventId];
        block5: for (int i = 0; i < valueElements.size(); ++i) {
            GcEventStatisticValueElement element = valueElements.get(i);
            int type = element.getType();
            switch (type) {
                case 0: 
                case 1: {
                    this.valueData[i] = element.getValue(event);
                    continue block5;
                }
                case 3: {
                    this.valueArrayData[i] = element.getArrayValue(event);
                    continue block5;
                }
                case 2: {
                    this.valueStringData[i] = element.getStringValue(event);
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
    }

    public GcEventStatisticValue(List<GcEventStatisticValueElement> valueElements, Object[] valueData, GcStatisticValue statisticData) {
        this(valueElements);
        this.statisticData = statisticData;
        assert (valueData.length == valueElements.size());
        block5: for (int i = 0; i < valueData.length; ++i) {
            switch (valueElements.get(i).getType()) {
                case 2: {
                    this.valueStringData[i] = (String)valueData[i];
                    continue block5;
                }
                case 0: 
                case 1: {
                    this.valueData[i] = (Long)valueData[i];
                    continue block5;
                }
                case 3: {
                    this.valueArrayData[i] = (long[])valueData[i];
                    continue block5;
                }
                default: {
                    assert (false);
                    continue block5;
                }
            }
        }
    }

    public GcEventStatisticValue(List<GcEventStatisticValueElement> valueElements, ResourceReader reader) throws IOException {
        this(valueElements);
        reader.readVersion(0);
        this.statisticData = new GcStatisticValue(reader);
        int size = valueElements.size();
        block6: for (int i = 0; i < size; ++i) {
            GcEventStatisticValueElement element = valueElements.get(i);
            int type = element.getType();
            switch (type) {
                case 0: {
                    this.valueData[i] = reader.readBoolean() ? 1L : 0L;
                    continue block6;
                }
                case 1: {
                    this.valueData[i] = reader.readInt64();
                    continue block6;
                }
                case 3: {
                    int length = reader.readInt32();
                    this.valueArrayData[i] = new long[length];
                    for (int ii = 0; ii < length; ++ii) {
                        this.valueArrayData[i][ii] = reader.readInt64();
                    }
                    continue block6;
                }
                case 2: {
                    if (!reader.readBoolean()) continue block6;
                    this.valueStringData[i] = reader.readString();
                    continue block6;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        this.statisticData.write(writer);
        int size = this.valueElements.size();
        block6: for (int i = 0; i < size; ++i) {
            GcEventStatisticValueElement element = this.valueElements.get(i);
            int type = element.getType();
            switch (type) {
                case 0: {
                    writer.writeBoolean(this.valueData[i] > 0L);
                    continue block6;
                }
                case 1: {
                    writer.writeInt64(this.valueData[i]);
                    continue block6;
                }
                case 3: {
                    int length = this.valueArrayData[i] == null ? 0 : this.valueArrayData[i].length;
                    writer.writeInt32(length);
                    for (int ii = 0; ii < length; ++ii) {
                        writer.writeInt64(this.valueArrayData[i][ii]);
                    }
                    continue block6;
                }
                case 2: {
                    writer.writeBoolean(this.valueStringData[i] != null);
                    if (this.valueStringData[i] == null) continue block6;
                    writer.writeString(this.valueStringData[i]);
                    continue block6;
                }
                default: {
                    assert (false);
                    continue block6;
                }
            }
        }
    }

    public Object getElementValue(GcEventStatisticValueElement element) {
        int index = this.valueElements.indexOf(element);
        assert (index != -1);
        switch (element.getType()) {
            case 2: {
                return this.valueStringData[index];
            }
            case 0: 
            case 1: {
                return this.valueData[index];
            }
            case 3: {
                return this.valueArrayData[index];
            }
        }
        assert (false);
        return null;
    }

    public GcStatisticValue getGcStatisticData() {
        return this.statisticData;
    }

    @Override
    public GcEventStatisticValue getSum(GcEventStatisticValue toAdd) {
        GcEventStatisticValue result = new GcEventStatisticValue(this.valueElements);
        result.statisticData = this.statisticData.getSum(toAdd.statisticData);
        for (int i = 0; i < this.valueData.length; ++i) {
            result.valueData[i] = this.valueData[i] + toAdd.valueData[i];
        }
        return result;
    }
}

