/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.memory.event.GcDurationEventBase;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventClassunloadingPhase1;
import com.sap.jvm.profiling.memory.event.GcEventClassunloadingPhase2;
import com.sap.jvm.profiling.memory.event.GcEventCmsAbortablePrecleaning;
import com.sap.jvm.profiling.memory.event.GcEventCmsAborted;
import com.sap.jvm.profiling.memory.event.GcEventCmsFinalMarking;
import com.sap.jvm.profiling.memory.event.GcEventCmsInitialMarking;
import com.sap.jvm.profiling.memory.event.GcEventCmsMarking;
import com.sap.jvm.profiling.memory.event.GcEventCmsPrecleaning;
import com.sap.jvm.profiling.memory.event.GcEventCmsSweeping;
import com.sap.jvm.profiling.memory.event.GcEventG1BitmapClearing;
import com.sap.jvm.profiling.memory.event.GcEventG1Cleanup;
import com.sap.jvm.profiling.memory.event.GcEventG1ConcurrentCleanup;
import com.sap.jvm.profiling.memory.event.GcEventG1Counting;
import com.sap.jvm.profiling.memory.event.GcEventG1EmptyRegionsReclaim;
import com.sap.jvm.profiling.memory.event.GcEventG1FinalMarking;
import com.sap.jvm.profiling.memory.event.GcEventG1IncrementalGc;
import com.sap.jvm.profiling.memory.event.GcEventG1InitialMarking;
import com.sap.jvm.profiling.memory.event.GcEventG1MarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcEventG1Marking;
import com.sap.jvm.profiling.memory.event.GcEventG1ParallelFullGc;
import com.sap.jvm.profiling.memory.event.GcEventG1RootScanning;
import com.sap.jvm.profiling.memory.event.GcEventGenerational;
import com.sap.jvm.profiling.memory.event.GcEventParallelGcMarkSweep;
import com.sap.jvm.profiling.memory.event.GcEventParallelGcParallelCompact;
import com.sap.jvm.profiling.memory.event.GcEventParallelGcScavenge;
import com.sap.jvm.profiling.memory.event.GcEventParallelNewGc;
import com.sap.jvm.profiling.memory.event.GcEventParallelSmallGcForcedFullGc;
import com.sap.jvm.profiling.memory.event.GcEventReferenceHandling;
import com.sap.jvm.profiling.memory.event.GcEventSerialNewGc;
import com.sap.jvm.profiling.memory.event.GcEventSkippedGc;
import com.sap.jvm.profiling.memory.event.GcEventTenuredGc;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.memory.event.GcEventYoungGenPromotionFailure;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.snapshot.gc.StatisticValueElement;
import com.sap.jvm.profiling.util.TriPredicate;
import java.util.Arrays;

public enum GcEventStatisticValueElement implements StatisticValueElement
{
    TIME_STAMP(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return event.getTimestamp();
        }
    }),
    EVENT_TYPE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return event.getGcEventType().ordinal();
        }
    }),
    CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcDurationEventBase)event).getCpuTime() * 1000L;
        }
    }),
    DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcDurationEventBase)event).getDuration() * 1000L;
        }
    }),
    PAGE_FAULTS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcDurationEventBase)event).getPageFaults();
        }
    }),
    MAJOR_PAGE_FAULTS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcDurationEventBase)event).getMajorPageFaults();
        }
    }),
    MINOR_PAGE_FAULTS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcDurationEventBase)event).getMinorPageFaults();
        }
    }),
    FULL_GCS_SINCE_CONC_GC(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsAborted)event).getFullGcsSinceConcGc();
        }
    }),
    FULL_GCS_BEFORE_COMPACTION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsAborted)event).getFullGcsBeforeCompaction();
        }
    }),
    IS_USER_REQUESTED(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            return ((GcEventCmsAborted)event).isUserRequested();
        }
    }),
    IS_INCREMENTAL_COLLECTION_WILL_FAIL(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            return ((GcEventCmsAborted)event).isIncrementalCollectionWillFail();
        }
    }),
    IS_CLEAR_SOFTREFS(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            if (event instanceof GcEventCmsAborted) {
                return ((GcEventCmsAborted)event).isClearSoftRefs();
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).isClearSoftRefs();
            }
            if (event instanceof GcEventG1ParallelFullGc) {
                return ((GcEventG1ParallelFullGc)event).isClearSoftRefs();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    AVERAGE_PROMOTED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventParallelSmallGcForcedFullGc)event).getAveragePromoted();
        }
    }),
    SKIPPED_REASON(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventSkippedGc)event).getReason().ordinal();
        }
    }),
    CAUSING_OBJECT_TYPE(new StringGetter(){

        @Override
        public String getStringValue(GcEventBase event) {
            return ((GcEventYoungGenPromotionFailure)event).getCausingObjectType();
        }
    }),
    CAUSING_OBJECT_SIZE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventYoungGenPromotionFailure)event).getCausingObjectSize();
        }
    }),
    LARGEST_CONTIGUOUS_BLOCK_IN_OLD(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventYoungGenPromotionFailure) {
                return ((GcEventYoungGenPromotionFailure)event).getLargestContiguousBlockInOld();
            }
            if (event instanceof GcEventParallelNewGc) {
                return ((GcEventParallelNewGc)event).getLargestContiguousBlockInOld();
            }
            if (event instanceof GcEventSerialNewGc) {
                return ((GcEventSerialNewGc)event).getLargestContiguousBlockInOld();
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getLargestContiguousBlockInOld();
            }
            if (event instanceof GcEventCmsSweeping) {
                return ((GcEventCmsSweeping)event).getLargestContiguousBlockInOld();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    FAILED_PROMOTIONS_COUNT(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventYoungGenPromotionFailure)event).getFailedPromotionsCount();
        }
    }),
    PROMOTION_FAILURE_NR(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventYoungGenPromotionFailure)event).getPromotionFailureNr();
        }
    }),
    FIRST_PROMOTION_FAILURE_TIMESTAMP(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventYoungGenPromotionFailure)event).getFirstPromotionFailureTimestamp();
        }
    }),
    NR_OF_NON_ARRAY_CLASSES_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase1);
            return ((GcEventClassunloadingPhase1)event).getNrOfNonArrayClassesBefore();
        }
    }),
    NR_OF_NON_ARRAY_CLASSES_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase1);
            return ((GcEventClassunloadingPhase1)event).getNrOfNonArrayClassesAfter();
        }
    }),
    NR_OF_UNLOADED_NON_ARRAY_CLASSES(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase1);
            GcEventClassunloadingPhase1 cue = (GcEventClassunloadingPhase1)event;
            return cue.getNrOfNonArrayClassesBefore() - cue.getNrOfNonArrayClassesAfter();
        }
    }),
    NR_OF_ARRAY_CLASSES_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase1);
            return ((GcEventClassunloadingPhase1)event).getNrOfArrayClassesBefore();
        }
    }),
    NR_OF_ARRAY_CLASSES_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase1);
            return ((GcEventClassunloadingPhase1)event).getNrOfArrayClassesAfter();
        }
    }),
    NR_OF_UNLOADED_ARRAY_CLASSES(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase1);
            GcEventClassunloadingPhase1 cue = (GcEventClassunloadingPhase1)event;
            return cue.getNrOfArrayClassesBefore() - cue.getNrOfArrayClassesAfter();
        }
    }),
    METASPACE_USED_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            return ((GcEventClassunloadingPhase2)event).getMetaspaceUsedBefore();
        }
    }),
    METASPACE_USED_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            return ((GcEventClassunloadingPhase2)event).getMetaspaceUsedAfter();
        }
    }),
    METASPACE_USED_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            GcEventClassunloadingPhase2 clunl = (GcEventClassunloadingPhase2)event;
            return clunl.getMetaspaceUsedAfter() - clunl.getMetaspaceUsedBefore();
        }
    }),
    BYTES_FREED_IN_METASPACE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            GcEventClassunloadingPhase2 clunl = (GcEventClassunloadingPhase2)event;
            return clunl.getMetaspaceUsedBefore() - clunl.getMetaspaceUsedAfter();
        }
    }),
    METASPACE_COMMITTED_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            return ((GcEventClassunloadingPhase2)event).getMetaspaceCommittedBefore();
        }
    }),
    METASPACE_COMMITTED_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            return ((GcEventClassunloadingPhase2)event).getMetaspaceCommittedAfter();
        }
    }),
    BYTES_COMMITTED_IN_METASPACE_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            GcEventClassunloadingPhase2 clunl = (GcEventClassunloadingPhase2)event;
            return clunl.getMetaspaceCommittedAfter() - clunl.getMetaspaceCommittedBefore();
        }
    }),
    CLASS_SPACE_USED_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            return ((GcEventClassunloadingPhase2)event).getClassSpaceUsedBefore();
        }
    }),
    CLASS_SPACE_USED_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            return ((GcEventClassunloadingPhase2)event).getClassSpaceUsedAfter();
        }
    }),
    CLASS_SPACE_USED_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            GcEventClassunloadingPhase2 clunl = (GcEventClassunloadingPhase2)event;
            return clunl.getClassSpaceUsedAfter() - clunl.getClassSpaceUsedBefore();
        }
    }),
    BYTES_FREED_IN_CLASS_SPACE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            GcEventClassunloadingPhase2 clunl = (GcEventClassunloadingPhase2)event;
            return clunl.getClassSpaceUsedBefore() - clunl.getClassSpaceUsedAfter();
        }
    }),
    CLASS_SPACE_COMMITTED_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            return ((GcEventClassunloadingPhase2)event).getClassSpaceCommittedBefore();
        }
    }),
    CLASS_SPACE_COMMITTED_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            return ((GcEventClassunloadingPhase2)event).getClassSpaceCommittedAfter();
        }
    }),
    BYTES_COMMITTED_IN_CLASS_SPACE_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            assert (event instanceof GcEventClassunloadingPhase2);
            GcEventClassunloadingPhase2 clunl = (GcEventClassunloadingPhase2)event;
            return clunl.getClassSpaceCommittedAfter() - clunl.getClassSpaceCommittedBefore();
        }
    }),
    SOFT_REFERENCE_MAX_LAST_USED_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getSoftReferenceMaxLastUsedTime() * 1000000L;
        }
    }),
    SOFT_REFERENCES_FOUND(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getSoftReferencesFound();
        }
    }),
    SOFT_REFERENCES_RESURRECTED_BY_POLICY(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getSoftReferencesResurrectedByPolicy();
        }
    }),
    SOFT_REFERENCES_CLEARED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getSoftReferencesCleared();
        }
    }),
    SOFT_REFERENCES_NOT_CLEARED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getSoftReferencesNotCleared();
        }
    }),
    SOFT_REFERENCES_LIVE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventReferenceHandling rh = (GcEventReferenceHandling)event;
            return rh.getSoftReferencesFound() - rh.getSoftReferencesCleared() - rh.getSoftReferencesNotCleared();
        }
    }),
    SOFT_REFERENCES_ENQUEUED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getSoftReferencesEnqueued();
        }
    }),
    SOFT_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getSoftReferencesFoundInSoftReferenceHandling();
        }
    }),
    WEAK_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getWeakReferencesFoundInSoftReferenceHandling();
        }
    }),
    FINAL_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getFinalReferencesFoundInSoftReferenceHandling();
        }
    }),
    PHANTOM_REFERENCES_FOUND_IN_SOFT_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getPhantomReferencesFoundInSoftReferenceHandling();
        }
    }),
    WEAK_REFERENCES_FOUND(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getWeakReferencesFound();
        }
    }),
    WEAK_REFERENCES_CLEARED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getWeakReferencesCleared();
        }
    }),
    WEAK_REFERENCES_LIVE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventReferenceHandling rh = (GcEventReferenceHandling)event;
            return rh.getWeakReferencesFound() - rh.getWeakReferencesCleared();
        }
    }),
    WEAK_REFERENCES_ENQUEUED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getWeakReferencesEnqueued();
        }
    }),
    FINAL_REFERENCES_FOUND(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getFinalReferencesFound();
        }
    }),
    FINAL_REFERENCES_LIVE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventReferenceHandling rh = (GcEventReferenceHandling)event;
            return rh.getFinalReferencesFound() - rh.getFinalReferencesEnqueued();
        }
    }),
    FINAL_REFERENCES_ENQUEUED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getFinalReferencesEnqueued();
        }
    }),
    SOFT_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getSoftReferencesFoundInFinalReferenceHandling();
        }
    }),
    WEAK_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getWeakReferencesFoundInFinalReferenceHandling();
        }
    }),
    FINAL_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getFinalReferencesFoundInFinalReferenceHandling();
        }
    }),
    PHANTOM_REFERENCES_FOUND_IN_FINAL_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getPhantomReferencesFoundInFinalReferenceHandling();
        }
    }),
    PHANTOM_REFERENCES_FOUND(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getPhantomReferencesFound();
        }
    }),
    PHANTOM_REFERENCES_LIVE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventReferenceHandling rh = (GcEventReferenceHandling)event;
            return rh.getPhantomReferencesFound() - rh.getPhantomReferencesEnqueued();
        }
    }),
    PHANTOM_REFERENCES_ENQUEUED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getPhantomReferencesEnqueued();
        }
    }),
    SOFT_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getSoftReferencesFoundInPhantomReferenceHandling();
        }
    }),
    WEAK_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getWeakReferencesFoundInPhantomReferenceHandling();
        }
    }),
    FINAL_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getFinalReferencesFoundInPhantomReferenceHandling();
        }
    }),
    PHANTOM_REFERENCES_FOUND_IN_PHANTOM_REFERENCE_HANDLING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getPhantomReferencesFoundInPhantomReferenceHandling();
        }
    }),
    SOFT_REFERENCES_FOUND_IN_PREPROCESSING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventReferenceHandling) {
                return ((GcEventReferenceHandling)event).getSoftReferencesFoundInPreprocessing();
            }
            if (event instanceof GcEventCmsAbortablePrecleaning) {
                return ((GcEventCmsAbortablePrecleaning)event).getSoftReferencesFoundInPreprocessing();
            }
            if (event instanceof GcEventCmsPrecleaning) {
                return ((GcEventCmsPrecleaning)event).getSoftReferencesFoundInPreprocessing();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    DEAD_SOFT_REFERENCES_FOUND_IN_PREPROCESSING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventReferenceHandling) {
                return ((GcEventReferenceHandling)event).getDeadSoftReferencesFoundInPreprocessing();
            }
            if (event instanceof GcEventCmsAbortablePrecleaning) {
                return ((GcEventCmsAbortablePrecleaning)event).getDeadSoftReferencesFoundInPreprocessing();
            }
            if (event instanceof GcEventCmsPrecleaning) {
                return ((GcEventCmsPrecleaning)event).getDeadSoftReferencesFoundInPreprocessing();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    SOFT_REFERENCES_RESURRECTED_IN_PREPROCESSING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventReferenceHandling) {
                return ((GcEventReferenceHandling)event).getSoftReferencesResurrectedInPreprocessing();
            }
            if (event instanceof GcEventCmsAbortablePrecleaning) {
                return ((GcEventCmsAbortablePrecleaning)event).getSoftReferencesResurrectedInPreprocessing();
            }
            if (event instanceof GcEventCmsPrecleaning) {
                return ((GcEventCmsPrecleaning)event).getSoftReferencesResurrectedInPreprocessing();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    SOFT_REFERENCE_HANDLING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getSoftReferenceHandlingDuration() * 1000L;
        }
    }),
    SOFT_REFERENCE_HANDLING_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getSoftReferenceHandlingCpuTime() * 1000L;
        }
    }),
    WEAK_REFERENCE_HANDLING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getWeakReferenceHandlingDuration() * 1000L;
        }
    }),
    WEAK_REFERENCE_HANDLING_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getWeakReferenceHandlingCpuTime() * 1000L;
        }
    }),
    FINAL_REFERENCE_HANDLING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getFinalReferenceHandlingDuration() * 1000L;
        }
    }),
    FINAL_REFERENCE_HANDLING_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getFinalReferenceHandlingCpuTime() * 1000L;
        }
    }),
    PHANTOM_REFERENCE_HANDLING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getPhantomReferenceHandlingDuration() * 1000L;
        }
    }),
    PHANTOM_REFERENCE_HANDLING_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getPhantomReferenceHandlingCpuTime() * 1000L;
        }
    }),
    JNIWEAK_REFERENCE_HANDLING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getJNIWeakReferenceHandlingDuration() * 1000L;
        }
    }),
    JNIWEAK_REFERENCE_HANDLING_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getJNIWeakReferenceHandlingCpuTime() * 1000L;
        }
    }),
    TRANSITION_TO_SINGLE_THREADING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getTransitionToSingleThreadingDuration() * 1000L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 3)),
    TRANSITION_TO_SINGLE_THREADING_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getTransitionToSingleThreadingCpuTime() * 1000L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 3)),
    JNIWEAK_REFS_ALIVE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getJNIWeakRefsAlive();
        }
    }),
    JNIWEAK_REFS_DEADS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventReferenceHandling)event).getJNIWeakRefsDeads();
        }
    }),
    BYTES_IN_EDEN_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventGenerational)event).getBytesInEdenBefore();
        }
    }),
    BYTES_IN_EDEN_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventGenerational)event).getBytesInEdenAfter();
        }
    }),
    BYTES_IN_EDEN_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            return gen.getBytesInEdenAfter() - gen.getBytesInEdenBefore();
        }
    }),
    FREED_IN_EDEN(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            return gen.getBytesInEdenBefore() - gen.getBytesInEdenAfter();
        }
    }),
    BYTES_IN_FROM_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventGenerational)event).getBytesInFromBefore();
        }
    }),
    BYTES_IN_FROM_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventGenerational)event).getBytesInFromAfter();
        }
    }),
    BYTES_IN_FROM_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            return gen.getBytesInFromAfter() - gen.getBytesInFromBefore();
        }
    }),
    FREED_IN_FROM(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            return gen.getBytesInFromBefore() - gen.getBytesInFromAfter();
        }
    }),
    BYTES_IN_TO_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventGenerational)event).getBytesInToBefore();
        }
    }),
    BYTES_IN_TO_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventGenerational)event).getBytesInToAfter();
        }
    }),
    BYTES_IN_TO_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            return gen.getBytesInToAfter() - gen.getBytesInToBefore();
        }
    }),
    FREED_IN_TO(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            return gen.getBytesInToBefore() - gen.getBytesInToAfter();
        }
    }),
    BYTES_IN_YOUNG_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            return gen.getBytesInEdenBefore() + gen.getBytesInFromBefore() + gen.getBytesInToBefore();
        }
    }),
    BYTES_IN_YOUNG_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            return gen.getBytesInEdenAfter() + gen.getBytesInFromAfter() + gen.getBytesInToAfter();
        }
    }),
    BYTES_IN_YOUNG_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            return gen.getBytesInEdenAfter() + gen.getBytesInFromAfter() + gen.getBytesInToAfter() - (gen.getBytesInEdenBefore() + gen.getBytesInFromBefore() + gen.getBytesInToBefore());
        }
    }),
    FREED_IN_YOUNG(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            long before = gen.getBytesInEdenBefore() + gen.getBytesInFromBefore() + gen.getBytesInToBefore();
            long after = gen.getBytesInEdenAfter() + gen.getBytesInFromAfter() + gen.getBytesInToAfter();
            return before - after;
        }
    }),
    BYTES_IN_OLD_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventGenerational)event).getBytesInOldBefore();
        }
    }),
    BYTES_IN_OLD(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsInitialMarking)event).getBytesInOld();
        }
    }),
    BYTES_IN_OLD_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventGenerational)event).getBytesInOldAfter();
        }
    }),
    BYTES_IN_OLD_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            return gen.getBytesInOldAfter() - gen.getBytesInOldBefore();
        }
    }),
    BYTES_FREED_IN_OLD(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventGenerational) {
                GcEventGenerational gen = (GcEventGenerational)event;
                return gen.getBytesInOldBefore() - gen.getBytesInOldAfter();
            }
            if (event instanceof GcEventCmsSweeping) {
                return ((GcEventCmsSweeping)event).getBytesFreedInOld();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    BYTES_IN_PERM_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventGenerational)event).getBytesInPermBefore();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 1)),
    PERM_USED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsInitialMarking)event).getPermUsed();
        }
    }),
    BYTES_IN_PERM_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventGenerational)event).getBytesInPermAfter();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 1)),
    BYTES_IN_PERM_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            GcEventGenerational gen = (GcEventGenerational)event;
            return gen.getBytesInPermAfter() - gen.getBytesInPermBefore();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 1)),
    BYTES_FREED_IN_PERM(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventGenerational) {
                GcEventGenerational gen = (GcEventGenerational)event;
                return gen.getBytesInPermBefore() - gen.getBytesInPermAfter();
            }
            if (event instanceof GcEventCmsSweeping) {
                return ((GcEventCmsSweeping)event).getBytesFreedInPerm();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 1)),
    SYSTEM_LOAD_AVERAGE(new LongArrayGetter(){

        @Override
        public long[] getArrayValue(GcEventBase event) {
            double[] load = GcEventStatisticValueElement.getLoad(event);
            long[] result = new long[load.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Math.round(load[i] * 1000.0);
            }
            return result;
        }
    }),
    SYSTEM_LOAD_1MIN_AVERAGE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            double[] load = GcEventStatisticValueElement.getLoad(event);
            return Math.round(load[0] * 1000.0);
        }
    }),
    SYSTEM_LOAD_5MIN_AVERAGE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            double[] load = GcEventStatisticValueElement.getLoad(event);
            return Math.round(load[1] * 1000.0);
        }
    }),
    SYSTEM_LOAD_15MIN_AVERAGE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            double[] load = GcEventStatisticValueElement.getLoad(event);
            return Math.round(load[2] * 1000.0);
        }
    }),
    VIRTUAL_CPU_UTILIZATION(new LongArrayGetter(){

        @Override
        public long[] getArrayValue(GcEventBase event) {
            double[] values;
            if (event instanceof GcEventGenerational) {
                values = ((GcEventGenerational)event).getVirtualCpuUtilization();
            } else if (event instanceof GcEventCmsFinalMarking) {
                values = ((GcEventCmsFinalMarking)event).getVirtualCpuUtilization();
            } else if (event instanceof GcEventCmsInitialMarking) {
                values = ((GcEventCmsInitialMarking)event).getVirtualCpuUtilization();
            } else if (event instanceof GcEventG1Cleanup) {
                values = ((GcEventG1Cleanup)event).getVirtualCpuUtilization();
            } else if (event instanceof GcEventG1EmptyRegionsReclaim) {
                values = ((GcEventG1EmptyRegionsReclaim)event).getVirtualCpuUtilization();
            } else if (event instanceof GcEventG1FinalMarking) {
                values = ((GcEventG1FinalMarking)event).getVirtualCpuUtilization();
            } else if (event instanceof GcEventG1InitialMarking) {
                values = ((GcEventG1InitialMarking)event).getVirtualCpuUtilization();
            } else {
                throw new IllegalArgumentException("Illegal event type for this attribute!");
            }
            boolean virtualization = false;
            long[] result = new long[values.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = Math.round(values[i] * 1000.0);
                if (!(values[i] >= 0.0)) continue;
                virtualization = true;
            }
            return (long[])(virtualization ? result : null);
        }
    }),
    CLEAR_SOFTREFS(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).isClearSoftRefs();
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).isClearSoftRefs();
            }
            if (event instanceof GcEventParallelNewGc) {
                return ((GcEventParallelNewGc)event).isClearSoftRefs();
            }
            if (event instanceof GcEventSerialNewGc) {
                return ((GcEventSerialNewGc)event).isClearSoftRefs();
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).isClearSoftRefs();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    NR_OF_UNLOADED_CLASSES(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getNrOfUnloadedClasses();
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getNrOfUnloadedClasses();
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getNrOfUnloadedClasses();
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getNrOfUnloadedClasses();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 1)),
    ALLOWED_NON_PERM_DEAD_SPACE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getAllowedNonPermDeadSpace();
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getAllowedNonPermDeadSpace();
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getAllowedNonPermDeadSpace();
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getAllowedNonPermDeadSpace();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    USED_NON_PERM_DEAD_SPACE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getUsedNonPermDeadSpace();
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getUsedNonPermDeadSpace();
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getUsedNonPermDeadSpace();
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getUsedNonPermDeadSpace();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    ALLOWED_PERM_DEAD_SPACE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getAllowedPermDeadSpace();
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getAllowedPermDeadSpace();
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getAllowedPermDeadSpace();
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getAllowedPermDeadSpace();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> !session.getSystemInfo().hasMetaspace())),
    USED_PERM_DEAD_SPACE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getUsedPermDeadSpace();
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getUsedPermDeadSpace();
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getUsedPermDeadSpace();
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getUsedPermDeadSpace();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> !session.getSystemInfo().hasMetaspace())),
    PHASE_1_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getPhase1Duration() * 1000L;
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getPhase1Duration() * 1000L;
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getPhase1Duration() * 1000L;
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getPhase1Duration() * 1000L;
            }
            if (event instanceof GcEventG1ParallelFullGc) {
                return ((GcEventG1ParallelFullGc)event).getPhase1Duration() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    PHASE_1_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getPhase1CpuTime() * 1000L;
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getPhase1CpuTime() * 1000L;
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getPhase1CpuTime() * 1000L;
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getPhase1CpuTime() * 1000L;
            }
            if (event instanceof GcEventG1ParallelFullGc) {
                return ((GcEventG1ParallelFullGc)event).getPhase1CpuTime() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    PHASE_2_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getPhase2Duration() * 1000L;
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getPhase2Duration() * 1000L;
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getPhase2Duration() * 1000L;
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getPhase2Duration() * 1000L;
            }
            if (event instanceof GcEventG1ParallelFullGc) {
                return ((GcEventG1ParallelFullGc)event).getPhase2Duration() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    PHASE_2_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getPhase2CpuTime() * 1000L;
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getPhase2CpuTime() * 1000L;
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getPhase2CpuTime() * 1000L;
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getPhase2CpuTime() * 1000L;
            }
            if (event instanceof GcEventG1ParallelFullGc) {
                return ((GcEventG1ParallelFullGc)event).getPhase2CpuTime() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    PHASE_3_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getPhase3Duration() * 1000L;
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getPhase3Duration() * 1000L;
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getPhase3Duration() * 1000L;
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getPhase3Duration() * 1000L;
            }
            if (event instanceof GcEventG1ParallelFullGc) {
                return ((GcEventG1ParallelFullGc)event).getPhase3Duration() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    PHASE_3_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getPhase3CpuTime() * 1000L;
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getPhase3CpuTime() * 1000L;
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getPhase3CpuTime() * 1000L;
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getPhase3CpuTime() * 1000L;
            }
            if (event instanceof GcEventG1ParallelFullGc) {
                return ((GcEventG1ParallelFullGc)event).getPhase3CpuTime() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    PHASE_4_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getPhase4Duration() * 1000L;
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getPhase4Duration() * 1000L;
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getPhase4Duration() * 1000L;
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getPhase4Duration() * 1000L;
            }
            if (event instanceof GcEventG1ParallelFullGc) {
                return ((GcEventG1ParallelFullGc)event).getPhase4Duration() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    PHASE_4_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcMarkSweep) {
                return ((GcEventParallelGcMarkSweep)event).getPhase4CpuTime() * 1000L;
            }
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getPhase4CpuTime() * 1000L;
            }
            if (event instanceof GcEventTenuredGc) {
                return ((GcEventTenuredGc)event).getPhase4CpuTime() * 1000L;
            }
            if (event instanceof GcEventG1MarkSweepGc) {
                return ((GcEventG1MarkSweepGc)event).getPhase4CpuTime() * 1000L;
            }
            if (event instanceof GcEventG1ParallelFullGc) {
                return ((GcEventG1ParallelFullGc)event).getPhase4CpuTime() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    NR_OF_PARALLEL_COMPACT_THREADS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventParallelGcParallelCompact)event).getNrOfParallelCompactThreads();
        }
    }),
    SUCCESSFUL_STEALS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getSuccessfulSteals();
            }
            if (event instanceof GcEventParallelGcScavenge) {
                return ((GcEventParallelGcScavenge)event).getSuccessfulSteals();
            }
            if (event instanceof GcEventParallelNewGc) {
                return ((GcEventParallelNewGc)event).getSuccessfulSteals();
            }
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getSuccessfulSteals();
            }
            if (event instanceof GcEventCmsMarking) {
                return ((GcEventCmsMarking)event).getSuccessfulSteals();
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).getSuccessfulSteals();
            }
            if (event instanceof GcEventG1Marking) {
                return ((GcEventG1Marking)event).getSuccessfulSteals();
            }
            if (event instanceof GcEventG1IncrementalGc) {
                return ((GcEventG1IncrementalGc)event).getSuccessfulSteals();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    FAILED_STEALS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getFailedSteals();
            }
            if (event instanceof GcEventParallelGcScavenge) {
                return ((GcEventParallelGcScavenge)event).getFailedSteals();
            }
            if (event instanceof GcEventParallelNewGc) {
                return ((GcEventParallelNewGc)event).getFailedSteals();
            }
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getFailedSteals();
            }
            if (event instanceof GcEventCmsMarking) {
                return ((GcEventCmsMarking)event).getFailedSteals();
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).getFailedSteals();
            }
            if (event instanceof GcEventG1Marking) {
                return ((GcEventG1Marking)event).getFailedSteals();
            }
            if (event instanceof GcEventG1IncrementalGc) {
                return ((GcEventG1IncrementalGc)event).getFailedSteals();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    FAILED_STEALS_WITH_YIELD(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcParallelCompact) {
                return ((GcEventParallelGcParallelCompact)event).getFailedStealsWithYield();
            }
            if (event instanceof GcEventParallelGcScavenge) {
                return ((GcEventParallelGcScavenge)event).getFailedStealsWithYield();
            }
            if (event instanceof GcEventParallelNewGc) {
                return ((GcEventParallelNewGc)event).getFailedStealsWithYield();
            }
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getFailedStealsWithYield();
            }
            if (event instanceof GcEventCmsMarking) {
                return ((GcEventCmsMarking)event).getFailedStealsWithYield();
            }
            if (event instanceof GcEventG1IncrementalGc) {
                return ((GcEventG1IncrementalGc)event).getFailedStealsWithYield();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    IS_PROMOTION_FAILED(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            if (event instanceof GcEventParallelGcScavenge) {
                return ((GcEventParallelGcScavenge)event).isPromotionFailed();
            }
            if (event instanceof GcEventParallelNewGc) {
                return ((GcEventParallelNewGc)event).isPromotionFailed();
            }
            if (event instanceof GcEventSerialNewGc) {
                return ((GcEventSerialNewGc)event).isPromotionFailed();
            }
            if (event instanceof GcEventG1IncrementalGc) {
                return ((GcEventG1IncrementalGc)event).isPromotionFailed();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    PLABSIZE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelGcScavenge) {
                return ((GcEventParallelGcScavenge)event).getPLABSize();
            }
            if (event instanceof GcEventParallelNewGc) {
                return ((GcEventParallelNewGc)event).getPLABSize();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    AGE_SIZES(new LongArrayGetter(){

        @Override
        public long[] getArrayValue(GcEventBase event) {
            int[] ageSizes = null;
            if (event instanceof GcEventParallelGcScavenge) {
                ageSizes = ((GcEventParallelGcScavenge)event).getAgeSizes();
            } else if (event instanceof GcEventParallelNewGc) {
                ageSizes = ((GcEventParallelNewGc)event).getAgeSizes();
            } else if (event instanceof GcEventSerialNewGc) {
                ageSizes = ((GcEventSerialNewGc)event).getAgeSizes();
            } else if (event instanceof GcEventG1IncrementalGc) {
                ageSizes = ((GcEventG1IncrementalGc)event).getAgeSizes();
            } else {
                throw new IllegalArgumentException("Illegal event type for this attribute!");
            }
            return GcEventStatisticValueElement.compactValues(ageSizes, 16);
        }
    }),
    AGE_COUNTS(new LongArrayGetter(){

        @Override
        public long[] getArrayValue(GcEventBase event) {
            int[] ageSizes = null;
            if (event instanceof GcEventParallelGcScavenge) {
                ageSizes = ((GcEventParallelGcScavenge)event).getAgeCounts();
            } else if (event instanceof GcEventParallelNewGc) {
                ageSizes = ((GcEventParallelNewGc)event).getAgeCounts();
            } else if (event instanceof GcEventSerialNewGc) {
                ageSizes = ((GcEventSerialNewGc)event).getAgeCounts();
            } else if (event instanceof GcEventG1IncrementalGc) {
                ageSizes = ((GcEventG1IncrementalGc)event).getAgeCounts();
            } else {
                throw new IllegalArgumentException("Illegal event type for this attribute!");
            }
            return GcEventStatisticValueElement.compactValues(ageSizes, 16);
        }
    }),
    NR_OF_PARALLEL_GC_THREADS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventParallelNewGc)event).getNrOfParallelGcThreads();
        }
    }),
    SUCCESSFUL_OVERFLOW_REFILLS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelNewGc) {
                return ((GcEventParallelNewGc)event).getSuccessfulOverflowRefills();
            }
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getSuccessfulOverflowRefills();
            }
            if (event instanceof GcEventCmsMarking) {
                return ((GcEventCmsMarking)event).getSuccessfulOverflowRefills();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    SUCCESSFUL_OVERFLOW_REFILL_OBJECTS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelNewGc) {
                return ((GcEventParallelNewGc)event).getSuccessfulOverflowRefillObjects();
            }
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getSuccessfulOverflowRefillObjects();
            }
            if (event instanceof GcEventCmsMarking) {
                return ((GcEventCmsMarking)event).getSuccessfulOverflowRefillObjects();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    FAILED_OVERFLOW_REFILLS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventParallelNewGc) {
                return ((GcEventParallelNewGc)event).getFailedOverflowRefills();
            }
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getFailedOverflowRefills();
            }
            if (event instanceof GcEventCmsMarking) {
                return ((GcEventCmsMarking)event).getFailedOverflowRefills();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    NR_OF_CARDS_CLEANED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventCmsAbortablePrecleaning) {
                return ((GcEventCmsAbortablePrecleaning)event).getNrOfCardsCleaned();
            }
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getNrOfCardsCleaned();
            }
            if (event instanceof GcEventCmsPrecleaning) {
                return ((GcEventCmsPrecleaning)event).getNrOfCardsCleaned();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    IS_REMARKING_PARALLEL(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).isRemarkingParallel();
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).isRemarkingParallel();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    NR_OF_THREADS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventCmsInitialMarking) {
                return ((GcEventCmsInitialMarking)event).getNrOfThreads();
            }
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getNrOfThreads();
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).getNrOfThreads();
            }
            if (event instanceof GcEventG1InitialMarking) {
                return ((GcEventG1InitialMarking)event).getNrOfThreads();
            }
            if (event instanceof GcEventG1Marking) {
                return ((GcEventG1Marking)event).getNrOfThreads();
            }
            if (event instanceof GcEventG1IncrementalGc) {
                return ((GcEventG1IncrementalGc)event).getNrOfThreads();
            }
            if (event instanceof GcEventG1RootScanning) {
                return ((GcEventG1RootScanning)event).getNrOfThreads();
            }
            if (event instanceof GcEventG1ParallelFullGc) {
                return ((GcEventG1ParallelFullGc)event).getNrOfThreads();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    IS_REFERENCE_PROCESSING_PARALLEL(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).isReferenceProcessingParallel();
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).isReferenceProcessingParallel();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    NR_OF_NON_ARRAY_CLASSES_UNLOADED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsFinalMarking)event).getNrOfNonArrayClassesUnloaded();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 1)),
    NR_OF_ARRAY_CLASSES_UNLOADED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsFinalMarking)event).getNrOfArrayClassesUnloaded();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 1)),
    REMARKING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getRemarkingDuration() * 1000L;
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).getRemarkingDuration() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    REMARKING_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getRemarkingCpuTime() * 1000L;
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).getRemarkingCpuTime() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    CLASS_UNLOADING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsFinalMarking)event).getClassUnloadingDuration() * 1000L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 1)),
    CLASS_UNLOADING_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsFinalMarking)event).getClassUnloadingCpuTime() * 1000L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 1)),
    SYMBOL_UNLOADING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getSymbolUnloadingDuration() * 1000L;
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).getSymbolUnloadingDuration() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    SYMBOL_UNLOADING_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getSymbolUnloadingCpuTime() * 1000L;
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).getSymbolUnloadingCpuTime() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    REFERENCE_HANDLING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getReferenceHandlingDuration() * 1000L;
            }
            if (event instanceof GcEventG1IncrementalGc) {
                return ((GcEventG1IncrementalGc)event).getReferenceHandlingDuration() * 1000L;
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).getReferenceHandlingDuration() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    REFERENCE_HANDLING_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getReferenceHandlingCpuTime() * 1000L;
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).getReferenceHandlingCpuTime() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    REFERENCE_ENQUEUEING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getReferenceEqueueingDuration() * 1000L;
            }
            if (event instanceof GcEventG1IncrementalGc) {
                return ((GcEventG1IncrementalGc)event).getReferenceEnqueueingDuration() * 1000L;
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).getReferenceEqueueingDuration() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 3)),
    REFERENCE_ENQUEUEING_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventCmsFinalMarking) {
                return ((GcEventCmsFinalMarking)event).getReferenceEqueueingCpuTime() * 1000L;
            }
            if (event instanceof GcEventG1FinalMarking) {
                return ((GcEventG1FinalMarking)event).getReferenceEqueueingCpuTime() * 1000L;
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 3)),
    COMMITTED_BYTES_IN_OLD(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsInitialMarking)event).getCommittedBytesInOld();
        }
    }),
    PERM_COMMITTED(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsInitialMarking)event).getPermCommitted();
        }
    }),
    NR_OF_NON_ARRAY_CLASSES(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsInitialMarking)event).getNrOfNonArrayClasses();
        }
    }),
    NR_OF_ARRAY_CLASSES(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsInitialMarking)event).getNrOfArrayClasses();
        }
    }),
    IS_MARKING_CONCURRENT(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            return ((GcEventCmsMarking)event).isConcurrent();
        }
    }),
    IS_PARALLEL(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            if (event instanceof GcEventCmsInitialMarking) {
                return ((GcEventCmsInitialMarking)event).isParallel();
            }
            if (event instanceof GcEventCmsMarking) {
                return ((GcEventCmsMarking)event).isParallel();
            }
            if (event instanceof GcEventG1Cleanup) {
                return ((GcEventG1Cleanup)event).isParallel();
            }
            if (event instanceof GcEventG1InitialMarking) {
                return ((GcEventG1InitialMarking)event).isParallel();
            }
            if (event instanceof GcEventG1Marking) {
                return ((GcEventG1Marking)event).isParallel();
            }
            if (event instanceof GcEventG1RootScanning) {
                return ((GcEventG1RootScanning)event).isParallel();
            }
            if (event instanceof GcEventG1EmptyRegionsReclaim) {
                return ((GcEventG1EmptyRegionsReclaim)event).isParallel();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    NR_OF_GC_THREADS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventCmsMarking) {
                return ((GcEventCmsMarking)event).getNrOfGcThreads();
            }
            if (event instanceof GcEventG1Cleanup) {
                return ((GcEventG1Cleanup)event).getNrOfGcThreads();
            }
            if (event instanceof GcEventG1EmptyRegionsReclaim) {
                return ((GcEventG1EmptyRegionsReclaim)event).getNrOfGcThreads();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }),
    IS_SWEEPING_CONCURRENT(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            return ((GcEventCmsSweeping)event).isConcurrent();
        }
    }),
    BYTES_PROMOTED_TO_OLD(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsSweeping)event).getBytesPromotedToOld();
        }
    }),
    BYTES_ALLOCATED_IN_OLD(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsSweeping)event).getBytesAllocatedInOld();
        }
    }),
    BYTES_ALLOCATED_IN_PERM(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsSweeping)event).getBytesAllocatedInPerm();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> !session.getSystemInfo().hasMetaspace())),
    NR_OF_NON_COALESCABLE_BLOCKS_IN_OLD(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsSweeping)event).getNrOfNonCoalesableBlocksInOld();
        }
    }),
    SIZE_OF_NON_COALESCABLE_BLOCKS_IN_OLD(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsSweeping)event).getSizeOfNonCoalesableBlocksInOld();
        }
    }),
    NR_OF_NON_COALESCABLE_BLOCKS_IN_PERM(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsSweeping)event).getNrOfNonCoalesableBlocksInPerm();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> !session.getSystemInfo().hasMetaspace())),
    SIZE_OF_NON_COALESCABLE_BLOCKS_IN_PERM(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventCmsSweeping)event).getSizeOfNonCoalesableBlocksInPerm();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> !session.getSystemInfo().hasMetaspace())),
    CLEARED_BITMAP_BYTES(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1BitmapClearing)event).getClearedBitmapBytes();
        }
    }),
    YIELD_COUNT(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1BitmapClearing)event).getYieldCount();
        }
    }),
    BYTES_IN_NON_PERM_BEFORE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventG1Cleanup) {
                return ((GcEventG1Cleanup)event).getBytesInNonPermBefore();
            }
            if (event instanceof GcEventG1EmptyRegionsReclaim) {
                return ((GcEventG1EmptyRegionsReclaim)event).getBytesInNonPermBefore();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 3 || evType != GcEventType.G1_CLEANUP)),
    LIVE_BYTES_IN_NON_PERM(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventG1Cleanup) {
                return ((GcEventG1Cleanup)event).getLiveBytesInNonPerm();
            }
            if (event instanceof GcEventG1EmptyRegionsReclaim) {
                return ((GcEventG1EmptyRegionsReclaim)event).getLiveBytesInNonPerm();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 3 || evType != GcEventType.G1_CLEANUP)),
    GARBAGE_IN_NON_PERM(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventG1Cleanup) {
                GcEventG1Cleanup g1e = (GcEventG1Cleanup)event;
                return g1e.getBytesInNonPermBefore() - g1e.getLiveBytesInNonPerm();
            }
            if (event instanceof GcEventG1EmptyRegionsReclaim) {
                GcEventG1EmptyRegionsReclaim g1e = (GcEventG1EmptyRegionsReclaim)event;
                return g1e.getBytesInNonPermBefore() - g1e.getLiveBytesInNonPerm();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 3 || evType != GcEventType.G1_CLEANUP)),
    GARBAGE_REGION_COUNT(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventG1Cleanup) {
                return ((GcEventG1Cleanup)event).getGarbageRegionCount();
            }
            if (event instanceof GcEventG1EmptyRegionsReclaim) {
                return ((GcEventG1EmptyRegionsReclaim)event).getGarbageRegionCount();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 3 || evType != GcEventType.G1_CLEANUP)),
    BYTES_IN_GARBAGE_REGIONS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            if (event instanceof GcEventG1Cleanup) {
                return ((GcEventG1Cleanup)event).getBytesInGarbageRegions();
            }
            if (event instanceof GcEventG1EmptyRegionsReclaim) {
                return ((GcEventG1EmptyRegionsReclaim)event).getBytesInGarbageRegions();
            }
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticVersion() < 3 || evType != GcEventType.G1_CLEANUP)),
    REGIONS_TO_BE_CLEANED_COUNT(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1ConcurrentCleanup)event).getRegionsToBeCleanedCount();
        }
    }),
    BYTES_FREED_IN_NON_PERM(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1ConcurrentCleanup)event).getBytesFreedInNonPerm();
        }
    }),
    NR_OF_ITERATIONS(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1Counting)event).getNrOfIterations();
        }
    }),
    HAS_MARKING_STACK_OVERFLOW_OCCURRED(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            return ((GcEventG1FinalMarking)event).hasMarkingStackOverflowOccurred();
        }
    }),
    NR_OF_BYTES_SCANNED_DURING_FINAL_MARKING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1FinalMarking)event).getNrOfBytesScanned();
        }
    }),
    NR_OF_OBJECT_REFERENCES_REACHED_DURING_FINAL_MARKING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1FinalMarking)event).getNrOfObjectReferencesReached();
        }
    }),
    IS_PART_OF_PARTIAL_GC(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            return ((GcEventG1InitialMarking)event).isPartOfPartialGc();
        }
    }),
    BYTES_IN_NON_PERM_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1InitialMarking)event).getBytesInNonPermAfter();
        }
    }),
    COMMITTED_BYTES_IN_NON_PERM_AFTER(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1InitialMarking)event).getCommittedBytesInNonPermAfter();
        }
    }),
    HAS_INITIAL_MARKING(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).hasInitialMarking();
        }
    }),
    YOUNG_PLABSIZE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getYoungPLABSize();
        }
    }),
    OLD_PLABSIZE(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getOldPLABSize();
        }
    }),
    CONCURRENT_MARKING_ROOT_SCAN_WAIT_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getConcurrentMarkingRootScanWaitDuration() * 1000L;
        }
    }),
    PARALLEL_ROOT_SCANNING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getParallelRootScanningDuration() * 1000L;
        }
    }),
    PARALLEL_SNAPSHOT_AT_THE_BEGINNING_FILTERING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getParallelSnapshotAtTheBeginningFilteringDuration() * 1000L;
        }
    }),
    PARALLEL_REMEMBERED_SET_UPDATING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getParallelRememberedSetUpdatingDuration() * 1000L;
        }
    }),
    BUFFERS_PROCESSED_DURING_PARALLEL_REMEMBERED_SET_UPDATING(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getBuffersProcessedDuringParallelRememberedSetUpdating();
        }
    }),
    PARALLEL_REMEMBERED_SET_SCANNING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getParallelRememberedSetScanningDuration() * 1000L;
        }
    }),
    PARALLEL_OBJECT_COPYING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getParallelObjectCopyingDuration() * 1000L;
        }
    }),
    CARD_TABLE_CLEARING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getCardTableClearingDuration() * 1000L;
        }
    }),
    COLLECTION_SET_CHOOSING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getCollectionSetChoosingDuration() * 1000L;
        }
    }),
    COLLECTION_SET_FREEING_DURATION(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).getCollectionSetFreeingDuration() * 1000L;
        }
    }),
    HAS_ONLY_YOUNG_REGIONS(new BooleanGetter(){

        @Override
        public boolean getBool(GcEventBase event) {
            return ((GcEventG1IncrementalGc)event).hasOnlyYoungRegions();
        }
    }),
    SCANNED_ROOT_REGION_COUNT(new LongGetter(){

        @Override
        public long getLong(GcEventBase event) {
            return ((GcEventG1RootScanning)event).getScannedRootRegions();
        }
    });

    public static final int TYPE_BOOLEAN = 0;
    public static final int TYPE_LONG = 1;
    public static final int TYPE_STRING = 2;
    public static final int TYPE_LONG_ARRAY = 3;
    public static final String TAG_PREFIX = "GCEVENT_";
    private Getter getter;
    private TriPredicate<ProfilingSession, GcType, GcEventType> isApplicablePredicate;

    private GcEventStatisticValueElement(Getter getter) {
        this.getter = getter;
        this.isApplicablePredicate = P.TRUE;
    }

    private GcEventStatisticValueElement(Getter getter, TriPredicate<ProfilingSession, GcType, GcEventType> isApplicablePredicate) {
        this.getter = getter;
        this.isApplicablePredicate = isApplicablePredicate;
    }

    @Override
    public boolean isApplicable(ProfilingSession session, GcType type, GcEventType eventType) {
        return this.isApplicablePredicate.test((Object)session, (Object)type, (Object)eventType);
    }

    public int getType() {
        return this.getter.getType();
    }

    public long getValue(GcEventBase event) {
        return this.getter.getValue(event);
    }

    public long getValue(GcStatistic gcStatistic, int eventId) {
        return this.getter.getValue(gcStatistic.getEvents()[eventId]);
    }

    public String getStringValue(GcEventBase event) {
        return this.getter.getStringValue(event);
    }

    public long[] getArrayValue(GcEventBase event) {
        return this.getter.getArrayValue(event);
    }

    @Override
    public String getColumnTag() {
        return TAG_PREFIX + this.name();
    }

    private static long[] compactValues(int[] values, int maxLength) {
        int i;
        int length = values.length;
        if (length > maxLength) {
            boolean canShorten = true;
            for (i = values.length - 1; i >= maxLength; --i) {
                if (values[i] == 0) continue;
                canShorten = false;
                break;
            }
            if (canShorten) {
                length = maxLength;
            }
        }
        long[] result = new long[length];
        for (i = 0; i < length; ++i) {
            result[i] = values[i];
        }
        return result;
    }

    private static double[] getLoad(GcEventBase event) {
        double[] load;
        if (event instanceof GcEventGenerational) {
            load = ((GcEventGenerational)event).getSystemLoadAverage();
        } else if (event instanceof GcEventCmsFinalMarking) {
            load = ((GcEventCmsFinalMarking)event).getSystemLoadAverage();
        } else if (event instanceof GcEventCmsInitialMarking) {
            load = ((GcEventCmsInitialMarking)event).getSystemLoadAverage();
        } else if (event instanceof GcEventG1Cleanup) {
            load = ((GcEventG1Cleanup)event).getSystemLoadAverage();
        } else if (event instanceof GcEventG1EmptyRegionsReclaim) {
            load = ((GcEventG1EmptyRegionsReclaim)event).getSystemLoadAverage();
        } else if (event instanceof GcEventG1FinalMarking) {
            load = ((GcEventG1FinalMarking)event).getSystemLoadAverage();
        } else if (event instanceof GcEventG1InitialMarking) {
            load = ((GcEventG1InitialMarking)event).getSystemLoadAverage();
        } else {
            throw new IllegalArgumentException("Illegal event type for this attribute!");
        }
        return load;
    }

    private static class P {
        public static final TriPredicate<ProfilingSession, GcType, GcEventType> TRUE = (s, t, e) -> true;

        private P() {
        }
    }

    private static abstract class LongArrayGetter
    implements Getter {
        private LongArrayGetter() {
        }

        @Override
        public int getType() {
            return 3;
        }

        @Override
        public long getValue(GcEventBase event) {
            throw new UnsupportedOperationException("Cant convert the array attribute to long");
        }

        @Override
        public String getStringValue(GcEventBase event) {
            return Arrays.toString(this.getArrayValue(event));
        }
    }

    private static abstract class StringGetter
    implements Getter {
        private StringGetter() {
        }

        @Override
        public int getType() {
            return 2;
        }

        @Override
        public long getValue(GcEventBase event) {
            throw new UnsupportedOperationException("Cant convert the string attribute to long");
        }

        @Override
        public long[] getArrayValue(GcEventBase event) {
            throw new UnsupportedOperationException("Cant convert the string attribute to array");
        }
    }

    private static abstract class LongGetter
    implements Getter {
        private LongGetter() {
        }

        abstract long getLong(GcEventBase var1);

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getValue(GcEventBase event) {
            return this.getLong(event);
        }

        @Override
        public String getStringValue(GcEventBase event) {
            return Long.toString(this.getLong(event));
        }

        @Override
        public long[] getArrayValue(GcEventBase event) {
            return new long[]{this.getLong(event)};
        }
    }

    private static abstract class BooleanGetter
    implements Getter {
        private BooleanGetter() {
        }

        abstract boolean getBool(GcEventBase var1);

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public long getValue(GcEventBase event) {
            return this.getBool(event) ? 1L : 0L;
        }

        @Override
        public String getStringValue(GcEventBase event) {
            return Boolean.toString(this.getBool(event));
        }

        @Override
        public long[] getArrayValue(GcEventBase event) {
            return new long[]{this.getValue(event)};
        }
    }

    private static interface Getter {
        public int getType();

        public long getValue(GcEventBase var1);

        public String getStringValue(GcEventBase var1);

        public long[] getArrayValue(GcEventBase var1);
    }
}

