/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.gc;

import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.elements.GcEventColumnsElement;
import com.sap.jvm.profiling.snapshot.elements.GcEventTypeFilterElement;
import com.sap.jvm.profiling.snapshot.filter.GcEventTypeFilter;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class GcEventValueStatisticUtil {
    public static List<GcEventStatisticValueElement> getValueElements(ResourceName name) {
        ResourceNameElement[] nameElements = name.getElements();
        for (int i = 0; i < nameElements.length; ++i) {
            ResourceNameElement nameElement = nameElements[nameElements.length - (i + 1)];
            if (!(nameElement instanceof GcEventColumnsElement)) continue;
            return ((GcEventColumnsElement)nameElement).getValueElements();
        }
        ArrayList<GcEventStatisticValueElement> result = new ArrayList<GcEventStatisticValueElement>();
        result.add(GcEventStatisticValueElement.TIME_STAMP);
        result.add(GcEventStatisticValueElement.EVENT_TYPE);
        return result;
    }

    public static List<String> getDefaultVisibleColumnTags(ResourceName name) {
        ResourceNameElement[] nameElements = name.getElements();
        for (int i = 0; i < nameElements.length; ++i) {
            ResourceNameElement nameElement = nameElements[nameElements.length - (i + 1)];
            if (!(nameElement instanceof GcEventColumnsElement)) continue;
            return ((GcEventColumnsElement)nameElement).getDefaultVisibleColumnTags();
        }
        ArrayList<String> result = new ArrayList<String>();
        result.add(GcEventStatisticValueElement.TIME_STAMP.getColumnTag());
        result.add(GcEventStatisticValueElement.EVENT_TYPE.getColumnTag());
        return result;
    }

    public static Set<GcEventType> getGcEventTypes(ResourceName name) {
        GcEventTypeFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof GcEventTypeFilterElement)) continue;
            GcEventTypeFilterElement filterElement = (GcEventTypeFilterElement)element;
            if (filter == null) {
                filter = filterElement.getFilter();
                continue;
            }
            filter = filter.copy();
            filter.narrow(filterElement.getFilter());
        }
        return filter.getEventTypes();
    }
}

