/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.gc;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import java.util.ArrayList;
import java.util.List;

public class GcReportNode {
    public static final int CRITICAL_COLOR = 0xFF0000;

    public static GcReportNode getPercentage(double percentage, boolean critical) {
        return new FormattedText(DataFormatter.getPercentage((double)(percentage / 100.0)), true, false, 0, critical ? 0xFF0000 : -1);
    }

    public static GcReportNode getNumber(long number, boolean critical) {
        return new FormattedText(DataFormatter.getNumberText((long)number), true, false, 0, critical ? 0xFF0000 : -1);
    }

    public static GcReportNode getDuration(long duration, boolean critical) {
        return new FormattedText(DataFormatter.getMicrosDurationText((long)duration), true, false, 0, critical ? 0xFF0000 : -1);
    }

    public static GcReportNode getNrOfBytes(long nrOfBytes, boolean critical) {
        return new FormattedText(DataFormatter.getNrOfBytesText((long)nrOfBytes), true, false, 0, critical ? 0xFF0000 : -1);
    }

    public static GcReportNode getValueText(String text, boolean critical) {
        return new FormattedText(text, true, false, 0, critical ? 0xFF0000 : -1);
    }

    public static String getOptionString(List<Long> longs) {
        StringBuilder result = new StringBuilder();
        for (long l : longs) {
            if (result.length() > 0) {
                result.append(',');
            }
            result.append(Long.toString(l));
        }
        return result.toString();
    }

    public static class AccBarChart
    extends GcReportNode {
        private final String title;
        private final String altTag;
        private final ArrayList<Long> values;
        private final ArrayList<String> labels;
        private final ArrayList<String> ranges;
        private final long max;
        private final boolean horizontal;

        public AccBarChart(String title, String altTag, long maxValue, boolean horizontal) {
            this.title = title;
            this.altTag = altTag;
            this.max = maxValue;
            this.horizontal = horizontal;
            this.values = new ArrayList();
            this.labels = new ArrayList();
            this.ranges = new ArrayList();
        }

        public void addValue(long value, String descriptionLabel, String rangeLabel) {
            this.values.add(value);
            this.labels.add(descriptionLabel);
            this.ranges.add(rangeLabel);
        }

        public String[] getDescriptionLabels() {
            return this.labels.toArray(new String[this.labels.size()]);
        }

        public String[] getRangeLabels() {
            return this.ranges.toArray(new String[this.ranges.size()]);
        }

        public long[] getValues() {
            long[] result = new long[this.values.size()];
            for (int i = 0; i < result.length; ++i) {
                result[i] = this.values.get(i);
            }
            return result;
        }

        public String getTitle() {
            return this.title;
        }

        public String getAltTag() {
            return this.altTag;
        }

        public long getMax() {
            return this.max;
        }

        public boolean isHorizontal() {
            return this.horizontal;
        }
    }

    public static class PieChart
    extends GcReportNode {
        private final String title;
        private String altTag;
        private final ArrayList<Double> values;
        private final ArrayList<String> labels;
        private final ArrayList<Integer> colors;

        public PieChart(String title) {
            this.title = title;
            this.values = new ArrayList();
            this.labels = new ArrayList();
            this.colors = new ArrayList();
        }

        public void addValue(double value, String label, int rgb) {
            this.values.add(value);
            this.labels.add(label);
            this.colors.add(rgb);
        }

        public String getAltTag() {
            return this.altTag;
        }

        public void setAltTag(String altTag) {
            this.altTag = altTag;
        }

        public String getLabel(int i) {
            return this.labels.get(i);
        }

        public double getValue(int i) {
            return this.values.get(i);
        }

        public int getColor(int i) {
            return this.colors.get(i);
        }

        public String getTitle() {
            return this.title;
        }

        public int size() {
            return this.values.size();
        }
    }

    public static class Link
    extends NodeWithOneChild {
        final String location;
        final String options;

        public Link(String location, String options, GcReportNode child) {
            super(child);
            this.location = location;
            this.options = options;
        }

        public String getLocation() {
            return this.location;
        }

        public String getOptions() {
            return this.options;
        }
    }

    public static class ComposedText
    extends MultiChildNode {
        final String textPattern;

        public ComposedText(String textPattern, GcReportNode ... arguments) {
            super(arguments);
            this.textPattern = textPattern;
        }

        public String getTextPattern() {
            return this.textPattern;
        }
    }

    public static class Table
    extends GcReportNode {
        final String[] headings;
        final double[] relativeWidths;
        final boolean showBorder;
        final boolean showGrid;
        final int alignment;
        final GcReportNode[][] content;
        private int[] colAlignment;
        private int[] headerAlignment;

        public Table(String[] headings, double[] relativeWidths, int[] headerAlignment, int[] colAlignment, boolean border, boolean grid, int alignment, GcReportNode[][] content) {
            this.headings = headings;
            this.relativeWidths = relativeWidths;
            this.headerAlignment = headerAlignment;
            this.colAlignment = colAlignment;
            this.showBorder = border;
            this.showGrid = grid;
            this.alignment = alignment;
            this.content = content;
        }

        public String[] getHeadings() {
            return this.headings;
        }

        public double[] getRelativeWidths() {
            return this.relativeWidths;
        }

        public int[] getHeaderAlignment() {
            return this.headerAlignment;
        }

        public int[] getColAlignment() {
            return this.colAlignment;
        }

        public boolean isShowBorder() {
            return this.showBorder;
        }

        public boolean isShowGrid() {
            return this.showGrid;
        }

        public int getAlignment() {
            return this.alignment;
        }

        public GcReportNode[][] getContent() {
            return this.content;
        }
    }

    public static class Section
    extends MultiChildNode {
        final String title;
        final Icon icon;

        public Section(Icon icon, String title, GcReportNode ... children) {
            super(children);
            this.icon = icon;
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }

        public Icon getIcon() {
            return this.icon;
        }
    }

    public static class FormattedText
    extends Text {
        final boolean bold;
        final boolean italic;
        final int fontSizeIncrease;
        final int rgb;

        public FormattedText(String text, boolean bold, boolean italic, int fontSizeIncrease) {
            super(text);
            this.bold = bold;
            this.italic = italic;
            this.fontSizeIncrease = fontSizeIncrease;
            this.rgb = -1;
        }

        public FormattedText(String text, boolean bold, boolean italic, int fontSizeIncrease, int rgb) {
            super(text);
            this.bold = bold;
            this.italic = italic;
            this.fontSizeIncrease = fontSizeIncrease;
            this.rgb = rgb;
        }

        public boolean isBold() {
            return this.bold;
        }

        public boolean isItalic() {
            return this.italic;
        }

        public int getFontSizeIncrease() {
            return this.fontSizeIncrease;
        }

        public int getRgb() {
            return this.rgb;
        }
    }

    public static class LegendBox
    extends PercentageBar {
        public LegendBox(int color) {
            super(1.0, color);
        }
    }

    public static class PercentageBar
    extends GcReportNode {
        private double percentage;
        private int color;

        public PercentageBar(double percentage, int color) {
            this.percentage = percentage;
            this.color = color;
        }

        public double getPercentage() {
            return this.percentage;
        }

        public int getColor() {
            return this.color;
        }
    }

    public static class Icon
    extends GcReportNode {
        final GcReportBuilder.Severity severity;

        public Icon(GcReportBuilder.Severity severity) {
            this.severity = severity;
        }

        public GcReportBuilder.Severity getSeverity() {
            return this.severity;
        }
    }

    public static class Text
    extends GcReportNode {
        final String text;

        public Text(String text) {
            this.text = text;
        }

        public String getText() {
            return this.text;
        }
    }

    public static class Note
    extends MultiChildNode {
        private String title;

        public Note(String title, GcReportNode ... children) {
            super(children);
            this.title = title;
        }

        public String getTitle() {
            return this.title;
        }
    }

    public static class Paragraph
    extends MultiChildNode {
        public Paragraph(GcReportNode ... children) {
            super(children);
        }
    }

    public static class MultiChildNode
    extends GcReportNode {
        final GcReportNode[] children;

        public MultiChildNode(GcReportNode ... children) {
            this.children = children;
        }

        public GcReportNode[] getChildren() {
            return this.children;
        }
    }

    private static class NodeWithOneChild
    extends GcReportNode {
        final GcReportNode child;

        public NodeWithOneChild(GcReportNode child) {
            this.child = child;
        }

        public GcReportNode getChild() {
            return this.child;
        }
    }
}

