/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.gc;

import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcStatisticConcMarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcStatisticG1Gc;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ResourceReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;

public class GcSnapshotProperties {
    private static boolean isTest = false;
    private static final int VERSION = 1;
    private boolean initial = true;
    private GcType gcType;
    private long durationFull = 0L;
    private long durationYoung = 0L;
    private long durationConc = 0L;
    private long maxDurationFull = 0L;
    private long maxDurationYoung = 0L;
    private long maxDurationConc = 0L;
    private int nrGcsFull = 0;
    private int nrGcsYoung = 0;
    private int nrGcsConc = 0;
    private long firstGcId = Long.MAX_VALUE;
    private long lastGcId = 0L;
    private List<Long> fullGcIds;
    private List<Long> concGcIds;
    private long maxOldGenSize = -1L;
    private long maxYoungGenSize = -1L;
    private long maxPermGenSize = -1L;
    private long maxCommittedToSize = -1L;
    private long maxCommittedFromSize = -1L;
    private long maxCommittedEdenSize = -1L;
    private long maxCommittedYoungSize = -1L;
    private long maxCommittedOldSize = -1L;
    private long maxCommittedPermSize = -1L;

    public GcSnapshotProperties(GcType type) {
        this.gcType = type;
        this.fullGcIds = new ArrayList<Long>();
        this.concGcIds = new ArrayList<Long>();
    }

    public GcSnapshotProperties(ResourceReader reader, int snapshotVersion) throws IOException {
        int i;
        this.durationFull = reader.readInt64();
        this.durationYoung = reader.readInt64();
        this.durationConc = reader.readInt64();
        this.maxDurationFull = reader.readInt64();
        this.maxDurationYoung = reader.readInt64();
        this.maxDurationConc = reader.readInt64();
        this.nrGcsFull = reader.readInt32();
        this.nrGcsYoung = reader.readInt32();
        this.nrGcsConc = reader.readInt32();
        this.firstGcId = reader.readInt64();
        this.lastGcId = reader.readInt64();
        this.gcType = null;
        if (this.nrGcsFull + this.nrGcsYoung + this.nrGcsConc > 0) {
            this.gcType = GcType.values()[reader.readInt32()];
        }
        this.fullGcIds = new ArrayList<Long>(this.nrGcsFull);
        for (i = 0; i < this.nrGcsFull; ++i) {
            this.fullGcIds.add(reader.readInt64());
        }
        this.concGcIds = new ArrayList<Long>(this.nrGcsConc);
        for (i = 0; i < this.nrGcsConc; ++i) {
            this.concGcIds.add(reader.readInt64());
        }
        if (snapshotVersion > 1) {
            reader.readVersion(1);
            this.maxOldGenSize = reader.readInt64();
            this.maxYoungGenSize = reader.readInt64();
            this.maxPermGenSize = reader.readInt64();
            this.maxCommittedToSize = reader.readInt64();
            this.maxCommittedFromSize = reader.readInt64();
            this.maxCommittedEdenSize = reader.readInt64();
            this.maxCommittedYoungSize = reader.readInt64();
            this.maxCommittedOldSize = reader.readInt64();
            this.maxCommittedPermSize = reader.readInt64();
        }
        this.initial = false;
    }

    public void write(PacketResourceWriter writer) throws IOException {
        this.initial = false;
        writer.writeInt64(this.durationFull);
        writer.writeInt64(this.durationYoung);
        writer.writeInt64(this.durationConc);
        writer.writeInt64(this.maxDurationFull);
        writer.writeInt64(this.maxDurationYoung);
        writer.writeInt64(this.maxDurationConc);
        writer.writeInt32(this.nrGcsFull);
        writer.writeInt32(this.nrGcsYoung);
        writer.writeInt32(this.nrGcsConc);
        writer.writeInt64(this.firstGcId);
        writer.writeInt64(this.lastGcId);
        if (this.getNrOfGcsTotal() > 0) {
            writer.writeInt32(this.gcType.ordinal());
        }
        for (Long fullGc : this.fullGcIds) {
            writer.writeInt64(fullGc.longValue());
        }
        for (Long concGc : this.concGcIds) {
            writer.writeInt64(concGc.longValue());
        }
        writer.writeVersion(1);
        writer.writeInt64(this.maxOldGenSize);
        writer.writeInt64(this.maxYoungGenSize);
        writer.writeInt64(this.maxPermGenSize);
        writer.writeInt64(this.maxCommittedToSize);
        writer.writeInt64(this.maxCommittedFromSize);
        writer.writeInt64(this.maxCommittedEdenSize);
        writer.writeInt64(this.maxCommittedYoungSize);
        writer.writeInt64(this.maxCommittedOldSize);
        writer.writeInt64(this.maxCommittedPermSize);
    }

    public GcType getGcType() {
        return this.gcType;
    }

    public long getDurationTotal() {
        return this.durationFull + this.durationYoung + this.durationConc;
    }

    public long getDurationFull() {
        return this.durationFull;
    }

    public long getDurationYoung() {
        return this.durationYoung;
    }

    public long getDurationConc() {
        return this.durationConc;
    }

    public long getMaxDurationTotal() {
        return Math.max(this.maxDurationFull, Math.max(this.maxDurationYoung, this.maxDurationConc));
    }

    public long getMaxDurationFull() {
        return this.maxDurationFull;
    }

    public long getMaxDurationYoung() {
        return this.maxDurationYoung;
    }

    public long getMaxDurationConc() {
        return this.maxDurationConc;
    }

    public int getNrOfGcsTotal() {
        return this.nrGcsFull + this.nrGcsYoung + this.nrGcsConc;
    }

    public int getNrOfGcsFull() {
        return this.nrGcsFull;
    }

    public int getNrOfGcsYoung() {
        return this.nrGcsYoung;
    }

    public int getNrOfGcsConc() {
        return this.nrGcsConc;
    }

    public long getFirstGcId() {
        return this.firstGcId;
    }

    public long getLastGcId() {
        return this.lastGcId;
    }

    public List<Long> getFullGcIds() {
        return Collections.unmodifiableList(this.fullGcIds);
    }

    public List<Long> getConcGcIds() {
        return Collections.unmodifiableList(this.concGcIds);
    }

    public long getMaxYoungGenSize() {
        return this.maxYoungGenSize;
    }

    public long getMaxOldGenSize() {
        return this.maxOldGenSize;
    }

    public long getMaxPermGenSize() {
        return this.maxPermGenSize;
    }

    public long getMaxCommittedToSize() {
        return this.maxCommittedToSize;
    }

    public long getMaxCommittedFromSize() {
        return this.maxCommittedFromSize;
    }

    public long getMaxCommittedEdenSize() {
        return this.maxCommittedEdenSize;
    }

    public long getMaxCommittedYoungSize() {
        return this.maxCommittedYoungSize;
    }

    public long getMaxCommittedOldSize() {
        return this.maxCommittedOldSize;
    }

    public long getMaxCommittedPermSize() {
        return this.maxCommittedPermSize;
    }

    public boolean isInitial() {
        return this.initial;
    }

    public void update(GcStatistic event) {
        if (event != null) {
            if (this.gcType == null) {
                this.gcType = event.getGcType();
            } else assert (this.gcType == event.getGcType() || isTest);
            long gcId = event.getGcNr();
            this.firstGcId = Math.min(this.firstGcId, gcId);
            this.lastGcId = Math.max(this.lastGcId, gcId);
            this.maxOldGenSize = Math.max(this.maxOldGenSize, event.getMaxOldGenSize());
            this.maxYoungGenSize = Math.max(this.maxYoungGenSize, event.getMaxYoungGenSize());
            this.maxPermGenSize = Math.max(this.maxPermGenSize, event.getMaxPermGenSize());
            this.maxCommittedToSize = Math.max(this.maxCommittedToSize, event.getCommittedBytesInToBeforeGc());
            this.maxCommittedToSize = Math.max(this.maxCommittedToSize, event.getCommittedBytesInToAfterGc());
            this.maxCommittedFromSize = Math.max(this.maxCommittedFromSize, event.getCommittedBytesInFromBeforeGc());
            this.maxCommittedFromSize = Math.max(this.maxCommittedFromSize, event.getCommittedBytesInFromAfterGc());
            this.maxCommittedEdenSize = Math.max(this.maxCommittedEdenSize, event.getCommittedBytesInEdenBeforeGc());
            this.maxCommittedEdenSize = Math.max(this.maxCommittedEdenSize, event.getCommittedBytesInEdenAfterGc());
            this.maxCommittedYoungSize = Math.max(this.maxCommittedYoungSize, event.getCommittedBytesInYoungBeforeGc());
            this.maxCommittedYoungSize = Math.max(this.maxCommittedYoungSize, event.getCommittedBytesInYoungAfterGc());
            this.maxCommittedOldSize = Math.max(this.maxCommittedOldSize, event.getCommittedBytesInOldBeforeGc());
            this.maxCommittedOldSize = Math.max(this.maxCommittedOldSize, event.getCommittedBytesInOldAfterGc());
            this.maxCommittedPermSize = Math.max(this.maxCommittedPermSize, event.getCommittedBytesInPermBeforeGc());
            this.maxCommittedPermSize = Math.max(this.maxCommittedPermSize, event.getCommittedBytesInPermAfterGc());
            if (event.isFullGc()) {
                this.fullGcIds.add(gcId);
                this.updateFull(event.getDuration());
            } else {
                GcStatisticG1Gc g1gc;
                GcStatisticConcMarkSweepGc cms;
                if (event.getGcType() == GcType.CONC_MARK_SWEEP_GC && (cms = (GcStatisticConcMarkSweepGc)event).isConcurrent()) {
                    this.concGcIds.add(gcId);
                    this.updateConc(cms.getDuration(), cms.getMaxStopTheWorldDuration());
                    return;
                }
                if (event.getGcType() == GcType.GARBAGE_FIRST_GC && (g1gc = (GcStatisticG1Gc)event).isConcurrent()) {
                    this.concGcIds.add(gcId);
                    this.updateConc(g1gc.getDuration(), g1gc.getMaxStopTheWorldDuration());
                    return;
                }
                this.updateYoung(event.getDuration());
            }
        }
        this.initial = false;
    }

    private void updateFull(long durationToAdd) {
        ++this.nrGcsFull;
        this.durationFull += durationToAdd;
        this.maxDurationFull = Math.max(this.maxDurationFull, durationToAdd);
    }

    private void updateYoung(long durationToAdd) {
        ++this.nrGcsYoung;
        this.durationYoung += durationToAdd;
        this.maxDurationYoung = Math.max(this.maxDurationYoung, durationToAdd);
    }

    private void updateConc(long durationToAdd, long maxPause) {
        ++this.nrGcsConc;
        this.durationConc += maxPause;
        this.maxDurationConc = Math.max(this.maxDurationConc, maxPause);
    }

    public static void enableTestMode() {
        isTest = true;
    }
}

