/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.gc;

import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValueElement;
import com.sap.jvm.profiling.snapshot.util.Value;
import com.sap.jvm.util.persistence.VersionMismatchException;
import java.io.IOException;

public class GcStatisticValue
implements Value<GcStatisticValue> {
    private static final int VERSION = 3;
    public static final byte TYPE_UNSPECIFIED = 0;
    public static final byte TYPE_FULL_GC = 1;
    public static final byte TYPE_PARTIAL_GC = 2;
    public static final byte TYPE_CONCURRENT_GC = 3;
    public static final GcStatisticValue EMPTY = new GcStatisticValue();
    private static final int numValues = GcStatisticValueElement.values().length;
    private static final int idxConcurrencyGroup = GcStatisticValueElement.CONCURRENCY_GROUP.ordinal();
    private long[] valueData = new long[numValues];

    private GcStatisticValue() {
    }

    public GcStatisticValue(GcStatistic gcStatisticEvent) {
        this();
        GcStatisticValueElement[] elements = GcStatisticValueElement.values();
        for (int i = 0; i < numValues; ++i) {
            this.valueData[i] = elements[i].getValue(gcStatisticEvent);
        }
    }

    public GcStatisticValue(ResourceReader reader) throws IOException {
        this();
        reader.readVersion(3);
        int size = reader.readInt32();
        if (size != numValues) {
            throw new VersionMismatchException(size, numValues);
        }
        this.valueData = new long[numValues];
        for (int i = 0; i < size; ++i) {
            this.valueData[i] = reader.readInt64();
        }
    }

    public GcStatisticValue(long[] data) {
        this();
        assert (data.length <= numValues);
        System.arraycopy(data, 0, this.valueData, 0, data.length);
    }

    public long getElementValue(GcStatisticValueElement element) {
        return this.valueData[element.ordinal()];
    }

    public long getElementValue(int elementIdx) {
        return this.valueData[elementIdx];
    }

    public int getConcurrencyGroup() {
        return (int)this.valueData[idxConcurrencyGroup];
    }

    public void setConcurrencyGroup(int concurrencyGroup) {
        assert (this.getConcurrencyGroup() == 0 || this.getConcurrencyGroup() == concurrencyGroup);
        this.valueData[GcStatisticValue.idxConcurrencyGroup] = concurrencyGroup;
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(3);
        int size = this.valueData.length;
        writer.writeInt32(size);
        for (int i = 0; i < size; ++i) {
            writer.writeInt64(this.valueData[i]);
        }
    }

    @Override
    public GcStatisticValue getSum(GcStatisticValue toAdd) {
        GcStatisticValue result = new GcStatisticValue();
        for (int i = 0; i < this.valueData.length; ++i) {
            result.valueData[i] = this.valueData[i] + toAdd.valueData[i];
        }
        return result;
    }
}

