/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventG1IncrementalGc;
import com.sap.jvm.profiling.memory.event.GcEventGenerational;
import com.sap.jvm.profiling.memory.event.GcEventParallelGcScavenge;
import com.sap.jvm.profiling.memory.event.GcEventParallelNewGc;
import com.sap.jvm.profiling.memory.event.GcEventSerialNewGc;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.memory.event.GcEventYoungGenPromotionFailure;
import com.sap.jvm.profiling.memory.event.GcG1CollectionSet;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcStatisticConcMarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcStatisticG1Gc;
import com.sap.jvm.profiling.memory.event.GcStatisticParallelGc;
import com.sap.jvm.profiling.memory.event.GcStatisticParallelNewGc;
import com.sap.jvm.profiling.memory.event.GcStatisticParallelOldGc;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.snapshot.gc.StatisticValueElement;
import com.sap.jvm.profiling.util.TriPredicate;

public enum GcStatisticValueElement implements StatisticValueElement
{
    GC_NR(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getGcNr();
        }
    }),
    GC_TYPE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            GcStatisticG1Gc g1gc;
            GcStatisticConcMarkSweepGc cms;
            if (gcStatistic.isFullGc()) {
                return 1L;
            }
            if (gcStatistic.getGcType() == GcType.CONC_MARK_SWEEP_GC && (cms = (GcStatisticConcMarkSweepGc)gcStatistic).isConcurrent()) {
                return 3L;
            }
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC && (g1gc = (GcStatisticG1Gc)gcStatistic).isConcurrent()) {
                return 3L;
            }
            return 2L;
        }
    }),
    COLLECTION_SET(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getCollectionSet().ordinal();
            }
            return GcG1CollectionSet.NOT_APPLICABLE.ordinal();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC)),
    MAX_PAUSE_TIME(new LongGetter(){

        @Override
        long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getMaxStopTheWorldDuration() * 1000L;
        }
    }),
    DURATION(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getDuration() * 1000L;
        }
    }),
    CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCpuTime() * 1000L;
        }
    }),
    GC_CAUSE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCause().ordinal();
        }
    }),
    TIME_STAMP(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getTimestamp();
        }
    }),
    CONCURRENCY_GROUP(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return 0L;
        }
    }),
    GC_ALGORITHM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getGcType().ordinal();
        }
    }),
    PROMOTION_FAILURES(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            long promotionFailures = 0L;
            for (GcEventBase event : gcStatistic.getEvents()) {
                if (!(event instanceof GcEventYoungGenPromotionFailure)) continue;
                promotionFailures += (long)((GcEventYoungGenPromotionFailure)event).getFailedPromotionsCount();
            }
            return promotionFailures;
        }
    }),
    FORCED_SOFT_REF_CLEAR(new BooleanGetter(){

        @Override
        public boolean getBool(GcStatistic gcStatistic) {
            return gcStatistic.isForcedSoftRefClear();
        }
    }),
    NR_OF_UNLOADED_CLASSES(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getNrOfNonArrayClassesBeforeGc() + gcStatistic.getNrOfArrayClassesBeforeGc() - (gcStatistic.getNrOfNonArrayClassesAfterGc() + gcStatistic.getNrOfArrayClassesAfterGc());
        }
    }),
    NR_OF_ARRAY_CLASSES_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getNrOfArrayClassesBeforeGc();
        }
    }),
    NR_OF_ARRAY_CLASSES_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getNrOfArrayClassesAfterGc();
        }
    }),
    NR_OF_NON_ARRAY_CLASSES_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getNrOfNonArrayClassesBeforeGc();
        }
    }),
    NR_OF_NON_ARRAY_CLASSES_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getNrOfNonArrayClassesAfterGc();
        }
    }),
    ALLOCATION_GOAL(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getAllocationGoal();
        }
    }),
    PAGE_FAULTS(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getPageFaults();
        }
    }),
    MAJOR_PAGE_FAULTS(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getMajorPageFaults();
        }
    }),
    MINOR_PAGE_FAULTS(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getMinorPageFaults();
        }
    }),
    BYTES_IN_YOUNG_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInYoungBeforeGc();
        }
    }),
    BYTES_IN_YOUNG_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInYoungAfterGc();
        }
    }),
    BYTES_IN_YOUNG_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInYoungAfterGc() - gcStatistic.getBytesInYoungBeforeGc();
        }
    }),
    BYTES_IN_YOUNG_DIFFERENCE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInYoungAfterGc() - gcStatistic.getBytesInYoungBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_YOUNG_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInYoungBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_YOUNG_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInYoungAfterGc();
        }
    }),
    BYTES_IN_TO_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInToBeforeGc();
        }
    }),
    BYTES_IN_TO_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInToAfterGc();
        }
    }),
    BYTES_IN_TO_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInToAfterGc() - gcStatistic.getBytesInToBeforeGc();
        }
    }),
    BYTES_IN_TO_DIFFERENCE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInToAfterGc() - gcStatistic.getBytesInToBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_TO_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInToBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_TO_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInToAfterGc();
        }
    }),
    BYTES_IN_FROM_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInFromBeforeGc();
        }
    }),
    BYTES_IN_FROM_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInFromAfterGc();
        }
    }),
    BYTES_IN_FROM_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInFromAfterGc() - gcStatistic.getBytesInFromBeforeGc();
        }
    }),
    BYTES_IN_FROM_DIFFERENCE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInFromAfterGc() - gcStatistic.getBytesInFromBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_FROM_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInFromBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_FROM_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInFromAfterGc();
        }
    }),
    BYTES_IN_EDEN_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInEdenBeforeGc();
        }
    }),
    BYTES_IN_EDEN_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInEdenAfterGc();
        }
    }),
    BYTES_IN_EDEN_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInEdenAfterGc() - gcStatistic.getBytesInEdenBeforeGc();
        }
    }),
    BYTES_IN_EDEN_DIFFERENCE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInEdenAfterGc() - gcStatistic.getBytesInEdenBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_EDEN_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInEdenBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_EDEN_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInEdenAfterGc();
        }
    }),
    BYTES_WASTED_BY_TLABS_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesWastedByTLABsBeforeGc();
        }
    }),
    BYTES_IN_OLD_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInOldBeforeGc();
        }
    }),
    BYTES_IN_OLD_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInOldAfterGc();
        }
    }),
    BYTES_IN_OLD_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInOldAfterGc() - gcStatistic.getBytesInOldBeforeGc();
        }
    }),
    BYTES_IN_OLD_DIFFERENCE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInOldAfterGc() - gcStatistic.getBytesInOldBeforeGc();
        }
    }),
    PROMOTIONS_TO_OLD(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            long result = 0L;
            for (GcEventBase event : gcStatistic.getEvents()) {
                GcEventGenerational ev;
                if (event instanceof GcEventParallelGcScavenge || event instanceof GcEventParallelNewGc || event instanceof GcEventSerialNewGc) {
                    ev = (GcEventGenerational)event;
                    result += ev.getBytesInOldAfter() - ev.getBytesInOldBefore();
                    continue;
                }
                if (!(event instanceof GcEventG1IncrementalGc)) continue;
                ev = (GcEventGenerational)event;
                result += Math.max(0L, ev.getBytesInOldAfter() - ev.getBytesInOldBefore());
            }
            return result;
        }
    }),
    SURVIVING_YOUNG(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            long survivingYoung = -1L;
            for (GcEventBase event : gcStatistic.getEvents()) {
                int[] ageSizes = null;
                if (event instanceof GcEventParallelGcScavenge) {
                    ageSizes = ((GcEventParallelGcScavenge)event).getAgeSizes();
                } else if (event instanceof GcEventParallelNewGc) {
                    ageSizes = ((GcEventParallelNewGc)event).getAgeSizes();
                } else if (event instanceof GcEventSerialNewGc) {
                    ageSizes = ((GcEventSerialNewGc)event).getAgeSizes();
                } else if (event instanceof GcEventG1IncrementalGc) {
                    ageSizes = ((GcEventG1IncrementalGc)event).getAgeSizes();
                }
                if (ageSizes == null) continue;
                if (survivingYoung == -1L) {
                    survivingYoung = 0L;
                }
                for (int i = 0; i < ageSizes.length; ++i) {
                    survivingYoung += (long)ageSizes[i];
                }
            }
            return survivingYoung;
        }
    }),
    COMMITTED_BYTES_IN_OLD_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInOldBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_OLD_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInOldAfterGc();
        }
    }),
    BYTES_IN_NON_PERM_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInNonPermBeforeGc();
        }
    }),
    BYTES_IN_NON_PERM_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInNonPermAfterGc();
        }
    }),
    BYTES_IN_NON_PERM_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInNonPermAfterGc() - gcStatistic.getBytesInNonPermBeforeGc();
        }
    }),
    BYTES_IN_NON_PERM_DIFFERENCE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInNonPermAfterGc() - gcStatistic.getBytesInNonPermBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_NON_PERM_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInNonPermBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_NON_PERM_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInNonPermAfterGc();
        }
    }),
    BYTES_IN_PERM_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInPermBeforeGc();
        }
    }),
    BYTES_IN_PERM_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInPermAfterGc();
        }
    }),
    BYTES_IN_CLASS_SPACE_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInClassSpaceBeforeGc();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticHasClassSpaceData())),
    BYTES_IN_CLASS_SPACE_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInClassSpaceAfterGc();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticHasClassSpaceData())),
    COMMITTED_BYTES_IN_CLASS_SPACE_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInClassSpaceBeforeGc();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticHasClassSpaceData())),
    COMMITTED_BYTES_IN_CLASS_SPACE_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInClassSpaceAfterGc();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticHasClassSpaceData())),
    BYTES_IN_CLASS_SPACE_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInClassSpaceAfterGc() - gcStatistic.getBytesInClassSpaceBeforeGc();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticHasClassSpaceData())),
    BYTES_IN_CLASS_SPACE_DIFFERENCE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInClassSpaceAfterGc() - gcStatistic.getBytesInClassSpaceBeforeGc();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticHasClassSpaceData())),
    MAX_CLASS_SPACE_SIZE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getMaxClassSpaceSize();
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> session.getSystemInfo().gcStatisticHasClassSpaceData())),
    BYTES_IN_PERM_BEFORE_AND_AFTER(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInPermAfterGc() - gcStatistic.getBytesInPermBeforeGc();
        }
    }),
    BYTES_IN_PERM_DIFFERENCE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getBytesInPermAfterGc() - gcStatistic.getBytesInPermBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_PERM_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInPermBeforeGc();
        }
    }),
    COMMITTED_BYTES_IN_PERM_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInPermAfterGc();
        }
    }),
    BYTES_DECOMMITTED_IN_JAVA_HEAP(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCommittedBytesInNonPermBeforeGc() - gcStatistic.getCommittedBytesInNonPermAfterGc();
        }
    }),
    MAX_OLD_GEN_SIZE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getMaxOldGenSize();
        }
    }),
    MAX_PERM_GEN_SIZE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getMaxPermGenSize();
        }
    }),
    MAX_NON_PERM_GEN_SIZE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getMaxNonPermGenSize();
        }
    }),
    MAX_YOUNG_GEN_SIZE(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getMaxYoungGenSize();
        }
    }),
    NR_OF_FULL_GCS(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getNrOfFullGcs();
        }
    }),
    TENURING_THRESHOLD(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getTenuringThreshold();
        }
    }),
    CUMULATIVE_DURATION(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCumulativeDuration() / 1000L;
        }
    }),
    CUMULATIVE_CPU_TIME(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCumulativeCpuTime() * 1000L;
        }
    }),
    CUMULATIVE_PAGE_FAULTS(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCumulativePageFaults();
        }
    }),
    CUMULATIVE_MAJOR_PAGE_FAULTS(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCumulativeMajorPageFaults();
        }
    }),
    CUMULATIVE_MINOR_PAGE_FAULTS(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCumulativeMinorPageFaults();
        }
    }),
    CUMULATIVE_UNLOADED_NON_ARRAY_CLASSES(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCumulativeNrOfUnloadedNonArrayClasses();
        }
    }),
    CUMULATIVE_UNLOADED_ARRAY_CLASSES(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCumulativeNrOfUnloadedArrayClasses();
        }
    }),
    CUMULATIV_BYTES_ALLOCATED_IN_PERM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCumulativeBytesAllocatedInPerm();
        }
    }),
    CUMULATIV_BYTES_FREED_IN_PERM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCumulativeBytesFreedInPerm();
        }
    }),
    CUMULATIV_BYTES_ALLOCATED_IN_NON_PERM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCumulativeBytesAllocatedInNonPerm();
        }
    }),
    CUMULATIV_BYTES_FREED_IN_NON_PERM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getCumulativeBytesFreedInNonPerm();
        }
    }),
    CLEARED_SOFT_REFS_SUM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getClearedSoftRefsSum();
        }
    }),
    ENQUEUED_SOFT_REFS_SUM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getEnqueuedSoftRefsSum();
        }
    }),
    CLEARED_WEAK_REFS_SUM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getClearedWeakRefsSum();
        }
    }),
    ENQUEUED_WEAK_REFS_SUM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getEnqueuedWeakRefsSum();
        }
    }),
    ENQUEUED_FINAL_REFS_SUM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getEnqueuedFinalRefsSum();
        }
    }),
    ENQUEUED_PHANTOM_REFS_SUM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            return gcStatistic.getEnqueuedPhantomRefsSum();
        }
    }),
    IS_CONCURRENT(new BooleanGetter(){

        @Override
        public boolean getBool(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.CONC_MARK_SWEEP_GC) {
                return ((GcStatisticConcMarkSweepGc)gcStatistic).isConcurrent();
            }
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).isConcurrent();
            }
            return false;
        }
    }),
    IS_COMPACTING_OLD(new BooleanGetter(){

        @Override
        public boolean getBool(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.CONC_MARK_SWEEP_GC) {
                return ((GcStatisticConcMarkSweepGc)gcStatistic).isCompactingOld();
            }
            return false;
        }
    }),
    NR_OF_THREADS(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.CONC_MARK_SWEEP_GC) {
                return ((GcStatisticConcMarkSweepGc)gcStatistic).getNrOfThreads();
            }
            return 0L;
        }
    }),
    BYTES_FREED_CONCURRENTLY_IN_OLD(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.CONC_MARK_SWEEP_GC) {
                return ((GcStatisticConcMarkSweepGc)gcStatistic).getBytesFreedConcurrentlyInOld();
            }
            return 0L;
        }
    }),
    BYTES_FREED_CONCURRENTLY_IN_PERM(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.CONC_MARK_SWEEP_GC) {
                return ((GcStatisticConcMarkSweepGc)gcStatistic).getBytesFreedConcurrentlyInPerm();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> !session.getSystemInfo().hasMetaspace())),
    BYTES_FREED_CONCURRENTLY(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getBytesFreedConcurrently();
            }
            return 0L;
        }
    }),
    NR_OF_NON_ARRAY_CLASSES_UNLOADED_CONCURRENTLY(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.CONC_MARK_SWEEP_GC) {
                return ((GcStatisticConcMarkSweepGc)gcStatistic).getNrOfNonArrayClassesUnloadedConcurrently();
            }
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getNrOfNonArrayClassesUnloadedConcurrently();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.CONC_MARK_SWEEP_GC || session.getSystemInfo().gcStatisticVersion() > 0)),
    NR_OF_ARRAY_CLASSES_UNLOADED_CONCURRENTLY(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.CONC_MARK_SWEEP_GC) {
                return ((GcStatisticConcMarkSweepGc)gcStatistic).getNrOfArrayClassesUnloadedConcurrently();
            }
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getNrOfArrayClassesUnloadedConcurrently();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.CONC_MARK_SWEEP_GC || session.getSystemInfo().gcStatisticVersion() > 0)),
    HUMONGOUS_REGIONS_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getHumongousRegionsBeforeGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    HUMONGOUS_REGIONS_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getHumongousRegionsAfterGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    HUMONGOUS_START_REGIONS_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getHumongousStartRegionsBeforeGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    HUMONGOUS_START_REGIONS_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getHumongousStartRegionsAfterGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    FREE_REGIONS_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getFreeRegionsBeforeGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    FREE_REGIONS_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getFreeRegionsAfterGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    YOUNG_REGIONS_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getYoungRegionsBeforeGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    YOUNG_REGIONS_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getYoungRegionsAfterGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    SURVIVOR_REGIONS_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getSurvivorRegionsBeforeGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    SURVIVOR_REGIONS_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getSurvivorRegionsAfterGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    YOUNG_LIST_TARGET_REGIONS_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getYoungListTargetRegionsBeforeGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    YOUNG_LIST_TARGET_REGIONS_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getYoungListTargetRegionsAfterGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    YOUNG_LIST_MAXIMUM_REGIONS_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getYoungListMaximumRegionsBeforeGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    YOUNG_LIST_MAXIMUM_REGIONS_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getYoungListMaximumRegionsAfterGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    COMMITTED_REGIONS_BEFORE_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getCommittedRegionsBeforeGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    COMMITTED_REGIONS_AFTER_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getCommittedRegionsAfterGc();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    YOUNG_LIST_TARGET_SEL_REASON(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC) {
                return ((GcStatisticG1Gc)gcStatistic).getYoungListTargetSelReason().ordinal();
            }
            return 0L;
        }
    }, (TriPredicate<ProfilingSession, GcType, GcEventType>)((TriPredicate)(session, gcType, evType) -> gcType == GcType.GARBAGE_FIRST_GC && session.getSystemInfo().gcStatisticHasG1SpecificDetails())),
    NR_OF_SCAVENGE_THREADS(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic instanceof GcStatisticParallelGc) {
                return ((GcStatisticParallelGc)gcStatistic).getNrOfScavengeThreads();
            }
            if (gcStatistic instanceof GcStatisticParallelOldGc) {
                return ((GcStatisticParallelOldGc)gcStatistic).getNrOfScavengeThreads();
            }
            if (gcStatistic instanceof GcStatisticG1Gc) {
                return ((GcStatisticG1Gc)gcStatistic).getNrOfScavengeThreads();
            }
            if (gcStatistic instanceof GcStatisticParallelNewGc) {
                return ((GcStatisticParallelNewGc)gcStatistic).getNrOfScavengeThreads();
            }
            return 0L;
        }
    }),
    NR_OF_COMPACT_THREADS(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            if (gcStatistic.getGcType() == GcType.PARALLEL_OLD_GC) {
                return ((GcStatisticParallelOldGc)gcStatistic).getNrOfCompactThreads();
            }
            return 0L;
        }
    }),
    TIME_SINCE_LAST_CONC_GC(new LongGetter(){

        @Override
        public long getLong(GcStatistic gcStatistic) {
            long millis = gcStatistic.getMillisSinceLastConcGC();
            return millis == -1L ? -1L : millis * 1000000L;
        }
    });

    public static final int TYPE_BOOLEAN = 0;
    public static final int TYPE_LONG = 1;
    public static final String TAG_PREFIX = "GC_";
    private Getter getter;
    private TriPredicate<ProfilingSession, GcType, GcEventType> isApplicablePredicate;

    private GcStatisticValueElement(Getter getter) {
        this.getter = getter;
        this.isApplicablePredicate = P.TRUE;
    }

    private GcStatisticValueElement(Getter getter, TriPredicate<ProfilingSession, GcType, GcEventType> isApplicablePredicate) {
        this.getter = getter;
        this.isApplicablePredicate = isApplicablePredicate;
    }

    public int getType() {
        return this.getter.getType();
    }

    public long getValue(GcStatistic gcStatistic) {
        return this.getter.getValue(gcStatistic);
    }

    @Override
    public String getColumnTag() {
        return TAG_PREFIX + this.name();
    }

    @Override
    public boolean isApplicable(ProfilingSession session, GcType type, GcEventType eventType) {
        return this.isApplicablePredicate.test((Object)session, (Object)type, (Object)eventType);
    }

    private static class P {
        public static final TriPredicate<ProfilingSession, GcType, GcEventType> TRUE = (s, gc, ev) -> true;

        private P() {
        }
    }

    private static abstract class LongGetter
    implements Getter {
        private LongGetter() {
        }

        abstract long getLong(GcStatistic var1);

        @Override
        public int getType() {
            return 1;
        }

        @Override
        public long getValue(GcStatistic gcStatistic) {
            return this.getLong(gcStatistic);
        }
    }

    private static abstract class BooleanGetter
    implements Getter {
        private BooleanGetter() {
        }

        abstract boolean getBool(GcStatistic var1);

        @Override
        public int getType() {
            return 0;
        }

        @Override
        public long getValue(GcStatistic gcStatistic) {
            return this.getBool(gcStatistic) ? 1L : 0L;
        }
    }

    private static interface Getter {
        public long getValue(GcStatistic var1);

        public int getType();
    }
}

