/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.hprof;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;

public class HprofAddonsIdReader {
    private final int[] offsets;
    private final byte[] indices;
    private final long[] longIds;
    private final int[] intIds;
    private final long baseAddress;
    private final long baseId;

    public HprofAddonsIdReader(File addonsFile, ProgressReporter reporter) throws IOException {
        FileInputStream fis = new FileInputStream(addonsFile);
        BufferedInputStream bis = new BufferedInputStream(fis);
        DataInputStream dis = new DataInputStream(bis);
        String header = dis.readUTF();
        if (!header.equals("HPROF_ADDITIONAL_INFO_SAPJVM_V1.0")) {
            dis.close();
            throw new IOException(I18n._s((String)"File '{0}' is no valid hprof addons file (wrong header: '{1}')", (Object[])new Object[]{addonsFile, header}));
        }
        long minAddress = Long.MAX_VALUE;
        long maxAddress = Long.MIN_VALUE;
        long minId = Long.MAX_VALUE;
        long maxId = Long.MIN_VALUE;
        long nrOfIds = 0L;
        try {
            long address;
            long i;
            long sectionLength;
            while (true) {
                long id;
                long address2;
                long i2;
                String tag = dis.readUTF();
                long sectionLength2 = dis.readLong();
                if (tag.equals("HPROF_OBJECT_IDS_INFO_SAPJVM_V1.0_32")) {
                    nrOfIds = dis.readLong();
                    reporter.addWork(I18n._s((String)"Reading addons file ..."), 3L * nrOfIds);
                    for (i2 = 0L; i2 < nrOfIds; ++i2) {
                        reporter.reportNextOrThrow();
                        address2 = ((long)dis.readInt() & 0xFFFFFFFFL) >>> 3;
                        id = dis.readLong() >>> 26;
                        minAddress = Math.min(minAddress, address2);
                        maxAddress = Math.max(maxAddress, address2);
                        minId = Math.min(minId, id);
                        maxId = Math.max(maxId, id);
                    }
                    break;
                }
                if (tag.equals("HPROF_OBJECT_IDS_INFO_SAPJVM_V1.0_64")) {
                    nrOfIds = dis.readLong();
                    reporter.addWork(I18n._s((String)"Reading addons file ..."), 3L * nrOfIds);
                    for (i2 = 0L; i2 < nrOfIds; ++i2) {
                        reporter.reportNextOrThrow();
                        address2 = dis.readLong() >>> 3;
                        id = dis.readLong() >>> 26;
                        minAddress = Math.min(minAddress, address2);
                        maxAddress = Math.max(maxAddress, address2);
                        minId = Math.min(minId, id);
                        maxId = Math.max(maxId, id);
                    }
                    break;
                }
                dis.skip(sectionLength2);
            }
            dis.close();
            if (nrOfIds == 0L) {
                this.offsets = new int[0];
                this.indices = null;
                this.intIds = null;
                this.longIds = null;
                this.baseAddress = 0L;
                this.baseId = 0L;
                return;
            }
            long nrOfBuckets = 1L + (maxAddress - minAddress) / 256L;
            if (nrOfBuckets >= Integer.MAX_VALUE) {
                throw new IOException(I18n._s((String)"The addons file spans {0} bytes, which is more than we can handle.", (Object[])new Object[]{8L * (maxAddress - minAddress)}));
            }
            if (nrOfIds >= Integer.MAX_VALUE) {
                throw new IOException(I18n._s((String)"The addons file contains {0} entries, which is more than we can handle.", (Object[])new Object[]{nrOfIds}));
            }
            this.baseAddress = minAddress;
            this.baseId = minId;
            this.offsets = new int[1 + (int)nrOfBuckets];
            this.indices = new byte[(int)nrOfIds];
            if (maxId - minId < 0x100000000L) {
                this.intIds = new int[(int)nrOfIds];
                this.longIds = null;
            } else {
                this.intIds = null;
                this.longIds = new long[(int)nrOfIds];
            }
            fis = new FileInputStream(addonsFile);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            header = dis.readUTF();
            if (!header.equals("HPROF_ADDITIONAL_INFO_SAPJVM_V1.0")) {
                dis.close();
                throw new IOException(I18n._s((String)"File '{0} is no valid hprof addons file (wrong header: '{1}')", (Object[])new Object[]{addonsFile, header}));
            }
            while (true) {
                int bucket;
                String tag = dis.readUTF();
                sectionLength = dis.readLong();
                if (tag.equals("HPROF_OBJECT_IDS_INFO_SAPJVM_V1.0_32")) {
                    nrOfIds = dis.readLong();
                    reporter.addWork(I18n._s((String)"Reading addons file ..."), 3L * nrOfIds);
                    for (i = 0L; i < nrOfIds; ++i) {
                        reporter.reportNextOrThrow();
                        address = ((long)dis.readInt() & 0xFFFFFFFFL) >>> 3;
                        dis.readLong();
                        int n = bucket = (int)(address - this.baseAddress >>> 8);
                        this.offsets[n] = this.offsets[n] + 1;
                    }
                    break;
                }
                if (tag.equals("HPROF_OBJECT_IDS_INFO_SAPJVM_V1.0_64")) {
                    nrOfIds = dis.readLong();
                    reporter.addWork(I18n._s((String)"Reading addons file ..."), 3L * nrOfIds);
                    for (i = 0L; i < nrOfIds; ++i) {
                        reporter.reportNextOrThrow();
                        address = dis.readLong() >>> 3;
                        dis.readLong();
                        int n = bucket = (int)(address - this.baseAddress >>> 8);
                        this.offsets[n] = this.offsets[n] + 1;
                    }
                    break;
                }
                dis.skip(sectionLength);
            }
            for (int i3 = 1; i3 < this.offsets.length; ++i3) {
                int n = i3;
                this.offsets[n] = this.offsets[n] + this.offsets[i3 - 1];
            }
            this.offsets[this.offsets.length - 1] = this.indices.length;
            dis.close();
            fis = new FileInputStream(addonsFile);
            bis = new BufferedInputStream(fis);
            dis = new DataInputStream(bis);
            header = dis.readUTF();
            if (!header.equals("HPROF_ADDITIONAL_INFO_SAPJVM_V1.0")) {
                dis.close();
                throw new IOException(I18n._s((String)"File '{0} is no valid hprof addons file (wrong header: '{1}')", (Object[])new Object[]{addonsFile, header}));
            }
            while (true) {
                String tag = dis.readUTF();
                sectionLength = dis.readLong();
                if (tag.equals("HPROF_OBJECT_IDS_INFO_SAPJVM_V1.0_32")) {
                    nrOfIds = dis.readLong();
                    reporter.addWork(I18n._s((String)"Reading addons file ..."), 3L * nrOfIds);
                    for (i = 0L; i < nrOfIds; ++i) {
                        int newOffset;
                        reporter.reportNextOrThrow();
                        address = ((long)dis.readInt() & 0xFFFFFFFFL) >>> 3;
                        long id = dis.readLong() >>> 26;
                        int bucket = (int)(address - this.baseAddress >>> 8);
                        byte index = (byte)(address - this.baseAddress & 0xFFL);
                        this.offsets[bucket] = newOffset = this.offsets[bucket] - 1;
                        this.indices[newOffset] = index;
                        if (this.intIds != null) {
                            this.intIds[newOffset] = (int)(id - this.baseId);
                            continue;
                        }
                        this.longIds[newOffset] = id - this.baseId;
                    }
                    break;
                }
                if (tag.equals("HPROF_OBJECT_IDS_INFO_SAPJVM_V1.0_64")) {
                    nrOfIds = dis.readLong();
                    reporter.addWork(I18n._s((String)"Reading addons file ..."), 3L * nrOfIds);
                    for (i = 0L; i < nrOfIds; ++i) {
                        int newOffset;
                        reporter.reportNextOrThrow();
                        address = dis.readLong() >>> 3;
                        long id = dis.readLong() >>> 26;
                        int bucket = (int)(address - this.baseAddress >>> 8);
                        byte index = (byte)(address - this.baseAddress & 0xFFL);
                        this.offsets[bucket] = newOffset = this.offsets[bucket] - 1;
                        this.indices[newOffset] = index;
                        if (this.intIds != null) {
                            this.intIds[newOffset] = (int)(id - this.baseId);
                            continue;
                        }
                        this.longIds[newOffset] = id - this.baseId;
                    }
                    break;
                }
                dis.skip(sectionLength);
            }
            dis.close();
        }
        catch (EOFException e) {
            IOException e2 = new IOException(I18n._s((String)"No ids section found in addons file {0}", (Object[])new Object[]{addonsFile}));
            e2.initCause(e);
            throw e2;
        }
    }

    public long getIdForAddress(long address) {
        int bucket = (int)((address >>> 3) - this.baseAddress >>> 8);
        if (bucket < 0 || bucket >= this.offsets.length - 1) {
            return 0L;
        }
        byte index = (byte)((address >>> 3) - this.baseAddress & 0xFFL);
        int fromOffset = this.offsets[bucket];
        int toOffset = this.offsets[bucket + 1];
        for (int i = fromOffset; i < toOffset; ++i) {
            if (this.indices[i] != index) continue;
            if (this.intIds != null) {
                return ((long)this.intIds[i] & 0xFFFFFFFFL) + this.baseId;
            }
            return this.longIds[i] + this.baseId;
        }
        return 0L;
    }
}

