/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.hprof;

import com.sap.jvm.profiling.memory.event.HprofDumpEnd;
import com.sap.jvm.profiling.memory.event.HprofDumpStart;
import com.sap.jvm.profiling.memory.response.HprofDumpResponse;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import java.io.IOException;

public class HprofDumpProperties {
    private static final int VERSION = 0;
    private long size;
    private long addonSize;
    private long nrOfObjects;
    private final long duration;
    private final String name;
    private final boolean forceGcRequested;
    private final boolean forcedGc;
    private final boolean includesAddons;
    private final boolean ensuredIdsForAllObjects;

    public HprofDumpProperties(HprofDumpStart startEvent, HprofDumpEnd endEvent) {
        this.size = endEvent.getSize();
        this.addonSize = endEvent.getAddonSize();
        this.nrOfObjects = endEvent.getNumberOfObjects();
        this.duration = endEvent.getEndTime() - startEvent.getStartTime();
        this.name = startEvent.getName();
        this.forceGcRequested = startEvent.forceGcRequested();
        this.forcedGc = startEvent.forcedGc();
        this.includesAddons = startEvent.includesAddons();
        this.ensuredIdsForAllObjects = startEvent.ensuredIdsForAllObjects();
    }

    public HprofDumpProperties(HprofDumpResponse response) {
        this.size = 0L;
        this.addonSize = 0L;
        this.nrOfObjects = 0L;
        this.duration = 0L;
        this.name = response.getName();
        this.forceGcRequested = response.forceGcRequested();
        this.forcedGc = response.forceGcRequested();
        this.includesAddons = response.includesAddons();
        this.ensuredIdsForAllObjects = response.ensuredIdsForAllObjects();
    }

    public HprofDumpProperties(ResourceReader reader) throws IOException {
        reader.readVersion(0);
        this.size = reader.readInt64();
        this.addonSize = reader.readInt64();
        this.nrOfObjects = reader.readInt64();
        this.duration = reader.readInt64();
        this.name = reader.readString();
        this.forceGcRequested = reader.readBoolean();
        this.forcedGc = reader.readBoolean();
        this.includesAddons = reader.readBoolean();
        this.ensuredIdsForAllObjects = reader.readBoolean();
    }

    public void write(ResourceWriter writer) throws IOException {
        writer.writeVersion(0);
        writer.writeInt64(this.size);
        writer.writeInt64(this.addonSize);
        writer.writeInt64(this.nrOfObjects);
        writer.writeInt64(this.duration);
        writer.writeString(this.name);
        writer.writeBoolean(this.forceGcRequested);
        writer.writeBoolean(this.forcedGc);
        writer.writeBoolean(this.includesAddons);
        writer.writeBoolean(this.ensuredIdsForAllObjects);
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public long getAddonSize() {
        return this.addonSize;
    }

    public void setAddonSize(long addonSize) {
        this.addonSize = addonSize;
    }

    public long getNrOfObjects() {
        return this.nrOfObjects;
    }

    public void setNrOfObjects(long nrOfObjects) {
        this.nrOfObjects = nrOfObjects;
    }

    public long getDuration() {
        return this.duration;
    }

    public String getName() {
        return this.name;
    }

    public boolean forceGcRequested() {
        return this.forceGcRequested;
    }

    public boolean forcedGc() {
        return this.forcedGc;
    }

    public boolean includesAddons() {
        return this.includesAddons;
    }

    public boolean ensuredIdsForAllObjects() {
        return this.ensuredIdsForAllObjects;
    }
}

