/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.io.command.IOTraceConfiguration;
import com.sap.jvm.profiling.memory.command.AllocationTraceConfiguration;
import com.sap.jvm.profiling.memory.command.GcTraceConfiguration;
import com.sap.jvm.profiling.memory.event.OldGenClassStatistic;
import com.sap.jvm.profiling.memory.event.PermGenClassStatistic;
import com.sap.jvm.profiling.memory.event.YoungGenClassStatistic;
import com.sap.jvm.profiling.method.command.TimeBasedSamplingConfiguration;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.net.command.NetworkTraceConfiguration;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.GcHistoryFile.GcHistoryFileDumpSnapshot;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.alloc.AllocationSnapshot;
import com.sap.jvm.profiling.snapshot.cls.ClsSnapshot;
import com.sap.jvm.profiling.snapshot.elements.NarrowSnapshotByPacketNr;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshotProperties;
import com.sap.jvm.profiling.snapshot.hprof.HprofDumpProperties;
import com.sap.jvm.profiling.snapshot.hprof.HprofDumpSnapshot;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.cls.ClsSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.gc.GcHistoryFileDumpSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.gc.GcSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.hprof.HprofDumpSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.io.IOSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.mpt.MethodParameterSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.sync.SynchronizationSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.tbs.PerformanceHotspotSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpSnapshotImpl;
import com.sap.jvm.profiling.snapshot.io.IOSnapshot;
import com.sap.jvm.profiling.snapshot.mpt.MethodParameterSnapshot;
import com.sap.jvm.profiling.snapshot.net.NetworkSnapshot;
import com.sap.jvm.profiling.snapshot.sync.SynchronizationSnapshot;
import com.sap.jvm.profiling.snapshot.tbs.PerformanceHotspotSnapshot;
import com.sap.jvm.profiling.snapshot.thread.ThreadDumpSnapshot;
import com.sap.jvm.profiling.sync.command.SynchronizationTraceConfiguration;
import com.sap.jvm.profiling.thread.ThreadDump;
import java.io.IOException;
import java.util.List;

public final class SnapshotFactoryImpl {
    private ProfilingSession session;

    public SnapshotFactoryImpl(ProfilingSession session) {
        this.session = session;
    }

    private static long getAdjustedStartTimestamp(Snapshot parent, ResourceName name) {
        long startTimeStamp = parent.getStartCollectionTimeStamp();
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof NarrowSnapshotByPacketNr)) continue;
            NarrowSnapshotByPacketNr narrowElement = (NarrowSnapshotByPacketNr)element;
            startTimeStamp = Math.max(startTimeStamp, narrowElement.getStartTimestamp());
        }
        return startTimeStamp;
    }

    private static long getAdjustedEndTimestamp(Snapshot parent, ResourceName name) {
        long endTimeStamp = parent.getEndCollectionTimeStamp();
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof NarrowSnapshotByPacketNr)) continue;
            NarrowSnapshotByPacketNr narrowElement = (NarrowSnapshotByPacketNr)element;
            endTimeStamp = Math.min(endTimeStamp, narrowElement.getEndTimestamp());
        }
        return endTimeStamp;
    }

    private static Bookmark getAdjustedStartBookmark(Snapshot parent, ResourceName name) {
        long startPacket = parent.getStartBookmark().getNrOfReadEvents();
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof NarrowSnapshotByPacketNr)) continue;
            startPacket = Math.max(startPacket, ((NarrowSnapshotByPacketNr)element).getStartPacket());
        }
        return name.getSession().createBookmarkByPacketNr(startPacket);
    }

    private static Bookmark getAdjustedEndBookmark(Snapshot parent, ResourceName name) {
        long endPacket = parent.getEndBookmark().getNrOfReadEvents();
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof NarrowSnapshotByPacketNr)) continue;
            endPacket = Math.min(endPacket, ((NarrowSnapshotByPacketNr)element).getEndPacket());
        }
        return name.getSession().createBookmarkByPacketNr(endPacket);
    }

    public HprofDumpSnapshot createHprofDumpSnapshot(int id, ResourceName resourceName, String name, Bookmark start, Bookmark end, HprofDumpProperties properties, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual) {
        return new HprofDumpSnapshotImpl(id, resourceName, name, this.session, start, end, properties, startCollectionTimeStamp, endCollectionTimeStamp, isVirtual);
    }

    public AllocationSnapshot createAllocationSnapshot(int id, ResourceName resourceName, String name, Bookmark start, Bookmark end, AllocationTraceConfiguration allocTraceConfig, long nrOfAllocations, long nrOfAllocatedBytes, long nrOfInvocations, List<MethodParameterSpec> specs, List<MethodParameterMethodToTraceEvent> methodsToTrace, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, AllocationSnapshot parent) {
        return new AllocationSnapshotImpl(id, resourceName, name, this.session, start, end, allocTraceConfig, nrOfAllocations, nrOfAllocatedBytes, nrOfInvocations, specs, methodsToTrace, startCollectionTimeStamp, endCollectionTimeStamp, isVirtual, parent);
    }

    public AllocationSnapshot createAllocationSnapshot(int id, ResourceName resourceName, String name, AllocationSnapshot parent, boolean isVirtual, ProgressReporter reporter) throws OperationCanceledException {
        Bookmark startBookmark = SnapshotFactoryImpl.getAdjustedStartBookmark(parent, resourceName);
        Bookmark endBookmark = SnapshotFactoryImpl.getAdjustedEndBookmark(parent, resourceName);
        long startTimeStamp = SnapshotFactoryImpl.getAdjustedStartTimestamp(parent, resourceName);
        long endTimeStamp = SnapshotFactoryImpl.getAdjustedEndTimestamp(parent, resourceName);
        AllocationSnapshotImpl snapshot = new AllocationSnapshotImpl(id, resourceName, name, this.session, startBookmark, endBookmark, parent.getTraceConfiguration(), -1L, -1L, parent.getNrOfInvocations(), parent.getParameterSpecs(), parent.getMethodsToTrace(), startTimeStamp, endTimeStamp, isVirtual, parent);
        return snapshot;
    }

    public PerformanceHotspotSnapshot createPerformanceHotspotSnapshot(int id, ResourceName resourceName, String name, Bookmark start, Bookmark end, TimeBasedSamplingConfiguration traceConfig, long nrOfSamples, long runningTime, long cpuTime, long sleepingTime, long nrOfInvocations, List<MethodParameterSpec> specs, List<MethodParameterMethodToTraceEvent> methodsToTrace, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, PerformanceHotspotSnapshot parent) {
        return new PerformanceHotspotSnapshotImpl(id, resourceName, name, this.session, start, end, traceConfig, nrOfSamples, runningTime, cpuTime, sleepingTime, nrOfInvocations, specs, methodsToTrace, startCollectionTimeStamp, endCollectionTimeStamp, isVirtual, parent);
    }

    public PerformanceHotspotSnapshot createPerformanceHotspotSnapshot(int id, ResourceName resourceName, String name, PerformanceHotspotSnapshot parent, boolean isVirtual, ProgressReporter reporter) throws IOException {
        Bookmark startBookmark = SnapshotFactoryImpl.getAdjustedStartBookmark(parent, resourceName);
        Bookmark endBookmark = SnapshotFactoryImpl.getAdjustedEndBookmark(parent, resourceName);
        long startTimeStamp = SnapshotFactoryImpl.getAdjustedStartTimestamp(parent, resourceName);
        long endTimeStamp = SnapshotFactoryImpl.getAdjustedEndTimestamp(parent, resourceName);
        PerformanceHotspotSnapshotImpl snapshot = new PerformanceHotspotSnapshotImpl(id, resourceName, name, this.session, startBookmark, endBookmark, parent.getConfig(), parent.getNrOfInvocations(), parent.getParameterSpecs(), parent.getMethodsToTrace(), startTimeStamp, endTimeStamp, isVirtual, parent, reporter);
        return snapshot;
    }

    public MethodParameterSnapshot createMethodParameterSnapshot(int id, ResourceName resourceName, String name, Bookmark start, Bookmark end, long nrOfInvocations, List<MethodParameterSpec> specs, List<MethodParameterMethodToTraceEvent> methodsToTrace, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, MethodParameterSnapshot parent) {
        return new MethodParameterSnapshotImpl(id, resourceName, name, this.session, start, end, nrOfInvocations, specs, methodsToTrace, startCollectionTimeStamp, endCollectionTimeStamp, isVirtual, parent);
    }

    public MethodParameterSnapshot createMethodParameterSnapshot(int id, ResourceName resourceName, String name, MethodParameterSnapshot parent, boolean isVirtual, ProgressReporter reporter) throws OperationCanceledException {
        Bookmark startBookmark = SnapshotFactoryImpl.getAdjustedStartBookmark(parent, resourceName);
        Bookmark endBookmark = SnapshotFactoryImpl.getAdjustedEndBookmark(parent, resourceName);
        long startTimeStamp = SnapshotFactoryImpl.getAdjustedStartTimestamp(parent, resourceName);
        long endTimeStamp = SnapshotFactoryImpl.getAdjustedEndTimestamp(parent, resourceName);
        MethodParameterSnapshotImpl snapshot = new MethodParameterSnapshotImpl(id, resourceName, name, this.session, startBookmark, endBookmark, -1L, parent.getParameterSpecs(), parent.getMethodsToTrace(), startTimeStamp, endTimeStamp, isVirtual, parent);
        return snapshot;
    }

    public IOSnapshotImpl createIOSnapshot(int id, ResourceName resourceName, String name, Bookmark start, Bookmark end, IOTraceConfiguration config, long nrOfReadBytes, long nrOfWrittenBytes, long readDuration, long writeDuration, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, IOSnapshot parent) {
        return new IOSnapshotImpl(id, resourceName, name, this.session, start, end, config, nrOfReadBytes, nrOfWrittenBytes, readDuration, writeDuration, startCollectionTimeStamp, endCollectionTimeStamp, isVirtual, parent);
    }

    public IOSnapshot createIOSnapshot(int id, ResourceName resourceName, String name, IOSnapshot parent, boolean isVirtual, ProgressReporter reporter) throws OperationCanceledException {
        Bookmark startBookmark = SnapshotFactoryImpl.getAdjustedStartBookmark(parent, resourceName);
        Bookmark endBookmark = SnapshotFactoryImpl.getAdjustedEndBookmark(parent, resourceName);
        long startTimeStamp = SnapshotFactoryImpl.getAdjustedStartTimestamp(parent, resourceName);
        long endTimeStamp = SnapshotFactoryImpl.getAdjustedEndTimestamp(parent, resourceName);
        IOSnapshotImpl snapshot = new IOSnapshotImpl(id, resourceName, name, this.session, startBookmark, endBookmark, parent.getTraceConfiguration(), -1L, -1L, -1L, -1L, startTimeStamp, endTimeStamp, isVirtual, parent);
        return snapshot;
    }

    public SynchronizationSnapshotImpl createSynchronizationSnapshot(int id, ResourceName resourceName, String name, Bookmark start, Bookmark end, Bookmark completeStart, Bookmark completeEnd, SynchronizationTraceConfiguration config, long nrOfBlockedEvents, long blockedTime, long nrOfWaitEvents, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, SynchronizationSnapshot parent) {
        return new SynchronizationSnapshotImpl(id, resourceName, name, this.session, start, end, completeStart, completeEnd, config, nrOfBlockedEvents, blockedTime, nrOfWaitEvents, startCollectionTimeStamp, endCollectionTimeStamp, isVirtual, parent);
    }

    public SynchronizationSnapshot createSynchronizationSnapshot(int id, ResourceName resourceName, String name, SynchronizationSnapshot parent, boolean isVirtual, ProgressReporter reporter) throws OperationCanceledException {
        Bookmark startBookmark = SnapshotFactoryImpl.getAdjustedStartBookmark(parent, resourceName);
        Bookmark endBookmark = SnapshotFactoryImpl.getAdjustedEndBookmark(parent, resourceName);
        long startTimeStamp = SnapshotFactoryImpl.getAdjustedStartTimestamp(parent, resourceName);
        long endTimeStamp = SnapshotFactoryImpl.getAdjustedEndTimestamp(parent, resourceName);
        SynchronizationSnapshotImpl snapshot = new SynchronizationSnapshotImpl(id, resourceName, name, this.session, startBookmark, endBookmark, parent.getCompleteStartBookmark(), parent.getCompleteEndBookmark(), parent.getTraceConfiguration(), -1L, -1L, -1L, startTimeStamp, endTimeStamp, isVirtual, parent);
        return snapshot;
    }

    public NetworkSnapshotImpl createNetworkSnapshot(int id, ResourceName resourceName, String name, Bookmark start, Bookmark end, NetworkTraceConfiguration config, long nrOfReadBytes, long nrOfWrittenBytes, long readDuration, long writeDuration, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, NetworkSnapshot parent) {
        return new NetworkSnapshotImpl(id, resourceName, name, this.session, start, end, config, nrOfReadBytes, nrOfWrittenBytes, readDuration, writeDuration, startCollectionTimeStamp, endCollectionTimeStamp, isVirtual, parent);
    }

    public NetworkSnapshot createNetworkSnapshot(int id, ResourceName resourceName, String name, NetworkSnapshot parent, boolean isVirtual, ProgressReporter reporter) throws OperationCanceledException {
        Bookmark startBookmark = SnapshotFactoryImpl.getAdjustedStartBookmark(parent, resourceName);
        Bookmark endBookmark = SnapshotFactoryImpl.getAdjustedEndBookmark(parent, resourceName);
        long startTimeStamp = SnapshotFactoryImpl.getAdjustedStartTimestamp(parent, resourceName);
        long endTimeStamp = SnapshotFactoryImpl.getAdjustedEndTimestamp(parent, resourceName);
        NetworkSnapshotImpl snapshot = new NetworkSnapshotImpl(id, resourceName, name, this.session, startBookmark, endBookmark, parent.getTraceConfiguration(), -1L, -1L, -1L, -1L, startTimeStamp, endTimeStamp, isVirtual, parent);
        return snapshot;
    }

    public synchronized GcSnapshot createGcSnapshot(int id, ResourceName resourceName, String name, Bookmark start, Bookmark end, GcTraceConfiguration config, GcSnapshotProperties properties, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, GcSnapshot parent) {
        return new GcSnapshotImpl(id, resourceName, name, this.session, start, end, config, startCollectionTimeStamp, endCollectionTimeStamp, properties, isVirtual, parent);
    }

    public synchronized GcSnapshot createGcSnapshot(int id, ResourceName resourceName, String name, GcSnapshot parent, boolean isVirtual, ProgressReporter reporter) throws OperationCanceledException {
        Bookmark startBookmark = SnapshotFactoryImpl.getAdjustedStartBookmark(parent, resourceName);
        Bookmark endBookmark = SnapshotFactoryImpl.getAdjustedEndBookmark(parent, resourceName);
        long startTimeStamp = SnapshotFactoryImpl.getAdjustedStartTimestamp(parent, resourceName);
        long endTimeStamp = SnapshotFactoryImpl.getAdjustedEndTimestamp(parent, resourceName);
        return new GcSnapshotImpl(id, resourceName, name, this.session, startBookmark, endBookmark, parent.getTraceConfiguration(), startTimeStamp, endTimeStamp, parent.getGcType(), isVirtual, parent, reporter);
    }

    public SnapshotImpl readSnapshot(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store, ProgressReporter reporter) throws IOException {
        return SnapshotImpl.read(resourceName, reader, store, reporter);
    }

    public Snapshot CreateClassStatisticSnapshot(int snapshotId, ResourceName resourceName, String name, Bookmark start, Bookmark end, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, ClsSnapshot parent, YoungGenClassStatistic currentYoungGenClassStatistic, OldGenClassStatistic currentOldGenClassStatistic, PermGenClassStatistic currentPermGenClassStatistic, long sizeOfYoungGen, long sizeOfOldGen, long sizeOfPermGen) {
        return new ClsSnapshotImpl(snapshotId, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, this.session, isVirtual, resourceName, parent, currentYoungGenClassStatistic, currentOldGenClassStatistic, currentPermGenClassStatistic, sizeOfYoungGen, sizeOfOldGen, sizeOfPermGen);
    }

    public ThreadDumpSnapshot createThreadDumpSnapshot(int id, ResourceName resourceName, String name, Bookmark start, Bookmark end, long startCollectionTimeStamp, long endCollectionTimeStamp, ThreadDump[] dumps, boolean isVirtual) {
        return new ThreadDumpSnapshotImpl(id, resourceName, name, this.session, start, end, startCollectionTimeStamp, endCollectionTimeStamp, dumps, isVirtual);
    }

    public GcHistoryFileDumpSnapshot createGcHistorySnapshot(int id, ResourceName resourceName, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimeStamp, long endTimeStamp, GcHistoryFileDumpSnapshot parent, boolean isVirtual, String idToSessionKeyName) {
        return new GcHistoryFileDumpSnapshotImpl(id, resourceName, name, startBookmark, endBookmark, startTimeStamp, endTimeStamp, this.session, isVirtual, parent, idToSessionKeyName);
    }
}

