/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.cls.ClsSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.gc.GcHistoryFileDumpSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.gc.GcSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.hprof.HprofDumpSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.io.IOSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.mpt.MethodParameterSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.net.NetworkSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.sync.SynchronizationSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.tbs.PerformanceHotspotSnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.thread.ThreadDumpSnapshotImpl;
import java.io.IOException;

public abstract class SnapshotImpl
implements Snapshot {
    private SnapshotType type;
    private String name;
    private Bookmark start;
    private Bookmark end;
    private ProfilingSession session;
    private final long startCollectionTimeStamp;
    private final long endCollectionTimeStamp;
    private final boolean isVirtual;
    private Snapshot parent;
    private int parentId;
    private SnapshotStore<Snapshot> store;
    private final int id;

    public static SnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store, ProgressReporter reporter) throws IOException {
        short snapshotType = reader.readInt16();
        if (SnapshotType.ALLOCATION_SNAPSHOT.getIndex() == snapshotType) {
            return AllocationSnapshotImpl.read(resourceName, reader, store);
        }
        if (SnapshotType.PERFORMANCE_HOTSPOT_SNAPSHOT.getIndex() == snapshotType) {
            return PerformanceHotspotSnapshotImpl.read(resourceName, reader, store, reporter);
        }
        if (SnapshotType.METHOD_PARAMETER_SNAPSHOT.getIndex() == snapshotType) {
            return MethodParameterSnapshotImpl.read(resourceName, reader, store);
        }
        if (SnapshotType.IO_SNAPSHOT.getIndex() == snapshotType) {
            return IOSnapshotImpl.read(resourceName, reader, store);
        }
        if (SnapshotType.SYNCHRONIZATION_SNAPSHOT.getIndex() == snapshotType) {
            return SynchronizationSnapshotImpl.read(resourceName, reader, store);
        }
        if (SnapshotType.NETWORK_SNAPSHOT.getIndex() == snapshotType) {
            return NetworkSnapshotImpl.read(resourceName, reader, store);
        }
        if (SnapshotType.HPROF_DUMP_SNAPSHOT.getIndex() == snapshotType) {
            return HprofDumpSnapshotImpl.read(resourceName, reader, store);
        }
        if (SnapshotType.GC_SNAPSHOT.getIndex() == snapshotType) {
            return GcSnapshotImpl.read(resourceName, reader, store, reporter);
        }
        if (SnapshotType.CLASS_STATISTIC_SNAPSHOT.getIndex() == snapshotType) {
            return ClsSnapshotImpl.read(resourceName, reader, store);
        }
        if (SnapshotType.THREAD_DUMP_SNAPSHOT.getIndex() == snapshotType) {
            return ThreadDumpSnapshotImpl.read(resourceName, reader, store);
        }
        if (SnapshotType.GC_HISTORY_FILE_DUMP_SNAPSHOT.getIndex() == snapshotType) {
            return GcHistoryFileDumpSnapshotImpl.read(resourceName, reader, store);
        }
        assert (false);
        return null;
    }

    public SnapshotImpl(SnapshotType type, int id, String name, Bookmark start, Bookmark end, long startCollectionTimeStamp, long endCollectionTimeStamp, ProfilingSession session, boolean isVirtual, Snapshot parent) {
        assert (start.getNrOfReadEvents() <= end.getNrOfReadEvents());
        this.id = id;
        this.type = type;
        this.name = name;
        this.start = start;
        this.end = end;
        this.session = session;
        this.startCollectionTimeStamp = startCollectionTimeStamp;
        this.endCollectionTimeStamp = endCollectionTimeStamp;
        this.isVirtual = isVirtual;
        this.parent = parent;
    }

    @Override
    public SnapshotType getType() {
        return this.type;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void setName(String name) {
        this.name = name;
    }

    @Override
    public long getStartCollectionTimeStamp() {
        return this.startCollectionTimeStamp;
    }

    @Override
    public long getEndCollectionTimeStamp() {
        return this.endCollectionTimeStamp;
    }

    @Override
    public ProfilingReader getEventReader(ProgressReporter reporter) throws OperationCanceledException {
        return this.session.getResourceManager().getEventReader(this.start, this.end, null, reporter);
    }

    @Override
    public ProfilingReader getEventReader(ProgressReporter reporter, Bookmark starBookmark) throws OperationCanceledException {
        return this.session.getResourceManager().getEventReader(starBookmark, this.end, null, reporter);
    }

    @Override
    public boolean isVirtual() {
        return this.isVirtual;
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        writer.writeInt16((short)this.type.getIndex());
        writer.writeInt32(this.getId());
        writer.writeString(this.name);
        this.start.write((ResourceWriter)writer);
        this.end.write((ResourceWriter)writer);
        writer.writeInt64(this.startCollectionTimeStamp);
        writer.writeInt64(this.endCollectionTimeStamp);
        writer.writeBoolean(this.isVirtual);
        writer.writeInt32(this.parent == null ? -1 : this.parent.getId());
    }

    @Override
    public Bookmark getStartBookmark() {
        return this.start;
    }

    @Override
    public Bookmark getEndBookmark() {
        return this.end;
    }

    @Override
    public Snapshot getParent() {
        if (this.parent == null && this.parentId > 0) {
            this.parent = this.store.getById(this.parentId);
            assert (this.parent != null);
        }
        return this.parent;
    }

    @Override
    public int getId() {
        return this.id;
    }

    public void setSnapshotStore(SnapshotStore<Snapshot> store) {
        this.store = store;
    }

    public void setParentId(int id) {
        this.parentId = id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object obj) {
        if (obj == null || obj.getClass() != this.getClass()) {
            return false;
        }
        return ((Snapshot)obj).getId() == this.id;
    }

    public ProfilingSession getSession() {
        return this.session;
    }
}

