/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl;

import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceHandler;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.resource.SnapshotResource;
import com.sap.jvm.profiling.util.AccessibleObjectWrapper;
import com.sap.jvm.profiling.util.CtorWrapper;
import com.sap.jvm.profiling.util.MethodWrapper;
import java.io.IOException;

public final class SnapshotResourceHandler
implements ResourceHandler {
    private static AccessibleObjectWrapper.SetAccessibleHook sah = o -> {
        if (!o.isAccessible()) {
            o.setAccessible(true);
        }
    };
    private final CtorWrapper readMethod;
    private final MethodWrapper createMethod;
    private final MethodWrapper writeMethod;
    private final MethodWrapper writeWorkMethod;
    private final ResourceNameElement element;

    public SnapshotResourceHandler(ResourceNameElement element, Class<? extends SnapshotResource> resource) {
        this.element = element;
        this.createMethod = new MethodWrapper(resource, "create", sah, new Class[]{ResourceName.class, ProgressReporter.class});
        this.writeMethod = new MethodWrapper(resource, "write", sah, new Class[]{ResourceWriter.class, ProgressReporter.class});
        this.writeWorkMethod = new MethodWrapper(resource, "calculateWriteWork", sah, new Class[0]);
        this.readMethod = new CtorWrapper(resource, sah, new Class[]{ResourceReader.class, ResourceName.class, ProgressReporter.class});
    }

    public boolean canHandle(ResourceName name) {
        return name.endsWithType(this.element);
    }

    public Resource create(ResourceName name, ProgressReporter reporter) throws IOException {
        return (Resource)this.createMethod.invokeWithIOException(null, new Object[]{name, reporter});
    }

    public Resource read(ResourceName name, ResourceReader reader, ProgressReporter reporter) throws IOException {
        return (Resource)this.readMethod.newInstanceWithIOException(new Object[]{reader, name, reporter});
    }

    public void write(ResourceName name, Resource resource, ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.writeMethod.invokeWithIOException((Object)resource, new Object[]{writer, reporter});
    }

    public long calculateWriteWork(ResourceName name, Resource resource) {
        return (Long)this.writeWorkMethod.invoke((Object)resource, new Object[0]);
    }
}

