/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.alloc.AllocTimeSeriesCollection;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.series.AbstractValueTimeSeriesCollection;
import java.io.IOException;

public class AllocTimeSeriesCollectionImpl
extends AbstractValueTimeSeriesCollection<BytesAndObjects>
implements AllocTimeSeriesCollection {
    public AllocTimeSeriesCollectionImpl(ResourceName name) throws IOException {
        super(name);
    }

    public AllocTimeSeriesCollectionImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reader, reporter, I18n._s((String)"Reading the time series ... (<%> %)"));
    }

    public static AllocTimeSeriesCollectionImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        AllocTimeSeriesCollectionImpl result = new AllocTimeSeriesCollectionImpl(name);
        AllocationValueIterator it = AllocationValueIterator.getEventIterator(name, reporter, I18n._s((String)"Creating the time series ... (<%> %)"));
        result.createTimeSeries(it);
        return result;
    }

    @Override
    protected void getValuesForValue(long[] values, long elapsed, BytesAndObjects value) {
        values[0] = value.getHeapBytes() * 1000L / elapsed;
        values[1] = value.getHeapObjects() * 1000L / elapsed;
        values[2] = value.getStackBytes() * 1000L / elapsed;
        values[3] = value.getStackObjects() * 1000L / elapsed;
    }
}

