/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ThreadFilter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.command.AllocationTraceConfiguration;
import com.sap.jvm.profiling.memory.command.AllocationTraceType;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.method.event.MethodParameterMethodToTraceEvent;
import com.sap.jvm.profiling.method.response.MethodParameterSpec;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.alloc.AllocationSnapshot;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationValueIterator;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class AllocationSnapshotImpl
extends SnapshotImpl
implements AllocationSnapshot {
    private ResourceName resourceName;
    private final AllocationTraceConfiguration config;
    private long nrOfAllocations;
    private long nrOfAllocatedBytes;
    private final List<MethodParameterSpec> specs;
    private final List<MethodParameterMethodToTraceEvent> methodsToTrace;
    private final long nrOfInvocations;

    public static AllocationSnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store) throws IOException {
        int id = reader.readInt32();
        String name = reader.readString();
        Bookmark start = reader.getSession().readBookmark(reader);
        Bookmark end = reader.getSession().readBookmark(reader);
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        boolean isVirtual = reader.readBoolean();
        int parentId = reader.readInt32();
        long nrOfBytes = reader.readInt64();
        long allocations = reader.readInt64();
        AllocationTraceConfiguration config = AllocationSnapshotImpl.readAllocationTraceConfig(reader);
        long nrOfInvocations = reader.readInt64();
        ProfilingSession session = reader.getSession();
        int nrOfSpecs = reader.readInt8();
        ArrayList<MethodParameterSpec> specs = new ArrayList<MethodParameterSpec>();
        for (int i = 0; i < nrOfSpecs; ++i) {
            specs.add(session.readMethodParameterSpec(reader));
        }
        int nrOfMethodsToTrace = reader.hasNext() ? reader.readInt32() : 0;
        ArrayList<MethodParameterMethodToTraceEvent> methodsToTrace = new ArrayList<MethodParameterMethodToTraceEvent>();
        for (int i = 0; i < nrOfMethodsToTrace; ++i) {
            methodsToTrace.add(session.readMethodToTrace(reader));
        }
        if (reader.hasNext() && reader.readBoolean()) {
            config.setType(AllocationTraceType.ADAPTIVE);
        }
        AllocationSnapshotImpl snapshot = new AllocationSnapshotImpl(id, resourceName, name, reader.getSession(), start, end, config, allocations, nrOfBytes, nrOfInvocations, specs, methodsToTrace, startTimestamp, endTimestamp, isVirtual, null);
        snapshot.setParentId(parentId);
        snapshot.setSnapshotStore(store);
        return snapshot;
    }

    public AllocationSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark start, Bookmark end, AllocationTraceConfiguration config, long nrOfAllocations, long nrOfAllocatedBytes, long nrOfInvocations, List<MethodParameterSpec> specs, List<MethodParameterMethodToTraceEvent> methodsToTrace, long startCollectionTimeStamp, long endCollectionTimeStamp, boolean isVirtual, AllocationSnapshot parent) {
        super(SnapshotType.ALLOCATION_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, parent);
        this.config = config;
        this.nrOfAllocations = nrOfAllocations;
        this.nrOfAllocatedBytes = nrOfAllocatedBytes;
        this.nrOfInvocations = nrOfInvocations;
        this.specs = specs != null ? specs : new ArrayList();
        this.methodsToTrace = methodsToTrace != null ? methodsToTrace : new ArrayList();
        this.resourceName = resourceName;
    }

    @Override
    public long getBytes() {
        return this.nrOfAllocatedBytes;
    }

    @Override
    public long getObjects() {
        return this.nrOfAllocations;
    }

    @Override
    public AllocationTraceConfiguration getTraceConfiguration() {
        return this.config;
    }

    @Override
    public long getNrOfInvocations() {
        return this.nrOfInvocations;
    }

    @Override
    public List<MethodParameterSpec> getParameterSpecs() {
        return this.specs;
    }

    @Override
    public List<MethodParameterMethodToTraceEvent> getMethodsToTrace() {
        return this.methodsToTrace;
    }

    @Override
    public ResourceName asResourceName() {
        return this.resourceName;
    }

    @Override
    public void computeProperties(ProgressReporter reporter) throws IOException {
        if (this.nrOfAllocatedBytes >= 0L && this.nrOfAllocations >= 0L) {
            return;
        }
        this.nrOfAllocatedBytes = 0L;
        this.nrOfAllocations = 0L;
        AllocationValueIterator it = this.getAllocationEventIterator(reporter, I18n._s((String)"Analyzing the allocations ... (<%> %)"));
        try {
            while (it.next()) {
                AllocationEvent event = it.getAllocEvent();
                this.nrOfAllocations += (long)event.getNrOfAllocations();
                this.nrOfAllocatedBytes += event.getSize() * (long)event.getNrOfAllocations();
            }
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Failed to analyze the allocations");
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.getBytes());
        writer.writeInt64(this.getObjects());
        this.writeAllocationTraceConfig((ResourceWriter)writer);
        writer.writeInt64(this.getNrOfInvocations());
        writer.writeInt8(this.specs.size());
        for (MethodParameterSpec spec : this.specs) {
            writer.writeMethodParameterSpec(spec);
        }
        writer.writeInt32(this.methodsToTrace.size());
        for (MethodParameterMethodToTraceEvent methodToTrace : this.methodsToTrace) {
            writer.writeMethodToTrace(methodToTrace);
        }
        writer.writeBoolean(this.config.getType() == AllocationTraceType.ADAPTIVE);
    }

    public AllocationValueIterator getAllocationEventIterator(ProgressReporter progressReporter, String message) throws OperationCanceledException {
        return new AllocationValueIterator(this, this.resourceName, progressReporter, message);
    }

    @Override
    public boolean hasParameterSettings() {
        return this.specs != null && this.specs.size() != 0;
    }

    private void writeAllocationTraceConfig(ResourceWriter writer) throws IOException {
        writer.writeInt32(this.config.getMaxStackTraceSize());
        writer.writeBoolean(this.config.isIncludingLineNrs());
        writer.writeBoolean(this.config.getType() == AllocationTraceType.WITH_OBJECT_IDS);
        writer.writeBoolean(this.config.getType() == AllocationTraceType.SILENT);
        writer.writeString(this.config.getAllocatedObjectClassFilter());
        writer.writeBoolean(this.config.isHidingStringResolving());
        writer.writeBoolean(this.config.isHidingFinalizerAllocation());
        writer.writeBoolean(this.config.isHidingStaticInitializers());
        writer.writeBoolean(this.config.isHidingClassLoading());
        writer.writeBoolean(this.config.isAllowingPacketReordering());
        writer.writeBoolean(this.config.isAllowingMultiEvents());
        writer.writeNewThreadFilter(this.config.getAllocatedObjectThreadFilter());
    }

    private static AllocationTraceConfiguration readAllocationTraceConfig(ResourceReader reader) throws IOException {
        AllocationTraceType type;
        int maxStackTraceSize = reader.readInt32();
        boolean includeLineNrs = reader.readBoolean();
        boolean assignObjectId = reader.readBoolean();
        boolean isSilent = reader.readBoolean();
        String classFilter = reader.readString();
        boolean hideStringResolving = reader.readBoolean();
        boolean hideFinalizerAllocation = reader.readBoolean();
        boolean hideStaticInitializers = reader.readBoolean();
        boolean hideClassLoading = reader.readBoolean();
        boolean allowPacketReordering = reader.readBoolean();
        boolean multiEvents = reader.readBoolean();
        ThreadFilter threadFilter = reader.readNewThreadFilter();
        if (isSilent) {
            assert (assignObjectId);
            type = AllocationTraceType.SILENT;
        } else {
            type = assignObjectId ? AllocationTraceType.WITH_OBJECT_IDS : AllocationTraceType.NO_OBJECT_IDS;
        }
        AllocationTraceConfiguration retValue = new AllocationTraceConfiguration(type);
        retValue.setMaxStackTraceSize(maxStackTraceSize);
        retValue.setAllocatedObjectClassFilter(classFilter);
        retValue.setAllocatedObjectThreadFilter(threadFilter);
        retValue.setIncludeLineNrs(includeLineNrs);
        retValue.setHideStringResolving(hideStringResolving);
        retValue.setHideFinalizerAllocation(hideFinalizerAllocation);
        retValue.setHideStaticInitializers(hideStaticInitializers);
        retValue.setHideClassLoading(hideClassLoading);
        retValue.setAllowPacketReordering(allowPacketReordering);
        retValue.setAllowMultiEvents(multiEvents);
        retValue.setAllocatedObjectThreadFilter(threadFilter);
        return retValue;
    }
}

