/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.memory.event.AllocationEventHandler;
import com.sap.jvm.profiling.memory.response.DisableAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.DisableAllocationTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAdaptiveAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAdaptiveAllocationTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAllocationMptTraceResponse;
import com.sap.jvm.profiling.memory.response.EnableAllocationTraceResponse;
import com.sap.jvm.profiling.resource.GenericResourceNameElement;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.ClassAndStackIterator;
import com.sap.jvm.profiling.snapshot.alloc.ClassAndStackStatistic;
import com.sap.jvm.profiling.snapshot.alloc.Elements;
import com.sap.jvm.profiling.snapshot.alloc.elements.ArrayLengthFilter;
import com.sap.jvm.profiling.snapshot.alloc.elements.FilterAllocatedObjectByArea;
import com.sap.jvm.profiling.snapshot.alloc.elements.FilterAllocatedObjectByClass;
import com.sap.jvm.profiling.snapshot.alloc.elements.FilterAllocatedObjectByFilter;
import com.sap.jvm.profiling.snapshot.alloc.elements.FilterAllocationById;
import com.sap.jvm.profiling.snapshot.filter.AllocationAreaFilter;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.impl.resource.AbstractValueIterator;
import com.sap.jvm.profiling.snapshot.util.IdHashSet;
import java.io.IOException;

public final class AllocationValueIterator
extends AbstractValueIterator<BytesAndObjects>
implements AllocationEventHandler {
    private final ProfilingReader reader;
    private AllocationEvent currentEvent;
    private final ProgressReporter reporter;
    private final ClassFilter classFilter;
    private final ArrayLengthFilter lengthFilter;
    private final IdHashSet[] idFilters;
    private final AllocationAreaFilter areaFilter;
    public final ClassAndStackIterator it;

    public AllocationValueIterator(Snapshot snapshot, ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        super(name, snapshot, reporter);
        this.classFilter = AllocationValueIterator.getAllocatedClassFilter(name);
        this.lengthFilter = AllocationValueIterator.getArrayLengthFilter(name);
        this.idFilters = AllocationValueIterator.getIdFilters(name);
        this.areaFilter = AllocationValueIterator.getAreaFilter(name);
        this.reader = this.getEventReader();
        this.reporter = reporter;
        reporter.setWork(message, this.reader.getNrOfPacketsToRead());
        this.reader.registerAllocationEventHandler((AllocationEventHandler)this);
        this.it = null;
    }

    private AllocationValueIterator(ClassAndStackIterator it, ResourceName name, ProgressReporter reporter) throws OperationCanceledException {
        super(name, null, reporter);
        assert (!this.usesEvents());
        this.classFilter = AllocationValueIterator.getAllocatedClassFilter(name);
        this.lengthFilter = AllocationValueIterator.getArrayLengthFilter(name);
        this.idFilters = AllocationValueIterator.getIdFilters(name);
        this.areaFilter = AllocationValueIterator.getAreaFilter(name);
        this.reporter = reporter;
        this.it = it;
        this.reader = null;
    }

    public static AllocationValueIterator getEventIterator(ResourceName name, ProgressReporter reporter, String message) throws IOException {
        return AllocationValueIterator.getIterators(name, 1, reporter, message, true)[0];
    }

    public static AllocationValueIterator[] getIterators(ResourceName name, ProgressReporter reporter, String message, boolean usesEvents) throws IOException {
        return AllocationValueIterator.getIterators(name, name.getSession().getNrOfThreads(), reporter, message, usesEvents);
    }

    public static AllocationValueIterator[] getIterators(ResourceName name, int nrOfIterators, ProgressReporter reporter, String message, boolean usesEvents) throws IOException {
        ProfilingSession session = name.getSession();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        if (usesEvents || AllocationValueIterator.needsEventIteration(name)) {
            return new AllocationValueIterator[]{new AllocationValueIterator(snapshot, name, reporter, message)};
        }
        GenericResourceNameElement createElement = name.getSession().getSystemInfo().supportsStackAllocations() ? new Elements.CreateClassAndStackStatisticForAllAllocations() : new Elements.CreateClassAndStackStatistic();
        ResourceName cAndSName = snapshot.asResourceName().addElement((ResourceNameElement)createElement);
        ClassAndStackStatistic statistic = (ClassAndStackStatistic)session.getResourceManager().get(cAndSName, reporter);
        if (statistic == null) {
            throw new OperationCanceledException();
        }
        ClassAndStackIterator[] baseIterators = statistic.getIterators(nrOfIterators);
        AllocationValueIterator[] result = new AllocationValueIterator[baseIterators.length];
        ProgressReporter[] dummyReporters = reporter.getChildren(nrOfIterators - 1);
        result[0] = new AllocationValueIterator(baseIterators[0], name, reporter);
        for (int i = 1; i < result.length; ++i) {
            result[i] = new AllocationValueIterator(baseIterators[i], name, dummyReporters[i - 1]);
        }
        reporter.setWork(message, result[0].it.getMaxProgress());
        return result;
    }

    @Override
    protected ResourceName getDependentForIt() {
        ResourceName name = this.getResourceName();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        return snapshot.asResourceName().addElement((ResourceNameElement)new Elements.CreateClassAndStackStatistic());
    }

    @Override
    public BytesAndObjects getEmptyValue() {
        return BytesAndObjects.EMPTY;
    }

    @Override
    public int getStackIndex() {
        if (this.it != null) {
            return this.it.getStackIndex();
        }
        return this.currentEvent.getStackTraceIndex();
    }

    public ClassObject getClassObject() {
        if (this.it != null) {
            return this.it.getClassObject();
        }
        return this.currentEvent.getClassObject();
    }

    @Override
    public char getThreadIndex() {
        return this.currentEvent.getThreadIndex();
    }

    public AllocationEvent getAllocEvent() {
        return this.currentEvent;
    }

    @Override
    public BytesAndObjects getValue() {
        if (this.it != null) {
            return new BytesAndObjects(this.it.getHeapBytes(), this.it.getHeapObjects(), this.it.getStackBytes(), this.it.getStackObjects());
        }
        int nrOfAllocations = this.currentEvent.getNrOfAllocations();
        if (this.currentEvent.isStackAllocation()) {
            return new BytesAndObjects(0L, 0L, this.currentEvent.getSize() * (long)nrOfAllocations, nrOfAllocations);
        }
        return new BytesAndObjects(this.currentEvent.getSize() * (long)nrOfAllocations, nrOfAllocations, 0L, 0L);
    }

    @Override
    protected boolean nextFromStatistic() throws OperationCanceledException {
        while (this.it.next()) {
            if (!this.reporter.report(this.it.getProgress())) {
                throw new OperationCanceledException();
            }
            if (this.classFilter != null && !this.classFilter.matches(this.it.getClassObject()) || this.areaFilter != null && !this.areaFilter.matches(this.it)) continue;
            return true;
        }
        return false;
    }

    @Override
    protected int nextOrReadRaw() throws IOException {
        this.currentEvent = null;
        try {
            if (this.reader.nextPacket() != null) {
                if (!this.reporter.report(this.reader.getNrOfReadPackets())) {
                    throw new OperationCanceledException();
                }
                if (this.currentEvent == null) {
                    return 1;
                }
                if (this.classFilter != null && !this.classFilter.matches(this.currentEvent.getClassObject())) {
                    this.currentEvent = null;
                    return 1;
                }
                if (this.lengthFilter != null && !this.lengthFilter.include(this.currentEvent.getLength())) {
                    this.currentEvent = null;
                    return 1;
                }
                if (this.idFilters != null) {
                    long id = this.currentEvent.getObjectId() >>> 26;
                    if (id == 0L) {
                        return 1;
                    }
                    for (IdHashSet set : this.idFilters) {
                        if (set.contains(id)) continue;
                        return 1;
                    }
                }
                if (this.areaFilter != null && !this.areaFilter.matches(this.currentEvent)) {
                    this.currentEvent = null;
                    return 1;
                }
                return 0;
            }
        }
        catch (IOException ex) {
            this.reader.close();
            throw ex;
        }
        this.reader.close();
        return 2;
    }

    public void handle(AllocationEvent event) {
        this.currentEvent = event;
    }

    public void handle(EnableAllocationTraceResponse response) {
    }

    public void handle(EnableAdaptiveAllocationTraceResponse response) {
    }

    public void handle(DisableAllocationTraceResponse response) {
    }

    public void handle(EnableAllocationMptTraceResponse response) {
    }

    public void handle(EnableAdaptiveAllocationMptTraceResponse response) {
    }

    public void handle(DisableAllocationMptTraceResponse response) {
    }

    private static ClassFilter getAllocatedClassFilter(ResourceName name) {
        ClassFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            Object filterElement;
            if (element instanceof FilterAllocatedObjectByFilter) {
                filterElement = (FilterAllocatedObjectByFilter)element;
                ClassFilter toAdd = ClassFilter.createWide("<artificial>", ((FilterAllocatedObjectByFilter)filterElement).getFilters(), false);
                if (filter == null) {
                    filter = toAdd;
                    continue;
                }
                filter = filter.narrow("<artificial>", toAdd, true);
                continue;
            }
            if (!(element instanceof FilterAllocatedObjectByClass)) continue;
            filterElement = (FilterAllocatedObjectByClass)element;
            filter = filter == null ? ((FilterAllocatedObjectByClass)filterElement).getFilter() : filter.narrow("<artificial>", ((FilterAllocatedObjectByClass)filterElement).getFilter(), true);
        }
        return filter;
    }

    private static ArrayLengthFilter getArrayLengthFilter(ResourceName name) {
        ArrayLengthFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof ArrayLengthFilter)) continue;
            ArrayLengthFilter filterElement = (ArrayLengthFilter)element;
            if (filter == null) {
                filter = filterElement;
                continue;
            }
            final ArrayLengthFilter oldFilter = filter;
            final ArrayLengthFilter newFilter = filterElement;
            filter = new ArrayLengthFilter(){

                @Override
                public boolean include(int length) {
                    return oldFilter.include(length) && newFilter.include(length);
                }
            };
        }
        return filter;
    }

    private static IdHashSet[] getIdFilters(ResourceName name) {
        IdHashSet[] result = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof FilterAllocationById)) continue;
            if (result == null) {
                result = new IdHashSet[1];
            } else {
                IdHashSet[] oldResult = result;
                result = new IdHashSet[oldResult.length + 1];
                System.arraycopy(oldResult, 0, result, 1, oldResult.length);
            }
            result[0] = ((FilterAllocationById)element).getIds();
        }
        return result;
    }

    private static AllocationAreaFilter getAreaFilter(ResourceName name) {
        AllocationAreaFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof FilterAllocatedObjectByArea)) continue;
            FilterAllocatedObjectByArea filterElement = (FilterAllocatedObjectByArea)element;
            AllocationAreaFilter toAdd = filterElement.getFilter();
            filter = filter == null ? toAdd : filter.narrow(toAdd);
        }
        return filter;
    }

    @Override
    public ProgressReporter getReporter() {
        return this.reporter;
    }
}

