/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceManager;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.alloc.ArrayLengthHistogram;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.Elements;
import com.sap.jvm.profiling.snapshot.impl.alloc.ArrayLengthStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.collections.EntryHashSet;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.EntrySorter;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.BytesAndObjectsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.IntPairColumn;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.BytesAndObjectsSerializer;
import com.sap.jvm.util.pair.IntPair;
import java.io.IOException;
import java.util.Arrays;
import java.util.Comparator;

public class ArrayLengthHistogramImpl
extends ValueStatisticImpl<IntPair, BytesAndObjects>
implements ArrayLengthHistogram {
    protected ArrayLengthHistogramImpl(ResourceName name) {
        super(name, new IntPairColumn(), new BytesAndObjectsColumnImpl(), new BytesAndObjectsSerializer());
    }

    public ArrayLengthHistogramImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the array length histogram ... (<%> %)"), reporter);
    }

    public static ArrayLengthHistogramImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        ResourceManager manager = name.getResourceManager();
        ResourceName statisticName = name.stripLastElement().addElement((ResourceNameElement)new Elements.CreateArrayLengthStatistic());
        ArrayLengthStatisticImpl statistic = (ArrayLengthStatisticImpl)manager.get(statisticName, reporter);
        IntPair[] ranges = ArrayLengthHistogramImpl.getRegions();
        ValueStatisticCollector<IntPair, BytesAndObjects> collector = new ValueStatisticCollector<IntPair, BytesAndObjects>(BytesAndObjects.EMPTY);
        for (IntPair range : ranges) {
            collector.add(range, BytesAndObjects.EMPTY);
        }
        block1: for (int i = 0; i < statistic.size(); ++i) {
            int length = (Integer)statistic.getKey(i);
            for (IntPair range : ranges) {
                if (range.getFirst() > length || range.getSecond() <= length) continue;
                collector.add(range, (BytesAndObjects)statistic.getValue(i));
                continue block1;
            }
        }
        collector.add((BytesAndObjects)statistic.getValue());
        ArrayLengthHistogramImpl result = new ArrayLengthHistogramImpl(name);
        result.setDependent(statisticName);
        collector.setSorter(new EntrySorter<IntPair>(){

            @Override
            public void sort(EntryHashSet.Entry<IntPair>[] entries) {
                Arrays.sort(entries, new Comparator<EntryHashSet.Entry<IntPair>>(){

                    @Override
                    public int compare(EntryHashSet.Entry<IntPair> o1, EntryHashSet.Entry<IntPair> o2) {
                        return o1.getKey().compareTo(o2.getKey());
                    }
                });
            }
        });
        collector.fillStatistic(result);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the array length histogram ... (<%> %)"), reporter);
    }

    public static final IntPair[] getRegions() {
        return new IntPair[]{new IntPair(0, 1), new IntPair(1, 10), new IntPair(10, 100), new IntPair(100, 1000), new IntPair(1000, 10000), new IntPair(10000, 100000), new IntPair(100000, 1000000), new IntPair(1000000, 10000000), new IntPair(10000000, Integer.MAX_VALUE)};
    }
}

