/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.alloc.ArrayLengthStatistic;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.BytesAndObjectsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.IntegerColumn;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.BytesAndObjectsSerializer;
import java.io.IOException;

public class ArrayLengthStatisticImpl
extends ValueStatisticImpl<Integer, BytesAndObjects>
implements ArrayLengthStatistic {
    protected ArrayLengthStatisticImpl(ResourceName name) {
        super(name, new IntegerColumn(), new BytesAndObjectsColumnImpl(), new BytesAndObjectsSerializer());
    }

    public ArrayLengthStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the array length statistic ... (<%> %)"), reporter);
    }

    public static ArrayLengthStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        AllocationValueIterator it = AllocationValueIterator.getEventIterator(name, reporter, I18n._s((String)"Creating the array length statistic ... (<%> %)"));
        ArrayLengthStatisticImpl result = new ArrayLengthStatisticImpl(name);
        result.setDependent(it.getDependent());
        ValueStatisticCollector<Integer, BytesAndObjects> collector = new ValueStatisticCollector<Integer, BytesAndObjects>(it.getEmptyValue());
        while (it.next()) {
            AllocationEvent event = it.getAllocEvent();
            ClassObject clazz = event.getClassObject();
            if (!clazz.isArrayClass()) continue;
            Integer length = event.getLength();
            BytesAndObjects val = it.getValue();
            collector.add(length, val);
            collector.add(val);
        }
        collector.fillStatistic(result);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the array length statistic ... (<%> %)"), reporter);
    }
}

