/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.CalledArrayLengthStatistic;
import com.sap.jvm.profiling.snapshot.alloc.CallingArrayLengthStatistic;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.BytesAndObjectsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.IntegerColumn;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.BytesAndObjectsSerializer;
import java.io.IOException;

public class CalledCallingArrayLengthStatisticImpl
extends SelfAndTotalValueStatisticImpl<Integer, BytesAndObjects>
implements CalledArrayLengthStatistic,
CallingArrayLengthStatistic {
    protected CalledCallingArrayLengthStatisticImpl(ResourceName name) {
        super(name, new IntegerColumn(), new BytesAndObjectsColumnImpl(), new BytesAndObjectsColumnImpl(), new BytesAndObjectsSerializer());
    }

    public CalledCallingArrayLengthStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the array length statistic ... (<%> %)"), reporter);
    }

    public static CalledCallingArrayLengthStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        AllocationValueIterator it = AllocationValueIterator.getEventIterator(name, reporter, I18n._s((String)"Creating the array length statistic ... (<%> %)"));
        CalledCallingArrayLengthStatisticImpl result = new CalledCallingArrayLengthStatisticImpl(name);
        SelfAndTotalValueStatisticCollector<Integer, BytesAndObjects> collector = new SelfAndTotalValueStatisticCollector<Integer, BytesAndObjects>(it.getEmptyValue());
        while (it.next()) {
            AllocationEvent event = it.getAllocEvent();
            ClassObject clazz = event.getClassObject();
            if (!clazz.isArrayClass()) continue;
            BytesAndObjects value = it.getValue();
            Integer length = event.getLength();
            collector.addTotal(length, value);
            collector.add(value);
            if (!it.hasSelfRoot()) continue;
            collector.addSelf(length, value);
        }
        collector.fillStatistic(result);
        result.setDependent(it.getDependent());
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the array length statistic ... (<%> %)"), reporter);
    }
}

