/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.CalledClassStatistic;
import com.sap.jvm.profiling.snapshot.alloc.CallingClassStatistic;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationValueIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.SelfAndTotalValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.BytesAndObjectsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.ClassColumn;
import com.sap.jvm.profiling.snapshot.impl.util.creator.SelfAndTotalStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.BytesAndObjectsSerializer;
import java.io.IOException;

public class CalledCallingClassStatisticImpl
extends SelfAndTotalValueStatisticImpl<ClassObject, BytesAndObjects>
implements CalledClassStatistic,
CallingClassStatistic {
    protected CalledCallingClassStatisticImpl(ResourceName name) {
        super(name, new ClassColumn(name.getSession()), new BytesAndObjectsColumnImpl(), new BytesAndObjectsColumnImpl(), new BytesAndObjectsSerializer());
    }

    public CalledCallingClassStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the class statistic ... (<%> %)"), reporter);
    }

    public static CalledCallingClassStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        AllocationValueIterator[] its = AllocationValueIterator.getIterators(name, reporter, I18n._s((String)"Creating the class statistic ... (<%> %)"), false);
        CalledCallingClassStatisticImpl result = new CalledCallingClassStatisticImpl(name);
        new Creator().fillInStatistic(result, its);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the class statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends SelfAndTotalStatisticCreator<ClassObject, BytesAndObjects> {
        private Creator() {
        }

        @Override
        protected SelfAndTotalValueStatisticCollector<ClassObject, BytesAndObjects> getCollector(ValueIterator<BytesAndObjects> rawIt) throws IOException {
            AllocationValueIterator it = (AllocationValueIterator)rawIt;
            SelfAndTotalValueStatisticCollector<ClassObject, BytesAndObjects> collector = new SelfAndTotalValueStatisticCollector<ClassObject, BytesAndObjects>(BytesAndObjects.EMPTY);
            while (it.next()) {
                BytesAndObjects value = it.getValue();
                ClassObject clazz = it.getClassObject();
                collector.addTotal(clazz, value);
                collector.add(value);
                if (!it.hasSelfRoot()) continue;
                collector.addSelf(clazz, value);
            }
            return collector;
        }
    }
}

