/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.CalledMethodTree;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.Pruner;
import com.sap.jvm.profiling.snapshot.impl.util.creator.CalledMethodTreeCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.BytesAndObjectsSerializer;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.MethodLocationSerializer;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import java.io.IOException;

public final class CalledMethodTreeImpl
extends SelfAndTotalValueTreeImpl<MethodLocation, BytesAndObjects>
implements CalledMethodTree {
    protected CalledMethodTreeImpl(ResourceName name) {
        super(name, new MethodLocationSerializer(), new BytesAndObjectsSerializer());
    }

    public CalledMethodTreeImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, reporter, I18n._s((String)"Reading the method tree ... (<%> %)"));
    }

    public static CalledMethodTreeImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        AllocationValueIterator[] its = AllocationValueIterator.getIterators(name, reporter, I18n._s((String)"Creating the method tree ... (<%> %)"), false);
        CalledMethodTreeImpl tree = new CalledMethodTreeImpl(name);
        new CalledMethodTreeCreator<BytesAndObjects>().fillIn(tree, new TreePruner(), its);
        return tree;
    }

    @Override
    public void createChildren(SelfAndTotalValueTreeNode<MethodLocation, BytesAndObjects> node, ProgressReporter reporter) throws IOException {
        assert (node.hasChildren());
        assert (!node.hasCreatedChildren());
        AllocationValueIterator[] its = AllocationValueIterator.getIterators(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"), false);
        new CalledMethodTreeCreator<BytesAndObjects>().setChildren(new TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void createSubNodes(SelfAndTotalValueTreeNode<MethodLocation, BytesAndObjects> node, ProgressReporter reporter) throws IOException {
        assert (node.hasSubNodes());
        assert (!node.hasCreatedSubNodes());
        AllocationValueIterator[] its = AllocationValueIterator.getIterators(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"), false);
        new CalledMethodTreeCreator<BytesAndObjects>().setSubNodes(new TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        super.write(writer, reporter, I18n._s((String)"Writing the method tree ... (<%> %)"));
    }

    public static class TreePruner
    implements Pruner<BytesAndObjects> {
        @Override
        public boolean shouldPrune(BytesAndObjects value, BytesAndObjects parentValue, BytesAndObjects totalValue) {
            double fraction = 1.0E-4;
            if (fraction * (double)(totalValue.getHeapBytes() + totalValue.getStackBytes()) >= (double)(value.getHeapBytes() + value.getStackBytes())) {
                return true;
            }
            if (fraction * (double)(totalValue.getHeapObjects() + totalValue.getStackObjects()) >= (double)(value.getHeapObjects() + value.getStackObjects())) {
                return true;
            }
            int scale = 7;
            long relativeObjects = value.getHeapObjects() + value.getStackObjects() << scale;
            if (parentValue.getHeapObjects() + parentValue.getStackObjects() >= relativeObjects) {
                return true;
            }
            long relativeBytes = value.getHeapBytes() + value.getStackBytes() << scale;
            return parentValue.getHeapBytes() + parentValue.getStackBytes() >= relativeBytes;
        }
    }
}

