/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.core.type.MethodLocation;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.CallingMethodTree;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationValueIterator;
import com.sap.jvm.profiling.snapshot.impl.alloc.CalledMethodTreeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collections.SelfAndTotalValueTreeNodeImpl;
import com.sap.jvm.profiling.snapshot.impl.util.creator.CallingMethodTreeCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.BytesAndObjectsSerializer;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.MethodLocationSerializer;
import com.sap.jvm.profiling.snapshot.util.SelfAndTotalValueTreeNode;
import java.io.IOException;

public class CallingMethodTreeImpl
extends SelfAndTotalValueTreeImpl<MethodLocation, BytesAndObjects>
implements CallingMethodTree {
    protected CallingMethodTreeImpl(ResourceName name) {
        super(name, new MethodLocationSerializer(), new BytesAndObjectsSerializer());
    }

    public CallingMethodTreeImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, reporter, I18n._s((String)"Reading the method tree ... (<%> %)"));
    }

    public static CallingMethodTreeImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        AllocationValueIterator[] its = AllocationValueIterator.getIterators(name, reporter, I18n._s((String)"Creating the method tree ... (<%> %)"), false);
        CallingMethodTreeImpl tree = new CallingMethodTreeImpl(name);
        new CallingMethodTreeCreator<BytesAndObjects>().fillIn(tree, new CalledMethodTreeImpl.TreePruner(), its);
        return tree;
    }

    @Override
    public void createChildren(SelfAndTotalValueTreeNode<MethodLocation, BytesAndObjects> node, ProgressReporter reporter) throws IOException {
        assert (node.hasChildren());
        assert (!node.hasCreatedChildren());
        AllocationValueIterator[] its = AllocationValueIterator.getIterators(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"), false);
        new CallingMethodTreeCreator<BytesAndObjects>().setChildren(new CalledMethodTreeImpl.TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void createSubNodes(SelfAndTotalValueTreeNode<MethodLocation, BytesAndObjects> node, ProgressReporter reporter) throws IOException {
        assert (node.hasSubNodes());
        assert (!node.hasCreatedSubNodes());
        AllocationValueIterator[] its = AllocationValueIterator.getIterators(this.getResourceName(), reporter, I18n._s((String)"Creating the children ... (<%> %)"), false);
        new CallingMethodTreeCreator<BytesAndObjects>().setSubNodes(new CalledMethodTreeImpl.TreePruner(), (SelfAndTotalValueTreeNodeImpl)node, its);
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        super.write(writer, reporter, I18n._s((String)"Writing the method tree ... (<%> %)"));
    }
}

