/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.alloc.ClassAndStackIterator;
import com.sap.jvm.profiling.snapshot.alloc.ClassAndStackStatistic;
import com.sap.jvm.profiling.snapshot.impl.alloc.ClassAndStackStatisticImpl;
import java.io.IOException;

public final class ClassAndStackStatisticForAllAllocations
extends AbstractResource
implements ClassAndStackStatistic {
    private static final int VERSION = 0;
    private final ClassAndStackStatistic heapStatistic;
    private final ClassAndStackStatistic stackStatistic;

    public ClassAndStackStatisticForAllAllocations(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        reader.readVersion(0, 0);
        this.heapStatistic = new ClassAndStackStatisticImpl(reader, name, reporter);
        this.stackStatistic = new ClassAndStackStatisticImpl(reader, name, reporter);
    }

    private ClassAndStackStatisticForAllAllocations(ResourceName name, ClassAndStackStatistic heapStatistic, ClassAndStackStatistic stackStatistic) {
        super(name);
        this.heapStatistic = heapStatistic;
        this.stackStatistic = stackStatistic;
    }

    public static Resource create(ResourceName name, ProgressReporter reporter) throws OperationCanceledException, IOException {
        ClassAndStackStatistic heap = (ClassAndStackStatistic)ClassAndStackStatisticImpl.create(name, reporter);
        ClassAndStackStatistic stack = (ClassAndStackStatistic)ClassAndStackStatisticImpl.createForStackAllocations(name, reporter);
        ClassAndStackStatisticForAllAllocations result = new ClassAndStackStatisticForAllAllocations(name, heap, stack);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        this.heapStatistic.write(writer, reporter);
        this.stackStatistic.write(writer, reporter);
    }

    @Override
    public long calculateWriteWork() {
        return this.heapStatistic.calculateWriteWork() + this.stackStatistic.calculateWriteWork();
    }

    public boolean isModifiable() {
        return this.heapStatistic.isModifiable() || this.stackStatistic.isModifiable();
    }

    public ResourceName[] getDependents() {
        return null;
    }

    @Override
    public ClassAndStackIterator[] getIterators(int nrOfIterators) {
        ClassAndStackIterator[] heapIters = this.heapStatistic.getIterators(nrOfIterators);
        ClassAndStackIterator[] stackIters = this.stackStatistic.getIterators(nrOfIterators);
        ClassAndStackIterator[] result = new ClassAndStackIterator[Math.max(heapIters.length, stackIters.length)];
        for (int i = 0; i < result.length; ++i) {
            if (i < heapIters.length && i < stackIters.length) {
                result[i] = new JoiningClassAndStackIterator(heapIters[i], stackIters[i]);
                continue;
            }
            if (i >= heapIters.length) {
                result[i] = stackIters[i];
                continue;
            }
            assert (i >= stackIters.length);
            result[i] = heapIters[i];
        }
        return result;
    }

    @Override
    public long getSize() {
        return this.heapStatistic.getSize() + this.stackStatistic.getSize();
    }

    @Override
    public long getHeapObjects() {
        return this.heapStatistic.getHeapObjects();
    }

    @Override
    public long getHeapBytes() {
        return this.heapStatistic.getHeapBytes();
    }

    @Override
    public long getStackObjects() {
        return this.heapStatistic.getStackObjects();
    }

    @Override
    public long getStackBytes() {
        return this.stackStatistic.getStackBytes();
    }

    private class JoiningClassAndStackIterator
    implements ClassAndStackIterator {
        private final ClassAndStackIterator heapIter;
        private final ClassAndStackIterator stackIter;
        private boolean useHeapIter = true;

        private JoiningClassAndStackIterator(ClassAndStackIterator heapIter, ClassAndStackIterator stackIter) {
            this.heapIter = heapIter;
            this.stackIter = stackIter;
        }

        @Override
        public long getProgress() {
            return this.heapIter.getProgress() + this.stackIter.getProgress();
        }

        @Override
        public long getMaxProgress() {
            return this.heapIter.getMaxProgress() + this.stackIter.getMaxProgress();
        }

        @Override
        public boolean next() {
            boolean result = this.getCurrentIter().next();
            if (!result && this.useHeapIter) {
                this.useHeapIter = false;
                result = this.getCurrentIter().next();
            }
            return result;
        }

        @Override
        public ClassObject getClassObject() {
            return this.getCurrentIter().getClassObject();
        }

        @Override
        public int getClassIndex() {
            return this.getCurrentIter().getClassIndex();
        }

        @Override
        public int getStackIndex() {
            return this.getCurrentIter().getStackIndex();
        }

        @Override
        public long getHeapObjects() {
            return this.getCurrentIter().getHeapObjects();
        }

        @Override
        public long getHeapBytes() {
            return this.getCurrentIter().getHeapBytes();
        }

        @Override
        public long getStackObjects() {
            return this.getCurrentIter().getStackObjects();
        }

        @Override
        public long getStackBytes() {
            return this.getCurrentIter().getStackBytes();
        }

        @Override
        public boolean isStackAllocation() {
            return this.getCurrentIter().isStackAllocation();
        }

        @Override
        public boolean isHeapAllocation() {
            return this.getCurrentIter().isHeapAllocation();
        }

        private ClassAndStackIterator getCurrentIter() {
            return this.useHeapIter ? this.heapIter : this.stackIter;
        }
    }
}

