/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.type.ArrayClassObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.core.type.ClassObjectManager;
import com.sap.jvm.profiling.core.type.NonArrayClassObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.AllocationEvent;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.Resource;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.alloc.ClassAndStackIterator;
import com.sap.jvm.profiling.snapshot.alloc.ClassAndStackStatistic;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationValueIterator;
import com.sap.jvm.profiling.util.BitUtil;
import com.sap.jvm.profiling.util.sets.PositiveLongSet;
import com.sap.jvm.profiling.util.splitarray.SplitArray32;
import com.sap.jvm.profiling.util.splitarray.SplitArray48;
import com.sap.jvm.profiling.util.splitarray.SplitArray64;
import com.sap.jvm.util.pair.IntPair;
import java.io.IOException;

public final class ClassAndStackStatisticImpl
extends AbstractResource
implements ClassAndStackStatistic {
    private static final int VERSION = 1;
    private static final int INITIAL_BUCKET_SIZE = 1024;
    private static final double LOAD_FACTOR = 5.0;
    private static final boolean CHECK_STATISTIC = "true".equals(System.getProperty("com.sap.jvm.profiling.alloc.checkClassAndStackStatistic"));
    private SplitArray48 arrayClassArray;
    private int nrOfArrayClassArrayEntries;
    private SplitArray32 nonArrayClassArray;
    private int nrOfNonArrayClassArrayEntries;
    private SplitArray32 smallNonArrayMapBuckets;
    private final SplitArray64 smallNonArrayMapEntries;
    private SplitArray32 smallNonArrayMapNext;
    private int smallNonArrayMapLimit;
    private int smallNonArrayMapMask;
    private int smallNonArrayMapNextIndex;
    private int smallNonArrayMapRemoved;
    private SplitArray32 smallArrayMapBuckets;
    private final SplitArray64 smallArrayMapEntries;
    private final SplitArray32 smallArrayMapNrOfBytes;
    private SplitArray32 smallArrayMapNext;
    private int smallArrayMapLimit;
    private int smallArrayMapMask;
    private int smallArrayMapNextIndex;
    private int smallArrayMapRemoved;
    private SplitArray32 bigNonArrayMapBuckets;
    private final SplitArray32 bigNonArrayMapStackIndex;
    private final SplitArray32 bigNonArrayMapClassIndex;
    private final SplitArray64 bigNonArrayMapNrOfObjects;
    private SplitArray32 bigNonArrayMapNext;
    private int bigNonArrayMapLimit;
    private int bigNonArrayMapMask;
    private int bigNonArrayMapNextIndex;
    private SplitArray32 bigArrayMapBuckets;
    private final SplitArray32 bigArrayMapStackIndex;
    private final SplitArray32 bigArrayMapClassIndex;
    private final SplitArray64 bigArrayMapNrOfObjects;
    private final SplitArray64 bigArrayMapNrOfBytes;
    private SplitArray32 bigArrayMapNext;
    private int bigArrayMapLimit;
    private int bigArrayMapMask;
    private int bigArrayMapNextIndex;
    private final ProfilingSession session;
    private long totalObjects;
    private long totalBytes;
    private long nrOfEntries;
    private boolean isHeapOnly;

    public ClassAndStackStatisticImpl(ResourceName name, boolean onlyHeap) {
        super(name);
        this.session = name.getSession();
        this.arrayClassArray = new SplitArray48();
        this.nonArrayClassArray = new SplitArray32();
        this.smallNonArrayMapBuckets = new SplitArray32(1024L);
        this.smallNonArrayMapEntries = new SplitArray64();
        this.smallNonArrayMapNext = new SplitArray32();
        this.smallNonArrayMapLimit = 5120;
        this.smallNonArrayMapMask = 1023;
        this.smallNonArrayMapNextIndex = 1;
        this.smallArrayMapBuckets = new SplitArray32(1024L);
        this.smallArrayMapEntries = new SplitArray64();
        this.smallArrayMapNrOfBytes = new SplitArray32();
        this.smallArrayMapNext = new SplitArray32();
        this.smallArrayMapLimit = 5120;
        this.smallArrayMapMask = 1023;
        this.smallArrayMapNextIndex = 1;
        this.bigNonArrayMapBuckets = new SplitArray32(1024L);
        this.bigNonArrayMapStackIndex = new SplitArray32();
        this.bigNonArrayMapClassIndex = new SplitArray32();
        this.bigNonArrayMapNrOfObjects = new SplitArray64();
        this.bigNonArrayMapNext = new SplitArray32();
        this.bigNonArrayMapLimit = 5120;
        this.bigNonArrayMapMask = 1023;
        this.bigNonArrayMapNextIndex = 1;
        this.bigArrayMapBuckets = new SplitArray32(1024L);
        this.bigArrayMapStackIndex = new SplitArray32();
        this.bigArrayMapClassIndex = new SplitArray32();
        this.bigArrayMapNrOfObjects = new SplitArray64();
        this.bigArrayMapNrOfBytes = new SplitArray64();
        this.bigArrayMapNext = new SplitArray32();
        this.bigArrayMapLimit = 5120;
        this.bigArrayMapMask = 1023;
        this.bigArrayMapNextIndex = 1;
        this.isHeapOnly = onlyHeap;
    }

    public ClassAndStackStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name, true);
        reader.readVersion(0, 1);
        long toRead = reader.readInt64();
        ClassObjectManager classManager = name.getSession().getClassObjectManager();
        reporter.setWork(I18n._s((String)"Reading the allocation analysis ... (<%> %)"), toRead);
        for (long i = 0L; i < toRead; ++i) {
            reporter.reportNextOrThrow();
            int classIndex = reader.readInt32();
            int stackIndex = reader.readInt32();
            long nrOfObjects = reader.readInt64();
            long nrOfBytes = reader.readInt64();
            ClassObject clazz = classManager.getClassObject(classIndex);
            if (clazz.isArrayClass()) {
                this.add((ArrayClassObject)clazz, stackIndex, nrOfObjects, nrOfBytes);
                continue;
            }
            this.add((NonArrayClassObject)clazz, stackIndex, nrOfObjects);
        }
        this.isHeapOnly = reader.hasNext() ? reader.readBoolean() : true;
        this.finish();
    }

    public static Resource create(ResourceName name, ProgressReporter reporter) throws OperationCanceledException, IOException {
        return ClassAndStackStatisticImpl.createImpl(name, reporter, true);
    }

    public static Resource createForStackAllocations(ResourceName name, ProgressReporter reporter) throws OperationCanceledException, IOException {
        return ClassAndStackStatisticImpl.createImpl(name, reporter, false);
    }

    private static Resource createImpl(ResourceName name, ProgressReporter reporter, boolean onlyHeap) throws OperationCanceledException, IOException {
        AllocationValueIterator it = AllocationValueIterator.getEventIterator(name, reporter, I18n._s((String)"Analyzing the allocations ... (<%> %)"));
        ClassAndStackStatisticImpl result = new ClassAndStackStatisticImpl(name, onlyHeap);
        while (it.next()) {
            AllocationEvent event = it.getAllocEvent();
            if (event.isHeapAllocation() != onlyHeap) continue;
            ClassObject clazz = event.getClassObject();
            long nrOfObjects = event.getNrOfAllocations();
            if (clazz.isArrayClass()) {
                long nrOfBytes = nrOfObjects * event.getSize();
                result.add((ArrayClassObject)clazz, event.getStackTraceIndex(), nrOfObjects, nrOfBytes);
                continue;
            }
            result.add((NonArrayClassObject)clazz, event.getStackTraceIndex(), nrOfObjects);
        }
        result.finish();
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        writer.writeInt64(this.nrOfEntries);
        ClassAndStackIteratorImpl it = this.getIterators(1)[0];
        reporter.setWork(I18n._s((String)"Writing the allocation analysis ... (<%> %)"), this.nrOfEntries);
        long count = 0L;
        while (it.next()) {
            reporter.reportNextOrThrow();
            writer.writeInt32(it.getClassIndex());
            writer.writeInt32(it.getStackIndex());
            writer.writeInt64(it.getObjects());
            writer.writeInt64(it.getBytes());
            ++count;
        }
        assert (count == this.nrOfEntries);
        writer.writeBoolean(this.isHeapOnly);
    }

    @Override
    public long calculateWriteWork() {
        return this.nrOfEntries;
    }

    private void add(NonArrayClassObject clazz, int stackIndex, long nrOfObjects) {
        this.totalObjects += nrOfObjects;
        this.totalBytes += nrOfObjects * (long)clazz.getInstanceSize();
        if (this.addToBigNonArrayHashMap(clazz, stackIndex, nrOfObjects, true)) {
            return;
        }
        if (!BitUtil.usesMoreBits((long)nrOfObjects, (int)31)) {
            if (this.addToSmallNonArrayHashMap(clazz, stackIndex, (int)nrOfObjects, true)) {
                return;
            }
            if (this.addToNonArrayClassArray(clazz, stackIndex, (int)nrOfObjects)) {
                return;
            }
            if (this.addToSmallNonArrayHashMap(clazz, stackIndex, (int)nrOfObjects, false)) {
                return;
            }
        }
        boolean result = this.addToBigNonArrayHashMap(clazz, stackIndex, nrOfObjects, false);
        assert (result);
    }

    private void add(ArrayClassObject clazz, int stackIndex, long nrOfObjects, long nrOfBytes) {
        this.totalObjects += nrOfObjects;
        this.totalBytes += nrOfBytes;
        long reducedNrOfBytes = nrOfBytes - nrOfObjects * clazz.getInstanceSize(0);
        assert ((reducedNrOfBytes & (long)(clazz.getWordSize() - 1)) == 0L);
        if (this.addToBigArrayHashMap(clazz, stackIndex, nrOfObjects, reducedNrOfBytes /= (long)clazz.getWordSize(), true)) {
            return;
        }
        if (!BitUtil.usesMoreBits((long)nrOfObjects, (int)31) && !BitUtil.usesMoreBits((long)nrOfBytes, (int)31)) {
            if (this.addToSmallArrayHashMap(clazz, stackIndex, (int)nrOfObjects, (int)reducedNrOfBytes, true)) {
                return;
            }
            if (this.addToArrayClassArray(clazz, stackIndex, (int)nrOfObjects, (int)reducedNrOfBytes)) {
                return;
            }
            if (this.addToSmallArrayHashMap(clazz, stackIndex, (int)nrOfObjects, (int)reducedNrOfBytes, false)) {
                return;
            }
        }
        boolean result = this.addToBigArrayHashMap(clazz, stackIndex, nrOfObjects, reducedNrOfBytes, false);
        assert (result);
    }

    private void finish() {
        long memUsedInSmallNonArrayMap;
        long memUsedForNonArrayClassArray;
        long memUsedInSmallArrayMap;
        long memUsedForArrayClassArray = this.arrayClassArray.size() * 6L;
        if ((double)memUsedForArrayClassArray * 0.9 > (double)(memUsedInSmallArrayMap = 12L * (long)this.nrOfArrayClassArrayEntries)) {
            int maxIndex = (int)this.arrayClassArray.size();
            ClassObjectManager classManager = this.session.getClassObjectManager();
            for (int i = 0; i < maxIndex; ++i) {
                int classIndex = (int)this.arrayClassArray.get(i, 0, 18);
                if (classIndex == 0) continue;
                ArrayClassObject clazz = (ArrayClassObject)classManager.getClassObject(classIndex);
                int stackBaseIndex = 2 * (i & 0xFFFFFFF0);
                int stackIndex = stackBaseIndex + (int)this.arrayClassArray.get(i, 27, 5);
                int currNrOfObjects = (int)this.arrayClassArray.get(i, 18, 9);
                int currNrOfBytes = (int)this.arrayClassArray.get(i, 32, 16);
                --this.nrOfEntries;
                boolean result = this.addToSmallArrayHashMap(clazz, stackIndex, currNrOfObjects, currNrOfBytes, false);
                assert (result);
            }
            this.arrayClassArray = null;
            this.nrOfArrayClassArrayEntries = 0;
        }
        if ((double)(memUsedForNonArrayClassArray = this.nonArrayClassArray.size() * 4L) * 0.9 > (double)(memUsedInSmallNonArrayMap = 8L * (long)this.nrOfNonArrayClassArrayEntries)) {
            int maxIndex = (int)this.nonArrayClassArray.size();
            ClassObjectManager classManager = this.session.getClassObjectManager();
            for (int i = 0; i < maxIndex; ++i) {
                int classIndex = this.nonArrayClassArray.get(i, 0, 18);
                if (classIndex == 0) continue;
                NonArrayClassObject clazz = (NonArrayClassObject)classManager.getClassObject(classIndex);
                int stackBaseIndex = 2 * (i & 0xFFFFFFF0);
                int stackIndex = stackBaseIndex + this.nonArrayClassArray.get(i, 27, 5);
                int currNrOfObjects = this.nonArrayClassArray.get(i, 18, 9);
                --this.nrOfEntries;
                boolean result = this.addToSmallNonArrayHashMap(clazz, stackIndex, currNrOfObjects, false);
                assert (result);
            }
            this.nonArrayClassArray = null;
            this.nrOfNonArrayClassArrayEntries = 0;
        }
        this.smallArrayMapBuckets = null;
        this.smallArrayMapNext = null;
        this.smallNonArrayMapBuckets = null;
        this.smallNonArrayMapNext = null;
        this.bigArrayMapBuckets = null;
        this.bigArrayMapNext = null;
        this.bigNonArrayMapBuckets = null;
        this.bigNonArrayMapNext = null;
        if (CHECK_STATISTIC && this.getClass().desiredAssertionStatus()) {
            PositiveLongSet seen = new PositiveLongSet();
            ClassAndStackIteratorImpl it = this.getIterators(1)[0];
            long itBytes = 0L;
            long itObjects = 0L;
            long itCount = 0L;
            while (it.next()) {
                long stackAndClassIndex = (long)it.getStackIndex() << 32 | (long)it.getClassIndex();
                assert (!seen.contains(stackAndClassIndex));
                seen.add(stackAndClassIndex);
                itBytes += it.getBytes();
                itObjects += it.getObjects();
                ++itCount;
            }
            assert (itBytes == this.totalBytes);
            assert (itObjects == this.totalObjects);
            assert (itCount == this.nrOfEntries);
        }
    }

    @Override
    public long getHeapBytes() {
        return this.isHeapOnly ? this.totalBytes : 0L;
    }

    @Override
    public long getHeapObjects() {
        return this.isHeapOnly ? this.totalObjects : 0L;
    }

    @Override
    public long getStackBytes() {
        return this.isHeapOnly ? 0L : this.totalBytes;
    }

    @Override
    public long getStackObjects() {
        return this.isHeapOnly ? 0L : this.totalObjects;
    }

    public long getNrOfEntries() {
        return this.nrOfEntries;
    }

    public ClassAndStackIteratorImpl[] getIterators(int nrOfIterators) {
        ClassAndStackIteratorImpl baseIterator;
        assert (nrOfIterators > 0);
        ClassAndStackIteratorImpl[] result = new ClassAndStackIteratorImpl[nrOfIterators];
        result[0] = baseIterator = new ClassAndStackIteratorImpl(this, null);
        for (int i = 1; i < nrOfIterators; ++i) {
            result[i] = new ClassAndStackIteratorImpl(this, baseIterator);
        }
        return result;
    }

    @Override
    public long getSize() {
        return (long)this.nrOfArrayClassArrayEntries + (long)this.nrOfNonArrayClassArrayEntries + (long)(this.smallArrayMapNextIndex - 1) - (long)this.smallArrayMapRemoved + (long)(this.smallNonArrayMapNextIndex - 1) - (long)this.smallNonArrayMapRemoved + (long)(this.bigArrayMapNextIndex - 1) + (long)(this.bigNonArrayMapNextIndex - 1);
    }

    public ResourceName[] getDependents() {
        return null;
    }

    private boolean addToNonArrayClassArray(NonArrayClassObject clazz, int stackIndex, int nrOfObjects) {
        int classIndex = clazz.getIndex();
        assert (classIndex != 0);
        if (BitUtil.usesMoreBits((int)classIndex, (int)18)) {
            return false;
        }
        int stackIndexBase = stackIndex & 0xFFFFFFE0;
        int arrayIndexBase = stackIndexBase / 2;
        int emptySlot = -1;
        if (this.nonArrayClassArray.size() < (long)(arrayIndexBase + 16)) {
            this.nonArrayClassArray.resize(arrayIndexBase + 16);
        }
        for (int i = arrayIndexBase; i < arrayIndexBase + 16; ++i) {
            int currStackIndex;
            int currClassIndex = this.nonArrayClassArray.get(i, 0, 18);
            if (currClassIndex == 0) {
                emptySlot = i;
                continue;
            }
            if (currClassIndex != classIndex || (currStackIndex = stackIndexBase + this.nonArrayClassArray.get(i, 27, 5)) != stackIndex) continue;
            int oldNrOfObjects = this.nonArrayClassArray.get(i, 18, 9);
            int newNrOfObjects = oldNrOfObjects + nrOfObjects;
            if (BitUtil.usesMoreBits((int)newNrOfObjects, (int)9)) {
                this.nonArrayClassArray.set(i, 0);
                --this.nrOfNonArrayClassArrayEntries;
                --this.nrOfEntries;
                boolean result = this.addToSmallNonArrayHashMap(clazz, stackIndex, newNrOfObjects, false);
                assert (result);
                return true;
            }
            this.nonArrayClassArray.set(i, newNrOfObjects, 18, 9);
            return true;
        }
        if (BitUtil.usesMoreBits((int)nrOfObjects, (int)9)) {
            return false;
        }
        if (emptySlot >= 0) {
            this.nonArrayClassArray.set(emptySlot, classIndex, 0, 18);
            this.nonArrayClassArray.set(emptySlot, nrOfObjects, 18, 9);
            this.nonArrayClassArray.set(emptySlot, stackIndex - stackIndexBase, 27, 5);
            ++this.nrOfNonArrayClassArrayEntries;
            ++this.nrOfEntries;
            return true;
        }
        return false;
    }

    private IntPair getFromNonArrayClassArray(int startIndex, int maxToAdd, int offset, int[] classIndices, int[] stackIndices, long[] nrOfObjects, long[] nrOfBytes) {
        int leftToAdd = maxToAdd;
        int currOffset = offset;
        int maxIndex = (int)this.nonArrayClassArray.size();
        ClassObjectManager classManager = this.session.getClassObjectManager();
        for (int i = startIndex; i < maxIndex; ++i) {
            int classIndex = this.nonArrayClassArray.get(i, 0, 18);
            if (classIndex == 0) {
                assert (this.nonArrayClassArray.get(i) == 0);
                continue;
            }
            NonArrayClassObject clazz = (NonArrayClassObject)classManager.getClassObject(classIndex);
            int stackBaseIndex = 2 * (i & 0xFFFFFFF0);
            int stackIndex = stackBaseIndex + this.nonArrayClassArray.get(i, 27, 5);
            int currNrOfObjects = this.nonArrayClassArray.get(i, 18, 9);
            nrOfObjects[currOffset] = currNrOfObjects;
            nrOfBytes[currOffset] = (long)clazz.getInstanceSize() * (long)currNrOfObjects;
            classIndices[currOffset] = classIndex;
            stackIndices[currOffset] = stackIndex;
            ++currOffset;
            if (--leftToAdd != 0) continue;
            return new IntPair(maxToAdd, i + 1);
        }
        return new IntPair(maxToAdd - leftToAdd, maxIndex);
    }

    private boolean addToArrayClassArray(ArrayClassObject clazz, int stackIndex, int nrOfObjects, int nrOfBytes) {
        int classIndex = clazz.getIndex();
        assert (classIndex != 0);
        if (BitUtil.usesMoreBits((int)classIndex, (int)18)) {
            return false;
        }
        int stackIndexBase = stackIndex & 0xFFFFFFE0;
        int arrayIndexBase = stackIndexBase / 2;
        int emptySlot = -1;
        if (this.arrayClassArray.size() < (long)(arrayIndexBase + 16)) {
            this.arrayClassArray.resize(arrayIndexBase + 16);
        }
        for (int i = arrayIndexBase; i < arrayIndexBase + 16; ++i) {
            int currStackIndex;
            int currClassIndex = (int)this.arrayClassArray.get(i, 0, 18);
            if (currClassIndex == 0) {
                emptySlot = i;
                continue;
            }
            if (currClassIndex != classIndex || (currStackIndex = stackIndexBase + (int)this.arrayClassArray.get(i, 27, 5)) != stackIndex) continue;
            int oldNrOfObjects = (int)this.arrayClassArray.get(i, 18, 9);
            int newNrOfObjects = oldNrOfObjects + nrOfObjects;
            int oldNrOfBytes = (int)this.arrayClassArray.get(i, 32, 16);
            int newNrOfBytes = oldNrOfBytes + nrOfBytes;
            if (BitUtil.usesMoreBits((int)newNrOfObjects, (int)9) || BitUtil.usesMoreBits((int)newNrOfBytes, (int)16)) {
                this.arrayClassArray.set((long)i, 0L);
                --this.nrOfArrayClassArrayEntries;
                --this.nrOfEntries;
                boolean result = this.addToSmallArrayHashMap(clazz, currStackIndex, newNrOfObjects, newNrOfBytes, false);
                assert (result);
                return true;
            }
            this.arrayClassArray.set(i, (long)newNrOfObjects, 18, 9);
            this.arrayClassArray.set(i, (long)newNrOfBytes, 32, 16);
            return true;
        }
        if (BitUtil.usesMoreBits((int)nrOfObjects, (int)9)) {
            return false;
        }
        if (BitUtil.usesMoreBits((int)nrOfBytes, (int)16)) {
            return false;
        }
        if (emptySlot >= 0) {
            this.arrayClassArray.set(emptySlot, (long)classIndex, 0, 18);
            this.arrayClassArray.set(emptySlot, (long)nrOfObjects, 18, 9);
            this.arrayClassArray.set(emptySlot, (long)(stackIndex - stackIndexBase), 27, 5);
            this.arrayClassArray.set(emptySlot, (long)nrOfBytes, 32, 16);
            ++this.nrOfArrayClassArrayEntries;
            ++this.nrOfEntries;
            return true;
        }
        return false;
    }

    private IntPair getFromArrayClassArray(int startIndex, int maxToAdd, int offset, int[] classIndices, int[] stackIndices, long[] nrOfObjects, long[] nrOfBytes) {
        int leftToAdd = maxToAdd;
        int currOffset = offset;
        int maxIndex = (int)this.arrayClassArray.size();
        ClassObjectManager classManager = this.session.getClassObjectManager();
        for (int i = startIndex; i < maxIndex; ++i) {
            int classIndex = (int)this.arrayClassArray.get(i, 0, 18);
            if (classIndex == 0) continue;
            ArrayClassObject clazz = (ArrayClassObject)classManager.getClassObject(classIndex);
            int stackBaseIndex = 2 * (i & 0xFFFFFFF0);
            int stackIndex = stackBaseIndex + (int)this.arrayClassArray.get(i, 27, 5);
            int currNrOfObjects = (int)this.arrayClassArray.get(i, 18, 9);
            int currNrOfBytes = (int)this.arrayClassArray.get(i, 32, 16);
            nrOfObjects[currOffset] = currNrOfObjects;
            nrOfBytes[currOffset] = (long)currNrOfObjects * clazz.getInstanceSize(0) + (long)(currNrOfBytes * clazz.getWordSize());
            classIndices[currOffset] = classIndex;
            stackIndices[currOffset] = stackIndex;
            ++currOffset;
            if (--leftToAdd != 0) continue;
            return new IntPair(maxToAdd, i + 1);
        }
        return new IntPair(maxToAdd - leftToAdd, maxIndex);
    }

    private final boolean addToSmallNonArrayHashMap(NonArrayClassObject clazz, int stackIndex, int nrOfObjects, boolean addOnlyIfPresent) {
        if (BitUtil.usesMoreBits((int)stackIndex, (int)26)) {
            return false;
        }
        if (BitUtil.usesMoreBits((int)nrOfObjects, (int)20)) {
            return false;
        }
        int classIndex = clazz.getIndex();
        if (BitUtil.usesMoreBits((int)classIndex, (int)18)) {
            return false;
        }
        int bucket = (stackIndex ^ classIndex) & this.smallNonArrayMapMask;
        int index = this.smallNonArrayMapBuckets.get(bucket);
        while (index != 0) {
            int currStackIndex;
            int currClassIndex = (int)this.smallNonArrayMapEntries.get(index, 26, 18);
            if (currClassIndex == classIndex && (currStackIndex = (int)this.smallNonArrayMapEntries.get(index, 0, 26)) == stackIndex) {
                int oldNrOfObjects = (int)this.smallNonArrayMapEntries.get(index, 44, 20);
                int newNrOfObjects = oldNrOfObjects + nrOfObjects;
                if (BitUtil.usesMoreBits((int)newNrOfObjects, (int)20)) {
                    this.smallNonArrayMapEntries.set((long)index, 0L);
                    ++this.smallNonArrayMapRemoved;
                    --this.nrOfEntries;
                    boolean result = this.addToBigNonArrayHashMap(clazz, stackIndex, newNrOfObjects, false);
                    assert (result);
                    return true;
                }
                this.smallNonArrayMapEntries.set(index, (long)newNrOfObjects, 44, 20);
                return true;
            }
            index = this.smallNonArrayMapNext.get(index);
        }
        if (addOnlyIfPresent) {
            return false;
        }
        if (this.smallNonArrayMapNextIndex >= this.smallNonArrayMapLimit) {
            int nrOfBuckets = (int)this.smallNonArrayMapBuckets.size() * 2;
            this.smallNonArrayMapBuckets.resizeAndClear((long)nrOfBuckets);
            this.smallNonArrayMapLimit = (int)((double)nrOfBuckets * 5.0);
            this.smallNonArrayMapMask = nrOfBuckets - 1;
            for (int i = 1; i < this.smallNonArrayMapNextIndex; ++i) {
                int currClassIndex = (int)this.smallNonArrayMapEntries.get(i, 26, 18);
                if (currClassIndex == 0) continue;
                int currStackIndex = (int)this.smallNonArrayMapEntries.get(i, 0, 26);
                bucket = (currClassIndex ^ currStackIndex) & this.smallNonArrayMapMask;
                int oldNext = this.smallNonArrayMapBuckets.get(bucket);
                this.smallNonArrayMapNext.set(i, oldNext);
                this.smallNonArrayMapBuckets.set(bucket, i);
            }
            bucket = (stackIndex ^ classIndex) & this.smallNonArrayMapMask;
        }
        this.smallNonArrayMapEntries.resize(this.smallNonArrayMapNextIndex + 1);
        this.smallNonArrayMapNext.resize(this.smallNonArrayMapNextIndex + 1);
        this.smallNonArrayMapEntries.set(this.smallNonArrayMapNextIndex, (long)stackIndex, 0, 26);
        this.smallNonArrayMapEntries.set(this.smallNonArrayMapNextIndex, (long)classIndex, 26, 18);
        this.smallNonArrayMapEntries.set(this.smallNonArrayMapNextIndex, (long)nrOfObjects, 44, 20);
        int oldNext = this.smallNonArrayMapBuckets.get(bucket);
        this.smallNonArrayMapNext.set(this.smallNonArrayMapNextIndex, oldNext);
        this.smallNonArrayMapBuckets.set(bucket, this.smallNonArrayMapNextIndex);
        ++this.smallNonArrayMapNextIndex;
        ++this.nrOfEntries;
        return true;
    }

    private IntPair getFromSmallNonArrayClassMap(int startIndex, int maxToAdd, int offset, int[] classIndices, int[] stackIndices, long[] nrOfObjects, long[] nrOfBytes) {
        int leftToAdd = maxToAdd;
        int currOffset = offset;
        int maxIndex = this.smallNonArrayMapNextIndex;
        ClassObjectManager classManager = this.session.getClassObjectManager();
        for (int i = startIndex; i < maxIndex; ++i) {
            int classIndex = (int)this.smallNonArrayMapEntries.get(i, 26, 18);
            if (classIndex == 0) continue;
            NonArrayClassObject clazz = (NonArrayClassObject)classManager.getClassObject(classIndex);
            int stackIndex = (int)this.smallNonArrayMapEntries.get(i, 0, 26);
            int currNrOfObjects = (int)this.smallNonArrayMapEntries.get(i, 44, 20);
            nrOfObjects[currOffset] = currNrOfObjects;
            nrOfBytes[currOffset] = (long)clazz.getInstanceSize() * (long)currNrOfObjects;
            classIndices[currOffset] = classIndex;
            stackIndices[currOffset] = stackIndex;
            ++currOffset;
            if (--leftToAdd != 0) continue;
            return new IntPair(maxToAdd, i + 1);
        }
        return new IntPair(maxToAdd - leftToAdd, maxIndex);
    }

    private final boolean addToSmallArrayHashMap(ArrayClassObject clazz, int stackIndex, int nrOfObjects, int nrOfBytes, boolean addOnlyIfPresent) {
        if (BitUtil.usesMoreBits((int)stackIndex, (int)26)) {
            return false;
        }
        if (BitUtil.usesMoreBits((int)nrOfObjects, (int)20)) {
            return false;
        }
        int classIndex = clazz.getIndex();
        if (BitUtil.usesMoreBits((int)classIndex, (int)18)) {
            return false;
        }
        int bucket = (stackIndex ^ classIndex) & this.smallArrayMapMask;
        int index = this.smallArrayMapBuckets.get(bucket);
        while (index != 0) {
            int currStackIndex;
            int currClassIndex = (int)this.smallArrayMapEntries.get(index, 26, 18);
            if (currClassIndex == classIndex && (currStackIndex = (int)this.smallArrayMapEntries.get(index, 0, 26)) == stackIndex) {
                int oldNrOfObjects = (int)this.smallArrayMapEntries.get(index, 44, 20);
                int newNrOfObjects = oldNrOfObjects + nrOfObjects;
                int oldNrOfBytes = this.smallArrayMapNrOfBytes.get(index);
                long newNrOfBytes = oldNrOfBytes + nrOfBytes;
                if (BitUtil.usesMoreBits((int)newNrOfObjects, (int)20) || BitUtil.usesMoreBits((long)newNrOfBytes, (int)31)) {
                    this.smallArrayMapEntries.set((long)index, 0L);
                    ++this.smallArrayMapRemoved;
                    --this.nrOfEntries;
                    boolean result = this.addToBigArrayHashMap(clazz, currStackIndex, newNrOfObjects, newNrOfBytes, false);
                    assert (result);
                    return true;
                }
                this.smallArrayMapEntries.set(index, (long)newNrOfObjects, 44, 20);
                this.smallArrayMapNrOfBytes.set(index, (int)newNrOfBytes);
                return true;
            }
            index = this.smallArrayMapNext.get(index);
        }
        if (addOnlyIfPresent) {
            return false;
        }
        if (this.smallArrayMapNextIndex >= this.smallArrayMapLimit) {
            int nrOfBuckets = (int)this.smallArrayMapBuckets.size() * 2;
            this.smallArrayMapBuckets.resizeAndClear((long)nrOfBuckets);
            this.smallArrayMapLimit = (int)((double)nrOfBuckets * 5.0);
            this.smallArrayMapMask = nrOfBuckets - 1;
            for (int i = 1; i < this.smallArrayMapNextIndex; ++i) {
                int currClassIndex = (int)this.smallArrayMapEntries.get(i, 26, 18);
                if (currClassIndex == 0) continue;
                int currStackIndex = (int)this.smallArrayMapEntries.get(i, 0, 26);
                bucket = (currClassIndex ^ currStackIndex) & this.smallArrayMapMask;
                int oldNext = this.smallArrayMapBuckets.get(bucket);
                this.smallArrayMapNext.set(i, oldNext);
                this.smallArrayMapBuckets.set(bucket, i);
            }
            bucket = (stackIndex ^ classIndex) & this.smallArrayMapMask;
        }
        this.smallArrayMapEntries.resize(this.smallArrayMapNextIndex + 1);
        this.smallArrayMapNrOfBytes.resize(this.smallArrayMapNextIndex + 1);
        this.smallArrayMapNext.resize(this.smallArrayMapNextIndex + 1);
        this.smallArrayMapEntries.set(this.smallArrayMapNextIndex, (long)stackIndex, 0, 26);
        this.smallArrayMapEntries.set(this.smallArrayMapNextIndex, (long)classIndex, 26, 18);
        this.smallArrayMapEntries.set(this.smallArrayMapNextIndex, (long)nrOfObjects, 44, 20);
        this.smallArrayMapNrOfBytes.set(this.smallArrayMapNextIndex, nrOfBytes);
        int oldNext = this.smallArrayMapBuckets.get(bucket);
        this.smallArrayMapNext.set(this.smallArrayMapNextIndex, oldNext);
        this.smallArrayMapBuckets.set(bucket, this.smallArrayMapNextIndex);
        ++this.smallArrayMapNextIndex;
        ++this.nrOfEntries;
        return true;
    }

    private IntPair getFromSmallArrayClassMap(int startIndex, int maxToAdd, int offset, int[] classIndices, int[] stackIndices, long[] nrOfObjects, long[] nrOfBytes) {
        int leftToAdd = maxToAdd;
        int currOffset = offset;
        int maxIndex = this.smallArrayMapNextIndex;
        ClassObjectManager classManager = this.session.getClassObjectManager();
        for (int i = startIndex; i < maxIndex; ++i) {
            int classIndex = (int)this.smallArrayMapEntries.get(i, 26, 18);
            if (classIndex == 0) continue;
            ArrayClassObject clazz = (ArrayClassObject)classManager.getClassObject(classIndex);
            int stackIndex = (int)this.smallArrayMapEntries.get(i, 0, 26);
            int currNrOfObjects = (int)this.smallArrayMapEntries.get(i, 44, 20);
            long currNrOfBytes = this.smallArrayMapNrOfBytes.get(i);
            nrOfObjects[currOffset] = currNrOfObjects;
            nrOfBytes[currOffset] = clazz.getInstanceSize(0) * (long)currNrOfObjects + currNrOfBytes * (long)clazz.getWordSize();
            classIndices[currOffset] = classIndex;
            stackIndices[currOffset] = stackIndex;
            ++currOffset;
            if (--leftToAdd != 0) continue;
            return new IntPair(maxToAdd, i + 1);
        }
        return new IntPair(maxToAdd - leftToAdd, maxIndex);
    }

    private final boolean addToBigNonArrayHashMap(NonArrayClassObject clazz, int stackIndex, long nrOfObjects, boolean addOnlyIfPresent) {
        int classIndex = clazz.getIndex();
        int bucket = (stackIndex ^ classIndex) & this.bigNonArrayMapMask;
        int index = this.bigNonArrayMapBuckets.get(bucket);
        while (index != 0) {
            int currStackIndex;
            int currClassIndex = this.bigNonArrayMapClassIndex.get(index);
            if (currClassIndex == classIndex && (currStackIndex = this.bigNonArrayMapStackIndex.get(index)) == stackIndex) {
                long oldNrOfObjects = this.bigNonArrayMapNrOfObjects.get(index);
                long newNrOfObjects = oldNrOfObjects + nrOfObjects;
                this.bigNonArrayMapNrOfObjects.set((long)index, newNrOfObjects);
                return true;
            }
            index = this.bigNonArrayMapNext.get(index);
        }
        if (addOnlyIfPresent) {
            return false;
        }
        if (this.bigNonArrayMapNextIndex >= this.bigNonArrayMapLimit) {
            int nrOfBuckets = (int)this.bigNonArrayMapBuckets.size() * 2;
            this.bigNonArrayMapBuckets.resizeAndClear((long)nrOfBuckets);
            this.bigNonArrayMapLimit = (int)((double)nrOfBuckets * 5.0);
            this.bigNonArrayMapMask = nrOfBuckets - 1;
            for (int i = 1; i < this.bigNonArrayMapNextIndex; ++i) {
                int currClassIndex = this.bigNonArrayMapClassIndex.get(1);
                assert (currClassIndex != 0);
                int currStackIndex = this.bigNonArrayMapStackIndex.get(1);
                bucket = (currClassIndex ^ currStackIndex) & this.bigNonArrayMapMask;
                int oldNext = this.bigNonArrayMapBuckets.get(bucket);
                this.bigNonArrayMapNext.set(i, oldNext);
                this.bigNonArrayMapBuckets.set(bucket, i);
            }
            bucket = (stackIndex ^ classIndex) & this.bigNonArrayMapMask;
        }
        this.bigNonArrayMapStackIndex.resize(this.bigNonArrayMapNextIndex + 1);
        this.bigNonArrayMapClassIndex.resize(this.bigNonArrayMapNextIndex + 1);
        this.bigNonArrayMapNrOfObjects.resize(this.bigNonArrayMapNextIndex + 1);
        this.bigNonArrayMapNext.resize(this.bigNonArrayMapNextIndex + 1);
        this.bigNonArrayMapStackIndex.set(this.bigNonArrayMapNextIndex, stackIndex);
        this.bigNonArrayMapClassIndex.set(this.bigNonArrayMapNextIndex, classIndex);
        this.bigNonArrayMapNrOfObjects.set((long)this.bigNonArrayMapNextIndex, nrOfObjects);
        int oldNext = this.bigNonArrayMapBuckets.get(bucket);
        this.bigNonArrayMapNext.set(this.bigNonArrayMapNextIndex, oldNext);
        this.bigNonArrayMapBuckets.set(bucket, this.bigNonArrayMapNextIndex);
        ++this.bigNonArrayMapNextIndex;
        ++this.nrOfEntries;
        return true;
    }

    private IntPair getFromBigNonArrayClassMap(int startIndex, int maxToAdd, int offset, int[] classIndices, int[] stackIndices, long[] nrOfObjects, long[] nrOfBytes) {
        int leftToAdd = maxToAdd;
        int currOffset = offset;
        int maxIndex = this.bigNonArrayMapNextIndex;
        ClassObjectManager classManager = this.session.getClassObjectManager();
        for (int i = startIndex; i < maxIndex; ++i) {
            long currNrOfObjects;
            int classIndex = this.bigNonArrayMapClassIndex.get(i);
            assert (classIndex != 0);
            NonArrayClassObject clazz = (NonArrayClassObject)classManager.getClassObject(classIndex);
            int stackIndex = this.bigNonArrayMapStackIndex.get(i);
            nrOfObjects[currOffset] = currNrOfObjects = this.bigNonArrayMapNrOfObjects.get(i);
            nrOfBytes[currOffset] = (long)clazz.getInstanceSize() * currNrOfObjects;
            classIndices[currOffset] = classIndex;
            stackIndices[currOffset] = stackIndex;
            ++currOffset;
            if (--leftToAdd != 0) continue;
            return new IntPair(maxToAdd, i + 1);
        }
        return new IntPair(maxToAdd - leftToAdd, maxIndex);
    }

    private final boolean addToBigArrayHashMap(ArrayClassObject clazz, int stackIndex, long nrOfObjects, long nrOfBytes, boolean addOnlyIfPresent) {
        int classIndex = clazz.getIndex();
        int bucket = (stackIndex ^ classIndex) & this.bigArrayMapMask;
        int index = this.bigArrayMapBuckets.get(bucket);
        while (index != 0) {
            int currStackIndex;
            int currClassIndex = this.bigArrayMapClassIndex.get(index);
            if (currClassIndex == classIndex && (currStackIndex = this.bigArrayMapStackIndex.get(index)) == stackIndex) {
                long oldNrOfObjects = this.bigArrayMapNrOfObjects.get(index);
                long newNrOfObjects = oldNrOfObjects + nrOfObjects;
                long oldNrOfBytes = this.bigArrayMapNrOfBytes.get(index);
                long newNrOfBytes = oldNrOfBytes + nrOfBytes;
                this.bigArrayMapNrOfObjects.set((long)index, newNrOfObjects);
                this.bigArrayMapNrOfBytes.set((long)index, newNrOfBytes);
                return true;
            }
            index = this.bigArrayMapNext.get(index);
        }
        if (addOnlyIfPresent) {
            return false;
        }
        if (this.bigArrayMapNextIndex >= this.bigArrayMapLimit) {
            int nrOfBuckets = (int)this.bigArrayMapBuckets.size() * 2;
            this.bigArrayMapBuckets.resizeAndClear((long)nrOfBuckets);
            this.bigArrayMapLimit = (int)((double)nrOfBuckets * 5.0);
            this.bigArrayMapMask = nrOfBuckets - 1;
            for (int i = 1; i < this.bigArrayMapNextIndex; ++i) {
                int currClassIndex = this.bigArrayMapClassIndex.get(1);
                assert (currClassIndex != 0);
                int currStackIndex = this.bigArrayMapStackIndex.get(1);
                bucket = (currClassIndex ^ currStackIndex) & this.bigArrayMapMask;
                int oldNext = this.bigArrayMapBuckets.get(bucket);
                this.bigArrayMapNext.set(i, oldNext);
                this.bigArrayMapBuckets.set(bucket, i);
            }
            bucket = (stackIndex ^ classIndex) & this.bigArrayMapMask;
        }
        this.bigArrayMapStackIndex.resize(this.bigArrayMapNextIndex + 1);
        this.bigArrayMapClassIndex.resize(this.bigArrayMapNextIndex + 1);
        this.bigArrayMapNrOfObjects.resize(this.bigArrayMapNextIndex + 1);
        this.bigArrayMapNrOfBytes.resize(this.bigArrayMapNextIndex + 1);
        this.bigArrayMapNext.resize(this.bigArrayMapNextIndex + 1);
        this.bigArrayMapStackIndex.set(this.bigArrayMapNextIndex, stackIndex);
        this.bigArrayMapClassIndex.set(this.bigArrayMapNextIndex, classIndex);
        this.bigArrayMapNrOfObjects.set((long)this.bigArrayMapNextIndex, nrOfObjects);
        this.bigArrayMapNrOfBytes.set((long)this.bigArrayMapNextIndex, nrOfBytes);
        int oldNext = this.bigArrayMapBuckets.get(bucket);
        this.bigArrayMapNext.set(this.bigArrayMapNextIndex, oldNext);
        this.bigArrayMapBuckets.set(bucket, this.bigArrayMapNextIndex);
        ++this.bigArrayMapNextIndex;
        ++this.nrOfEntries;
        return true;
    }

    private IntPair getFromBigArrayClassMap(int startIndex, int maxToAdd, int offset, int[] classIndices, int[] stackIndices, long[] nrOfObjects, long[] nrOfBytes) {
        int leftToAdd = maxToAdd;
        int currOffset = offset;
        int maxIndex = this.bigArrayMapNextIndex;
        ClassObjectManager classManager = this.session.getClassObjectManager();
        for (int i = startIndex; i < maxIndex; ++i) {
            int classIndex = this.bigArrayMapClassIndex.get(i);
            assert (classIndex != 0);
            ArrayClassObject clazz = (ArrayClassObject)classManager.getClassObject(classIndex);
            int stackIndex = this.bigArrayMapStackIndex.get(i);
            long currNrOfObjects = this.bigArrayMapNrOfObjects.get(i);
            long currNrOfBytes = this.bigArrayMapNrOfBytes.get(i);
            nrOfObjects[currOffset] = currNrOfObjects;
            nrOfBytes[currOffset] = clazz.getInstanceSize(0) * currNrOfObjects + currNrOfBytes * (long)clazz.getWordSize();
            classIndices[currOffset] = classIndex;
            stackIndices[currOffset] = stackIndex;
            ++currOffset;
            if (--leftToAdd != 0) continue;
            return new IntPair(maxToAdd, i + 1);
        }
        return new IntPair(maxToAdd - leftToAdd, maxIndex);
    }

    public boolean isModifiable() {
        return false;
    }

    public static final class ClassAndStackIteratorImpl
    implements ClassAndStackIterator {
        private static final int STORE_SIZE = 8192;
        private static final int ITERATE_ARRAY_CLASS_ARRAY = 0;
        private static final int ITERATE_NON_ARRAY_CLASS_ARRAY = 1;
        private static final int ITERATE_SMALL_NON_ARRAY_CLASS_MAP = 2;
        private static final int ITERATE_SMALL_ARRAY_CLASS_MAP = 3;
        private static final int ITERATE_BIG_NON_ARRAY_CLASS_MAP = 4;
        private static final int ITERATE_BIG_ARRAY_CLASS_MAP = 5;
        private final ClassAndStackStatisticImpl statistic;
        private int type;
        private int arrayClassArrayIndex;
        private int nonArrayClassArrayIndex;
        private int smallNonArrayClassMapIndex;
        private int smallArrayClassMapIndex;
        private int bigNonArrayClassMapIndex;
        private int bigArrayClassMapIndex;
        private long nrOfEntries;
        private final ClassAndStackIteratorImpl baseIterator;
        private final int[] classStore;
        private final int[] stackStore;
        private final long[] nrOfObjectsStore;
        private final long[] nrOfBytesStore;
        private int storeIndex;
        private int maxStoreIndex;
        private boolean isValid;
        private final ClassObjectManager classManager;

        public ClassAndStackIteratorImpl(ClassAndStackStatisticImpl statistic, ClassAndStackIteratorImpl baseIterator) {
            this.statistic = statistic;
            this.classStore = new int[8192];
            this.stackStore = new int[8192];
            this.nrOfObjectsStore = new long[8192];
            this.nrOfBytesStore = new long[8192];
            this.classManager = statistic.session.getClassObjectManager();
            this.smallNonArrayClassMapIndex = 1;
            this.smallArrayClassMapIndex = 1;
            this.bigNonArrayClassMapIndex = 1;
            this.bigArrayClassMapIndex = 1;
            this.baseIterator = baseIterator == null ? this : baseIterator;
            this.type = 0;
            this.maxStoreIndex = 0;
            this.isValid = true;
        }

        @Override
        public ClassObject getClassObject() {
            assert (this.isValid);
            return this.classManager.getClassObject(this.getClassIndex());
        }

        @Override
        public int getClassIndex() {
            assert (this.isValid);
            return this.classStore[this.storeIndex];
        }

        private long getBytes() {
            assert (this.isValid);
            return this.nrOfBytesStore[this.storeIndex];
        }

        private long getObjects() {
            assert (this.isValid);
            return this.nrOfObjectsStore[this.storeIndex];
        }

        @Override
        public long getHeapBytes() {
            if (!this.statistic.isHeapOnly) {
                return 0L;
            }
            return this.getBytes();
        }

        @Override
        public long getHeapObjects() {
            if (!this.statistic.isHeapOnly) {
                return 0L;
            }
            return this.getObjects();
        }

        @Override
        public long getStackBytes() {
            if (this.statistic.isHeapOnly) {
                return 0L;
            }
            return this.getBytes();
        }

        @Override
        public long getStackObjects() {
            if (this.statistic.isHeapOnly) {
                return 0L;
            }
            return this.getObjects();
        }

        @Override
        public int getStackIndex() {
            assert (this.isValid);
            return this.stackStore[this.storeIndex];
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public boolean next() {
            ++this.storeIndex;
            if (this.storeIndex < this.maxStoreIndex) {
                return true;
            }
            ClassAndStackIteratorImpl classAndStackIteratorImpl = this.baseIterator;
            synchronized (classAndStackIteratorImpl) {
                IntPair result;
                if (this.type == 0) {
                    if (this.statistic.arrayClassArray != null) {
                        this.storeIndex = 0;
                        result = this.statistic.getFromArrayClassArray(this.baseIterator.arrayClassArrayIndex, 8192, 0, this.classStore, this.stackStore, this.nrOfObjectsStore, this.nrOfBytesStore);
                        this.maxStoreIndex = result.getFirst();
                        this.baseIterator.arrayClassArrayIndex = result.getSecond();
                        this.baseIterator.nrOfEntries += (long)this.maxStoreIndex;
                        if (this.maxStoreIndex > 0) {
                            return true;
                        }
                    }
                    this.type = 1;
                }
                if (this.type == 1) {
                    if (this.statistic.nonArrayClassArray != null) {
                        this.storeIndex = 0;
                        result = this.statistic.getFromNonArrayClassArray(this.baseIterator.nonArrayClassArrayIndex, 8192, 0, this.classStore, this.stackStore, this.nrOfObjectsStore, this.nrOfBytesStore);
                        this.maxStoreIndex = result.getFirst();
                        this.baseIterator.nonArrayClassArrayIndex = result.getSecond();
                        this.baseIterator.nrOfEntries += (long)this.maxStoreIndex;
                        if (this.maxStoreIndex > 0) {
                            return true;
                        }
                    }
                    this.type = 2;
                }
                if (this.type == 2) {
                    this.storeIndex = 0;
                    result = this.statistic.getFromSmallNonArrayClassMap(this.baseIterator.smallNonArrayClassMapIndex, 8192, 0, this.classStore, this.stackStore, this.nrOfObjectsStore, this.nrOfBytesStore);
                    this.maxStoreIndex = result.getFirst();
                    this.baseIterator.smallNonArrayClassMapIndex = result.getSecond();
                    this.baseIterator.nrOfEntries += (long)this.maxStoreIndex;
                    if (this.maxStoreIndex > 0) {
                        return true;
                    }
                    this.type = 3;
                }
                if (this.type == 3) {
                    this.storeIndex = 0;
                    result = this.statistic.getFromSmallArrayClassMap(this.baseIterator.smallArrayClassMapIndex, 8192, 0, this.classStore, this.stackStore, this.nrOfObjectsStore, this.nrOfBytesStore);
                    this.maxStoreIndex = result.getFirst();
                    this.baseIterator.smallArrayClassMapIndex = result.getSecond();
                    this.baseIterator.nrOfEntries += (long)this.maxStoreIndex;
                    if (this.maxStoreIndex > 0) {
                        return true;
                    }
                    this.type = 4;
                }
                if (this.type == 4) {
                    this.storeIndex = 0;
                    result = this.statistic.getFromBigNonArrayClassMap(this.baseIterator.bigNonArrayClassMapIndex, 8192, 0, this.classStore, this.stackStore, this.nrOfObjectsStore, this.nrOfBytesStore);
                    this.maxStoreIndex = result.getFirst();
                    this.baseIterator.bigNonArrayClassMapIndex = result.getSecond();
                    this.baseIterator.nrOfEntries += (long)this.maxStoreIndex;
                    if (this.maxStoreIndex > 0) {
                        return true;
                    }
                    this.type = 5;
                }
                if (this.type == 5) {
                    this.storeIndex = 0;
                    result = this.statistic.getFromBigArrayClassMap(this.baseIterator.bigArrayClassMapIndex, 8192, 0, this.classStore, this.stackStore, this.nrOfObjectsStore, this.nrOfBytesStore);
                    this.maxStoreIndex = result.getFirst();
                    this.baseIterator.bigArrayClassMapIndex = result.getSecond();
                    this.baseIterator.nrOfEntries += (long)this.maxStoreIndex;
                    if (this.maxStoreIndex > 0) {
                        return true;
                    }
                    this.isValid = false;
                }
                return false;
            }
        }

        @Override
        public long getProgress() {
            return this.baseIterator.nrOfEntries;
        }

        @Override
        public long getMaxProgress() {
            return this.statistic.nrOfEntries;
        }

        @Override
        public boolean isStackAllocation() {
            return !this.isHeapAllocation();
        }

        @Override
        public boolean isHeapAllocation() {
            return this.statistic.isHeapOnly;
        }
    }
}

