/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.alloc;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.alloc.BytesAndObjects;
import com.sap.jvm.profiling.snapshot.alloc.ClassStatistic;
import com.sap.jvm.profiling.snapshot.impl.alloc.AllocationValueIterator;
import com.sap.jvm.profiling.snapshot.impl.resource.ValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.BytesAndObjectsColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.ClassColumn;
import com.sap.jvm.profiling.snapshot.impl.util.creator.ValueStatisticCreator;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.BytesAndObjectsSerializer;
import java.io.IOException;

public class ClassStatisticImpl
extends ValueStatisticImpl<ClassObject, BytesAndObjects>
implements ClassStatistic {
    protected ClassStatisticImpl(ResourceName name) {
        super(name, new ClassColumn(name.getSession()), new BytesAndObjectsColumnImpl(), new BytesAndObjectsSerializer());
    }

    public ClassStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the class statistic ... (<%> %)"), reporter);
    }

    public static ClassStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        AllocationValueIterator[] its = AllocationValueIterator.getIterators(name, reporter, I18n._s((String)"Creating the class statistic ... (<%> %)"), false);
        ClassStatisticImpl result = new ClassStatisticImpl(name);
        new Creator().fillInStatistic(result, its);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the class statistic ... (<%> %)"), reporter);
    }

    private static class Creator
    extends ValueStatisticCreator<ClassObject, BytesAndObjects> {
        private Creator() {
        }

        @Override
        protected ValueStatisticCollector<ClassObject, BytesAndObjects> getCollector(ValueIterator<BytesAndObjects> rawIt) throws IOException {
            AllocationValueIterator it = (AllocationValueIterator)rawIt;
            ValueStatisticCollector<ClassObject, BytesAndObjects> collector = new ValueStatisticCollector<ClassObject, BytesAndObjects>(BytesAndObjects.EMPTY);
            while (it.next()) {
                BytesAndObjects value = it.getValue();
                ClassObject clazz = it.getClassObject();
                collector.add(clazz, value);
                collector.add(value);
            }
            return collector;
        }
    }
}

