/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.cls;

import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.cls.ClassGeneration;
import com.sap.jvm.profiling.snapshot.cls.ClassLoaderValue;
import com.sap.jvm.profiling.snapshot.cls.ClsValue;
import java.io.IOException;
import java.util.HashMap;
import java.util.Map;

public class ClassLoaderValueImpl
implements ClassLoaderValue {
    private final ClassGeneration generation;
    private static final int VERSION = 0;
    private long nrOfClasses;
    private long nrOfObjects;
    private long nrOfBytes;
    private ClassObject initialObj;
    private ClassLoaderObject theClassloader;
    private Map<String, String> classes;
    private InstancesClassesAndBytesInGenerations[] instancesAndBytes;

    public ClassLoaderValueImpl(ClsValue obj) {
        this.classes = new HashMap<String, String>();
        this.initialObj = obj != null ? obj.getDelegate() : null;
        this.theClassloader = obj != null ? obj.getDelegate().getClassLoader() : null;
        this.nrOfClasses = obj != null ? 1L : 0L;
        this.nrOfBytes = obj != null ? obj.getSizeOfObjects() : 0L;
        this.generation = obj != null ? obj.getGeneration() : null;
        this.instancesAndBytes = new InstancesClassesAndBytesInGenerations[ClassGeneration.values().length];
        long l = this.nrOfObjects = obj != null ? obj.getNrOfObjetcs() : 0L;
        if (this.generation != null) {
            this.instancesAndBytes[this.generation.getId()] = new InstancesClassesAndBytesInGenerations(this.generation, this.nrOfClasses, this.nrOfBytes, this.nrOfObjects);
        }
    }

    public ClassLoaderValueImpl(ResourceReader reader) throws IOException {
        reader.readVersion(0, 0);
        this.theClassloader = reader.readClassLoaderObject();
        this.nrOfClasses = reader.readInt64();
        this.nrOfBytes = reader.readInt64();
        this.nrOfObjects = reader.readInt64();
        this.generation = ClassGeneration.getDataType(reader.readInt16());
        this.instancesAndBytes = new InstancesClassesAndBytesInGenerations[ClassGeneration.values().length];
        int countOfGens = reader.readInt32();
        for (int i = 0; i < countOfGens; ++i) {
            InstancesClassesAndBytesInGenerations temp;
            this.instancesAndBytes[temp.getGeneration().getId()] = temp = new InstancesClassesAndBytesInGenerations(reader);
        }
    }

    public static ClassLoaderValue create(ClsValue obj) {
        return new ClassLoaderValueImpl(obj);
    }

    public void write(ResourceWriter writer) throws IOException {
        int i;
        writer.writeVersion(0);
        writer.writeClassLoaderObject(this.theClassloader);
        writer.writeInt64(this.nrOfClasses);
        writer.writeInt64(this.nrOfBytes);
        writer.writeInt64(this.nrOfObjects);
        writer.writeInt16(this.generation != null ? this.generation.getId() : (short)0);
        int countOfGens = 0;
        for (i = 0; i < ClassGeneration.values().length; ++i) {
            if (this.instancesAndBytes[i] == null) continue;
            ++countOfGens;
        }
        writer.writeInt32(countOfGens);
        for (i = 0; i < ClassGeneration.values().length; ++i) {
            if (this.instancesAndBytes[i] == null) continue;
            this.instancesAndBytes[i].write(writer);
        }
    }

    @Override
    public ClassLoaderValue getSum(ClassLoaderValue toAdd) {
        String className;
        ClassObject objectUsedForInstanceCreation = ((ClassLoaderValueImpl)toAdd).getInitialObjectUsedForInstanceCreation();
        String string = className = objectUsedForInstanceCreation != null ? objectUsedForInstanceCreation.getFullName() : "unknown";
        if (this.classes.put(className, className) == null) {
            ++this.nrOfClasses;
        }
        if (this.instancesAndBytes[toAdd.getGeneration().getId()] == null) {
            this.instancesAndBytes[toAdd.getGeneration().getId()] = new InstancesClassesAndBytesInGenerations(toAdd.getGeneration(), 1L, toAdd.getSizeOfObjects(), toAdd.getNrOfObjetcs());
        } else {
            this.instancesAndBytes[toAdd.getGeneration().getId()].add(toAdd);
        }
        this.nrOfBytes += toAdd.getSizeOfObjects();
        this.nrOfObjects += toAdd.getNrOfObjetcs();
        return this;
    }

    @Override
    public long getClasses() {
        return this.nrOfClasses;
    }

    @Override
    public ClassLoaderObject getClassLoader() {
        return this.theClassloader;
    }

    @Override
    public long getSizeOfObjects() {
        return this.nrOfBytes;
    }

    @Override
    public long getNrOfClasses(ClassGeneration gen) {
        InstancesClassesAndBytesInGenerations val = this.instancesAndBytes[gen.getId()];
        if (val == null) {
            return 0L;
        }
        return val.getNrOfClasses();
    }

    @Override
    public long getSizeOfObjects(ClassGeneration gen) {
        InstancesClassesAndBytesInGenerations val = this.instancesAndBytes[gen.getId()];
        if (val == null) {
            return 0L;
        }
        return val.getSizeInBytes();
    }

    @Override
    public ClassGeneration getGeneration() {
        return this.generation;
    }

    @Override
    public long getNrOfObjetcs(ClassGeneration gen) {
        InstancesClassesAndBytesInGenerations val = this.instancesAndBytes[gen.getId()];
        if (val == null) {
            return 0L;
        }
        return val.getNrOfObjetcs();
    }

    @Override
    public long getNrOfObjetcs() {
        return this.nrOfObjects;
    }

    private ClassObject getInitialObjectUsedForInstanceCreation() {
        return this.initialObj;
    }

    public class InstancesClassesAndBytesInGenerations {
        private final ClassGeneration generation1;
        private long nrOfClasses1;
        private long nrOfObjects1;
        private long sizeInBytes;
        private static final int VERSION1 = 0;
        int i = 0;

        InstancesClassesAndBytesInGenerations(ClassGeneration gen, long nrOfClasses, long sizeInBytes, long nrOfObjects) {
            this.i = 0;
            this.generation1 = gen;
            this.nrOfClasses1 = nrOfClasses;
            this.sizeInBytes = sizeInBytes;
            this.nrOfObjects1 = nrOfObjects;
        }

        public void add(ClassLoaderValue toAdd) {
            this.sizeInBytes += toAdd.getSizeOfObjects();
            ++this.nrOfClasses1;
            this.nrOfObjects1 += toAdd.getNrOfObjetcs();
        }

        public void write(ResourceWriter writer) throws IOException {
            writer.writeVersion(0);
            writer.writeInt16(this.generation1.getId());
            writer.writeInt64(this.sizeInBytes);
            writer.writeInt64(this.nrOfClasses1);
            writer.writeInt64(this.nrOfObjects1);
        }

        InstancesClassesAndBytesInGenerations(ResourceReader reader) throws IOException {
            reader.readVersion(0, 0);
            this.generation1 = ClassGeneration.getDataType(reader.readInt16());
            this.sizeInBytes = reader.readInt64();
            this.nrOfClasses1 = reader.readInt64();
            this.nrOfObjects1 = reader.readInt64();
        }

        ClassGeneration getGeneration() {
            return this.generation1;
        }

        long getSizeInBytes() {
            return this.sizeInBytes;
        }

        long getNrOfClasses() {
            return this.nrOfClasses1;
        }

        long getNrOfObjetcs() {
            return this.nrOfObjects1;
        }
    }
}

