/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.cls;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.memory.event.BasicClassStatistic;
import com.sap.jvm.profiling.memory.event.OldGenClassStatistic;
import com.sap.jvm.profiling.memory.event.PermGenClassStatistic;
import com.sap.jvm.profiling.memory.event.YoungGenClassStatistic;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.cls.ClsSnapshot;
import com.sap.jvm.profiling.snapshot.cls.GenerationalStatisticValues;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;

public class ClsSnapshotImpl
extends SnapshotImpl
implements ClsSnapshot {
    private YoungGenClassStatistic currentYoungGenClassStatistic;
    private OldGenClassStatistic currentOldGenClassStatistic;
    private PermGenClassStatistic currentPermGenClassStatistic;
    private boolean statisticsCalculated;
    private long gcNumber;
    GenerationalStaticValues youngStatistics = new GenerationalStaticValues();
    GenerationalStaticValues oldStatistics = new GenerationalStaticValues();
    GenerationalStaticValues permStatistics = new GenerationalStaticValues();
    private final ResourceName resourceName;
    private long sizeOfYoungGen;
    private long sizeOfOldGen;
    private long sizeOfPermGen;

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeInt64(this.sizeOfYoungGen);
        writer.writeInt64(this.sizeOfOldGen);
        writer.writeInt64(this.sizeOfPermGen);
    }

    public static ClsSnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store) throws IOException {
        int id = reader.readInt32();
        String name = reader.readString();
        Bookmark start = reader.getSession().readBookmark(reader);
        Bookmark end = reader.getSession().readBookmark(reader);
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        boolean isVirtual = reader.readBoolean();
        int parentId = reader.readInt32();
        long sizeOfYoungGen = -1L;
        long sizeOfOldGen = -1L;
        long sizeOfPermGen = -1L;
        if (reader.hasNext()) {
            sizeOfYoungGen = reader.readInt64();
            sizeOfOldGen = reader.readInt64();
            sizeOfPermGen = reader.readInt64();
        }
        ClsSnapshotImpl snapshot = new ClsSnapshotImpl(id, name, start, end, startTimestamp, endTimestamp, reader.getSession(), isVirtual, resourceName, null, null, null, null, sizeOfYoungGen, sizeOfOldGen, sizeOfPermGen);
        snapshot.setParentId(parentId);
        snapshot.setSnapshotStore(store);
        return snapshot;
    }

    public ClsSnapshotImpl(int id, String name, Bookmark start, Bookmark end, long startCollectionTimeStamp, long endCollectionTimeStamp, ProfilingSession session, boolean isVirtual, ResourceName resourceName, Snapshot parent, YoungGenClassStatistic currentYoungGenClassStatistic, OldGenClassStatistic currentOldGenClassStatistic, PermGenClassStatistic currentPermGenClassStatistic, long sizeOfYoungGen, long sizeOfOldGen, long sizeOfPermGen) {
        super(SnapshotType.CLASS_STATISTIC_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, parent);
        this.resourceName = resourceName;
        this.currentYoungGenClassStatistic = currentYoungGenClassStatistic;
        this.currentOldGenClassStatistic = currentOldGenClassStatistic;
        this.currentPermGenClassStatistic = currentPermGenClassStatistic;
        this.sizeOfYoungGen = sizeOfYoungGen;
        this.sizeOfOldGen = sizeOfOldGen;
        this.sizeOfPermGen = sizeOfPermGen;
        this.ensureThatPackagesAreRead();
        this.calculateBytes4Generation();
        this.statisticsCalculated = false;
    }

    @Override
    public ResourceName asResourceName() {
        return this.resourceName;
    }

    @Override
    public void computeProperties(ProgressReporter reporter) throws IOException {
    }

    private void calculateBytes4Generation() {
        this.youngStatistics.calculate((BasicClassStatistic)this.currentYoungGenClassStatistic);
        this.oldStatistics.calculate((BasicClassStatistic)this.currentOldGenClassStatistic);
        this.permStatistics.calculate((BasicClassStatistic)this.currentPermGenClassStatistic);
    }

    private void ensureThatPackagesAreRead() {
        if (!this.statisticsCalculated) {
            if (this.currentYoungGenClassStatistic == null || this.currentOldGenClassStatistic == null || this.currentPermGenClassStatistic == null) {
                try {
                    ProgressReporter reporter = new ProgressReporter();
                    ProfilingReader profReader = this.getEventReader(reporter);
                    ProfilingPacket np = profReader.nextPacket();
                    while (np != null) {
                        if (np.getType() == ProfilingPacketType.YOUNG_GEN_CLASS_STATISTIC_EVENT) {
                            this.currentYoungGenClassStatistic = (YoungGenClassStatistic)np;
                            this.youngStatistics.calculate((BasicClassStatistic)this.currentYoungGenClassStatistic);
                        } else if (np.getType() == ProfilingPacketType.OLD_GEN_CLASS_STATISTIC_EVENT) {
                            this.currentOldGenClassStatistic = (OldGenClassStatistic)np;
                            this.oldStatistics.calculate((BasicClassStatistic)this.currentOldGenClassStatistic);
                        } else if (np.getType() == ProfilingPacketType.PERM_GEN_CLASS_STATISTIC_EVENT) {
                            this.currentPermGenClassStatistic = (PermGenClassStatistic)np;
                            this.permStatistics.calculate((BasicClassStatistic)this.currentPermGenClassStatistic);
                        }
                        np = profReader.nextPacket();
                    }
                    reporter.finish();
                }
                catch (OperationCanceledException e) {
                    Trace.warn((Throwable)e, (String)"OperationCanceledException during reading class statistic trace events.");
                }
                catch (IOException e) {
                    Trace.warn((Throwable)e, (String)"IOException during reading class statistic trace events.");
                }
            }
            this.statisticsCalculated = true;
            this.calculateBytes4Generation();
        }
    }

    @Override
    public long getNrOfClasses() {
        assert ((long)this.currentPermGenClassStatistic.getNrOfClasses() == this.permStatistics.getNrOfClasses());
        return this.permStatistics.getNrOfClasses();
    }

    @Override
    public long getNrOfClassObjects() {
        return this.youngStatistics.getTotalNumOfObjects() + this.oldStatistics.getTotalNumOfObjects() + this.permStatistics.getTotalNumOfObjects();
    }

    @Override
    public long getGCNr() {
        return this.gcNumber;
    }

    @Override
    public GenerationalStatisticValues getYoungGenClassStatistic() {
        return this.youngStatistics;
    }

    @Override
    public GenerationalStatisticValues getOldGenClassStatistic() {
        return this.oldStatistics;
    }

    @Override
    public GenerationalStatisticValues getPermGenClassStatistic() {
        return this.permStatistics;
    }

    @Override
    public long getUsedBytesInYoungGen() {
        return this.youngStatistics.getBytesUsedForAllObjects();
    }

    @Override
    public long getUsedBytesInOldGen() {
        return this.oldStatistics.getBytesUsedForAllObjects();
    }

    @Override
    public long getUsedBytesInPermGen() {
        return this.permStatistics.getBytesUsedForAllObjects();
    }

    @Override
    public long getMaxYoungGenSize() {
        return this.sizeOfYoungGen;
    }

    @Override
    public long getMaxOldGenSize() {
        return this.sizeOfOldGen;
    }

    @Override
    public long getMaxPermGenSize() {
        return this.sizeOfPermGen;
    }

    private class GenerationalStaticValues
    implements GenerationalStatisticValues {
        private long bytesUsedForAllObject = 0L;
        private long nrOfClasses = 0L;
        private long totalNumOfObjects = 0L;

        GenerationalStaticValues() {
        }

        private void init() {
            this.bytesUsedForAllObject = 0L;
            this.nrOfClasses = 0L;
            this.totalNumOfObjects = 0L;
        }

        void calculate(BasicClassStatistic basicStat) {
            this.init();
            if (basicStat == null) {
                Trace.warn((String)"Invalid BasicClassStatistic...");
                return;
            }
            if (ClsSnapshotImpl.this.gcNumber <= 0L) {
                ClsSnapshotImpl.this.gcNumber = basicStat.getGCNr();
            } else if (ClsSnapshotImpl.this.gcNumber != basicStat.getGCNr()) {
                Trace.warn(() -> "Got GC number :" + basicStat.getGCNr() + " but expected:" + ClsSnapshotImpl.this.gcNumber);
            }
            this.nrOfClasses = basicStat.getNrOfClasses();
            this.bytesUsedForAllObject = 0L;
            int i = 0;
            while ((long)i < this.nrOfClasses) {
                this.totalNumOfObjects += basicStat.getNrOfObjects(i);
                this.bytesUsedForAllObject += basicStat.getSizeOfObjects(i);
                ++i;
            }
        }

        @Override
        public long getBytesUsedForAllObjects() {
            return this.bytesUsedForAllObject;
        }

        @Override
        public long getNrOfClasses() {
            return this.nrOfClasses;
        }

        @Override
        public long getTotalNumOfObjects() {
            return this.totalNumOfObjects;
        }
    }
}

