/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.cls;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.cls.ClassLoaderValue;
import com.sap.jvm.profiling.snapshot.cls.ClsClassLoaderStatistic;
import com.sap.jvm.profiling.snapshot.cls.ClsValue;
import com.sap.jvm.profiling.snapshot.impl.cls.ClassLoaderValueImpl;
import com.sap.jvm.profiling.snapshot.impl.cls.ClsValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.collector.ValueStatisticCollector;
import com.sap.jvm.profiling.snapshot.impl.util.column.ClassLoaderValueColumn;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.ClassLoaderValuesSerializer;
import com.sap.jvm.profiling.snapshot.util.column.LongColumn;
import java.io.IOException;

public final class ClsValueByClassLoaderStatisticImpl
extends ValueStatisticImpl<Long, ClassLoaderValue>
implements ClsClassLoaderStatistic {
    private long allClasses;
    private long allInstances;
    private long allBytes;
    private long nrFilteredClasses = 0L;
    private long nrFilteredInstances = 0L;
    private long nrFfilteredBytes = 0L;

    protected ClsValueByClassLoaderStatisticImpl(ResourceName name) {
        super(name, new LongColumn(), new ClassLoaderValueColumn(), new ClassLoaderValuesSerializer());
    }

    private void setSnapshotSummaryData(long allClasses, long allInstances, long allBytes, long nrFilteredClasses, long nrFilteredInstances, long nrFfilteredBytes) {
        this.allClasses = allClasses;
        this.allInstances = allInstances;
        this.allBytes = allBytes;
        this.nrFilteredClasses = nrFilteredClasses;
        this.nrFilteredInstances = nrFilteredInstances;
        this.nrFfilteredBytes = nrFfilteredBytes;
    }

    public ClsValueByClassLoaderStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        this.read(reader, I18n._s((String)"Reading the class statistic dump statistic ... (<%> %)"), reporter);
        if (reader.hasNext()) {
            this.allClasses = reader.readInt64();
            this.allInstances = reader.readInt64();
            this.allBytes = reader.readInt64();
            this.nrFilteredClasses = reader.readInt64();
            this.nrFilteredInstances = reader.readInt64();
            this.nrFfilteredBytes = reader.readInt64();
        }
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the class statistic ... (<%> %)"), reporter);
        writer.writeInt64(this.allClasses);
        writer.writeInt64(this.allInstances);
        writer.writeInt64(this.allBytes);
        writer.writeInt64(this.nrFilteredClasses);
        writer.writeInt64(this.nrFilteredInstances);
        writer.writeInt64(this.nrFfilteredBytes);
    }

    public static ClsValueByClassLoaderStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        ClsValueIterator it = new ClsValueIterator(name, reporter, I18n._s((String)"Creating the class statistic ... (<%> %)"));
        ValueStatisticCollector<Long, ClassLoaderValue> collector = new ValueStatisticCollector<Long, ClassLoaderValue>(ClassLoaderValueImpl.create(null));
        while (it.next()) {
            ClsValue val = it.getValue();
            ClassLoaderValueImpl temp = new ClassLoaderValueImpl(val);
            collector.add(val.getDelegate().getClassLoader().getId(), temp);
            collector.add(temp);
        }
        ClsValueByClassLoaderStatisticImpl result = new ClsValueByClassLoaderStatisticImpl(name);
        collector.fillStatistic(result);
        result.setSnapshotSummaryData(it.getNrOfClassesBelongingToSnapshot(), it.getNrOfObjectsBelongingToSnapshot(), it.getNrOfBytesBelongingToSnapshot(), it.getNrOfClassesInView(), it.getNrOfObjectsInView(), it.getNrOfBytesInView());
        return result;
    }

    @Override
    public long getNrOfClassesBelongingToSnapshot() {
        return this.allClasses;
    }

    @Override
    public long getNrOfObjectsBelongingToSnapshot() {
        return this.allInstances;
    }

    @Override
    public long getNrOfBytesBelongingToSnapshot() {
        return this.allBytes;
    }

    @Override
    public long getNrOfClassesInView() {
        return this.nrFilteredClasses;
    }

    @Override
    public long getNrOfObjectsInView() {
        return this.nrFilteredInstances;
    }

    @Override
    public long getNrOfBytesInView() {
        return this.nrFfilteredBytes;
    }
}

