/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.cls;

import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.cls.ClassGeneration;
import com.sap.jvm.profiling.snapshot.cls.ClsValue;
import java.io.IOException;

public class ClsValueImpl
implements ClsValue {
    private ClassObject delegate;
    private ClassGeneration generationClassWasIn;
    private long nrOfClassesLoadedByOwnClassLoader;
    private static final int __VERSION = 0;
    private ObjectsAndBytesInGenerations[] objectAndBytes;

    public static ClsValue create(ClassObject obj, ClassGeneration gen, long numberOfObjetcs, long allocatedBytes) {
        return new ClsValueImpl(obj, gen, numberOfObjetcs, allocatedBytes);
    }

    public ClsValueImpl(ClassObject obj, ClassGeneration gen, long numberOfObjetcs, long allocatedBytes) {
        this.delegate = obj;
        this.generationClassWasIn = gen;
        this.nrOfClassesLoadedByOwnClassLoader = 1L;
        this.objectAndBytes = new ObjectsAndBytesInGenerations[ClassGeneration.values().length];
        if (gen != null) {
            this.objectAndBytes[gen.getId()] = new ObjectsAndBytesInGenerations(gen, numberOfObjetcs, allocatedBytes);
        }
    }

    public ClsValueImpl(ResourceReader reader) throws IOException {
        this(null, ClassGeneration.UNKNOWN, 0L, 0L);
        reader.readVersion(0, 0);
        this.delegate = reader.readClassObject();
        this.generationClassWasIn = ClassGeneration.getDataType(reader.readInt16());
        this.nrOfClassesLoadedByOwnClassLoader = reader.readInt64();
        int countOfGens = reader.readInt32();
        for (int i = 0; i < countOfGens; ++i) {
            ObjectsAndBytesInGenerations temp;
            this.objectAndBytes[temp.getGeneration().getId()] = temp = new ObjectsAndBytesInGenerations(reader);
        }
    }

    public void write(ResourceWriter writer) throws IOException {
        int i;
        writer.writeVersion(0);
        writer.writeClassObject(this.delegate);
        writer.writeInt16(this.generationClassWasIn.getId());
        writer.writeInt64(this.nrOfClassesLoadedByOwnClassLoader);
        int countOfGens = 0;
        for (i = 0; i < ClassGeneration.values().length; ++i) {
            if (this.objectAndBytes[i] == null) continue;
            ++countOfGens;
        }
        writer.writeInt32(countOfGens);
        for (i = 0; i < ClassGeneration.values().length; ++i) {
            if (this.objectAndBytes[i] == null) continue;
            this.objectAndBytes[i].write(writer);
        }
    }

    @Override
    public ClsValue getSum(ClsValue toAdd) {
        if (this.objectAndBytes[toAdd.getGeneration().getId()] == null) {
            this.objectAndBytes[toAdd.getGeneration().getId()] = new ObjectsAndBytesInGenerations(toAdd.getGeneration(), toAdd.getNrOfObjetcs(), toAdd.getSizeOfObjects());
        } else {
            this.objectAndBytes[toAdd.getGeneration().getId()].add(toAdd);
        }
        ++this.nrOfClassesLoadedByOwnClassLoader;
        return this;
    }

    @Override
    public ClassObject getDelegate() {
        return this.delegate;
    }

    @Override
    public long getNrOfObjetcs(ClassGeneration gen) {
        ObjectsAndBytesInGenerations val = this.objectAndBytes[gen.getId()];
        if (val == null) {
            return 0L;
        }
        return val.nrOfObjects;
    }

    @Override
    public long getSizeOfObjects(ClassGeneration gen) {
        ObjectsAndBytesInGenerations val = this.objectAndBytes[gen.getId()];
        if (val == null) {
            return 0L;
        }
        return val.sizeInBytes;
    }

    @Override
    public long getNrOfObjetcs() {
        ClassGeneration[] values = ClassGeneration.values();
        long ret = 0L;
        for (ClassGeneration val : values) {
            ret += this.getNrOfObjetcs(val);
        }
        return ret;
    }

    @Override
    public long getSizeOfObjects() {
        ClassGeneration[] values = ClassGeneration.values();
        long ret = 0L;
        for (ClassGeneration val : values) {
            ret += this.getSizeOfObjects(val);
        }
        return ret;
    }

    @Override
    public ClassGeneration getGeneration() {
        return this.generationClassWasIn;
    }

    public long getNumberOfClassesLoadedByThatClassLoader() {
        return this.nrOfClassesLoadedByOwnClassLoader;
    }

    public class ObjectsAndBytesInGenerations {
        private final ClassGeneration generation;
        private long nrOfObjects;
        private long sizeInBytes;
        private static final int VERSION = 0;

        ObjectsAndBytesInGenerations(ClassGeneration gen, long nrOfObjects, long sizeInBytes) {
            this.generation = gen;
            this.nrOfObjects = nrOfObjects;
            this.sizeInBytes = sizeInBytes;
        }

        public void add(ClsValue toAdd) {
            assert (this.generation == toAdd.getGeneration());
            this.nrOfObjects += toAdd.getNrOfObjetcs();
            this.sizeInBytes += toAdd.getSizeOfObjects();
        }

        public void write(ResourceWriter writer) throws IOException {
            writer.writeVersion(0);
            writer.writeInt16(this.generation.getId());
            writer.writeInt64(this.nrOfObjects);
            writer.writeInt64(this.sizeInBytes);
        }

        ObjectsAndBytesInGenerations(ResourceReader reader) throws IOException {
            reader.readVersion(0, 0);
            this.generation = ClassGeneration.getDataType(reader.readInt16());
            this.nrOfObjects = reader.readInt64();
            this.sizeInBytes = reader.readInt64();
        }

        ClassGeneration getGeneration() {
            return this.generation;
        }

        long getNrOfObjects() {
            return this.nrOfObjects;
        }

        long getSizeInBytes() {
            return this.sizeInBytes;
        }
    }
}

