/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.cls;

import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.core.type.ClassLoaderObject;
import com.sap.jvm.profiling.core.type.ClassObject;
import com.sap.jvm.profiling.memory.event.BasicClassStatistic;
import com.sap.jvm.profiling.memory.event.ClassStatisticDumpEnd;
import com.sap.jvm.profiling.memory.event.ClassStatisticDumpStart;
import com.sap.jvm.profiling.memory.event.ClassStatisticEventHandler;
import com.sap.jvm.profiling.memory.event.OldGenClassStatistic;
import com.sap.jvm.profiling.memory.event.PermGenClassStatistic;
import com.sap.jvm.profiling.memory.event.YoungGenClassStatistic;
import com.sap.jvm.profiling.memory.response.ClassStatisticDumpResponse;
import com.sap.jvm.profiling.memory.response.DisableOldGenClassStatisticResponse;
import com.sap.jvm.profiling.memory.response.DisablePermGenClassStatisticResponse;
import com.sap.jvm.profiling.memory.response.DisableYoungGenClassStatisticResponse;
import com.sap.jvm.profiling.memory.response.DumpClassStatisticEndResponse;
import com.sap.jvm.profiling.memory.response.DumpClassStatisticStartResponse;
import com.sap.jvm.profiling.memory.response.EnableOldGenClassStatisticResponse;
import com.sap.jvm.profiling.memory.response.EnablePermGenClassStatisticResponse;
import com.sap.jvm.profiling.memory.response.EnableYoungGenClassStatisticResponse;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.alloc.elements.FilterAllocatedObjectByClass;
import com.sap.jvm.profiling.snapshot.alloc.elements.FilterAllocatedObjectByFilter;
import com.sap.jvm.profiling.snapshot.cls.ClassGeneration;
import com.sap.jvm.profiling.snapshot.cls.ClsValue;
import com.sap.jvm.profiling.snapshot.cls.Elements;
import com.sap.jvm.profiling.snapshot.elements.UseClassesAsCalledRoots;
import com.sap.jvm.profiling.snapshot.elements.UseLoadersAsCalledRoots;
import com.sap.jvm.profiling.snapshot.filter.ClassFilter;
import com.sap.jvm.profiling.snapshot.impl.cls.ClsValueImpl;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;

public final class ClsValueIterator
implements ClassStatisticEventHandler {
    public static final int VALUE_AVAILABLE = 0;
    public static final int READ_PERFORMED = 1;
    public static final int FINISHED = 2;
    private final ProfilingReader reader;
    private BasicClassStatistic currentBasisClassStatisticEvent;
    private ClassGeneration currentClassGeneration;
    private int currentEventPos;
    private final ProgressReporter reporter;
    private List<ClassLoaderObject> classLoadersFilter = new ArrayList<ClassLoaderObject>();
    private List<ClassObject> classObjectsFilter = new ArrayList<ClassObject>();
    private ClassGeneration generationFilter = null;
    private ClassFilter classFilter = null;
    private long nrAllClasses = 0L;
    private long nrAllInstances = 0L;
    private long nrAllBytes = 0L;
    private long nrFilteredClasses = 0L;
    private long nrFilteredInstances = 0L;
    private long nrFfilteredBytes = 0L;

    public ClsValueIterator(Snapshot snapshot, ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        this.reader = snapshot.getEventReader(reporter);
        this.reporter = reporter;
        reporter.setWork(message, this.reader.getNrOfPacketsToRead());
        this.reader.registerClassStatisticEventHandler((ClassStatisticEventHandler)this);
    }

    public static void collectFilters(ResourceName name, List<ClassLoaderObject> classLoaders, List<ClassObject> classObjects) {
        for (ResourceNameElement elem : name.getElements()) {
            int i;
            if (elem instanceof UseLoadersAsCalledRoots) {
                ClassLoaderObject[] clLoaders = ((UseLoadersAsCalledRoots)elem).getLoaders();
                for (i = 0; i < clLoaders.length; ++i) {
                    classLoaders.add(clLoaders[i]);
                }
            }
            if (!(elem instanceof UseClassesAsCalledRoots)) continue;
            ClassObject[] clsObjects = ((UseClassesAsCalledRoots)elem).getClasses();
            for (i = 0; i < clsObjects.length; ++i) {
                classObjects.add(clsObjects[i]);
            }
        }
    }

    public static boolean applyClassLoaderFilter(List<ClassLoaderObject> clLoaders, ClassLoaderObject candiate) {
        if (clLoaders != null && clLoaders.size() != 0) {
            for (ClassLoaderObject classLoader : clLoaders) {
                if (!candiate.equals(classLoader)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public static boolean applyClassFilter(List<ClassObject> classes, ClassObject candiate) {
        if (classes != null && classes.size() != 0) {
            for (ClassObject clazz : classes) {
                if (!candiate.equals(clazz)) continue;
                return true;
            }
            return false;
        }
        return true;
    }

    public ClsValueIterator(ResourceName name, ProgressReporter reporter, String message) throws OperationCanceledException {
        this(SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name), name, reporter, message);
        ClsValueIterator.collectFilters(name, this.classLoadersFilter, this.classObjectsFilter);
        this.classFilter = ClsValueIterator.getAllocatedClassFilter(name);
        ResourceNameElement createElement = name.getLastElement();
        if (createElement instanceof Elements.CreateClassStatisticByClassLoaderInPermGenerationStatistic || createElement instanceof Elements.CreateClassStatisticByPermGenerationStatistic) {
            this.generationFilter = ClassGeneration.PERM;
        } else if (createElement instanceof Elements.CreateClassStatisticByClassLoaderInOldGenerationStatistic || createElement instanceof Elements.CreateClassStatisticByOldGenerationStatistic) {
            this.generationFilter = ClassGeneration.OLD;
        } else if (createElement instanceof Elements.CreateClassStatisticByClassLoaderInYoungGenerationStatistic || createElement instanceof Elements.CreateClassStatisticByYoungGenerationStatistic) {
            this.generationFilter = ClassGeneration.YOUNG;
        } else if (createElement instanceof Elements.CreateClassStatisticByClassLoaderStatistic || createElement instanceof Elements.CreateClassStatisticValueStatistic) {
            this.generationFilter = null;
        } else {
            assert (false);
            this.generationFilter = ClassGeneration.UNKNOWN;
        }
    }

    private static ClassFilter getAllocatedClassFilter(ResourceName name) {
        ClassFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            Object filterElement;
            if (element instanceof FilterAllocatedObjectByFilter) {
                filterElement = (FilterAllocatedObjectByFilter)element;
                ClassFilter toAdd = ClassFilter.createWide("<artificial>", ((FilterAllocatedObjectByFilter)filterElement).getFilters(), false);
                if (filter == null) {
                    filter = toAdd;
                    continue;
                }
                filter = filter.narrow("<artificial>", toAdd, true);
                continue;
            }
            if (!(element instanceof FilterAllocatedObjectByClass)) continue;
            filterElement = (FilterAllocatedObjectByClass)element;
            filter = filter == null ? ((FilterAllocatedObjectByClass)filterElement).getFilter() : filter.narrow("<artificial>", ((FilterAllocatedObjectByClass)filterElement).getFilter(), true);
        }
        return filter;
    }

    public ClsValue getValue() {
        return new ClsValueImpl(this.currentBasisClassStatisticEvent.getClassObject(this.currentEventPos), this.currentClassGeneration, this.currentBasisClassStatisticEvent.getNrOfObjects(this.currentEventPos), this.currentBasisClassStatisticEvent.getSizeOfObjects(this.currentEventPos));
    }

    public boolean next() throws IOException, OperationCanceledException {
        int result = -1;
        if (this.currentBasisClassStatisticEvent == null) {
            while ((result = this.nextOrReadRaw()) != 2) {
                if (result != 0) continue;
                this.nrAllClasses += (long)this.currentBasisClassStatisticEvent.getNrOfClasses();
                break;
            }
        }
        if (this.currentBasisClassStatisticEvent != null) {
            while (this.currentEventPos < this.currentBasisClassStatisticEvent.getNrOfClasses() - 1) {
                ++this.currentEventPos;
                this.nrAllInstances += this.currentBasisClassStatisticEvent.getNrOfObjects(this.currentEventPos);
                this.nrAllBytes += this.currentBasisClassStatisticEvent.getSizeOfObjects(this.currentEventPos);
                if (!ClsValueIterator.applyClassLoaderFilter(this.classLoadersFilter, this.currentBasisClassStatisticEvent.getClassObject(this.currentEventPos).getClassLoader()) || !ClsValueIterator.applyClassFilter(this.classObjectsFilter, this.currentBasisClassStatisticEvent.getClassObject(this.currentEventPos)) || this.generationFilter != null && this.generationFilter != this.currentClassGeneration || this.classFilter != null && (this.classFilter == null || !this.classFilter.matches(this.currentBasisClassStatisticEvent.getClassObject(this.currentEventPos)))) continue;
                ++this.nrFilteredClasses;
                this.nrFilteredInstances += this.currentBasisClassStatisticEvent.getNrOfObjects(this.currentEventPos);
                this.nrFfilteredBytes += this.currentBasisClassStatisticEvent.getSizeOfObjects(this.currentEventPos);
                return true;
            }
            this.currentEventPos = -1;
            this.currentBasisClassStatisticEvent = null;
            if (result == 2) {
                return false;
            }
            return this.next();
        }
        return false;
    }

    private int nextOrReadRaw() throws IOException {
        this.currentBasisClassStatisticEvent = null;
        this.currentClassGeneration = ClassGeneration.UNKNOWN;
        this.currentEventPos = -1;
        try {
            if (this.reader.nextPacket() != null) {
                if (!this.reporter.report(this.reader.getNrOfReadPackets())) {
                    throw new OperationCanceledException();
                }
                if (this.currentBasisClassStatisticEvent == null || this.currentBasisClassStatisticEvent.getNrOfClasses() == 0) {
                    this.currentBasisClassStatisticEvent = null;
                    return 1;
                }
                return 0;
            }
        }
        catch (IOException ex) {
            this.reader.close();
            throw ex;
        }
        this.reader.close();
        return 2;
    }

    public void handle(EnableOldGenClassStatisticResponse response) {
    }

    public void handle(DisableOldGenClassStatisticResponse response) {
    }

    public void handle(EnableYoungGenClassStatisticResponse response) {
    }

    public void handle(DisableYoungGenClassStatisticResponse response) {
    }

    public void handle(EnablePermGenClassStatisticResponse response) {
    }

    public void handle(DisablePermGenClassStatisticResponse response) {
    }

    public void handle(OldGenClassStatistic event) {
        this.currentBasisClassStatisticEvent = event;
        this.currentClassGeneration = ClassGeneration.OLD;
    }

    public void handle(PermGenClassStatistic event) {
        this.currentBasisClassStatisticEvent = event;
        this.currentClassGeneration = ClassGeneration.PERM;
    }

    public void handle(YoungGenClassStatistic event) {
        this.currentBasisClassStatisticEvent = event;
        this.currentClassGeneration = ClassGeneration.YOUNG;
    }

    public void handle(ClassStatisticDumpEnd event) {
    }

    public void handle(ClassStatisticDumpStart event) {
    }

    public void handle(DumpClassStatisticEndResponse event) {
    }

    public void handle(DumpClassStatisticStartResponse event) {
    }

    public void handle(ClassStatisticDumpResponse event) {
    }

    public long getNrOfClassesBelongingToSnapshot() {
        return this.nrAllClasses;
    }

    public long getNrOfObjectsBelongingToSnapshot() {
        return this.nrAllInstances;
    }

    public long getNrOfBytesBelongingToSnapshot() {
        return this.nrAllBytes;
    }

    public long getNrOfClassesInView() {
        return this.nrFilteredClasses;
    }

    public long getNrOfObjectsInView() {
        return this.nrFilteredInstances;
    }

    public long getNrOfBytesInView() {
        return this.nrFfilteredBytes;
    }
}

