/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.collections;

import java.util.Iterator;

public class EntryHashSet<T>
implements Iterable<Entry<T>> {
    private final double LOAD_FACTOR = 5.0;
    private final int INITIAL_SIZE = 1024;
    private Entry<T>[] buckets;
    private int nrOfEntries;
    private int resizeLimit;
    private int mask;

    public EntryHashSet() {
        this.clear();
    }

    public int size() {
        return this.nrOfEntries;
    }

    public Entry<T> get(T key) {
        int bucket = key.hashCode() & this.mask;
        Entry entry = this.buckets[bucket];
        while (entry != null && !entry.getKey().equals(key)) {
            entry = entry.next;
        }
        return entry;
    }

    @Override
    public Iterator<Entry<T>> iterator() {
        return new BucketIterator<T>(this.buckets);
    }

    public Entry<T>[] toArray() {
        Entry[] result = new Entry[this.nrOfEntries];
        int index = 0;
        for (int i = 0; i < this.buckets.length; ++i) {
            Entry entry = this.buckets[i];
            while (entry != null) {
                result[index] = entry;
                ++index;
                entry = entry.next;
            }
        }
        assert (index == this.nrOfEntries);
        this.clear();
        return result;
    }

    public void add(Entry<T> entry) {
        assert (this.get(entry.getKey()) == null);
        assert (((Entry)entry).next == null);
        int bucket = entry.getKey().hashCode() & this.mask;
        ((Entry)entry).next = (Entry)this.buckets[bucket];
        this.buckets[bucket] = entry;
        ++this.nrOfEntries;
        if (this.nrOfEntries >= this.resizeLimit) {
            Entry[] newBuckets = new Entry[this.buckets.length * 2];
            this.mask = newBuckets.length - 1;
            this.resizeLimit *= 2;
            for (int i = 0; i < this.buckets.length; ++i) {
                Entry curr = this.buckets[i];
                while (curr != null) {
                    Entry next = curr.next;
                    bucket = curr.getKey().hashCode() & this.mask;
                    curr.next = newBuckets[bucket];
                    newBuckets[bucket] = curr;
                    curr = next;
                }
            }
            this.buckets = newBuckets;
        }
    }

    public void clear() {
        this.buckets = new Entry[1024];
        this.mask = 1023;
        this.resizeLimit = 5120;
        this.nrOfEntries = 0;
    }

    private static class BucketIterator<T>
    implements Iterator<Entry<T>> {
        private Entry<T>[] buckets;
        private int index;

        public BucketIterator(Entry<T>[] buckets) {
            this.buckets = buckets;
            this.advance();
        }

        private void advance() {
            do {
                ++this.index;
            } while (this.hasNext() && this.buckets[this.index] == null);
        }

        @Override
        public boolean hasNext() {
            return this.index < this.buckets.length;
        }

        @Override
        public Entry<T> next() {
            Entry<T> result = this.buckets[this.index];
            this.advance();
            return result;
        }

        @Override
        public void remove() {
            throw new UnsupportedOperationException();
        }
    }

    public static abstract class Entry<T> {
        private Entry<T> next;

        public abstract T getKey();
    }
}

