/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.framecombiner;

import com.sap.jvm.profiling.core.type.StackFrames;
import com.sap.jvm.profiling.snapshot.framecombiner.CombinedEntity;
import com.sap.jvm.profiling.snapshot.framecombiner.CombinedEntityMatcher;
import com.sap.jvm.profiling.snapshot.impl.framecombiner.CombinedFrames;

public final class CalledFrameCombiner<T extends CombinedEntity> {
    private final CombinedEntity[] entities;
    private final CombinedEntityMatcher[] matchers;
    private T other;

    public CalledFrameCombiner(T[] entities) {
        this.entities = new CombinedEntity[entities.length - 1];
        this.matchers = new CombinedEntityMatcher[entities.length - 1];
        int index = 0;
        for (T entity : entities) {
            if (entity.isOther()) {
                assert (this.other == null);
                this.other = entity;
                continue;
            }
            this.entities[index] = entity;
            this.matchers[index] = entity.createMatcher();
            ++index;
        }
    }

    public CombinedFrames<T> getCombinedFrames(StackFrames stack, int bottom, int top) {
        int start = top;
        CombinedEntity result = null;
        CombinedEntityMatcher matcher = null;
        for (int i = 0; i < this.entities.length; ++i) {
            int newStart = this.matchers[i].getBottomMostBottom(stack, false, bottom, start);
            if (newStart < bottom || newStart >= start) continue;
            start = newStart;
            result = this.entities[i];
            matcher = this.matchers[i];
        }
        if (start == top) {
            return new CombinedFrames<T>(this.other, bottom, top);
        }
        return new CombinedFrames<Object>(result, start, matcher.getTopForBottom(stack, start, top));
    }
}

