/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc;

import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventHandler;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.response.DisableGcStatisticResponse;
import com.sap.jvm.profiling.memory.response.EnableGcStatisticResponse;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.elements.GcEventTypeFilterElement;
import com.sap.jvm.profiling.snapshot.elements.GcFilterElement;
import com.sap.jvm.profiling.snapshot.filter.GcEventTypeFilter;
import com.sap.jvm.profiling.snapshot.filter.GcFilter;
import com.sap.jvm.profiling.snapshot.gc.GcEventId;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import com.sap.jvm.profiling.snapshot.impl.resource.BasicValueIterator;
import java.io.IOException;
import java.util.LinkedList;
import java.util.List;

public final class GcEventStatisticValueIterator
implements BasicValueIterator<GcEventStatisticValue>,
GcEventHandler {
    private final ProfilingReader reader;
    private GcStatistic currentStatistic;
    private GcEventBase currentEvent;
    private GcEventId currentEventId;
    private LinkedList<GcEventBase> currentEventsList = new LinkedList();
    private LinkedList<GcEventId> currentEventIdsList = new LinkedList();
    private final ProgressReporter reporter;
    private ResourceName name;
    private GcFilter gcFilter;
    private GcEventTypeFilter gcEventFilter;
    private final List<GcEventStatisticValueElement> valueElements;

    public GcEventStatisticValueIterator(Snapshot snapshot, ResourceName name, List<GcEventStatisticValueElement> valueElements, ProgressReporter reporter, String message) throws OperationCanceledException {
        this.valueElements = valueElements;
        this.gcFilter = GcEventStatisticValueIterator.getGcFilter(name);
        this.gcEventFilter = GcEventStatisticValueIterator.getGcEventFilter(name);
        this.name = name;
        this.reader = snapshot.getEventReader(reporter);
        this.reporter = reporter;
        reporter.setWork(message, this.reader.getNrOfPacketsToRead());
        this.reader.registerGcEventHandler((GcEventHandler)this);
    }

    public GcEventStatisticValueIterator(ResourceName name, List<GcEventStatisticValueElement> valueElements, ProgressReporter reporter, String message) throws OperationCanceledException {
        this(SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name), name, valueElements, reporter, message);
    }

    public GcEventBase getEvent() {
        return this.currentEvent;
    }

    public GcStatistic getStatistic() {
        return this.currentStatistic;
    }

    public long getGcNr() {
        return this.currentStatistic.getGcNr();
    }

    public GcEventId getEventId() {
        return this.currentEventId;
    }

    @Override
    public boolean next() throws IOException, OperationCanceledException {
        int result;
        if (!this.currentEventsList.isEmpty()) {
            this.currentEvent = this.currentEventsList.removeFirst();
            this.currentEventId = this.currentEventIdsList.removeFirst();
            return true;
        }
        assert (this.currentEventIdsList.isEmpty());
        while ((result = this.nextOrRead()) != 2) {
            if (result != 0) continue;
            return true;
        }
        return false;
    }

    @Override
    public int nextOrRead() throws IOException {
        this.currentStatistic = null;
        this.currentEvent = null;
        this.currentEventId = null;
        this.currentEventsList.clear();
        this.currentEventIdsList.clear();
        try {
            if (this.reader.nextPacket() != null) {
                if (!this.reporter.report(this.reader.getNrOfReadPackets())) {
                    throw new OperationCanceledException();
                }
                if (this.currentStatistic == null) {
                    return 1;
                }
                if (!this.appliesGcFilter(this.currentStatistic)) {
                    return 1;
                }
                this.applyGcEventFilter();
                if (this.currentEvent == null) {
                    return 1;
                }
                return 0;
            }
        }
        catch (IOException ex) {
            this.reader.close();
            throw ex;
        }
        this.reader.close();
        return 2;
    }

    public void handle(EnableGcStatisticResponse response) {
    }

    public void handle(DisableGcStatisticResponse response) {
    }

    public void handle(GcStatistic event) {
        this.currentStatistic = event;
    }

    private boolean appliesGcFilter(GcStatistic gcInfo) {
        return this.gcFilter == null || this.gcFilter.applies(gcInfo);
    }

    private void applyGcEventFilter() {
        GcEventBase[] events = this.currentStatistic.getEvents();
        for (int i = 0; i < events.length; ++i) {
            if (this.gcEventFilter != null && !this.gcEventFilter.applies(events[i])) continue;
            this.currentEventsList.add(events[i]);
            this.currentEventIdsList.add(new GcEventId(this.currentStatistic.getGcNr(), i));
        }
        if (!this.currentEventsList.isEmpty()) {
            this.currentEvent = this.currentEventsList.removeFirst();
            this.currentEventId = this.currentEventIdsList.removeFirst();
        }
    }

    @Override
    public GcEventStatisticValue getValue() {
        return new GcEventStatisticValue(this.valueElements, this.currentStatistic, this.currentEventId.getIndex());
    }

    @Override
    public GcEventStatisticValue getEmptyValue() {
        return new GcEventStatisticValue(this.valueElements);
    }

    @Override
    public ProfilingReader getEventReader() {
        return this.reader;
    }

    @Override
    public ResourceName getResourceName() {
        return this.name;
    }

    @Override
    public boolean usesEvents() {
        return true;
    }

    @Override
    public ResourceName getDependent() {
        return null;
    }

    @Override
    public ProgressReporter getReporter() {
        return this.reporter;
    }

    public static GcFilter getGcFilter(ResourceName name) {
        GcFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof GcFilterElement)) continue;
            GcFilterElement filterElement = (GcFilterElement)element;
            if (filter == null) {
                filter = filterElement.getFilter();
                continue;
            }
            filter = filter.copy();
            filter.narrow(filterElement.getFilter());
        }
        return filter;
    }

    public static GcEventTypeFilter getGcEventFilter(ResourceName name) {
        GcEventTypeFilter filter = null;
        for (ResourceNameElement element : name.getElements()) {
            if (!(element instanceof GcEventTypeFilterElement)) continue;
            GcEventTypeFilterElement filterElement = (GcEventTypeFilterElement)element;
            if (filter == null) {
                filter = filterElement.getFilter();
                continue;
            }
            filter = filter.copy();
            filter.narrow(filterElement.getFilter());
        }
        return filter;
    }
}

