/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.gc.GcEventId;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcEventStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcEventValueStatistic;
import com.sap.jvm.profiling.snapshot.gc.GcEventValueStatisticUtil;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValueElement;
import com.sap.jvm.profiling.snapshot.impl.gc.GcEventStatisticValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.GcEventIdColumn;
import com.sap.jvm.profiling.snapshot.impl.util.column.GcEventStatisticValuesColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.GcEventStatisticValuesSerializer;
import com.sap.jvm.profiling.util.splitarray.SplitArrayObject;
import java.io.IOException;
import java.util.List;

public final class GcEventValueStatisticImpl
extends ValueStatisticImpl<GcEventId, GcEventStatisticValue>
implements GcEventValueStatistic {
    protected GcEventValueStatisticImpl(ResourceName name, List<GcEventStatisticValueElement> valueElements) {
        super(name, new GcEventIdColumn(), new GcEventStatisticValuesColumnImpl(valueElements), new GcEventStatisticValuesSerializer(valueElements));
    }

    public GcEventValueStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name, GcEventValueStatisticUtil.getValueElements(name));
        this.read(reader, I18n._s((String)"Reading the GC event statistic ... (<%> %)"), reporter);
    }

    public static GcEventValueStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        List<GcEventStatisticValueElement> valueElements = GcEventValueStatisticUtil.getValueElements(name);
        GcEventStatisticValueIterator it = new GcEventStatisticValueIterator(name, valueElements, reporter, I18n._s((String)"Creating the GC event statistic ... (<%> %)"));
        SplitArrayObject keys = new SplitArrayObject(0);
        SplitArrayObject values = new SplitArrayObject(0);
        GcEventStatisticValue total = new GcEventStatisticValue(valueElements);
        int concurrencyGroup = 0;
        GcStatistic lastGcStatistic = null;
        boolean inConcurrent = false;
        while (it.next()) {
            keys.add((Object)it.getEventId());
            GcEventStatisticValue value = it.getValue();
            values.add((Object)value);
            total = total.getSum(value);
            GcStatistic currentGcStatistic = it.getStatistic();
            if (currentGcStatistic != lastGcStatistic) {
                GcStatisticValue statValue = value.getGcStatisticData();
                boolean bl = inConcurrent = statValue.getElementValue(GcStatisticValueElement.GC_TYPE) == 3L;
                if (inConcurrent) {
                    GcStatisticValue currentValue;
                    ++concurrencyGroup;
                    long startTime = it.getEvent().getTimestamp();
                    for (int i = values.size() - 1; i > 0 && (currentValue = ((GcEventStatisticValue)values.get(i)).getGcStatisticData()).getElementValue(GcStatisticValueElement.TIME_STAMP) >= startTime; --i) {
                        currentValue.setConcurrencyGroup(concurrencyGroup);
                    }
                }
                lastGcStatistic = currentGcStatistic;
                continue;
            }
            if (!inConcurrent) continue;
            value.getGcStatisticData().setConcurrencyGroup(concurrencyGroup);
        }
        GcEventValueStatisticImpl result = new GcEventValueStatisticImpl(name, valueElements);
        result.initValues(keys.asList(), values.asList(), total);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        this.write(writer, I18n._s((String)"Writing the GC event statistic ... (<%> %)"), reporter);
    }
}

