/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingPacketType;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.memory.GcHistoryFileDump;
import com.sap.jvm.profiling.memory.event.GcHistoryFileDumpEvent;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.GcHistoryFile.GcHistoryFileDumpSnapshot;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import com.sap.jvm.tracing.Trace;
import java.io.File;
import java.io.IOException;

public class GcHistoryFileDumpSnapshotImpl
extends SnapshotImpl
implements GcHistoryFileDumpSnapshot {
    private final ResourceName resourceName;
    private final String gcHistoryDirectoryName;
    private GcHistoryFileDump gcHistoryContent = null;
    private final String idToSessionKeyName;

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeString(this.gcHistoryDirectoryName);
        writer.writeString(this.idToSessionKeyName);
    }

    public static GcHistoryFileDumpSnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store) throws IOException {
        int id = reader.readInt32();
        String name = reader.readString();
        Bookmark start = reader.getSession().readBookmark(reader);
        Bookmark end = reader.getSession().readBookmark(reader);
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        boolean isVirtual = reader.readBoolean();
        int parentId = reader.readInt32();
        String gcHistoryDirectoryName = reader.readString();
        String idToSessionKeyName = reader.readString();
        GcHistoryFileDumpSnapshotImpl snapshot = new GcHistoryFileDumpSnapshotImpl(id, resourceName, name, start, end, startTimestamp, endTimestamp, reader.getSession(), isVirtual, null, gcHistoryDirectoryName, idToSessionKeyName);
        snapshot.setParentId(parentId);
        snapshot.setSnapshotStore(store);
        return snapshot;
    }

    public GcHistoryFileDumpSnapshotImpl(int id, ResourceName resourceName, String name, Bookmark start, Bookmark end, long startCollectionTimeStamp, long endCollectionTimeStamp, ProfilingSession session, boolean isVirtual, Snapshot parent, String directoryToBeUsed, String idToSessionKeyName) {
        super(SnapshotType.GC_HISTORY_FILE_DUMP_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, parent);
        this.resourceName = resourceName;
        this.gcHistoryDirectoryName = directoryToBeUsed;
        this.idToSessionKeyName = idToSessionKeyName;
    }

    public GcHistoryFileDumpSnapshotImpl(int id, ResourceName resourceName, String name, Bookmark startBookmark, Bookmark endBookmark, long startTimeStamp, long endTimeStamp, ProfilingSession session, boolean isVirtual, GcHistoryFileDumpSnapshot parent, String idToSessionKeyName) {
        super(SnapshotType.GC_HISTORY_FILE_DUMP_SNAPSHOT, id, name, startBookmark, endBookmark, startTimeStamp, endTimeStamp, session, isVirtual, parent);
        this.resourceName = resourceName;
        this.idToSessionKeyName = idToSessionKeyName;
        String dirName = "NOT_YET_CALCULATED";
        try {
            File tempDir = this.getSession().getResourceManager().createTemporaryDirectory(name);
            dirName = tempDir.getName();
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, () -> "Unable to calculate direcotry for the gc history dump of sanpshot:" + name);
            e.printStackTrace();
        }
        this.gcHistoryDirectoryName = dirName;
    }

    @Override
    public ResourceName asResourceName() {
        return this.resourceName;
    }

    @Override
    public void computeProperties(ProgressReporter reporter) throws IOException {
    }

    @Override
    public GcHistoryFileDump getDump() {
        if (this.gcHistoryContent == null) {
            try {
                ProgressReporter reporter = new ProgressReporter();
                ProfilingReader profReader = this.getEventReader(reporter);
                ProfilingPacket np = profReader.nextPacket();
                while (np != null) {
                    if (np.getType() == ProfilingPacketType.GC_HISTORY_FILE_DUMP_EVENT) {
                        this.gcHistoryContent = ((GcHistoryFileDumpEvent)np).getDumpFile();
                    }
                    np = profReader.nextPacket();
                }
                reporter.finish();
            }
            catch (OperationCanceledException e) {
                Trace.warn((Throwable)e, (String)"OperationCanceledException during reading GC file history trace events.");
            }
            catch (IOException e) {
                Trace.warn((Throwable)e, (String)"IOException during reading GC file history trace events.");
            }
        }
        return this.gcHistoryContent;
    }

    @Override
    public File getFileToBeUsedForTheContent() throws IOException {
        File tempDir = this.getSession().getResourceManager().createTemporaryDirectory("dummy");
        return new File(tempDir.getParent() + File.separator + this.gcHistoryDirectoryName + File.separator + this.getName() + ".prf");
    }

    @Override
    public String getIdToSessionKeyName() throws IOException {
        return this.idToSessionKeyName;
    }
}

