/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportCollection;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.profiling.snapshot.impl.gc.GcStatisticValueIterator;
import java.io.IOException;
import java.util.List;

public abstract class GcReportCollectionBase
extends AbstractResource
implements GcReportCollection {
    protected GcReportNode rootNode;
    protected final GcSnapshot snapshot;
    protected ProfilingSession session;

    public GcReportCollectionBase(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        this.snapshot = (GcSnapshot)SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        this.session = name.getSession();
        this.rootNode = this.createReportRoot(name, reporter);
    }

    public GcReportCollectionBase(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name, reporter);
    }

    public boolean isModifiable() {
        return false;
    }

    public ResourceName[] getDependents() {
        return null;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
    }

    @Override
    public long calculateWriteWork() {
        return 0L;
    }

    @Override
    public GcReportNode getReportRoot() {
        return this.rootNode;
    }

    protected GcReportNode createReportRoot(ResourceName name, ProgressReporter reporter) throws IOException {
        GcStatisticValueIterator iterator = new GcStatisticValueIterator(name, reporter, I18n._s((String)"Creating the report ... (<%> %)"));
        return this.createReportRoot(iterator);
    }

    protected abstract GcReportNode createReportRoot(GcStatisticValueIterator var1) throws IOException;

    protected void addHint(List<GcReportNode> nodes, GcReportBuilder builder) {
        nodes.add(new GcReportNode.MultiChildNode(new GcReportNode.Paragraph(new GcReportNode.FormattedText(builder.getReportTitle(), true, false, 2)), builder.getReport(), new GcReportNode.Paragraph(new GcReportNode[0])));
    }
}

