/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import com.sap.jvm.profiling.snapshot.impl.gc.GcReportCollectionBase;
import com.sap.jvm.profiling.snapshot.impl.gc.GcStatisticValueIterator;
import com.sap.jvm.profiling.snapshot.impl.gc.report.GcReportApplicationToGcRatioBuilder;
import com.sap.jvm.profiling.snapshot.impl.gc.report.GcReportConcurrentGcs;
import com.sap.jvm.profiling.snapshot.impl.gc.report.GcReportConcurrentModeFailures;
import com.sap.jvm.profiling.snapshot.impl.gc.report.GcReportDurationByEventType;
import com.sap.jvm.profiling.snapshot.impl.gc.report.GcReportExcessiveSwapping;
import com.sap.jvm.profiling.snapshot.impl.gc.report.GcReportGcConfigurationIssues;
import com.sap.jvm.profiling.snapshot.impl.gc.report.GcReportLongRunningGcs;
import com.sap.jvm.profiling.snapshot.impl.gc.report.GcReportMemoryShortage;
import com.sap.jvm.profiling.snapshot.impl.gc.report.GcReportPromotionFailures;
import com.sap.jvm.profiling.snapshot.impl.gc.report.GcReportSystemOverload;
import java.io.IOException;
import java.util.ArrayList;

public class GcReportCollectionImpl
extends GcReportCollectionBase {
    public GcReportCollectionImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(reader, name, reporter);
    }

    public GcReportCollectionImpl(ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reporter);
    }

    public static GcReportCollectionImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        return new GcReportCollectionImpl(name, reporter);
    }

    @Override
    protected GcReportNode createReportRoot(GcStatisticValueIterator iterator) throws IOException {
        ArrayList<GcReportBuilder> builders = new ArrayList<GcReportBuilder>();
        builders.add(new GcReportGcConfigurationIssues(this.session, this.snapshot));
        builders.add(new GcReportApplicationToGcRatioBuilder(this.snapshot));
        builders.add(new GcReportLongRunningGcs(this.snapshot));
        builders.add(new GcReportConcurrentGcs(this.snapshot));
        builders.add(new GcReportMemoryShortage());
        builders.add(new GcReportPromotionFailures());
        builders.add(new GcReportConcurrentModeFailures());
        builders.add(new GcReportSystemOverload());
        builders.add(new GcReportExcessiveSwapping());
        builders.add(new GcReportDurationByEventType());
        while (iterator.next()) {
            GcStatistic gcStatistic = iterator.getEvent();
            if (gcStatistic == null) continue;
            for (GcReportBuilder builder : builders) {
                builder.handle(gcStatistic);
            }
        }
        ArrayList<GcReportNode.Section> sections = new ArrayList<GcReportNode.Section>();
        ArrayList<GcReportNode> sectionNodes = new ArrayList<GcReportNode>();
        for (GcReportBuilder builder : builders) {
            if (builder.getSeverity() != GcReportBuilder.Severity.RED) continue;
            this.addHint(sectionNodes, builder);
        }
        if (!sectionNodes.isEmpty()) {
            sections.add(new GcReportNode.Section(new GcReportNode.Icon(GcReportBuilder.Severity.RED), I18n._ts((I18n.TextType)I18n.TextType.XGRP, (String)"Hints with High Relevance"), sectionNodes.toArray(new GcReportNode[sectionNodes.size()])));
        }
        sectionNodes.clear();
        for (GcReportBuilder builder : builders) {
            if (builder.getSeverity() != GcReportBuilder.Severity.YELLOW) continue;
            this.addHint(sectionNodes, builder);
        }
        if (!sectionNodes.isEmpty()) {
            sections.add(new GcReportNode.Section(new GcReportNode.Icon(GcReportBuilder.Severity.YELLOW), I18n._ts((I18n.TextType)I18n.TextType.XGRP, (String)"Hints with Medium Relevance"), sectionNodes.toArray(new GcReportNode[sectionNodes.size()])));
        }
        sectionNodes.clear();
        for (GcReportBuilder builder : builders) {
            if (builder.getSeverity() != GcReportBuilder.Severity.GREEN) continue;
            this.addHint(sectionNodes, builder);
        }
        if (!sectionNodes.isEmpty()) {
            sections.add(new GcReportNode.Section(new GcReportNode.Icon(GcReportBuilder.Severity.GREEN), I18n._ts((I18n.TextType)I18n.TextType.XGRP, (String)"General Information"), sectionNodes.toArray(new GcReportNode[sectionNodes.size()])));
        }
        return new GcReportNode.MultiChildNode(sections.toArray(new GcReportNode[sections.size()]));
    }
}

