/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.command.GcTraceConfiguration;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.resource.OperationCanceledException;
import com.sap.jvm.profiling.resource.PacketResourceWriter;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceNameElement;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotStore;
import com.sap.jvm.profiling.snapshot.SnapshotType;
import com.sap.jvm.profiling.snapshot.gc.Elements;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshotProperties;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticAccessor;
import com.sap.jvm.profiling.snapshot.impl.SnapshotImpl;
import com.sap.jvm.profiling.snapshot.impl.gc.GcStatisticValueIterator;
import com.sap.jvm.tracing.Trace;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;

public class GcSnapshotImpl
extends SnapshotImpl
implements GcSnapshot {
    private static final int VERSION = 2;
    private final ResourceName resourceName;
    private GcSnapshotProperties props;
    private GcTraceConfiguration config;
    private GcStatisticAccessor accessor;

    public static GcSnapshotImpl read(ResourceName resourceName, ResourceReader reader, SnapshotStore<Snapshot> store, ProgressReporter reporter) throws IOException {
        int id = reader.readInt32();
        String name = reader.readString();
        Bookmark start = reader.getSession().readBookmark(reader);
        Bookmark end = reader.getSession().readBookmark(reader);
        long startTimestamp = reader.readInt64();
        long endTimestamp = reader.readInt64();
        boolean isVirtual = reader.readBoolean();
        int parentId = reader.readInt32();
        int version = reader.readVersion(1, 2);
        GcSnapshotProperties properties = new GcSnapshotProperties(reader, version);
        GcTraceConfiguration config = GcSnapshotImpl.readGcTraceConfig(reader);
        GcSnapshotImpl snapshot = new GcSnapshotImpl(id, resourceName, name, reader.getSession(), start, end, config, startTimestamp, endTimestamp, properties, isVirtual, null);
        snapshot.setParentId(parentId);
        snapshot.setSnapshotStore(store);
        if (version < 2) {
            snapshot.props = null;
            snapshot.computeProperties(reporter);
        }
        return snapshot;
    }

    public GcSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark start, Bookmark end, GcTraceConfiguration config, long startCollectionTimeStamp, long endCollectionTimeStamp, GcSnapshotProperties properties, boolean isVirtual, GcSnapshot parent) {
        super(SnapshotType.GC_SNAPSHOT, id, name, start, end, startCollectionTimeStamp, endCollectionTimeStamp, session, isVirtual, parent);
        this.config = config;
        this.resourceName = resourceName;
        this.props = properties;
    }

    public GcSnapshotImpl(int id, ResourceName resourceName, String name, ProfilingSession session, Bookmark startBookmark, Bookmark endBookmark, GcTraceConfiguration traceConfiguration, long startTimeStamp, long endTimeStamp, GcType gcType, boolean isVirtual, GcSnapshot parent, ProgressReporter reporter) {
        this(id, resourceName, name, session, startBookmark, endBookmark, traceConfiguration, startTimeStamp, endTimeStamp, new GcSnapshotProperties(gcType), isVirtual, parent);
        try {
            this.computeProperties(reporter);
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Failed to compute GC snapshot properties");
        }
    }

    @Override
    public ResourceName asResourceName() {
        return this.resourceName;
    }

    @Override
    public void computeProperties(ProgressReporter reporter) throws IOException {
        if (this.props == null) {
            this.props = new GcSnapshotProperties(null);
        }
        if (!this.props.isInitial()) {
            return;
        }
        GcStatisticValueIterator it = new GcStatisticValueIterator(this, this.asResourceName(), reporter, I18n._s((String)"Analyzing the GC events ... (<%> %)"));
        try {
            while (it.next()) {
                GcStatistic event = it.getEvent();
                this.props.update(event);
            }
        }
        catch (IOException ex) {
            Trace.error((Throwable)ex, (String)"Failed to analyze the GC events");
        }
    }

    @Override
    public void write(PacketResourceWriter writer) throws IOException {
        super.write(writer);
        writer.writeVersion(2);
        this.props.write(writer);
        this.writeGcTraceConfig((ResourceWriter)writer);
    }

    @Override
    public GcTraceConfiguration getTraceConfiguration() {
        return this.config;
    }

    private void writeGcTraceConfig(ResourceWriter writer) throws IOException {
    }

    private static GcTraceConfiguration readGcTraceConfig(ResourceReader reader) throws IOException {
        GcTraceConfiguration retValue = new GcTraceConfiguration();
        return retValue;
    }

    @Override
    public GcSnapshotProperties getProperties() {
        return this.props;
    }

    @Override
    public long getDurationTotal() {
        return this.props.getDurationTotal();
    }

    @Override
    public int getNrOfGcsTotal() {
        return this.props.getNrOfGcsTotal();
    }

    @Override
    public long getFirstGcId() {
        return this.props.getFirstGcId();
    }

    @Override
    public long getLastGcId() {
        return this.props.getLastGcId();
    }

    @Override
    public List<Long> getFullGcIds() {
        return this.props.getFullGcIds();
    }

    @Override
    public List<Long> getConcGcIds() {
        return this.props.getConcGcIds();
    }

    @Override
    public GcType getGcType() {
        return this.props.getGcType();
    }

    @Override
    public GcStatistic getGcInfo(long gcId, ProgressReporter reporter) {
        this.checkAccessor(reporter);
        return this.accessor.getGcStatistic(this, gcId);
    }

    @Override
    public GcStatistic[] getGcInfos(long[] gcIds, ProgressReporter reporter) {
        this.checkAccessor(reporter);
        GcStatistic[] result = new GcStatistic[gcIds.length];
        long[] sortedIds = (long[])gcIds.clone();
        Arrays.sort(sortedIds);
        int[] positions = new int[gcIds.length];
        for (int i = 0; i < gcIds.length; ++i) {
            positions[Arrays.binarySearch((long[])sortedIds, (long)gcIds[i])] = i;
        }
        try {
            GcStatisticValueIterator it = new GcStatisticValueIterator(this, this.asResourceName(), reporter, I18n._s((String)"Scanning the GC events ... (<%> %)"));
            int pos = 0;
            long gcToFind = sortedIds[pos];
            block4: while (it.next()) {
                GcStatistic event = it.getEvent();
                if (event == null) continue;
                long foundId = event.getGcNr();
                if (foundId == gcToFind) {
                    result[positions[pos]] = event;
                    if (++pos != sortedIds.length) {
                        gcToFind = sortedIds[pos];
                        continue;
                    }
                    break;
                }
                while (foundId > gcToFind && pos < sortedIds.length) {
                    result[positions[pos]] = null;
                    if (++pos == sortedIds.length) continue block4;
                    gcToFind = sortedIds[pos];
                }
            }
        }
        catch (OperationCanceledException pos) {
        }
        catch (IOException e) {
            Trace.error((Throwable)e, (String)"Failed to analyze the GC events");
        }
        return result;
    }

    @Override
    public GcStatistic[] getGcInfos(long startTimeStamp, long endTimeStamp, ProgressReporter reporter) {
        this.checkAccessor(reporter);
        ArrayList<GcStatistic> result = new ArrayList<GcStatistic>();
        try {
            GcStatistic event;
            GcStatisticValueIterator it = new GcStatisticValueIterator(this, this.asResourceName(), reporter, I18n._s((String)"Scanning the GC events ... (<%> %)"));
            while (it.next() && (event = it.getEvent()).getTimestamp() <= endTimeStamp) {
                if (event.getTimestamp() < startTimeStamp) continue;
                result.add(event);
            }
        }
        catch (OperationCanceledException event) {
        }
        catch (IOException e) {
            Trace.error((Throwable)e, (String)"Failed to analyze the GC events");
        }
        return result.toArray(new GcStatistic[result.size()]);
    }

    @Override
    public GcStatisticAccessor getGcAccessor() {
        ProgressReporter reporter = new ProgressReporter();
        this.checkAccessor(reporter);
        reporter.finish();
        return this.accessor;
    }

    private void checkAccessor(ProgressReporter reporter) {
        if (this.accessor == null) {
            try {
                this.accessor = GcSnapshotImpl.getStatisticAccessor(this.resourceName, reporter);
            }
            catch (IOException e) {
                Trace.error((Throwable)e, (String)"Could not get the GC statistic accessor");
            }
        }
    }

    private static GcStatisticAccessor getStatisticAccessor(ResourceName name, ProgressReporter reporter) throws IOException {
        ResourceName accessorName = name.addElement((ResourceNameElement)new Elements.CreateGcStatisticAccessor());
        return (GcStatisticAccessor)name.getResourceManager().get(accessorName, reporter);
    }
}

