/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.Bookmark;
import com.sap.jvm.profiling.core.ProfilingPacket;
import com.sap.jvm.profiling.core.ProfilingReader;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.resource.AbstractResource;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.Snapshot;
import com.sap.jvm.profiling.snapshot.SnapshotResourceManagerFactory;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticAccessor;
import com.sap.jvm.profiling.util.splitarray.SplitArray64;
import com.sap.jvm.tracing.Trace;
import com.sap.jvm.util.pair.LongPair;
import java.io.IOException;
import java.util.ArrayList;

public class GcStatisticAccessorImpl
extends AbstractResource
implements GcStatisticAccessor {
    private static final int BOOKMARK_READ_BYTES_DISTANCE = 262144;
    private static final int VERSION = 0;
    private final ArrayList<Bookmark> bookmarks;
    private final SplitArray64 bookmarkTimes;
    private final SplitArray64 bookmarkIndices;

    private GcStatisticAccessorImpl(ResourceName name) {
        super(name);
        this.bookmarks = new ArrayList();
        this.bookmarkIndices = new SplitArray64();
        this.bookmarkTimes = new SplitArray64();
    }

    public GcStatisticAccessorImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name);
        reader.readVersion(0);
        int nrOfBookmarks = reader.readInt32();
        this.bookmarks = new ArrayList(nrOfBookmarks);
        this.bookmarkIndices = new SplitArray64((long)nrOfBookmarks);
        this.bookmarkTimes = new SplitArray64((long)nrOfBookmarks);
        ProfilingSession session = name.getSession();
        for (int i = 0; i < nrOfBookmarks; ++i) {
            this.bookmarks.add(session.readBookmark(reader));
            this.bookmarkTimes.set((long)i, reader.readInt64());
            this.bookmarkIndices.set((long)i, reader.readInt64());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static GcStatisticAccessorImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        ResourceName snapshotName = name.stripLastElement();
        GcSnapshot snapshot = (GcSnapshot)SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(snapshotName);
        GcStatisticAccessorImpl result = new GcStatisticAccessorImpl(name);
        try (ProfilingReader reader = snapshot.getEventReader(reporter);){
            ProfilingPacket packet;
            reporter.setWork(I18n._s((String)"Creating the gc statistic accessor ... (<%> %)"), reader.getNrOfPacketsToRead());
            long lastReadForBookmark = 0L;
            long lastReadForStatistic = 0L;
            Bookmark lastGcBookmark = null;
            GcStatistic lastStatistic = null;
            while ((packet = reader.nextPacket()) != null) {
                reporter.reportNextOrThrow();
                if (!(packet instanceof GcStatistic)) continue;
                GcStatistic statistic = (GcStatistic)packet;
                boolean getBoomark = result.bookmarks.isEmpty();
                if (!getBoomark) {
                    long bytesSinceLastBookmark = reader.getNrOfReadBytes() - lastReadForBookmark;
                    long bytesSinceLastGc = reader.getNrOfReadBytes() - lastReadForStatistic;
                    if (bytesSinceLastGc > 262144L && bytesSinceLastBookmark != bytesSinceLastGc) {
                        result.bookmarks.add(lastGcBookmark);
                        result.bookmarkTimes.resize(result.bookmarkTimes.size() + 1L);
                        result.bookmarkTimes.set(result.bookmarkTimes.size() - 1L, lastStatistic.getTimestamp());
                        result.bookmarkIndices.add(lastStatistic.getGcNr());
                        lastReadForBookmark = lastReadForStatistic;
                        bytesSinceLastBookmark = reader.getNrOfReadBytes() - lastReadForBookmark;
                    }
                    if (bytesSinceLastBookmark > 262144L) {
                        getBoomark = true;
                    }
                }
                lastGcBookmark = reader.createBookmark();
                lastReadForStatistic = reader.getNrOfReadBytes();
                lastStatistic = statistic;
                if (!getBoomark) continue;
                result.bookmarks.add(lastGcBookmark);
                result.bookmarkTimes.resize(result.bookmarkTimes.size() + 1L);
                result.bookmarkTimes.set(result.bookmarkTimes.size() - 1L, statistic.getTimestamp());
                result.bookmarkIndices.add(statistic.getGcNr());
                lastReadForBookmark = reader.getNrOfReadBytes();
            }
        }
        return result;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public GcStatistic getGcStatistic(Snapshot snapshot, long gcId) {
        ProgressReporter reporter = new ProgressReporter();
        int nrOfBookmarks = (int)this.bookmarkIndices.size();
        if (nrOfBookmarks > 0) {
            int bookmarkIndex = nrOfBookmarks - 1;
            for (int i = 1; i < nrOfBookmarks; ++i) {
                if (gcId >= this.bookmarkIndices.get(i)) continue;
                bookmarkIndex = i - 1;
                break;
            }
            Bookmark bookmark = this.bookmarks.get(bookmarkIndex);
            ProfilingReader snapshotReader = null;
            try {
                ProfilingPacket packet;
                snapshotReader = snapshot.getEventReader(reporter, bookmark);
                while ((packet = snapshotReader.nextPacket()) != null) {
                    if (!(packet instanceof GcStatistic)) continue;
                    GcStatistic statistic = (GcStatistic)packet;
                    if (statistic.getGcNr() == gcId) {
                        GcStatistic gcStatistic = statistic;
                        return gcStatistic;
                    }
                    if (statistic.getGcNr() <= gcId) continue;
                    GcStatistic gcStatistic = null;
                    return gcStatistic;
                }
            }
            catch (IOException e) {
                Trace.warn((Throwable)e, (String)"Error reading packets");
            }
            finally {
                if (snapshotReader != null) {
                    snapshotReader.close();
                }
                reporter.finish();
            }
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public LongPair getGcRangeIds(long fromTime, long toTime) {
        int i;
        int nrOfBookmarks = this.bookmarks.size();
        LongPair result = new LongPair(-1L, -1L);
        if (nrOfBookmarks == 0) {
            return result;
        }
        int startIndex = nrOfBookmarks - 1;
        int endIndex = nrOfBookmarks - 1;
        for (i = 0; i < nrOfBookmarks; ++i) {
            if (this.bookmarkTimes.get(i) <= fromTime) continue;
            startIndex = Math.max(0, i - 1);
            break;
        }
        if (this.bookmarkTimes.get(nrOfBookmarks - 1) < toTime) {
            endIndex = nrOfBookmarks - 1;
        } else {
            for (i = 0; i < nrOfBookmarks; ++i) {
                if (this.bookmarkTimes.get(i) <= toTime) continue;
                endIndex = Math.max(0, i - 1);
                break;
            }
        }
        Bookmark startBookmark = this.bookmarks.get(startIndex);
        Bookmark endBookmark = this.bookmarks.get(endIndex);
        long start = this.bookmarkIndices.get(startIndex);
        long end = this.bookmarkIndices.get(endIndex);
        ResourceName name = this.getResourceName();
        Snapshot snapshot = SnapshotResourceManagerFactory.get(name.getSession()).getSnapshot(name);
        ProgressReporter reporter = new ProgressReporter();
        ProfilingReader snapshotReader = null;
        try {
            GcStatistic event;
            ProfilingPacket packet;
            if (this.bookmarkTimes.get(startIndex) < fromTime && (startIndex + 1 >= nrOfBookmarks || this.bookmarkIndices.get(startIndex) + 1L != this.bookmarkIndices.get(startIndex + 1) || this.bookmarkTimes.get(startIndex + 1) <= fromTime)) {
                snapshotReader = snapshot.getEventReader(reporter, startBookmark);
                while ((packet = snapshotReader.nextPacket()) != null) {
                    if (!(packet instanceof GcStatistic)) continue;
                    event = (GcStatistic)packet;
                    if (event.getTimestamp() >= fromTime) break;
                    ++start;
                }
                snapshotReader.close();
                snapshotReader = null;
            }
            if (this.bookmarkTimes.get(endIndex) < toTime) {
                if (endIndex + 1 < nrOfBookmarks && this.bookmarkIndices.get(endIndex) + 1L == this.bookmarkIndices.get(endIndex + 1) && this.bookmarkTimes.get(endIndex + 1) > toTime) {
                    ++end;
                } else {
                    snapshotReader = snapshot.getEventReader(reporter, endBookmark);
                    while ((packet = snapshotReader.nextPacket()) != null) {
                        if (!(packet instanceof GcStatistic)) continue;
                        event = (GcStatistic)packet;
                        if (event.getTimestamp() > toTime) break;
                        ++end;
                    }
                }
            }
            end = Math.max(start, end);
            result = new LongPair(start, end);
        }
        catch (IOException e) {
            Trace.warn((Throwable)e, (String)"Error reading gc statistic");
        }
        finally {
            if (snapshotReader != null) {
                snapshotReader.close();
            }
            reporter.finish();
        }
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(0);
        writer.writeInt32(this.bookmarks.size());
        for (int i = 0; i < this.bookmarks.size(); ++i) {
            this.bookmarks.get(i).write(writer);
            writer.writeInt64(this.bookmarkTimes.get(i));
            writer.writeInt64(this.bookmarkIndices.get(i));
        }
    }

    @Override
    public long calculateWriteWork() {
        return this.bookmarks.size();
    }

    public boolean isModifiable() {
        return false;
    }

    public ResourceName[] getDependents() {
        return new ResourceName[0];
    }
}

