/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc;

import com.sap.jvm.profiling.snapshot.gc.GcTimeSeriesAnnotation;
import com.sap.jvm.profiling.snapshot.impl.util.series.DataConverter;
import com.sap.jvm.util.persistence.VersionMismatchException;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class GcTimeSeriesAnnotaionConverter
implements DataConverter {
    private static final byte VERSION = 1;

    @Override
    public Object convert(byte[] data) {
        if (data.length == 0) {
            return null;
        }
        ByteArrayInputStream bis = new ByteArrayInputStream(data);
        DataInputStream dis = new DataInputStream(bis);
        try {
            byte version = dis.readByte();
            if (version < 1 || version > 1) {
                throw new VersionMismatchException((int)version, 1, 1);
            }
            String text = dis.readUTF();
            int iconKey = dis.readInt();
            return new GcTimeSeriesAnnotation(text, iconKey);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public byte[] convert(Object obj) {
        if (obj == null) {
            return new byte[0];
        }
        GcTimeSeriesAnnotation annotation = (GcTimeSeriesAnnotation)obj;
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        DataOutputStream dos = new DataOutputStream(bos);
        try {
            dos.writeByte(1);
            dos.writeUTF(annotation.getText());
            dos.writeInt(annotation.getIconKey());
            dos.close();
            return bos.toByteArray();
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }
}

