/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcCause;
import com.sap.jvm.profiling.memory.event.GcDurationEventBase;
import com.sap.jvm.profiling.memory.event.GcEventAllGenRefHandling;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventClassunloadingPhase1;
import com.sap.jvm.profiling.memory.event.GcEventClassunloadingPhase2;
import com.sap.jvm.profiling.memory.event.GcEventCmsAbortablePrecleaning;
import com.sap.jvm.profiling.memory.event.GcEventCmsAborted;
import com.sap.jvm.profiling.memory.event.GcEventCmsFinalMarking;
import com.sap.jvm.profiling.memory.event.GcEventCmsInitialMarking;
import com.sap.jvm.profiling.memory.event.GcEventCmsMarking;
import com.sap.jvm.profiling.memory.event.GcEventCmsPrecleaning;
import com.sap.jvm.profiling.memory.event.GcEventCmsSweeping;
import com.sap.jvm.profiling.memory.event.GcEventG1BitmapClearing;
import com.sap.jvm.profiling.memory.event.GcEventG1Cleanup;
import com.sap.jvm.profiling.memory.event.GcEventG1ConcurrentCleanup;
import com.sap.jvm.profiling.memory.event.GcEventG1Counting;
import com.sap.jvm.profiling.memory.event.GcEventG1EmptyRegionsReclaim;
import com.sap.jvm.profiling.memory.event.GcEventG1FinalMarking;
import com.sap.jvm.profiling.memory.event.GcEventG1IncrementalGc;
import com.sap.jvm.profiling.memory.event.GcEventG1InitialMarking;
import com.sap.jvm.profiling.memory.event.GcEventG1MarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcEventG1Marking;
import com.sap.jvm.profiling.memory.event.GcEventG1MarkingAborted;
import com.sap.jvm.profiling.memory.event.GcEventG1ParallelFullGc;
import com.sap.jvm.profiling.memory.event.GcEventG1RootScanning;
import com.sap.jvm.profiling.memory.event.GcEventGenerational;
import com.sap.jvm.profiling.memory.event.GcEventOldGenRefHandling;
import com.sap.jvm.profiling.memory.event.GcEventParallelGcMarkSweep;
import com.sap.jvm.profiling.memory.event.GcEventParallelGcParallelCompact;
import com.sap.jvm.profiling.memory.event.GcEventParallelGcScavenge;
import com.sap.jvm.profiling.memory.event.GcEventParallelNewGc;
import com.sap.jvm.profiling.memory.event.GcEventParallelSmallGcForcedFullGc;
import com.sap.jvm.profiling.memory.event.GcEventPartialRefHandling;
import com.sap.jvm.profiling.memory.event.GcEventSerialNewGc;
import com.sap.jvm.profiling.memory.event.GcEventSkippedGc;
import com.sap.jvm.profiling.memory.event.GcEventTenuredGc;
import com.sap.jvm.profiling.memory.event.GcEventYoungGenPromotionFailure;
import com.sap.jvm.profiling.memory.event.GcEventYoungGenRefHandling;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcStatisticBase;
import com.sap.jvm.profiling.memory.event.GcStatisticConcMarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcStatisticG1Gc;
import com.sap.jvm.profiling.memory.event.GcStatisticParallelGc;
import com.sap.jvm.profiling.memory.event.GcStatisticParallelNewGc;
import com.sap.jvm.profiling.memory.event.GcStatisticParallelOldGc;
import com.sap.jvm.profiling.memory.event.GcStatisticSerialGc;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcTimeSeriesAnnotation;
import com.sap.jvm.profiling.snapshot.gc.GcTimeSeriesCollection;
import com.sap.jvm.profiling.snapshot.impl.gc.GcStatisticValueIterator;
import com.sap.jvm.profiling.snapshot.impl.gc.GcTimeSeriesAnnotaionConverter;
import com.sap.jvm.profiling.snapshot.impl.util.series.AbstractTimeSeriesCollection;
import com.sap.jvm.profiling.snapshot.impl.util.series.DataConverter;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;

public class GcTimeSeriesCollectionImpl
extends AbstractTimeSeriesCollection
implements GcTimeSeriesCollection {
    private GcStatisticValueIterator iterator = null;
    private long profilingStartupTimeStamp;

    public GcTimeSeriesCollectionImpl(ResourceName name) throws IOException {
        super(name);
        this.profilingStartupTimeStamp = name.getSession().getSystemInfo().getTimeMillis();
    }

    public GcTimeSeriesCollectionImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        super(name, reader, reporter, I18n._s((String)"Reading the time series ... (<%> %)"));
    }

    public static GcTimeSeriesCollectionImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        GcTimeSeriesCollectionImpl result = new GcTimeSeriesCollectionImpl(name);
        result.iterator = new GcStatisticValueIterator(name, reporter, I18n._s((String)"Creating the time series ... (<%> %)"));
        result.createTimeSeries(result.iterator);
        return result;
    }

    private void createTimeSeries(GcStatisticValueIterator it) throws IOException {
        while (it.next()) {
            GcEventBase[] events;
            long survivingYoung;
            long timeSinceLastConc;
            GcStatistic gcStatistic = it.getEvent();
            long timeStampMicros = (gcStatistic.getTimestamp() - this.profilingStartupTimeStamp) * 1000L;
            boolean skipped = gcStatistic.getNrOfEvents() == 1 && gcStatistic.getEvents()[0] instanceof GcEventSkippedGc;
            boolean isConcurrent = gcStatistic.getGcType() == GcType.CONC_MARK_SWEEP_GC && ((GcStatisticConcMarkSweepGc)gcStatistic).isConcurrent() || gcStatistic.getGcType() == GcType.GARBAGE_FIRST_GC && ((GcStatisticG1Gc)gcStatistic).isConcurrent();
            this.builders[0].add(timeStampMicros, gcStatistic.getCpuTime() * 1000L);
            this.builders[1].add(timeStampMicros, gcStatistic.getDuration() * 1000L);
            this.builders[2].add(timeStampMicros, gcStatistic.getPageFaults());
            this.builders[3].add(timeStampMicros, gcStatistic.getMajorPageFaults());
            this.builders[4].add(timeStampMicros, gcStatistic.getMinorPageFaults());
            if (!skipped) {
                this.builders[5].add(timeStampMicros, gcStatistic.getNrOfArrayClassesAfterGc());
            }
            this.builders[6].add(timeStampMicros, gcStatistic.getNrOfArrayClassesBeforeGc());
            if (!skipped) {
                this.builders[7].add(timeStampMicros, gcStatistic.getNrOfNonArrayClassesAfterGc());
            }
            this.builders[8].add(timeStampMicros, gcStatistic.getNrOfNonArrayClassesBeforeGc());
            this.builders[9].add(timeStampMicros, gcStatistic.getAllocationGoal());
            this.builders[10].add(timeStampMicros, gcStatistic.getMaxStopTheWorldDuration() * 1000L);
            this.builders[11].add(timeStampMicros, gcStatistic.getGcNr());
            if (!skipped && !isConcurrent) {
                this.builders[12].add(timeStampMicros, gcStatistic.getBytesInEdenAfterGc());
            }
            this.builders[13].add(timeStampMicros, gcStatistic.getBytesInEdenBeforeGc());
            this.builders[14].add(timeStampMicros, gcStatistic.getBytesWastedByTLABsBeforeGc());
            if (!skipped && !isConcurrent) {
                this.builders[15].add(timeStampMicros, gcStatistic.getBytesInFromAfterGc());
            }
            this.builders[16].add(timeStampMicros, gcStatistic.getBytesInFromBeforeGc());
            if (!skipped) {
                this.builders[17].add(timeStampMicros, gcStatistic.getBytesInOldAfterGc());
            }
            this.builders[18].add(timeStampMicros, gcStatistic.getBytesInOldBeforeGc());
            if (!skipped && !isConcurrent) {
                this.builders[19].add(timeStampMicros, gcStatistic.getBytesInToAfterGc());
            }
            this.builders[20].add(timeStampMicros, gcStatistic.getBytesInToBeforeGc());
            if (!skipped) {
                this.builders[21].add(timeStampMicros, gcStatistic.getBytesInNonPermAfterGc());
            }
            this.builders[22].add(timeStampMicros, gcStatistic.getBytesInNonPermBeforeGc());
            if (!skipped) {
                this.builders[23].add(timeStampMicros, gcStatistic.getBytesInPermAfterGc());
            }
            this.builders[24].add(timeStampMicros, gcStatistic.getBytesInPermBeforeGc());
            if (!skipped) {
                this.builders[25].add(timeStampMicros, gcStatistic.getBytesInClassSpaceAfterGc());
            }
            this.builders[26].add(timeStampMicros, gcStatistic.getBytesInClassSpaceBeforeGc());
            if (!skipped && !isConcurrent) {
                this.builders[27].add(timeStampMicros, gcStatistic.getBytesInYoungAfterGc());
            }
            this.builders[28].add(timeStampMicros, gcStatistic.getBytesInYoungBeforeGc());
            if (!skipped && !isConcurrent) {
                this.builders[29].add(timeStampMicros, gcStatistic.getCommittedBytesInEdenAfterGc());
            }
            this.builders[30].add(timeStampMicros, gcStatistic.getCommittedBytesInEdenBeforeGc());
            if (!skipped && !isConcurrent) {
                this.builders[31].add(timeStampMicros, gcStatistic.getCommittedBytesInFromAfterGc());
            }
            this.builders[32].add(timeStampMicros, gcStatistic.getCommittedBytesInFromBeforeGc());
            if (!skipped) {
                this.builders[33].add(timeStampMicros, gcStatistic.getCommittedBytesInOldAfterGc());
            }
            this.builders[34].add(timeStampMicros, gcStatistic.getCommittedBytesInOldBeforeGc());
            if (!skipped && !isConcurrent) {
                this.builders[35].add(timeStampMicros, gcStatistic.getCommittedBytesInToAfterGc());
            }
            this.builders[36].add(timeStampMicros, gcStatistic.getCommittedBytesInToBeforeGc());
            if (!skipped && !isConcurrent) {
                this.builders[37].add(timeStampMicros, gcStatistic.getCommittedBytesInYoungAfterGc());
            }
            this.builders[38].add(timeStampMicros, gcStatistic.getCommittedBytesInYoungBeforeGc());
            if (!skipped) {
                this.builders[39].add(timeStampMicros, gcStatistic.getCommittedBytesInNonPermAfterGc());
            }
            this.builders[40].add(timeStampMicros, gcStatistic.getCommittedBytesInNonPermBeforeGc());
            if (!skipped) {
                this.builders[41].add(timeStampMicros, gcStatistic.getCommittedBytesInPermAfterGc());
            }
            this.builders[42].add(timeStampMicros, gcStatistic.getCommittedBytesInPermBeforeGc());
            if (!skipped) {
                this.builders[43].add(timeStampMicros, gcStatistic.getCommittedBytesInClassSpaceAfterGc());
            }
            this.builders[44].add(timeStampMicros, gcStatistic.getCommittedBytesInClassSpaceBeforeGc());
            this.builders[45].add(timeStampMicros, gcStatistic.getMaxOldGenSize());
            this.builders[46].add(timeStampMicros, gcStatistic.getMaxPermGenSize());
            this.builders[47].add(timeStampMicros, gcStatistic.getMaxClassSpaceSize());
            this.builders[48].add(timeStampMicros, gcStatistic.getMaxNonPermGenSize());
            this.builders[49].add(timeStampMicros, gcStatistic.getMaxYoungGenSize());
            this.builders[50].add(timeStampMicros, gcStatistic.getTenuringThreshold());
            if (gcStatistic instanceof GcStatisticConcMarkSweepGc) {
                this.builders[51].add(timeStampMicros, ((GcStatisticConcMarkSweepGc)gcStatistic).getNrOfThreads());
                this.builders[52].add(timeStampMicros, ((GcStatisticConcMarkSweepGc)gcStatistic).getBytesFreedConcurrentlyInOld());
                this.builders[53].add(timeStampMicros, ((GcStatisticConcMarkSweepGc)gcStatistic).getBytesFreedConcurrentlyInPerm());
                this.builders[54].add(timeStampMicros, ((GcStatisticConcMarkSweepGc)gcStatistic).getNrOfNonArrayClassesUnloadedConcurrently());
                this.builders[55].add(timeStampMicros, ((GcStatisticConcMarkSweepGc)gcStatistic).getNrOfArrayClassesUnloadedConcurrently());
            }
            if (gcStatistic instanceof GcStatisticG1Gc) {
                this.builders[54].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getNrOfNonArrayClassesUnloadedConcurrently());
                this.builders[55].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getNrOfArrayClassesUnloadedConcurrently());
                this.builders[56].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getNrOfScavengeThreads());
                this.builders[57].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getBytesFreedConcurrently());
                this.builders[58].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getCommittedRegionsBeforeGc());
                if (!skipped) {
                    this.builders[59].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getCommittedRegionsAfterGc());
                }
                this.builders[60].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getFreeRegionsBeforeGc());
                if (!skipped) {
                    this.builders[61].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getFreeRegionsAfterGc());
                }
                this.builders[62].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getHumongousRegionsBeforeGc());
                if (!skipped) {
                    this.builders[63].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getHumongousRegionsAfterGc());
                }
                this.builders[64].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getHumongousStartRegionsBeforeGc());
                if (!skipped) {
                    this.builders[65].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getHumongousStartRegionsAfterGc());
                }
                this.builders[66].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getYoungRegionsBeforeGc());
                if (!skipped) {
                    this.builders[67].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getYoungRegionsAfterGc());
                }
                this.builders[68].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getSurvivorRegionsBeforeGc());
                if (!skipped) {
                    this.builders[69].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getSurvivorRegionsAfterGc());
                }
                this.builders[70].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getYoungListTargetRegionsBeforeGc());
                if (!skipped) {
                    this.builders[71].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getYoungListTargetRegionsAfterGc());
                }
                this.builders[72].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getYoungListMaximumRegionsBeforeGc());
                if (!skipped) {
                    this.builders[73].add(timeStampMicros, ((GcStatisticG1Gc)gcStatistic).getYoungListMaximumRegionsAfterGc());
                }
            }
            if (gcStatistic instanceof GcStatisticParallelGc) {
                this.builders[56].add(timeStampMicros, ((GcStatisticParallelGc)gcStatistic).getNrOfScavengeThreads());
            }
            if (gcStatistic instanceof GcStatisticParallelNewGc) {
                this.builders[56].add(timeStampMicros, ((GcStatisticParallelNewGc)gcStatistic).getNrOfScavengeThreads());
            }
            if (gcStatistic instanceof GcStatisticParallelOldGc) {
                this.builders[56].add(timeStampMicros, ((GcStatisticParallelOldGc)gcStatistic).getNrOfScavengeThreads());
                this.builders[74].add(timeStampMicros, ((GcStatisticParallelOldGc)gcStatistic).getNrOfCompactThreads());
            }
            for (GcEventBase event : gcStatistic.getEvents()) {
                if (event instanceof GcEventClassunloadingPhase1) {
                    this.writeForGcEventClassunloadingPhase1((GcEventClassunloadingPhase1)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventClassunloadingPhase2) {
                    this.writeForGcEventClassunloadingPhase2((GcEventClassunloadingPhase2)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventCmsAbortablePrecleaning) {
                    this.writeForGcEventCmsAbortablePrecleaning((GcEventCmsAbortablePrecleaning)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventCmsFinalMarking) {
                    this.writeForGcEventCmsFinalMarking((GcEventCmsFinalMarking)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventCmsInitialMarking) {
                    this.writeForGcEventCmsInitialMarking((GcEventCmsInitialMarking)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventCmsMarking) {
                    this.writeForGcEventCmsMarking((GcEventCmsMarking)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventCmsPrecleaning) {
                    this.writeForGcEventCmsPrecleaning((GcEventCmsPrecleaning)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventCmsSweeping) {
                    this.writeForGcEventCmsSweeping((GcEventCmsSweeping)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1BitmapClearing) {
                    this.writeForGcEventG1BitmapClearing((GcEventG1BitmapClearing)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1Cleanup) {
                    this.writeForGcEventG1Cleanup((GcEventG1Cleanup)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1EmptyRegionsReclaim) {
                    this.writeForGcEventG1EmptyRegionsReclaim((GcEventG1EmptyRegionsReclaim)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1ConcurrentCleanup) {
                    this.writeForGcEventG1ConcurrentCleanup((GcEventG1ConcurrentCleanup)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1Counting) {
                    this.writeForGcEventG1Counting((GcEventG1Counting)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1FinalMarking) {
                    this.writeForGcEventG1FinalMarking((GcEventG1FinalMarking)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1InitialMarking) {
                    this.writeForGcEventG1InitialMarking((GcEventG1InitialMarking)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1Marking) {
                    this.writeForGcEventG1Marking((GcEventG1Marking)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1RootScanning) {
                    this.writeForGcEventG1RootScanning((GcEventG1RootScanning)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1IncrementalGc) {
                    this.writeForGcEventG1IncrementalGc((GcEventG1IncrementalGc)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1MarkSweepGc) {
                    this.writeForGcEventG1MarkSweepGc((GcEventG1MarkSweepGc)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventG1ParallelFullGc) {
                    this.writeForGcEventG1ParallelFullGc((GcEventG1ParallelFullGc)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventParallelGcMarkSweep) {
                    this.writeForGcEventParallelGcMarkSweep((GcEventParallelGcMarkSweep)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventParallelGcParallelCompact) {
                    this.writeForGcEventParallelGcParallelCompact((GcEventParallelGcParallelCompact)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventParallelGcScavenge) {
                    this.writeForGcEventParallelGcScavenge((GcEventParallelGcScavenge)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventParallelNewGc) {
                    this.writeForGcEventParallelNewGc((GcEventParallelNewGc)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventSerialNewGc) {
                    this.writeForGcEventSerialNewGc((GcEventSerialNewGc)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventTenuredGc) {
                    this.writeForGcEventTenuredGc((GcEventTenuredGc)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventAllGenRefHandling) {
                    this.writeForGcEventAllGenRefHandling((GcEventAllGenRefHandling)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventOldGenRefHandling) {
                    this.writeForGcEventOldGenRefHandling((GcEventOldGenRefHandling)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventYoungGenRefHandling) {
                    this.writeForGcEventYoungGenRefHandling((GcEventYoungGenRefHandling)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventPartialRefHandling) {
                    this.writeForGcEventPartialRefHandling((GcEventPartialRefHandling)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventCmsAborted) {
                    this.writeForGcEventCmsAborted((GcEventCmsAborted)event, timeStampMicros);
                    continue;
                }
                if (event instanceof GcEventParallelSmallGcForcedFullGc) {
                    this.writeForGcEventParallelSmallGcForcedFullGc((GcEventParallelSmallGcForcedFullGc)event, timeStampMicros);
                    continue;
                }
                if (!(event instanceof GcEventYoungGenPromotionFailure)) continue;
                this.writeForGcEventYoungGenPromotionFailure((GcEventYoungGenPromotionFailure)event, timeStampMicros);
            }
            if (!skipped && !isConcurrent) {
                this.builders[708].add(timeStampMicros, gcStatistic.getBytesInYoungAfterGc() - gcStatistic.getBytesInYoungBeforeGc());
                this.builders[709].add(timeStampMicros, gcStatistic.getBytesInToAfterGc() - gcStatistic.getBytesInToBeforeGc());
                this.builders[710].add(timeStampMicros, gcStatistic.getBytesInFromAfterGc() - gcStatistic.getBytesInFromBeforeGc());
                this.builders[711].add(timeStampMicros, gcStatistic.getBytesInEdenAfterGc() - gcStatistic.getBytesInEdenBeforeGc());
            }
            if (!skipped) {
                this.builders[712].add(timeStampMicros, gcStatistic.getBytesInOldAfterGc() - gcStatistic.getBytesInOldBeforeGc());
                this.builders[713].add(timeStampMicros, gcStatistic.getBytesInNonPermAfterGc() - gcStatistic.getBytesInNonPermBeforeGc());
                this.builders[714].add(timeStampMicros, gcStatistic.getBytesInPermAfterGc() - gcStatistic.getBytesInPermBeforeGc());
            }
            if ((timeSinceLastConc = GcStatisticValueElement.TIME_SINCE_LAST_CONC_GC.getValue(gcStatistic)) != -1L) {
                this.builders[716].add(timeStampMicros, timeSinceLastConc);
            }
            if (!gcStatistic.isFullGc()) {
                this.builders[702].add(timeStampMicros, GcStatisticValueElement.PROMOTIONS_TO_OLD.getValue(gcStatistic));
            }
            if ((survivingYoung = GcStatisticValueElement.SURVIVING_YOUNG.getValue(gcStatistic)) != -1L) {
                this.builders[703].add(timeStampMicros, survivingYoung);
            }
            for (GcEventBase event : gcStatistic.getEvents()) {
                double[] virtCpu;
                double[] load;
                if (event instanceof GcEventGenerational) {
                    load = ((GcEventGenerational)event).getSystemLoadAverage();
                    virtCpu = ((GcEventGenerational)event).getVirtualCpuUtilization();
                    this.addLoadInfo(timeStampMicros, load, virtCpu);
                }
                if (event instanceof GcEventCmsFinalMarking) {
                    load = ((GcEventCmsFinalMarking)event).getSystemLoadAverage();
                    virtCpu = ((GcEventCmsFinalMarking)event).getVirtualCpuUtilization();
                    this.addLoadInfo(timeStampMicros, load, virtCpu);
                }
                if (event instanceof GcEventCmsInitialMarking) {
                    load = ((GcEventCmsInitialMarking)event).getSystemLoadAverage();
                    virtCpu = ((GcEventCmsInitialMarking)event).getVirtualCpuUtilization();
                    this.addLoadInfo(timeStampMicros, load, virtCpu);
                }
                if (event instanceof GcEventG1Cleanup) {
                    load = ((GcEventG1Cleanup)event).getSystemLoadAverage();
                    virtCpu = ((GcEventG1Cleanup)event).getVirtualCpuUtilization();
                    this.addLoadInfo(timeStampMicros, load, virtCpu);
                }
                if (event instanceof GcEventG1EmptyRegionsReclaim) {
                    load = ((GcEventG1EmptyRegionsReclaim)event).getSystemLoadAverage();
                    virtCpu = ((GcEventG1EmptyRegionsReclaim)event).getVirtualCpuUtilization();
                    this.addLoadInfo(timeStampMicros, load, virtCpu);
                }
                if (event instanceof GcEventG1FinalMarking) {
                    load = ((GcEventG1FinalMarking)event).getSystemLoadAverage();
                    virtCpu = ((GcEventG1FinalMarking)event).getVirtualCpuUtilization();
                    this.addLoadInfo(timeStampMicros, load, virtCpu);
                }
                if (!(event instanceof GcEventG1InitialMarking)) continue;
                load = ((GcEventG1InitialMarking)event).getSystemLoadAverage();
                virtCpu = ((GcEventG1InitialMarking)event).getVirtualCpuUtilization();
                this.addLoadInfo(timeStampMicros, load, virtCpu);
            }
            if (gcStatistic.getCause() == GcCause.GC_LOCKER) {
                this.eventBuilders[698].add(timeStampMicros, new GcTimeSeriesAnnotation(GcCause.GC_LOCKER.getShortDescrDisplay(), 2));
            }
            if (isConcurrent && (events = gcStatistic.getEvents()).length > 0) {
                long first = events[0].getTimestamp();
                GcEventBase lastEvent = events[events.length - 1];
                long last = lastEvent.getTimestamp();
                long durationMicros = (last - first) * 1000L;
                if (lastEvent instanceof GcDurationEventBase) {
                    durationMicros += ((GcDurationEventBase)lastEvent).getDuration();
                }
                this.eventBuilders[701].add((first - this.profilingStartupTimeStamp) * 1000L, durationMicros, new GcTimeSeriesAnnotation(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Concurrent GC")));
            }
            for (GcEventBase event : gcStatistic.getEvents()) {
                if (event instanceof GcEventYoungGenPromotionFailure) {
                    this.eventBuilders[699].add(timeStampMicros, new GcTimeSeriesAnnotation(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Promotion failure")));
                }
                if (event instanceof GcEventCmsAborted) {
                    this.eventBuilders[699].add(timeStampMicros, new GcTimeSeriesAnnotation(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Concurrent mode failure"), 3));
                }
                if (!(event instanceof GcEventG1MarkingAborted)) continue;
                this.eventBuilders[699].add(timeStampMicros, new GcTimeSeriesAnnotation(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Concurrent mode failure"), 3));
            }
            if (gcStatistic.isFullGc()) {
                this.eventBuilders[698].add(timeStampMicros, new GcTimeSeriesAnnotation(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Full GC"), 1));
            }
            if (gcStatistic.getDuration() > 60000000L) {
                this.eventBuilders[699].add(timeStampMicros, new GcTimeSeriesAnnotation(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Suspiciously long running GC")));
            }
            if (!gcStatistic.isForcedSoftRefClear()) continue;
            this.eventBuilders[699].add(timeStampMicros, new GcTimeSeriesAnnotation(I18n._ts((I18n.TextType)I18n.TextType.XMSG, (String)"Memory shortage")));
        }
        this.convert(it.getReporter());
    }

    private void writeForGcEventClassunloadingPhase1(GcEventClassunloadingPhase1 event, long timeStampMicros) throws IOException {
        this.builders[75].add(timeStampMicros, event.getNrOfNonArrayClassesBefore());
        this.builders[76].add(timeStampMicros, event.getNrOfNonArrayClassesAfter());
        this.builders[77].add(timeStampMicros, event.getNrOfArrayClassesBefore());
        this.builders[78].add(timeStampMicros, event.getNrOfArrayClassesAfter());
        this.builders[79].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[80].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[81].add(timeStampMicros, event.getPageFaults());
        this.builders[82].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[83].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventClassunloadingPhase2(GcEventClassunloadingPhase2 event, long timeStampMicros) throws IOException {
        this.builders[84].add(timeStampMicros, event.getMetaspaceUsedBefore());
        this.builders[85].add(timeStampMicros, event.getMetaspaceUsedAfter());
        this.builders[86].add(timeStampMicros, event.getMetaspaceCommittedBefore());
        this.builders[87].add(timeStampMicros, event.getMetaspaceCommittedAfter());
        this.builders[88].add(timeStampMicros, event.getClassSpaceUsedBefore());
        this.builders[89].add(timeStampMicros, event.getClassSpaceUsedAfter());
        this.builders[90].add(timeStampMicros, event.getClassSpaceCommittedBefore());
        this.builders[91].add(timeStampMicros, event.getClassSpaceCommittedAfter());
        this.builders[92].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[93].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[94].add(timeStampMicros, event.getPageFaults());
        this.builders[95].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[96].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventCmsAbortablePrecleaning(GcEventCmsAbortablePrecleaning event, long timeStampMicros) throws IOException {
        this.builders[97].add(timeStampMicros, event.getNrOfCardsCleaned());
        this.builders[98].add(timeStampMicros, event.getSoftReferencesFoundInPreprocessing());
        this.builders[99].add(timeStampMicros, event.getDeadSoftReferencesFoundInPreprocessing());
        this.builders[100].add(timeStampMicros, event.getSoftReferencesResurrectedInPreprocessing());
        this.builders[101].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[102].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[103].add(timeStampMicros, event.getPageFaults());
        this.builders[104].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[105].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventCmsFinalMarking(GcEventCmsFinalMarking event, long timeStampMicros) throws IOException {
        this.builders[106].add(timeStampMicros, event.getNrOfThreads());
        this.builders[107].add(timeStampMicros, event.getNrOfCardsCleaned());
        this.builders[108].add(timeStampMicros, event.getNrOfArrayClassesUnloaded());
        this.builders[109].add(timeStampMicros, event.getNrOfNonArrayClassesUnloaded());
        this.builders[110].add(timeStampMicros, event.getRemarkingDuration() * 1000L);
        this.builders[111].add(timeStampMicros, event.getRemarkingCpuTime() * 1000L);
        this.builders[112].add(timeStampMicros, event.getClassUnloadingDuration() * 1000L);
        this.builders[113].add(timeStampMicros, event.getClassUnloadingCpuTime() * 1000L);
        this.builders[114].add(timeStampMicros, event.getSymbolUnloadingDuration() * 1000L);
        this.builders[115].add(timeStampMicros, event.getSymbolUnloadingCpuTime() * 1000L);
        this.builders[116].add(timeStampMicros, event.getReferenceHandlingDuration() * 1000L);
        this.builders[117].add(timeStampMicros, event.getReferenceHandlingCpuTime() * 1000L);
        this.builders[118].add(timeStampMicros, event.getReferenceEqueueingDuration() * 1000L);
        this.builders[119].add(timeStampMicros, event.getReferenceEqueueingCpuTime() * 1000L);
        this.builders[120].add(timeStampMicros, event.getSuccessfulSteals());
        this.builders[121].add(timeStampMicros, event.getFailedSteals());
        this.builders[122].add(timeStampMicros, event.getSuccessfulOverflowRefills());
        this.builders[123].add(timeStampMicros, event.getSuccessfulOverflowRefillObjects());
        this.builders[124].add(timeStampMicros, event.getFailedOverflowRefills());
        this.builders[125].add(timeStampMicros, event.getFailedStealsWithYield());
        this.builders[126].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[127].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[128].add(timeStampMicros, event.getPageFaults());
        this.builders[129].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[130].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventCmsInitialMarking(GcEventCmsInitialMarking event, long timeStampMicros) throws IOException {
        this.builders[131].add(timeStampMicros, event.getNrOfThreads());
        this.builders[132].add(timeStampMicros, event.getBytesInOld());
        this.builders[133].add(timeStampMicros, event.getCommittedBytesInOld());
        this.builders[134].add(timeStampMicros, event.getPermUsed());
        this.builders[135].add(timeStampMicros, event.getPermCommitted());
        this.builders[136].add(timeStampMicros, event.getNrOfNonArrayClasses());
        this.builders[137].add(timeStampMicros, event.getNrOfArrayClasses());
        this.builders[138].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[139].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[140].add(timeStampMicros, event.getPageFaults());
        this.builders[141].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[142].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventCmsMarking(GcEventCmsMarking event, long timeStampMicros) throws IOException {
        this.builders[143].add(timeStampMicros, event.getSuccessfulSteals());
        this.builders[144].add(timeStampMicros, event.getFailedSteals());
        this.builders[145].add(timeStampMicros, event.getSuccessfulOverflowRefills());
        this.builders[146].add(timeStampMicros, event.getSuccessfulOverflowRefillObjects());
        this.builders[147].add(timeStampMicros, event.getFailedOverflowRefills());
        this.builders[148].add(timeStampMicros, event.getFailedStealsWithYield());
        this.builders[149].add(timeStampMicros, event.getNrOfGcThreads());
        this.builders[150].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[151].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[152].add(timeStampMicros, event.getPageFaults());
        this.builders[153].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[154].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventCmsPrecleaning(GcEventCmsPrecleaning event, long timeStampMicros) throws IOException {
        this.builders[155].add(timeStampMicros, event.getNrOfCardsCleaned());
        this.builders[156].add(timeStampMicros, event.getSoftReferencesFoundInPreprocessing());
        this.builders[157].add(timeStampMicros, event.getDeadSoftReferencesFoundInPreprocessing());
        this.builders[158].add(timeStampMicros, event.getSoftReferencesResurrectedInPreprocessing());
        this.builders[159].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[160].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[161].add(timeStampMicros, event.getPageFaults());
        this.builders[162].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[163].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventCmsSweeping(GcEventCmsSweeping event, long timeStampMicros) throws IOException {
        this.builders[164].add(timeStampMicros, event.getBytesAllocatedInOld());
        this.builders[165].add(timeStampMicros, event.getBytesAllocatedInPerm());
        this.builders[166].add(timeStampMicros, event.getBytesFreedInOld());
        this.builders[167].add(timeStampMicros, event.getBytesFreedInPerm());
        this.builders[168].add(timeStampMicros, event.getBytesPromotedToOld());
        this.builders[169].add(timeStampMicros, event.getLargestContiguousBlockInOld());
        this.builders[170].add(timeStampMicros, event.getNrOfNonCoalesableBlocksInOld());
        this.builders[171].add(timeStampMicros, event.getSizeOfNonCoalesableBlocksInOld());
        this.builders[172].add(timeStampMicros, event.getNrOfNonCoalesableBlocksInPerm());
        this.builders[173].add(timeStampMicros, event.getSizeOfNonCoalesableBlocksInPerm());
        this.builders[174].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[175].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[176].add(timeStampMicros, event.getPageFaults());
        this.builders[177].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[178].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1BitmapClearing(GcEventG1BitmapClearing event, long timeStampMicros) throws IOException {
        this.builders[179].add(timeStampMicros, event.getClearedBitmapBytes());
        this.builders[180].add(timeStampMicros, event.getYieldCount());
        this.builders[181].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[182].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[183].add(timeStampMicros, event.getPageFaults());
        this.builders[184].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[185].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1Cleanup(GcEventG1Cleanup event, long timeStampMicros) throws IOException {
        this.builders[186].add(timeStampMicros, event.getNrOfGcThreads());
        this.builders[187].add(timeStampMicros, event.getBytesInNonPermBefore());
        this.builders[188].add(timeStampMicros, event.getLiveBytesInNonPerm());
        this.builders[189].add(timeStampMicros, event.getGarbageRegionCount());
        this.builders[190].add(timeStampMicros, event.getBytesInGarbageRegions());
        this.builders[191].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[192].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[193].add(timeStampMicros, event.getPageFaults());
        this.builders[194].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[195].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1EmptyRegionsReclaim(GcEventG1EmptyRegionsReclaim event, long timeStampMicros) throws IOException {
        this.builders[196].add(timeStampMicros, event.getNrOfGcThreads());
        this.builders[197].add(timeStampMicros, event.getBytesInNonPermBefore());
        this.builders[198].add(timeStampMicros, event.getLiveBytesInNonPerm());
        this.builders[199].add(timeStampMicros, event.getGarbageRegionCount());
        this.builders[200].add(timeStampMicros, event.getBytesInGarbageRegions());
        this.builders[201].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[202].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[203].add(timeStampMicros, event.getPageFaults());
        this.builders[204].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[205].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1ConcurrentCleanup(GcEventG1ConcurrentCleanup event, long timeStampMicros) throws IOException {
        this.builders[206].add(timeStampMicros, event.getRegionsToBeCleanedCount());
        this.builders[207].add(timeStampMicros, event.getBytesFreedInNonPerm());
        this.builders[208].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[209].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[210].add(timeStampMicros, event.getPageFaults());
        this.builders[211].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[212].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1Counting(GcEventG1Counting event, long timeStampMicros) throws IOException {
        this.builders[213].add(timeStampMicros, event.getNrOfIterations());
        this.builders[214].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[215].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[216].add(timeStampMicros, event.getPageFaults());
        this.builders[217].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[218].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1FinalMarking(GcEventG1FinalMarking event, long timeStampMicros) throws IOException {
        this.builders[219].add(timeStampMicros, event.getNrOfThreads());
        this.builders[220].add(timeStampMicros, event.getRemarkingDuration() * 1000L);
        this.builders[221].add(timeStampMicros, event.getRemarkingCpuTime() * 1000L);
        this.builders[222].add(timeStampMicros, event.getSymbolUnloadingDuration() * 1000L);
        this.builders[223].add(timeStampMicros, event.getSymbolUnloadingCpuTime() * 1000L);
        this.builders[224].add(timeStampMicros, event.getReferenceHandlingDuration() * 1000L);
        this.builders[225].add(timeStampMicros, event.getReferenceHandlingCpuTime() * 1000L);
        this.builders[226].add(timeStampMicros, event.getReferenceEqueueingDuration() * 1000L);
        this.builders[227].add(timeStampMicros, event.getReferenceEqueueingCpuTime() * 1000L);
        this.builders[228].add(timeStampMicros, event.getSuccessfulSteals());
        this.builders[229].add(timeStampMicros, event.getFailedSteals());
        this.builders[230].add(timeStampMicros, event.getNrOfBytesScanned());
        this.builders[231].add(timeStampMicros, event.getNrOfObjectReferencesReached());
        this.builders[232].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[233].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[234].add(timeStampMicros, event.getPageFaults());
        this.builders[235].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[236].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1InitialMarking(GcEventG1InitialMarking event, long timeStampMicros) throws IOException {
        this.builders[237].add(timeStampMicros, event.getNrOfThreads());
        this.builders[238].add(timeStampMicros, event.getBytesInNonPermAfter());
        this.builders[239].add(timeStampMicros, event.getCommittedBytesInNonPermAfter());
        this.builders[240].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[241].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[242].add(timeStampMicros, event.getPageFaults());
        this.builders[243].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[244].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1Marking(GcEventG1Marking event, long timeStampMicros) throws IOException {
        this.builders[245].add(timeStampMicros, event.getNrOfThreads());
        this.builders[246].add(timeStampMicros, event.getSuccessfulSteals());
        this.builders[247].add(timeStampMicros, event.getFailedSteals());
        this.builders[248].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[249].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[250].add(timeStampMicros, event.getPageFaults());
        this.builders[251].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[252].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1RootScanning(GcEventG1RootScanning event, long timeStampMicros) throws IOException {
        this.builders[253].add(timeStampMicros, event.getNrOfThreads());
        this.builders[254].add(timeStampMicros, event.getScannedRootRegions());
        this.builders[255].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[256].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[257].add(timeStampMicros, event.getPageFaults());
        this.builders[258].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[259].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1IncrementalGc(GcEventG1IncrementalGc event, long timeStampMicros) throws IOException {
        this.builders[260].add(timeStampMicros, event.getNrOfThreads());
        this.builders[261].add(timeStampMicros, event.getReferenceHandlingDuration() * 1000L);
        this.builders[262].add(timeStampMicros, event.getSuccessfulSteals());
        this.builders[263].add(timeStampMicros, event.getFailedSteals());
        this.builders[264].add(timeStampMicros, event.getFailedStealsWithYield());
        this.builders[265].add(timeStampMicros, event.getYoungPLABSize());
        this.builders[266].add(timeStampMicros, event.getOldPLABSize());
        this.builders[267].add(timeStampMicros, event.getConcurrentMarkingRootScanWaitDuration() * 1000L);
        this.builders[268].add(timeStampMicros, event.getParallelRootScanningDuration() * 1000L);
        this.builders[269].add(timeStampMicros, event.getParallelSnapshotAtTheBeginningFilteringDuration() * 1000L);
        this.builders[270].add(timeStampMicros, event.getParallelRememberedSetUpdatingDuration() * 1000L);
        this.builders[271].add(timeStampMicros, event.getBuffersProcessedDuringParallelRememberedSetUpdating());
        this.builders[272].add(timeStampMicros, event.getParallelRememberedSetScanningDuration() * 1000L);
        this.builders[273].add(timeStampMicros, event.getParallelObjectCopyingDuration() * 1000L);
        this.builders[274].add(timeStampMicros, event.getCardTableClearingDuration() * 1000L);
        this.builders[275].add(timeStampMicros, event.getCollectionSetChoosingDuration() * 1000L);
        this.builders[276].add(timeStampMicros, event.getCollectionSetFreeingDuration() * 1000L);
        this.builders[277].add(timeStampMicros, event.getReferenceEnqueueingDuration() * 1000L);
        this.builders[278].add(timeStampMicros, event.getPendingCards());
        this.builders[279].add(timeStampMicros, event.getPredictedBaseTime() * 1000L);
        this.builders[280].add(timeStampMicros, event.getEdenRegionLength());
        this.builders[281].add(timeStampMicros, event.getSurvivorRegionLength());
        this.builders[282].add(timeStampMicros, event.getPredictedYoungTime() * 1000L);
        this.builders[283].add(timeStampMicros, event.getOldRegionLengthMin());
        this.builders[284].add(timeStampMicros, event.getOldRegionLengthMax());
        this.builders[285].add(timeStampMicros, event.getExpensiveRegionLength());
        this.builders[286].add(timeStampMicros, event.getOldRegionLength());
        this.builders[287].add(timeStampMicros, event.getPredictedPauseTime() * 1000L);
        this.builders[288].add(timeStampMicros, event.getNrOfHumongousReclaimed());
        this.builders[289].add(timeStampMicros, event.getBytesInEdenAfter());
        this.builders[290].add(timeStampMicros, event.getBytesInEdenBefore());
        this.builders[291].add(timeStampMicros, event.getBytesInFromAfter());
        this.builders[292].add(timeStampMicros, event.getBytesInFromBefore());
        this.builders[293].add(timeStampMicros, event.getBytesInOldAfter());
        this.builders[294].add(timeStampMicros, event.getBytesInOldBefore());
        this.builders[295].add(timeStampMicros, event.getBytesInPermAfter());
        this.builders[296].add(timeStampMicros, event.getBytesInPermBefore());
        this.builders[297].add(timeStampMicros, event.getBytesInToAfter());
        this.builders[298].add(timeStampMicros, event.getBytesInToBefore());
        this.builders[299].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[300].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[301].add(timeStampMicros, event.getPageFaults());
        this.builders[302].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[303].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1MarkSweepGc(GcEventG1MarkSweepGc event, long timeStampMicros) throws IOException {
        this.builders[304].add(timeStampMicros, event.getAllowedNonPermDeadSpace());
        this.builders[305].add(timeStampMicros, event.getAllowedPermDeadSpace());
        this.builders[306].add(timeStampMicros, event.getNrOfUnloadedClasses());
        this.builders[307].add(timeStampMicros, event.getUsedNonPermDeadSpace());
        this.builders[308].add(timeStampMicros, event.getUsedPermDeadSpace());
        this.builders[309].add(timeStampMicros, event.getPhase1Duration() * 1000L);
        this.builders[310].add(timeStampMicros, event.getPhase1CpuTime() * 1000L);
        this.builders[311].add(timeStampMicros, event.getPhase2Duration() * 1000L);
        this.builders[312].add(timeStampMicros, event.getPhase2CpuTime() * 1000L);
        this.builders[313].add(timeStampMicros, event.getPhase3Duration() * 1000L);
        this.builders[314].add(timeStampMicros, event.getPhase3CpuTime() * 1000L);
        this.builders[315].add(timeStampMicros, event.getPhase4Duration() * 1000L);
        this.builders[316].add(timeStampMicros, event.getPhase4CpuTime() * 1000L);
        this.builders[317].add(timeStampMicros, event.getBytesInEdenAfter());
        this.builders[318].add(timeStampMicros, event.getBytesInEdenBefore());
        this.builders[319].add(timeStampMicros, event.getBytesInFromAfter());
        this.builders[320].add(timeStampMicros, event.getBytesInFromBefore());
        this.builders[321].add(timeStampMicros, event.getBytesInOldAfter());
        this.builders[322].add(timeStampMicros, event.getBytesInOldBefore());
        this.builders[323].add(timeStampMicros, event.getBytesInPermAfter());
        this.builders[324].add(timeStampMicros, event.getBytesInPermBefore());
        this.builders[325].add(timeStampMicros, event.getBytesInToAfter());
        this.builders[326].add(timeStampMicros, event.getBytesInToBefore());
        this.builders[327].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[328].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[329].add(timeStampMicros, event.getPageFaults());
        this.builders[330].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[331].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventG1ParallelFullGc(GcEventG1ParallelFullGc event, long timeStampMicros) throws IOException {
        this.builders[332].add(timeStampMicros, event.getNrOfThreads());
        this.builders[333].add(timeStampMicros, event.getPhase1Duration() * 1000L);
        this.builders[334].add(timeStampMicros, event.getPhase1CpuTime() * 1000L);
        this.builders[335].add(timeStampMicros, event.getPhase2Duration() * 1000L);
        this.builders[336].add(timeStampMicros, event.getPhase2CpuTime() * 1000L);
        this.builders[337].add(timeStampMicros, event.getPhase3Duration() * 1000L);
        this.builders[338].add(timeStampMicros, event.getPhase3CpuTime() * 1000L);
        this.builders[339].add(timeStampMicros, event.getPhase4Duration() * 1000L);
        this.builders[340].add(timeStampMicros, event.getPhase4CpuTime() * 1000L);
        this.builders[341].add(timeStampMicros, event.getBytesInEdenAfter());
        this.builders[342].add(timeStampMicros, event.getBytesInEdenBefore());
        this.builders[343].add(timeStampMicros, event.getBytesInFromAfter());
        this.builders[344].add(timeStampMicros, event.getBytesInFromBefore());
        this.builders[345].add(timeStampMicros, event.getBytesInOldAfter());
        this.builders[346].add(timeStampMicros, event.getBytesInOldBefore());
        this.builders[347].add(timeStampMicros, event.getBytesInPermAfter());
        this.builders[348].add(timeStampMicros, event.getBytesInPermBefore());
        this.builders[349].add(timeStampMicros, event.getBytesInToAfter());
        this.builders[350].add(timeStampMicros, event.getBytesInToBefore());
        this.builders[351].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[352].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[353].add(timeStampMicros, event.getPageFaults());
        this.builders[354].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[355].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventParallelGcMarkSweep(GcEventParallelGcMarkSweep event, long timeStampMicros) throws IOException {
        this.builders[356].add(timeStampMicros, event.getAllowedNonPermDeadSpace());
        this.builders[357].add(timeStampMicros, event.getAllowedPermDeadSpace());
        this.builders[358].add(timeStampMicros, event.getNrOfUnloadedClasses());
        this.builders[359].add(timeStampMicros, event.getUsedNonPermDeadSpace());
        this.builders[360].add(timeStampMicros, event.getUsedPermDeadSpace());
        this.builders[361].add(timeStampMicros, event.getPhase1Duration() * 1000L);
        this.builders[362].add(timeStampMicros, event.getPhase1CpuTime() * 1000L);
        this.builders[363].add(timeStampMicros, event.getPhase2Duration() * 1000L);
        this.builders[364].add(timeStampMicros, event.getPhase2CpuTime() * 1000L);
        this.builders[365].add(timeStampMicros, event.getPhase3Duration() * 1000L);
        this.builders[366].add(timeStampMicros, event.getPhase3CpuTime() * 1000L);
        this.builders[367].add(timeStampMicros, event.getPhase4Duration() * 1000L);
        this.builders[368].add(timeStampMicros, event.getPhase4CpuTime() * 1000L);
        this.builders[369].add(timeStampMicros, event.getBytesInEdenAfter());
        this.builders[370].add(timeStampMicros, event.getBytesInEdenBefore());
        this.builders[371].add(timeStampMicros, event.getBytesInFromAfter());
        this.builders[372].add(timeStampMicros, event.getBytesInFromBefore());
        this.builders[373].add(timeStampMicros, event.getBytesInOldAfter());
        this.builders[374].add(timeStampMicros, event.getBytesInOldBefore());
        this.builders[375].add(timeStampMicros, event.getBytesInPermAfter());
        this.builders[376].add(timeStampMicros, event.getBytesInPermBefore());
        this.builders[377].add(timeStampMicros, event.getBytesInToAfter());
        this.builders[378].add(timeStampMicros, event.getBytesInToBefore());
        this.builders[379].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[380].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[381].add(timeStampMicros, event.getPageFaults());
        this.builders[382].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[383].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventParallelGcParallelCompact(GcEventParallelGcParallelCompact event, long timeStampMicros) throws IOException {
        this.builders[384].add(timeStampMicros, event.getSuccessfulSteals());
        this.builders[385].add(timeStampMicros, event.getFailedSteals());
        this.builders[386].add(timeStampMicros, event.getFailedStealsWithYield());
        this.builders[387].add(timeStampMicros, event.getAllowedNonPermDeadSpace());
        this.builders[388].add(timeStampMicros, event.getAllowedPermDeadSpace());
        this.builders[389].add(timeStampMicros, event.getNrOfUnloadedClasses());
        this.builders[390].add(timeStampMicros, event.getUsedNonPermDeadSpace());
        this.builders[391].add(timeStampMicros, event.getUsedPermDeadSpace());
        this.builders[392].add(timeStampMicros, event.getPhase1Duration() * 1000L);
        this.builders[393].add(timeStampMicros, event.getPhase1CpuTime() * 1000L);
        this.builders[394].add(timeStampMicros, event.getPhase2Duration() * 1000L);
        this.builders[395].add(timeStampMicros, event.getPhase2CpuTime() * 1000L);
        this.builders[396].add(timeStampMicros, event.getPhase3Duration() * 1000L);
        this.builders[397].add(timeStampMicros, event.getPhase3CpuTime() * 1000L);
        this.builders[398].add(timeStampMicros, event.getPhase4Duration() * 1000L);
        this.builders[399].add(timeStampMicros, event.getPhase4CpuTime() * 1000L);
        this.builders[400].add(timeStampMicros, event.getNrOfParallelCompactThreads());
        this.builders[401].add(timeStampMicros, event.getBytesInEdenAfter());
        this.builders[402].add(timeStampMicros, event.getBytesInEdenBefore());
        this.builders[403].add(timeStampMicros, event.getBytesInFromAfter());
        this.builders[404].add(timeStampMicros, event.getBytesInFromBefore());
        this.builders[405].add(timeStampMicros, event.getBytesInOldAfter());
        this.builders[406].add(timeStampMicros, event.getBytesInOldBefore());
        this.builders[407].add(timeStampMicros, event.getBytesInPermAfter());
        this.builders[408].add(timeStampMicros, event.getBytesInPermBefore());
        this.builders[409].add(timeStampMicros, event.getBytesInToAfter());
        this.builders[410].add(timeStampMicros, event.getBytesInToBefore());
        this.builders[411].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[412].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[413].add(timeStampMicros, event.getPageFaults());
        this.builders[414].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[415].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventParallelGcScavenge(GcEventParallelGcScavenge event, long timeStampMicros) throws IOException {
        this.builders[416].add(timeStampMicros, event.getSuccessfulSteals());
        this.builders[417].add(timeStampMicros, event.getFailedSteals());
        this.builders[418].add(timeStampMicros, event.getFailedStealsWithYield());
        this.builders[419].add(timeStampMicros, event.getPLABSize());
        this.builders[420].add(timeStampMicros, event.getBytesInEdenAfter());
        this.builders[421].add(timeStampMicros, event.getBytesInEdenBefore());
        this.builders[422].add(timeStampMicros, event.getBytesInFromAfter());
        this.builders[423].add(timeStampMicros, event.getBytesInFromBefore());
        this.builders[424].add(timeStampMicros, event.getBytesInOldAfter());
        this.builders[425].add(timeStampMicros, event.getBytesInOldBefore());
        this.builders[426].add(timeStampMicros, event.getBytesInPermAfter());
        this.builders[427].add(timeStampMicros, event.getBytesInPermBefore());
        this.builders[428].add(timeStampMicros, event.getBytesInToAfter());
        this.builders[429].add(timeStampMicros, event.getBytesInToBefore());
        this.builders[430].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[431].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[432].add(timeStampMicros, event.getPageFaults());
        this.builders[433].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[434].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventParallelNewGc(GcEventParallelNewGc event, long timeStampMicros) throws IOException {
        this.builders[435].add(timeStampMicros, event.getSuccessfulSteals());
        this.builders[436].add(timeStampMicros, event.getFailedSteals());
        this.builders[437].add(timeStampMicros, event.getSuccessfulOverflowRefills());
        this.builders[438].add(timeStampMicros, event.getSuccessfulOverflowRefillObjects());
        this.builders[439].add(timeStampMicros, event.getFailedOverflowRefills());
        this.builders[440].add(timeStampMicros, event.getFailedStealsWithYield());
        this.builders[441].add(timeStampMicros, event.getLargestContiguousBlockInOld());
        this.builders[442].add(timeStampMicros, event.getPLABSize());
        this.builders[443].add(timeStampMicros, event.getNrOfParallelGcThreads());
        this.builders[444].add(timeStampMicros, event.getBytesInEdenAfter());
        this.builders[445].add(timeStampMicros, event.getBytesInEdenBefore());
        this.builders[446].add(timeStampMicros, event.getBytesInFromAfter());
        this.builders[447].add(timeStampMicros, event.getBytesInFromBefore());
        this.builders[448].add(timeStampMicros, event.getBytesInOldAfter());
        this.builders[449].add(timeStampMicros, event.getBytesInOldBefore());
        this.builders[450].add(timeStampMicros, event.getBytesInPermAfter());
        this.builders[451].add(timeStampMicros, event.getBytesInPermBefore());
        this.builders[452].add(timeStampMicros, event.getBytesInToAfter());
        this.builders[453].add(timeStampMicros, event.getBytesInToBefore());
        this.builders[454].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[455].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[456].add(timeStampMicros, event.getPageFaults());
        this.builders[457].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[458].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventSerialNewGc(GcEventSerialNewGc event, long timeStampMicros) throws IOException {
        this.builders[459].add(timeStampMicros, event.getLargestContiguousBlockInOld());
        this.builders[460].add(timeStampMicros, event.getBytesInEdenAfter());
        this.builders[461].add(timeStampMicros, event.getBytesInEdenBefore());
        this.builders[462].add(timeStampMicros, event.getBytesInFromAfter());
        this.builders[463].add(timeStampMicros, event.getBytesInFromBefore());
        this.builders[464].add(timeStampMicros, event.getBytesInOldAfter());
        this.builders[465].add(timeStampMicros, event.getBytesInOldBefore());
        this.builders[466].add(timeStampMicros, event.getBytesInPermAfter());
        this.builders[467].add(timeStampMicros, event.getBytesInPermBefore());
        this.builders[468].add(timeStampMicros, event.getBytesInToAfter());
        this.builders[469].add(timeStampMicros, event.getBytesInToBefore());
        this.builders[470].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[471].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[472].add(timeStampMicros, event.getPageFaults());
        this.builders[473].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[474].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventTenuredGc(GcEventTenuredGc event, long timeStampMicros) throws IOException {
        this.builders[475].add(timeStampMicros, event.getLargestContiguousBlockInOld());
        this.builders[476].add(timeStampMicros, event.getAllowedNonPermDeadSpace());
        this.builders[477].add(timeStampMicros, event.getAllowedPermDeadSpace());
        this.builders[478].add(timeStampMicros, event.getNrOfUnloadedClasses());
        this.builders[479].add(timeStampMicros, event.getUsedNonPermDeadSpace());
        this.builders[480].add(timeStampMicros, event.getUsedPermDeadSpace());
        this.builders[481].add(timeStampMicros, event.getPhase1Duration() * 1000L);
        this.builders[482].add(timeStampMicros, event.getPhase1CpuTime() * 1000L);
        this.builders[483].add(timeStampMicros, event.getPhase2Duration() * 1000L);
        this.builders[484].add(timeStampMicros, event.getPhase2CpuTime() * 1000L);
        this.builders[485].add(timeStampMicros, event.getPhase3Duration() * 1000L);
        this.builders[486].add(timeStampMicros, event.getPhase3CpuTime() * 1000L);
        this.builders[487].add(timeStampMicros, event.getPhase4Duration() * 1000L);
        this.builders[488].add(timeStampMicros, event.getPhase4CpuTime() * 1000L);
        this.builders[489].add(timeStampMicros, event.getBytesInEdenAfter());
        this.builders[490].add(timeStampMicros, event.getBytesInEdenBefore());
        this.builders[491].add(timeStampMicros, event.getBytesInFromAfter());
        this.builders[492].add(timeStampMicros, event.getBytesInFromBefore());
        this.builders[493].add(timeStampMicros, event.getBytesInOldAfter());
        this.builders[494].add(timeStampMicros, event.getBytesInOldBefore());
        this.builders[495].add(timeStampMicros, event.getBytesInPermAfter());
        this.builders[496].add(timeStampMicros, event.getBytesInPermBefore());
        this.builders[497].add(timeStampMicros, event.getBytesInToAfter());
        this.builders[498].add(timeStampMicros, event.getBytesInToBefore());
        this.builders[499].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[500].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[501].add(timeStampMicros, event.getPageFaults());
        this.builders[502].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[503].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventAllGenRefHandling(GcEventAllGenRefHandling event, long timeStampMicros) throws IOException {
        this.builders[504].add(timeStampMicros, event.getSoftReferencesFoundInPreprocessing());
        this.builders[505].add(timeStampMicros, event.getDeadSoftReferencesFoundInPreprocessing());
        this.builders[506].add(timeStampMicros, event.getSoftReferencesResurrectedInPreprocessing());
        this.builders[507].add(timeStampMicros, event.getFinalReferencesEnqueued());
        this.builders[508].add(timeStampMicros, event.getFinalReferencesFound());
        this.builders[509].add(timeStampMicros, event.getPhantomReferencesEnqueued());
        this.builders[510].add(timeStampMicros, event.getPhantomReferencesFound());
        this.builders[511].add(timeStampMicros, event.getSoftReferencesCleared());
        this.builders[512].add(timeStampMicros, event.getSoftReferencesEnqueued());
        this.builders[513].add(timeStampMicros, event.getSoftReferencesFound());
        this.builders[514].add(timeStampMicros, event.getSoftReferencesNotCleared());
        this.builders[515].add(timeStampMicros, event.getSoftReferenceMaxLastUsedTime() * 1000L);
        this.builders[516].add(timeStampMicros, event.getWeakReferencesCleared());
        this.builders[517].add(timeStampMicros, event.getWeakReferencesEnqueued());
        this.builders[518].add(timeStampMicros, event.getWeakReferencesFound());
        this.builders[519].add(timeStampMicros, event.getSoftReferencesFoundInSoftReferenceHandling());
        this.builders[520].add(timeStampMicros, event.getWeakReferencesFoundInSoftReferenceHandling());
        this.builders[521].add(timeStampMicros, event.getFinalReferencesFoundInSoftReferenceHandling());
        this.builders[522].add(timeStampMicros, event.getPhantomReferencesFoundInSoftReferenceHandling());
        this.builders[523].add(timeStampMicros, event.getSoftReferencesFoundInPhantomReferenceHandling());
        this.builders[524].add(timeStampMicros, event.getWeakReferencesFoundInPhantomReferenceHandling());
        this.builders[525].add(timeStampMicros, event.getFinalReferencesFoundInPhantomReferenceHandling());
        this.builders[526].add(timeStampMicros, event.getPhantomReferencesFoundInPhantomReferenceHandling());
        this.builders[527].add(timeStampMicros, event.getSoftReferencesFoundInFinalReferenceHandling());
        this.builders[528].add(timeStampMicros, event.getWeakReferencesFoundInFinalReferenceHandling());
        this.builders[529].add(timeStampMicros, event.getFinalReferencesFoundInFinalReferenceHandling());
        this.builders[530].add(timeStampMicros, event.getPhantomReferencesFoundInFinalReferenceHandling());
        this.builders[531].add(timeStampMicros, event.getSoftReferenceHandlingDuration() * 1000L);
        this.builders[532].add(timeStampMicros, event.getSoftReferenceHandlingCpuTime() * 1000L);
        this.builders[533].add(timeStampMicros, event.getWeakReferenceHandlingDuration() * 1000L);
        this.builders[534].add(timeStampMicros, event.getWeakReferenceHandlingCpuTime() * 1000L);
        this.builders[535].add(timeStampMicros, event.getFinalReferenceHandlingDuration() * 1000L);
        this.builders[536].add(timeStampMicros, event.getFinalReferenceHandlingCpuTime() * 1000L);
        this.builders[537].add(timeStampMicros, event.getPhantomReferenceHandlingDuration() * 1000L);
        this.builders[538].add(timeStampMicros, event.getPhantomReferenceHandlingCpuTime() * 1000L);
        this.builders[539].add(timeStampMicros, event.getJNIWeakReferenceHandlingDuration() * 1000L);
        this.builders[540].add(timeStampMicros, event.getJNIWeakReferenceHandlingCpuTime() * 1000L);
        this.builders[541].add(timeStampMicros, event.getSoftReferencesResurrectedByPolicy());
        this.builders[542].add(timeStampMicros, event.getJNIWeakRefsAlive());
        this.builders[543].add(timeStampMicros, event.getJNIWeakRefsDeads());
        this.builders[544].add(timeStampMicros, event.getTransitionToSingleThreadingDuration() * 1000L);
        this.builders[545].add(timeStampMicros, event.getTransitionToSingleThreadingCpuTime() * 1000L);
        this.builders[546].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[547].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[548].add(timeStampMicros, event.getPageFaults());
        this.builders[549].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[550].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventOldGenRefHandling(GcEventOldGenRefHandling event, long timeStampMicros) throws IOException {
        this.builders[551].add(timeStampMicros, event.getSoftReferencesFoundInPreprocessing());
        this.builders[552].add(timeStampMicros, event.getDeadSoftReferencesFoundInPreprocessing());
        this.builders[553].add(timeStampMicros, event.getSoftReferencesResurrectedInPreprocessing());
        this.builders[554].add(timeStampMicros, event.getFinalReferencesEnqueued());
        this.builders[555].add(timeStampMicros, event.getFinalReferencesFound());
        this.builders[556].add(timeStampMicros, event.getPhantomReferencesEnqueued());
        this.builders[557].add(timeStampMicros, event.getPhantomReferencesFound());
        this.builders[558].add(timeStampMicros, event.getSoftReferencesCleared());
        this.builders[559].add(timeStampMicros, event.getSoftReferencesEnqueued());
        this.builders[560].add(timeStampMicros, event.getSoftReferencesFound());
        this.builders[561].add(timeStampMicros, event.getSoftReferencesNotCleared());
        this.builders[562].add(timeStampMicros, event.getSoftReferenceMaxLastUsedTime() * 1000L);
        this.builders[563].add(timeStampMicros, event.getWeakReferencesCleared());
        this.builders[564].add(timeStampMicros, event.getWeakReferencesEnqueued());
        this.builders[565].add(timeStampMicros, event.getWeakReferencesFound());
        this.builders[566].add(timeStampMicros, event.getSoftReferencesFoundInSoftReferenceHandling());
        this.builders[567].add(timeStampMicros, event.getWeakReferencesFoundInSoftReferenceHandling());
        this.builders[568].add(timeStampMicros, event.getFinalReferencesFoundInSoftReferenceHandling());
        this.builders[569].add(timeStampMicros, event.getPhantomReferencesFoundInSoftReferenceHandling());
        this.builders[570].add(timeStampMicros, event.getSoftReferencesFoundInPhantomReferenceHandling());
        this.builders[571].add(timeStampMicros, event.getWeakReferencesFoundInPhantomReferenceHandling());
        this.builders[572].add(timeStampMicros, event.getFinalReferencesFoundInPhantomReferenceHandling());
        this.builders[573].add(timeStampMicros, event.getPhantomReferencesFoundInPhantomReferenceHandling());
        this.builders[574].add(timeStampMicros, event.getSoftReferencesFoundInFinalReferenceHandling());
        this.builders[575].add(timeStampMicros, event.getWeakReferencesFoundInFinalReferenceHandling());
        this.builders[576].add(timeStampMicros, event.getFinalReferencesFoundInFinalReferenceHandling());
        this.builders[577].add(timeStampMicros, event.getPhantomReferencesFoundInFinalReferenceHandling());
        this.builders[578].add(timeStampMicros, event.getSoftReferenceHandlingDuration() * 1000L);
        this.builders[579].add(timeStampMicros, event.getSoftReferenceHandlingCpuTime() * 1000L);
        this.builders[580].add(timeStampMicros, event.getWeakReferenceHandlingDuration() * 1000L);
        this.builders[581].add(timeStampMicros, event.getWeakReferenceHandlingCpuTime() * 1000L);
        this.builders[582].add(timeStampMicros, event.getFinalReferenceHandlingDuration() * 1000L);
        this.builders[583].add(timeStampMicros, event.getFinalReferenceHandlingCpuTime() * 1000L);
        this.builders[584].add(timeStampMicros, event.getPhantomReferenceHandlingDuration() * 1000L);
        this.builders[585].add(timeStampMicros, event.getPhantomReferenceHandlingCpuTime() * 1000L);
        this.builders[586].add(timeStampMicros, event.getJNIWeakReferenceHandlingDuration() * 1000L);
        this.builders[587].add(timeStampMicros, event.getJNIWeakReferenceHandlingCpuTime() * 1000L);
        this.builders[588].add(timeStampMicros, event.getSoftReferencesResurrectedByPolicy());
        this.builders[589].add(timeStampMicros, event.getJNIWeakRefsAlive());
        this.builders[590].add(timeStampMicros, event.getJNIWeakRefsDeads());
        this.builders[591].add(timeStampMicros, event.getTransitionToSingleThreadingDuration() * 1000L);
        this.builders[592].add(timeStampMicros, event.getTransitionToSingleThreadingCpuTime() * 1000L);
        this.builders[593].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[594].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[595].add(timeStampMicros, event.getPageFaults());
        this.builders[596].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[597].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventYoungGenRefHandling(GcEventYoungGenRefHandling event, long timeStampMicros) throws IOException {
        this.builders[598].add(timeStampMicros, event.getSoftReferencesFoundInPreprocessing());
        this.builders[599].add(timeStampMicros, event.getDeadSoftReferencesFoundInPreprocessing());
        this.builders[600].add(timeStampMicros, event.getSoftReferencesResurrectedInPreprocessing());
        this.builders[601].add(timeStampMicros, event.getFinalReferencesEnqueued());
        this.builders[602].add(timeStampMicros, event.getFinalReferencesFound());
        this.builders[603].add(timeStampMicros, event.getPhantomReferencesEnqueued());
        this.builders[604].add(timeStampMicros, event.getPhantomReferencesFound());
        this.builders[605].add(timeStampMicros, event.getSoftReferencesCleared());
        this.builders[606].add(timeStampMicros, event.getSoftReferencesEnqueued());
        this.builders[607].add(timeStampMicros, event.getSoftReferencesFound());
        this.builders[608].add(timeStampMicros, event.getSoftReferencesNotCleared());
        this.builders[609].add(timeStampMicros, event.getSoftReferenceMaxLastUsedTime() * 1000L);
        this.builders[610].add(timeStampMicros, event.getWeakReferencesCleared());
        this.builders[611].add(timeStampMicros, event.getWeakReferencesEnqueued());
        this.builders[612].add(timeStampMicros, event.getWeakReferencesFound());
        this.builders[613].add(timeStampMicros, event.getSoftReferencesFoundInSoftReferenceHandling());
        this.builders[614].add(timeStampMicros, event.getWeakReferencesFoundInSoftReferenceHandling());
        this.builders[615].add(timeStampMicros, event.getFinalReferencesFoundInSoftReferenceHandling());
        this.builders[616].add(timeStampMicros, event.getPhantomReferencesFoundInSoftReferenceHandling());
        this.builders[617].add(timeStampMicros, event.getSoftReferencesFoundInPhantomReferenceHandling());
        this.builders[618].add(timeStampMicros, event.getWeakReferencesFoundInPhantomReferenceHandling());
        this.builders[619].add(timeStampMicros, event.getFinalReferencesFoundInPhantomReferenceHandling());
        this.builders[620].add(timeStampMicros, event.getPhantomReferencesFoundInPhantomReferenceHandling());
        this.builders[621].add(timeStampMicros, event.getSoftReferencesFoundInFinalReferenceHandling());
        this.builders[622].add(timeStampMicros, event.getWeakReferencesFoundInFinalReferenceHandling());
        this.builders[623].add(timeStampMicros, event.getFinalReferencesFoundInFinalReferenceHandling());
        this.builders[624].add(timeStampMicros, event.getPhantomReferencesFoundInFinalReferenceHandling());
        this.builders[625].add(timeStampMicros, event.getSoftReferenceHandlingDuration() * 1000L);
        this.builders[626].add(timeStampMicros, event.getSoftReferenceHandlingCpuTime() * 1000L);
        this.builders[627].add(timeStampMicros, event.getWeakReferenceHandlingDuration() * 1000L);
        this.builders[628].add(timeStampMicros, event.getWeakReferenceHandlingCpuTime() * 1000L);
        this.builders[629].add(timeStampMicros, event.getFinalReferenceHandlingDuration() * 1000L);
        this.builders[630].add(timeStampMicros, event.getFinalReferenceHandlingCpuTime() * 1000L);
        this.builders[631].add(timeStampMicros, event.getPhantomReferenceHandlingDuration() * 1000L);
        this.builders[632].add(timeStampMicros, event.getPhantomReferenceHandlingCpuTime() * 1000L);
        this.builders[633].add(timeStampMicros, event.getJNIWeakReferenceHandlingDuration() * 1000L);
        this.builders[634].add(timeStampMicros, event.getJNIWeakReferenceHandlingCpuTime() * 1000L);
        this.builders[635].add(timeStampMicros, event.getSoftReferencesResurrectedByPolicy());
        this.builders[636].add(timeStampMicros, event.getJNIWeakRefsAlive());
        this.builders[637].add(timeStampMicros, event.getJNIWeakRefsDeads());
        this.builders[638].add(timeStampMicros, event.getTransitionToSingleThreadingDuration() * 1000L);
        this.builders[639].add(timeStampMicros, event.getTransitionToSingleThreadingCpuTime() * 1000L);
        this.builders[640].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[641].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[642].add(timeStampMicros, event.getPageFaults());
        this.builders[643].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[644].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventPartialRefHandling(GcEventPartialRefHandling event, long timeStampMicros) throws IOException {
        this.builders[645].add(timeStampMicros, event.getSoftReferencesFoundInPreprocessing());
        this.builders[646].add(timeStampMicros, event.getDeadSoftReferencesFoundInPreprocessing());
        this.builders[647].add(timeStampMicros, event.getSoftReferencesResurrectedInPreprocessing());
        this.builders[648].add(timeStampMicros, event.getFinalReferencesEnqueued());
        this.builders[649].add(timeStampMicros, event.getFinalReferencesFound());
        this.builders[650].add(timeStampMicros, event.getPhantomReferencesEnqueued());
        this.builders[651].add(timeStampMicros, event.getPhantomReferencesFound());
        this.builders[652].add(timeStampMicros, event.getSoftReferencesCleared());
        this.builders[653].add(timeStampMicros, event.getSoftReferencesEnqueued());
        this.builders[654].add(timeStampMicros, event.getSoftReferencesFound());
        this.builders[655].add(timeStampMicros, event.getSoftReferencesNotCleared());
        this.builders[656].add(timeStampMicros, event.getSoftReferenceMaxLastUsedTime() * 1000L);
        this.builders[657].add(timeStampMicros, event.getWeakReferencesCleared());
        this.builders[658].add(timeStampMicros, event.getWeakReferencesEnqueued());
        this.builders[659].add(timeStampMicros, event.getWeakReferencesFound());
        this.builders[660].add(timeStampMicros, event.getSoftReferencesFoundInSoftReferenceHandling());
        this.builders[661].add(timeStampMicros, event.getWeakReferencesFoundInSoftReferenceHandling());
        this.builders[662].add(timeStampMicros, event.getFinalReferencesFoundInSoftReferenceHandling());
        this.builders[663].add(timeStampMicros, event.getPhantomReferencesFoundInSoftReferenceHandling());
        this.builders[664].add(timeStampMicros, event.getSoftReferencesFoundInPhantomReferenceHandling());
        this.builders[665].add(timeStampMicros, event.getWeakReferencesFoundInPhantomReferenceHandling());
        this.builders[666].add(timeStampMicros, event.getFinalReferencesFoundInPhantomReferenceHandling());
        this.builders[667].add(timeStampMicros, event.getPhantomReferencesFoundInPhantomReferenceHandling());
        this.builders[668].add(timeStampMicros, event.getSoftReferencesFoundInFinalReferenceHandling());
        this.builders[669].add(timeStampMicros, event.getWeakReferencesFoundInFinalReferenceHandling());
        this.builders[670].add(timeStampMicros, event.getFinalReferencesFoundInFinalReferenceHandling());
        this.builders[671].add(timeStampMicros, event.getPhantomReferencesFoundInFinalReferenceHandling());
        this.builders[672].add(timeStampMicros, event.getSoftReferenceHandlingDuration() * 1000L);
        this.builders[673].add(timeStampMicros, event.getSoftReferenceHandlingCpuTime() * 1000L);
        this.builders[674].add(timeStampMicros, event.getWeakReferenceHandlingDuration() * 1000L);
        this.builders[675].add(timeStampMicros, event.getWeakReferenceHandlingCpuTime() * 1000L);
        this.builders[676].add(timeStampMicros, event.getFinalReferenceHandlingDuration() * 1000L);
        this.builders[677].add(timeStampMicros, event.getFinalReferenceHandlingCpuTime() * 1000L);
        this.builders[678].add(timeStampMicros, event.getPhantomReferenceHandlingDuration() * 1000L);
        this.builders[679].add(timeStampMicros, event.getPhantomReferenceHandlingCpuTime() * 1000L);
        this.builders[680].add(timeStampMicros, event.getJNIWeakReferenceHandlingDuration() * 1000L);
        this.builders[681].add(timeStampMicros, event.getJNIWeakReferenceHandlingCpuTime() * 1000L);
        this.builders[682].add(timeStampMicros, event.getSoftReferencesResurrectedByPolicy());
        this.builders[683].add(timeStampMicros, event.getJNIWeakRefsAlive());
        this.builders[684].add(timeStampMicros, event.getJNIWeakRefsDeads());
        this.builders[685].add(timeStampMicros, event.getTransitionToSingleThreadingDuration() * 1000L);
        this.builders[686].add(timeStampMicros, event.getTransitionToSingleThreadingCpuTime() * 1000L);
        this.builders[687].add(timeStampMicros, event.getCpuTime() * 1000L);
        this.builders[688].add(timeStampMicros, event.getDuration() * 1000L);
        this.builders[689].add(timeStampMicros, event.getPageFaults());
        this.builders[690].add(timeStampMicros, event.getMajorPageFaults());
        this.builders[691].add(timeStampMicros, event.getMinorPageFaults());
    }

    private void writeForGcEventCmsAborted(GcEventCmsAborted event, long timeStampMicros) throws IOException {
        this.builders[692].add(timeStampMicros, event.getFullGcsSinceConcGc());
        this.builders[693].add(timeStampMicros, event.getFullGcsBeforeCompaction());
    }

    private void writeForGcEventParallelSmallGcForcedFullGc(GcEventParallelSmallGcForcedFullGc event, long timeStampMicros) throws IOException {
        this.builders[694].add(timeStampMicros, event.getAveragePromoted());
    }

    private void writeForGcEventYoungGenPromotionFailure(GcEventYoungGenPromotionFailure event, long timeStampMicros) throws IOException {
        this.builders[695].add(timeStampMicros, event.getLargestContiguousBlockInOld());
        this.builders[696].add(timeStampMicros, event.getCausingObjectSize());
        this.builders[697].add(timeStampMicros, event.getFailedPromotionsCount());
    }

    private void addLoadInfo(long timeStamp, double[] load, double[] virtCpu) throws IOException {
        this.builders[704].add(timeStamp, Math.round(load[0] * 1000.0));
        this.builders[705].add(timeStamp, Math.round(load[1] * 1000.0));
        this.builders[706].add(timeStamp, Math.round(load[2] * 1000.0));
        if (virtCpu[0] >= 0.0) {
            this.builders[707].add(timeStamp, Math.round(virtCpu[0] * 1000.0));
        }
    }

    @Override
    protected int[] getListTypes() {
        int[] result = new int[717];
        for (int i = 0; i < result.length; ++i) {
            result[i] = 0;
        }
        result[698] = 2;
        result[699] = 2;
        result[700] = 2;
        result[701] = 2;
        return result;
    }

    @Override
    protected DataConverter getConverter(int index) {
        if (index == 700 || index == 699 || index == 698 || index == 701) {
            return new GcTimeSeriesAnnotaionConverter();
        }
        return null;
    }

    public static void main(String[] args) {
        String constantName;
        int classIdx;
        int i;
        int classIdx2;
        Class[] statClasses = new Class[]{GcStatisticBase.class, GcStatisticConcMarkSweepGc.class, GcStatisticG1Gc.class, GcStatisticParallelGc.class, GcStatisticParallelNewGc.class, GcStatisticParallelOldGc.class, GcStatisticSerialGc.class};
        Class[] eventClasses = new Class[]{GcEventClassunloadingPhase1.class, GcEventClassunloadingPhase2.class, GcEventCmsAbortablePrecleaning.class, GcEventCmsFinalMarking.class, GcEventCmsInitialMarking.class, GcEventCmsMarking.class, GcEventCmsPrecleaning.class, GcEventCmsSweeping.class, GcEventG1BitmapClearing.class, GcEventG1Cleanup.class, GcEventG1EmptyRegionsReclaim.class, GcEventG1ConcurrentCleanup.class, GcEventG1Counting.class, GcEventG1FinalMarking.class, GcEventG1InitialMarking.class, GcEventG1Marking.class, GcEventG1RootScanning.class, GcEventG1IncrementalGc.class, GcEventG1MarkSweepGc.class, GcEventG1ParallelFullGc.class, GcEventParallelGcMarkSweep.class, GcEventParallelGcParallelCompact.class, GcEventParallelGcScavenge.class, GcEventParallelNewGc.class, GcEventSerialNewGc.class, GcEventTenuredGc.class, GcEventAllGenRefHandling.class, GcEventOldGenRefHandling.class, GcEventYoungGenRefHandling.class, GcEventPartialRefHandling.class, GcEventCmsAborted.class, GcEventG1MarkingAborted.class, GcEventParallelSmallGcForcedFullGc.class, GcEventSkippedGc.class, GcEventYoungGenPromotionFailure.class};
        HashSet<String> blacklist = new HashSet<String>();
        blacklist.addAll(Arrays.asList("getNrOfFullGcs", "getCumulativeDuration", "getCumulativeCpuTime", "getCumulativePageFaults", "getCumulativeMajorPageFaults", "getCumulativeMinorPageFaults", "getCumulativeNrOfUnloadedNonArrayClasses", "getCumulativeNrOfUnloadedArrayClasses", "getCumulativeBytesAllocatedInPerm", "getCumulativeBytesFreedInPerm", "getCumulativeBytesAllocatedInNonPerm", "getCumulativeBytesFreedInNonPerm", "getClearedSoftRefsSum", "getEnqueuedSoftRefsSum", "getClearedWeakRefsSum", "getEnqueuedWeakRefsSum", "getEnqueuedFinalRefsSum", "getEnqueuedPhantomRefsSum", "getPromotionFailureNr", "getTimestamp", "getFirstPromotionFailureTimestamp", "getLastEventEndTimeStamp", "getNrOfEvents", "getMillisSinceLastConcGC"));
        HashSet<String> durationGetters = new HashSet<String>(GcTimeSeriesCollectionImpl.findGetters(GcDurationEventBase.class, true, blacklist));
        HashSet<String> generationalGetters = new HashSet<String>(GcTimeSeriesCollectionImpl.findGetters(GcEventGenerational.class, true, blacklist));
        ArrayList[] statGetters = new ArrayList[statClasses.length];
        for (int i2 = 0; i2 < statClasses.length; ++i2) {
            statGetters[i2] = GcTimeSeriesCollectionImpl.findGetters(statClasses[i2], true, blacklist);
        }
        ArrayList[] eventGetters = new ArrayList[eventClasses.length];
        ArrayList[] eventGetterGroups = new ArrayList[eventClasses.length];
        boolean[] isDuration = new boolean[eventClasses.length];
        boolean[] isGenerational = new boolean[eventClasses.length];
        for (int classIdx3 = 0; classIdx3 < eventClasses.length; ++classIdx3) {
            String className = eventClasses[classIdx3].getSimpleName();
            int start = "GcEvent".length();
            String eventName = Character.toLowerCase(className.charAt(start)) + className.substring(start + 1);
            eventGetters[classIdx3] = GcTimeSeriesCollectionImpl.findGetters(eventClasses[classIdx3], false, blacklist);
            eventGetterGroups[classIdx3] = new ArrayList(eventGetters[classIdx3].size());
            isDuration[classIdx3] = GcDurationEventBase.class.isAssignableFrom(eventClasses[classIdx3]);
            isGenerational[classIdx3] = GcEventGenerational.class.isAssignableFrom(eventClasses[classIdx3]);
            int specialGettersCount = eventGetters[classIdx3].size();
            if (isDuration[classIdx3]) {
                specialGettersCount -= durationGetters.size();
            }
            if (isGenerational[classIdx3]) {
                specialGettersCount -= generationalGetters.size();
            }
            boolean ownGroup = isDuration[classIdx3] && specialGettersCount > 3;
            for (String getter : eventGetters[classIdx3]) {
                String groupName = eventName;
                if (ownGroup && !durationGetters.contains(getter)) {
                    groupName = generationalGetters.contains(getter) ? (String)groupName + ", generational" : (String)groupName + ", " + (String)eventName + "Details";
                }
                eventGetterGroups[classIdx3].add(groupName);
            }
        }
        ArrayList<TimeSeriesConstant> seriesIndexConstants = new ArrayList<TimeSeriesConstant>();
        for (classIdx2 = 0; classIdx2 < statClasses.length; ++classIdx2) {
            Class theClass = statClasses[classIdx2];
            for (String getter : statGetters[classIdx2]) {
                String constantName2 = GcTimeSeriesCollectionImpl.getConstantFromMethodName(getter, theClass.getSimpleName(), false);
                TimeSeriesConstant constant = new TimeSeriesConstant(constantName2, getter);
                if (seriesIndexConstants.contains(constant)) continue;
                seriesIndexConstants.add(constant);
            }
        }
        for (classIdx2 = 0; classIdx2 < eventClasses.length; ++classIdx2) {
            Class theClass = eventClasses[classIdx2];
            for (int i3 = 0; i3 < eventGetters[classIdx2].size(); ++i3) {
                String getter = (String)eventGetters[classIdx2].get(i3);
                String group = (String)eventGetterGroups[classIdx2].get(i3);
                String constantName3 = GcTimeSeriesCollectionImpl.getConstantFromMethodName(getter, theClass.getSimpleName(), true);
                TimeSeriesConstant constant = new TimeSeriesConstant(constantName3, getter, group, true);
                assert (!seriesIndexConstants.contains(constant));
                seriesIndexConstants.add(constant);
            }
        }
        System.out.println("\n\n\n");
        System.out.println("##################### TimeSeries constants (GcTimeSeriesCollection.java) ############################");
        System.out.println("\n\n\n");
        String[][] customSeries = new String[][]{{"GC_INFO", "The index for GC alerts of INFO level"}, {"GC_WARNING", "The index for GC alerts of WARNING level"}, {"GC_ERROR", "The index for GC alerts of ERROR level"}, {"CONCURRENT_GC_DURATION", "The index for concurrent GC duration ranges markers"}, {"PROMOTIONS_TO_OLD", "The index for number of bytes promoted to old"}, {"SURVIVING_YOUNG", "The index for the number of bytes that survived young GCs"}, {"SYSTEM_LOAD_1MIN_AVERAGE", "The index for the system load 1min average"}, {"SYSTEM_LOAD_5MIN_AVERAGE", "The index for the system load 5min average"}, {"SYSTEM_LOAD_15MIN_AVERAGE", "The index for the system load 15min average"}, {"VIRTUAL_CPU_UTILIZATION", "The index for the virtual CPU utilization"}, {"BYTES_IN_YOUNG_DIFFERENCE", "The difference of the number of bytes used in the young generation before and after this GC."}, {"BYTES_IN_TO_DIFFERENCE", "The difference of the number of bytes used in the to-space before and after this GC."}, {"BYTES_IN_FROM_DIFFERENCE", "The difference of the number of bytes used in the from-space before and after this GC."}, {"BYTES_IN_EDEN_DIFFERENCE", "The difference of the number of bytes used in the eden-space before and after this GC."}, {"BYTES_IN_OLD_DIFFERENCE", "The difference of the number of bytes used in the old generation before and after this GC."}, {"BYTES_IN_NON_PERM_DIFFERENCE", "The difference of the number of bytes used in the Java heap before and after this GC."}, {"BYTES_IN_PERM_DIFFERENCE", "The difference of the number of bytes used in the perm generation before and after this GC."}, {"BYTES_IN_CLASS_SPACE_DIFFERENCE", "The difference of the number of bytes used in the class space before and after this GC."}, {"TIME_SINCE_LAST_CONC_GC", "The time since the end of the last concurrent GC"}};
        for (i = 0; i < seriesIndexConstants.size(); ++i) {
            TimeSeriesConstant constant = (TimeSeriesConstant)seriesIndexConstants.get(i);
            System.out.println("    /**");
            System.out.println("     * The index for the time series holding the result of " + constant.getter + "()");
            System.out.println("     */");
            System.out.println("    public static final int " + constant.name + " = " + i + ";");
            System.out.println();
        }
        for (i = 0; i < customSeries.length; ++i) {
            System.out.println("    /**");
            System.out.println("     * " + customSeries[i][1]);
            System.out.println("     */");
            System.out.println("    public static final int " + customSeries[i][0] + " = " + (i + seriesIndexConstants.size()) + ";");
            System.out.println();
        }
        System.out.println("    /**");
        System.out.println("     * The number of series.");
        System.out.println("     */");
        System.out.println("    public static final int NR_OF_SERIES = " + (seriesIndexConstants.size() + customSeries.length) + ";");
        System.out.println();
        System.out.println("\n\n\n");
        System.out.println("############### TimeSeries to attribute mapping #####################");
        System.out.println("##              add this to GcTimeSeriesMetaData                   ##");
        System.out.println("\n\n\n");
        for (i = 0; i < seriesIndexConstants.size(); ++i) {
            TimeSeriesConstant constant = (TimeSeriesConstant)seriesIndexConstants.get(i);
            String attributeName = GcTimeSeriesCollectionImpl.typoFixup(constant.getter.substring("get".length()));
            System.out.println("        add(" + constant.name + ",");
            if (constant.event) {
                System.out.println("            GcEventAttribute." + GcTimeSeriesCollectionImpl.toConstantFormat(attributeName) + ", " + constant.groupName + ");");
                continue;
            }
            System.out.println("            GcStatisticAttribute." + GcTimeSeriesCollectionImpl.toConstantFormat(attributeName) + ");");
        }
        System.out.println("\n\n\n");
        System.out.println("##################### GcTimeSeriesCollectionImpl.createTimeSeries ############################");
        System.out.println("\n\n\n");
        for (classIdx = 0; classIdx < statClasses.length; ++classIdx) {
            boolean qualify;
            if (statGetters[classIdx].size() == 0) continue;
            String className = statClasses[classIdx].getSimpleName();
            if (classIdx == 0) {
                for (String getter : statGetters[classIdx]) {
                    qualify = false;
                    constantName = GcTimeSeriesCollectionImpl.getConstantFromMethodName(getter, className, qualify);
                    GcTimeSeriesCollectionImpl.writeGetter(constantName, getter, null, "gcStatistic", "            ");
                }
                continue;
            }
            System.out.println();
            System.out.println("            if (gcStatistic instanceof " + className + ") {");
            for (String getter : statGetters[classIdx]) {
                qualify = false;
                constantName = GcTimeSeriesCollectionImpl.getConstantFromMethodName(getter, className, qualify);
                GcTimeSeriesCollectionImpl.writeGetter(constantName, getter, className, "gcStatistic", "                ");
            }
            System.out.println("            }");
        }
        System.out.println();
        System.out.println();
        System.out.println("            for(GcEventBase event : gcStatistic.getEvents()) {");
        for (classIdx = 0; classIdx < eventClasses.length; ++classIdx) {
            if (eventGetters[classIdx].size() == 0) continue;
            String className = eventClasses[classIdx].getSimpleName();
            System.out.println();
            System.out.println("                if (event instanceof " + className + ") {");
            System.out.println("                    writeFor" + className + "((" + className + ") event, timeStampMicros);");
            System.out.println("                    continue;");
            System.out.println("                }");
        }
        System.out.println("            }");
        System.out.println("\n\n\n");
        System.out.println("###################################################################");
        System.out.println("\n\n\n");
        for (classIdx = 0; classIdx < eventClasses.length; ++classIdx) {
            if (eventGetters[classIdx].size() == 0) continue;
            String className = eventClasses[classIdx].getSimpleName();
            System.out.println();
            System.out.println("    private void writeFor" + className + "(" + className + " event, long timeStampMicros) throws IOException {");
            for (String getter : eventGetters[classIdx]) {
                boolean qualify = true;
                constantName = GcTimeSeriesCollectionImpl.getConstantFromMethodName(getter, className, qualify);
                GcTimeSeriesCollectionImpl.writeGetter(constantName, getter, null, "event", "        ");
            }
            System.out.println("    }");
        }
    }

    private static ArrayList<String> findGetters(Class<?> theClass, boolean justDeclared, HashSet<String> blacklist) {
        Method[] allMethods;
        ArrayList<String> getters = new ArrayList<String>();
        for (Method m : allMethods = justDeclared ? theClass.getDeclaredMethods() : theClass.getMethods()) {
            String getterName = m.getName();
            if (!getterName.startsWith("get") || m.getReturnType() != Long.TYPE && m.getReturnType() != Integer.TYPE || blacklist.contains(getterName)) continue;
            getters.add(getterName);
        }
        return getters;
    }

    private static String typoFixup(String getterName) {
        String result = getterName.replaceAll("Equeue", "Enqueue");
        result = result.replaceAll("Coalesable", "Coalescable");
        result = result.replaceAll("MaxStopTheWorldDuration", "MaxPauseTime");
        return result;
    }

    private static void writeGetter(String constantName, String getterName, String className, String instanceName, String indent) {
        boolean concurrentCheck;
        boolean skipCheck = getterName.endsWith("AfterGc");
        boolean bl = concurrentCheck = skipCheck && (getterName.contains("BytesInTo") || getterName.contains("BytesInFrom") || getterName.contains("BytesInEden") || getterName.contains("BytesInYoung"));
        if (skipCheck) {
            System.out.println(indent + "// we don't want to collect \"AfterGc\" data for skipped GCs...");
            if (concurrentCheck) {
                System.out.println(indent + "if (! (skipped || isConcurrent)) {");
            } else {
                System.out.println(indent + "if (!skipped) {");
            }
            indent = indent + "    ";
        }
        System.out.println(indent + "builders[" + constantName + "].add(timeStampMicros,\n" + indent + "        " + (className == null ? instanceName + "." : "((" + className + ") " + instanceName + ").") + GcTimeSeriesCollectionImpl.getGetterCall(getterName) + ");");
        if (skipCheck) {
            indent = indent.substring(0, indent.length() - 4);
            System.out.println(indent + "}");
        }
    }

    private static String getConstantFromMethodName(String name, String className, boolean qualify) {
        String getterName = name.substring(3);
        StringBuilder indexConstantName = new StringBuilder();
        if (qualify) {
            if (className.startsWith("GcEvent")) {
                String eventName = className.substring("GcEvent".length());
                indexConstantName.append(GcTimeSeriesCollectionImpl.toConstantFormat(eventName));
                indexConstantName.append('_');
            } else if (className.startsWith("GcStatistic")) {
                String gcType = className.substring("GcStatistic".length());
                indexConstantName.append(GcTimeSeriesCollectionImpl.toConstantFormat(gcType));
                indexConstantName.append('_');
            } else assert (false);
        }
        indexConstantName.append(GcTimeSeriesCollectionImpl.toConstantFormat(GcTimeSeriesCollectionImpl.typoFixup(getterName)));
        String result = indexConstantName.toString();
        return result;
    }

    private static String toConstantFormat(String input) {
        StringBuilder result = new StringBuilder();
        boolean lastWasLower = true;
        boolean lastWasDigit = false;
        boolean lastWasUpper = false;
        for (int ii = 0; ii < input.length(); ++ii) {
            char c = input.charAt(ii);
            if (Character.isUpperCase(c)) {
                if (!lastWasUpper && ii != 0) {
                    result.append('_');
                }
                result.append(c);
                lastWasUpper = true;
                lastWasLower = false;
                lastWasDigit = false;
                continue;
            }
            if (Character.isDigit(c)) {
                if (lastWasLower && ii != 0) {
                    result.append('_');
                }
                result.append(c);
                lastWasUpper = false;
                lastWasLower = false;
                lastWasDigit = true;
                continue;
            }
            if (lastWasDigit && ii != 0) {
                result.append('_');
            }
            result.append(Character.toUpperCase(c));
            lastWasUpper = false;
            lastWasLower = true;
            lastWasDigit = false;
        }
        return result.toString();
    }

    private static String getGetterCall(String getterName) {
        StringBuilder result = new StringBuilder();
        result.append(getterName);
        result.append("()");
        String tmp = getterName.toLowerCase();
        if (tmp.contains("duration") || tmp.contains("time") && !tmp.contains("timestamp")) {
            result.append(" * 1000");
        }
        return result.toString();
    }

    private static class TimeSeriesConstant {
        final String name;
        final String getter;
        final String groupName;
        private boolean event;

        public TimeSeriesConstant(String constantName, String getterName) {
            this(constantName, getterName, null, false);
        }

        public TimeSeriesConstant(String constant, String getter, String group, boolean event) {
            this.name = constant;
            this.getter = getter;
            this.groupName = group;
            this.event = event;
        }

        public int hashCode() {
            return this.getter.hashCode() ^ (this.groupName != null ? this.groupName.hashCode() : 0);
        }

        public boolean equals(Object obj) {
            if (this == obj) {
                return true;
            }
            if (obj != null && obj instanceof TimeSeriesConstant) {
                TimeSeriesConstant other = (TimeSeriesConstant)obj;
                return this.getter.equals(other.getter) && (this.groupName == null && other.groupName == null || this.groupName != null && this.groupName.equals(other.groupName));
            }
            return false;
        }
    }
}

