/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.resource.ProgressReporter;
import com.sap.jvm.profiling.resource.ResourceName;
import com.sap.jvm.profiling.resource.ResourceReader;
import com.sap.jvm.profiling.resource.ResourceWriter;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValue;
import com.sap.jvm.profiling.snapshot.gc.GcStatisticValueElement;
import com.sap.jvm.profiling.snapshot.gc.GcValueStatistic;
import com.sap.jvm.profiling.snapshot.impl.gc.GcStatisticValueIterator;
import com.sap.jvm.profiling.snapshot.impl.util.collections.ValueStatisticImpl;
import com.sap.jvm.profiling.snapshot.impl.util.column.GcStatisticValuesColumnImpl;
import com.sap.jvm.profiling.snapshot.impl.util.serializer.GcStatisticValuesSerializer;
import com.sap.jvm.profiling.snapshot.util.column.LongColumn;
import com.sap.jvm.profiling.util.splitarray.SplitArrayObject;
import com.sap.jvm.util.persistence.VersionMismatchException;
import java.io.IOException;

public final class GcValueStatisticImpl
extends ValueStatisticImpl<Long, GcStatisticValue>
implements GcValueStatistic {
    public static final int VERSION = 1;

    protected GcValueStatisticImpl(ResourceName name) {
        super(name, new LongColumn(), new GcStatisticValuesColumnImpl(), new GcStatisticValuesSerializer());
    }

    public GcValueStatisticImpl(ResourceReader reader, ResourceName name, ProgressReporter reporter) throws IOException {
        this(name);
        reader.readVersion(1);
        int numColumns = reader.readInt32();
        if (GcStatisticValueElement.values().length != numColumns) {
            throw new VersionMismatchException(numColumns, GcStatisticValueElement.values().length);
        }
        this.read(reader, I18n._s((String)"Reading the GC statistic ... (<%> %)"), reporter);
    }

    public static GcValueStatisticImpl create(ResourceName name, ProgressReporter reporter) throws IOException {
        GcStatisticValueIterator it = new GcStatisticValueIterator(name, reporter, I18n._s((String)"Creating the GC statistic ... (<%> %)"));
        SplitArrayObject keys = new SplitArrayObject(0);
        SplitArrayObject values = new SplitArrayObject(0);
        GcStatisticValue total = GcStatisticValue.EMPTY;
        int concurrencyGroup = 0;
        while (it.next()) {
            GcStatisticValue currentValue;
            keys.add((Object)it.getGcNr());
            GcStatisticValue value = it.getValue();
            values.add((Object)value);
            total = total.getSum(value);
            if (value.getElementValue(GcStatisticValueElement.GC_TYPE) != 3L) continue;
            ++concurrencyGroup;
            GcEventBase[] events = it.getEvent().getEvents();
            long startTime = events.length > 0 ? events[0].getTimestamp() : it.getEvent().getTimestamp();
            for (int i = values.size() - 1; i > 0 && (currentValue = (GcStatisticValue)values.get(i)).getElementValue(GcStatisticValueElement.TIME_STAMP) >= startTime; --i) {
                currentValue.setConcurrencyGroup(concurrencyGroup);
            }
        }
        GcValueStatisticImpl result = new GcValueStatisticImpl(name);
        result.initValues(keys.asList(), values.asList(), total);
        return result;
    }

    @Override
    public void write(ResourceWriter writer, ProgressReporter reporter) throws IOException {
        writer.writeVersion(1);
        writer.writeInt32(GcStatisticValueElement.values().length);
        this.write(writer, I18n._s((String)"Writing the GC statistic ... (<%> %)"), reporter);
    }
}

