/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc.report;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;

public class GcReportApplicationToGcRatioBuilder
implements GcReportBuilder {
    public static final double RED_PERCENTAGE_THRESHOLD = 40.0;
    public static final double YELLOW_PERCENTAGE_THRESHOLD = 20.0;
    private long elapsedTime = 0L;
    private long gcTime = 0L;
    private double percentage;

    public GcReportApplicationToGcRatioBuilder(GcSnapshot snapshot) {
        this.elapsedTime = snapshot.getEndCollectionTimeStamp() > 0L ? snapshot.getEndCollectionTimeStamp() - snapshot.getStartCollectionTimeStamp() : -1L;
        this.gcTime = snapshot.getDurationTotal();
        this.percentage = this.elapsedTime > 0L ? (double)this.gcTime / ((double)this.elapsedTime * 10.0) : (this.gcTime > 0L ? 100.0 : 0.0);
    }

    @Override
    public String getReportTitle() {
        return I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"Application vs. GC Time Ratio");
    }

    @Override
    public void handle(GcStatistic statistic) {
    }

    @Override
    public GcReportNode getReport() {
        GcReportNode duration = GcReportNode.getDuration(this.gcTime, false);
        GcReportNode percent = GcReportNode.getPercentage(this.percentage, this.percentage > 40.0);
        GcReportNode elapsed = GcReportNode.getDuration(this.elapsedTime * 1000L, false);
        GcReportNode.ComposedText composed = new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"In total, {0} ({1} of the overall elapsed time of {2}) were spent in the Garbage Collection."), duration, percent, elapsed);
        return new GcReportNode.Paragraph(composed);
    }

    @Override
    public GcReportBuilder.Severity getSeverity() {
        if (this.gcTime == 0L) {
            return GcReportBuilder.Severity.NOTHING;
        }
        return this.percentage > 40.0 ? GcReportBuilder.Severity.RED : (this.percentage > 20.0 ? GcReportBuilder.Severity.YELLOW : GcReportBuilder.Severity.GREEN);
    }
}

