/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc.report;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcDurationEventBase;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcStatisticConcMarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcStatisticG1Gc;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import java.util.ArrayList;

public class GcReportConcurrentGcs
implements GcReportBuilder {
    public static final long RED_MIN_CONC_DISTANCE = 1000L;
    public static final long YELLOW_MIN_CONC_DISTANCE = 10000L;
    public static final long RED_AVG_CONC_DISTANCE = 10000L;
    public static final long YELLOW_AVG_CONC_DISTANCE = 100000L;
    public static final long MAX_DISTANCE_IN_CLUSTERS = 5000L;
    public static final double RED_PAUSE_PERCENTAGE = 50.0;
    public static final double YELLOW_PAUSE_PERCENTAGE = 40.0;
    private long elapsedTime = 0L;
    private long concGcTotalPauseMicros = 0L;
    private long concGcCount = 0L;
    private long concGcTotalMicros = 0L;
    private long minMillisBetweenConcGCs = Long.MAX_VALUE;
    private long totalMillisBetweenConcGCs = 0L;
    private int clusterCount;
    private int currentClusterSize;
    private int largestClusterSize;

    public GcReportConcurrentGcs(GcSnapshot snapshot) {
        this.elapsedTime = snapshot.getEndCollectionTimeStamp() > 0L ? snapshot.getEndCollectionTimeStamp() - snapshot.getStartCollectionTimeStamp() : -1L;
        this.concGcTotalPauseMicros = snapshot.getProperties().getDurationConc();
    }

    @Override
    public void handle(GcStatistic statistic) {
        boolean isConcurrent;
        boolean bl = isConcurrent = statistic.getGcType() == GcType.CONC_MARK_SWEEP_GC && ((GcStatisticConcMarkSweepGc)statistic).isConcurrent() || statistic.getGcType() == GcType.GARBAGE_FIRST_GC && ((GcStatisticG1Gc)statistic).isConcurrent();
        if (isConcurrent) {
            long millisSinceLastConc;
            GcEventBase[] events = statistic.getEvents();
            if (events.length == 0) {
                return;
            }
            ++this.concGcCount;
            long first = events[0].getTimestamp();
            GcEventBase lastEvent = events[events.length - 1];
            long last = lastEvent.getTimestamp();
            this.concGcTotalMicros += (last - first) * 1000L;
            if (lastEvent instanceof GcDurationEventBase) {
                this.concGcTotalMicros += ((GcDurationEventBase)lastEvent).getDuration();
            }
            if ((millisSinceLastConc = statistic.getMillisSinceLastConcGC()) > 0L) {
                this.totalMillisBetweenConcGCs += millisSinceLastConc;
                if (millisSinceLastConc < this.minMillisBetweenConcGCs) {
                    this.minMillisBetweenConcGCs = millisSinceLastConc;
                }
                if (millisSinceLastConc < 5000L) {
                    ++this.currentClusterSize;
                    if (this.currentClusterSize == 2) {
                        ++this.clusterCount;
                    }
                    this.largestClusterSize = Math.max(this.largestClusterSize, this.currentClusterSize);
                } else {
                    this.currentClusterSize = 0;
                }
            }
        }
    }

    @Override
    public String getReportTitle() {
        return I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"Concurrent GC Activity");
    }

    @Override
    public GcReportNode getReport() {
        ArrayList<GcReportNode> lines = new ArrayList<GcReportNode>();
        double percentage = this.elapsedTime > 0L ? (double)this.concGcTotalMicros / ((double)this.elapsedTime * 10.0) : (this.concGcTotalMicros > 0L ? 100.0 : 0.0);
        lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"In total {0} ({1}) of the overall elapsed time of {2} were spent in concurrent GCs."), GcReportNode.getDuration(this.concGcTotalMicros, false), GcReportNode.getPercentage(percentage, false), GcReportNode.getDuration(this.elapsedTime * 1000L, false)));
        percentage = 100.0 * (double)this.concGcTotalPauseMicros / (double)this.concGcTotalMicros;
        lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"The application was paused for {0} by concurrent GCs ({1} of concurrent GC time)."), GcReportNode.getDuration(this.concGcTotalPauseMicros, false), GcReportNode.getPercentage(percentage, percentage > 50.0)));
        if (this.concGcCount > 1L) {
            GcReportNode min = GcReportNode.getDuration(this.minMillisBetweenConcGCs * 1000L, this.minMillisBetweenConcGCs < 1000L);
            lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"The shortest time between concurrent GCs was {0}."), min));
            long avgMicrosBetweenConcGCs = 1000L * this.totalMillisBetweenConcGCs / this.concGcCount;
            GcReportNode avg = GcReportNode.getDuration(avgMicrosBetweenConcGCs, avgMicrosBetweenConcGCs < 10000L);
            lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"The average time between concurrent GCs was {0}."), avg));
            if (this.clusterCount == 1) {
                lines.add(new GcReportNode.Text(I18n._s((String)"{0} concurrent GCs occurred in a cluster, i.e. each less than {1} after the other.", (Object[])new Object[]{this.largestClusterSize, DataFormatter.getMicrosDurationText((long)5000000L)})));
            }
            if (this.clusterCount > 1) {
                lines.add(new GcReportNode.Text(I18n._s((String)"The concurrent GCs occurred in clusters, i.e. one less than {0} after the other.\nThere were {1} clusters, the largest containing {2} successive concurrent GCs.", (Object[])new Object[]{DataFormatter.getMicrosDurationText((long)5000000L), this.clusterCount, this.largestClusterSize})));
            }
        }
        lines.add(new GcReportNode.Text(""));
        lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"See the Time Series ({0}) for a graphical overview."), new GcReportNode.Link("gc_report_conc_gc_timeseries", null, new GcReportNode.Text("Concurrent GCs"))));
        return new GcReportNode.Paragraph(lines.toArray(new GcReportNode[lines.size()]));
    }

    @Override
    public GcReportBuilder.Severity getSeverity() {
        if (this.concGcCount == 0L) {
            return GcReportBuilder.Severity.NOTHING;
        }
        GcReportBuilder.Severity result = GcReportBuilder.Severity.GREEN;
        double pausePercentage = 100.0 * (double)this.concGcTotalPauseMicros / (double)this.concGcTotalMicros;
        if (pausePercentage > 50.0) {
            return GcReportBuilder.Severity.RED;
        }
        if (pausePercentage > 40.0) {
            result = GcReportBuilder.Severity.YELLOW;
        }
        if (this.concGcCount == 1L) {
            return result;
        }
        long avgTimeBetweenConcGCs = this.totalMillisBetweenConcGCs / (this.concGcCount - 1L);
        if (this.minMillisBetweenConcGCs < 1000L || avgTimeBetweenConcGCs < 10000L) {
            return GcReportBuilder.Severity.RED;
        }
        if (this.minMillisBetweenConcGCs < 10000L || avgTimeBetweenConcGCs < 100000L) {
            result = GcReportBuilder.Severity.YELLOW;
        }
        return result;
    }
}

