/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc.report;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventCmsAborted;
import com.sap.jvm.profiling.memory.event.GcEventG1MarkingAborted;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;

public class GcReportConcurrentModeFailures
implements GcReportBuilder {
    public static final int RED_GCS_THRESHOLD = 1;
    public static final int YELLOW_GCS_THRESHOLD = 0;
    private int concurrentModeFailures = 0;
    private int gcsWithConcModeFailure = 0;

    @Override
    public void handle(GcStatistic statistic) {
        boolean foundConcModeFailure = false;
        for (GcEventBase event : statistic.getEvents()) {
            if (event instanceof GcEventCmsAborted) {
                ++this.concurrentModeFailures;
                foundConcModeFailure = true;
            }
            if (!(event instanceof GcEventG1MarkingAborted)) continue;
            ++this.concurrentModeFailures;
            foundConcModeFailure = true;
        }
        if (foundConcModeFailure) {
            ++this.gcsWithConcModeFailure;
        }
    }

    @Override
    public String getReportTitle() {
        return I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"Concurrent Mode Failures");
    }

    @Override
    public GcReportNode getReport() {
        GcReportNode.ComposedText failures = new GcReportNode.ComposedText(I18n._ssn((String)"There was {0} concurrent mode failure in this snapshot.", (String)"There were {0} concurrent mode failures in this snapshot.", (int)this.concurrentModeFailures), GcReportNode.getNumber(this.concurrentModeFailures, this.gcsWithConcModeFailure > 1));
        GcReportNode.Text descrText = new GcReportNode.Text(I18n._s((String)"A concurrent mode failure is a concurrent GC that was aborted in favor of a stop-the-world GC."));
        return new GcReportNode.Paragraph(failures, descrText);
    }

    @Override
    public GcReportBuilder.Severity getSeverity() {
        return this.gcsWithConcModeFailure > 1 ? GcReportBuilder.Severity.RED : (this.gcsWithConcModeFailure > 0 ? GcReportBuilder.Severity.YELLOW : GcReportBuilder.Severity.NOTHING);
    }
}

