/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc.report;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcDurationEventBase;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventType;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import com.sap.jvm.tracing.Trace;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;

public class GcReportDurationByEventType
implements GcReportBuilder {
    public static final int OTHERS_COLOR = 0xB0B0B0;
    private static int[] colors;
    private static GcEventType[] eventTypeOrder;
    private HashMap<GcEventType, StatData> dataMap = new HashMap();
    private long totalEventsCpu;
    private long totalEventsDuration;
    private Comparator<Map.Entry<GcEventType, StatData>> SORT_BY_TOTAL_DURATION = new Comparator<Map.Entry<GcEventType, StatData>>(){

        @Override
        public int compare(Map.Entry<GcEventType, StatData> o1, Map.Entry<GcEventType, StatData> o2) {
            long duration1 = o1.getValue().totalDuration;
            long duration2 = o2.getValue().totalDuration;
            return duration1 < duration2 ? 1 : (duration1 > duration2 ? -1 : 0);
        }
    };
    private Comparator<Map.Entry<GcEventType, StatData>> SORT_BY_TOTAL_CPU = new Comparator<Map.Entry<GcEventType, StatData>>(){

        @Override
        public int compare(Map.Entry<GcEventType, StatData> o1, Map.Entry<GcEventType, StatData> o2) {
            long cpu1 = o1.getValue().totalCpu;
            long cpu2 = o2.getValue().totalCpu;
            return cpu1 < cpu2 ? 1 : (cpu1 > cpu2 ? -1 : 0);
        }
    };

    private static void setColor(GcEventType type, int index, int color) {
        GcReportDurationByEventType.eventTypeOrder[index] = type;
        GcReportDurationByEventType.colors[type.ordinal()] = color;
    }

    private static void initColors() {
        colors = new int[GcEventType.values().length];
        eventTypeOrder = new GcEventType[GcEventType.values().length];
        int i = 0;
        GcReportDurationByEventType.setColor(GcEventType.PARALLEL_GC_SCAVENGE, i++, 12116136);
        GcReportDurationByEventType.setColor(GcEventType.PARALLEL_NEW_GC, i++, 12116136);
        GcReportDurationByEventType.setColor(GcEventType.SERIAL_NEW_GC, i++, 12116136);
        GcReportDurationByEventType.setColor(GcEventType.G1_INCREMENTAL_GC, i++, 12116136);
        GcReportDurationByEventType.setColor(GcEventType.CMS_INITIAL_MARKING, i++, 0xFFEECC);
        GcReportDurationByEventType.setColor(GcEventType.CMS_MARKING, i++, 16769446);
        GcReportDurationByEventType.setColor(GcEventType.CMS_PRECLEANING, i++, 16569217);
        GcReportDurationByEventType.setColor(GcEventType.CMS_ABORTABLE_PRECLEANING, i++, 16237662);
        GcReportDurationByEventType.setColor(GcEventType.CMS_FINAL_MARKING, i++, 15246880);
        GcReportDurationByEventType.setColor(GcEventType.CMS_SWEEPING, i++, 14390795);
        GcReportDurationByEventType.setColor(GcEventType.G1_INITIAL_MARKING, i++, 0xFFEECC);
        GcReportDurationByEventType.setColor(GcEventType.G1_ROOT_SCANNING, i++, 16769446);
        GcReportDurationByEventType.setColor(GcEventType.G1_MARKING, i++, 16569217);
        GcReportDurationByEventType.setColor(GcEventType.G1_FINAL_MARKING, i++, 16237662);
        GcReportDurationByEventType.setColor(GcEventType.G1_COUNTING, i++, 15246880);
        GcReportDurationByEventType.setColor(GcEventType.G1_CLEANUP, i++, 14390795);
        GcReportDurationByEventType.setColor(GcEventType.G1_CONCURRENT_CLEANUP, i++, 15775038);
        GcReportDurationByEventType.setColor(GcEventType.G1_BITMAP_CLEARING, i++, 12747008);
        GcReportDurationByEventType.setColor(GcEventType.ALL_GEN_REF_HANDLING, i++, 12771058);
        GcReportDurationByEventType.setColor(GcEventType.YOUNG_GEN_REF_HANDLING, i++, 9288153);
        GcReportDurationByEventType.setColor(GcEventType.PARTIAL_REF_HANDLING, i++, 7511999);
        GcReportDurationByEventType.setColor(GcEventType.OLD_GEN_REF_HANDLING, i++, 7511999);
        GcReportDurationByEventType.setColor(GcEventType.CLASSUNLOADING_PHASE1, i++, 10826925);
        GcReportDurationByEventType.setColor(GcEventType.CLASSUNLOADING_PHASE2, i++, 6624619);
        GcReportDurationByEventType.setColor(GcEventType.G1_MARK_SWEEP_GC, i++, 15905962);
        GcReportDurationByEventType.setColor(GcEventType.G1_PARALLEL_FULL_GC, i++, 15905962);
        GcReportDurationByEventType.setColor(GcEventType.TENURED_GC, i++, 15905962);
        GcReportDurationByEventType.setColor(GcEventType.PARALLEL_GC_PARALLEL_COMPACT, i++, 15905962);
        GcReportDurationByEventType.setColor(GcEventType.PARALLEL_GC_MARK_SWEEP, i++, 15905962);
        GcReportDurationByEventType.setColor(GcEventType.PARALLEL_GC_SMALL_FORCED_FULL_GC, i++, 15905962);
        GcReportDurationByEventType.setColor(GcEventType.YOUNG_GEN_PROMOTION_FAILURE, i++, 0);
        GcReportDurationByEventType.setColor(GcEventType.G1_MARKING_ABORTED, i++, 0);
        GcReportDurationByEventType.setColor(GcEventType.CMS_ABORTED, i++, 0);
        GcReportDurationByEventType.setColor(GcEventType.SKIPPED_G1_INCREMENTAL_GC, i++, 0);
        GcReportDurationByEventType.setColor(GcEventType.SKIPPED_G1_MARK_SWEEP_GC, i++, 0);
        GcReportDurationByEventType.setColor(GcEventType.SKIPPED_G1_PARALLEL_FULL_GC, i++, 0);
        GcReportDurationByEventType.setColor(GcEventType.SKIPPED_PARALLEL_GC_MARK_SWEEP, i++, 0);
        GcReportDurationByEventType.setColor(GcEventType.SKIPPED_PARALLEL_GC_PARALLEL_COMPACT, i++, 0);
        GcReportDurationByEventType.setColor(GcEventType.SKIPPED_PARALLEL_GC_SCAVENGE, i++, 0);
        GcReportDurationByEventType.setColor(GcEventType.SKIPPED_PARALLEL_NEW_GC, i++, 0);
        GcReportDurationByEventType.setColor(GcEventType.SKIPPED_SERIAL_NEW_GC, i++, 0);
        GcReportDurationByEventType.setColor(GcEventType.SKIPPED_TENURED_GC, i++, 0);
        if (i != GcEventType.values().length) {
            EnumSet<GcEventType> unhandledTypes = EnumSet.allOf(GcEventType.class);
            for (int j = 0; j < i; ++j) {
                unhandledTypes.remove(eventTypeOrder[j]);
            }
            Iterator<GcEventType> it = unhandledTypes.iterator();
            StringBuilder message = new StringBuilder("Not all eventtypes recognized by GcReportDurationByEventType (only " + i + " of " + GcEventType.values().length + "). Missing: " + it.next());
            it.forEachRemaining(type -> message.append(", " + type));
            Trace.error((String)message.toString());
            for (GcEventType t : unhandledTypes) {
                GcReportDurationByEventType.setColor(t, i++, 0);
            }
        }
    }

    @Override
    public void handle(GcStatistic statistic) {
        for (GcEventBase current : statistic.getEvents()) {
            if (!(current instanceof GcDurationEventBase)) continue;
            GcDurationEventBase event = (GcDurationEventBase)current;
            GcEventType type = event.getGcEventType();
            StatData data = this.dataMap.get(type);
            if (data == null) {
                data = new StatData();
                this.dataMap.put(type, data);
            }
            ++data.count;
            long cpu = event.getCpuTime();
            long duration = event.getDuration();
            this.totalEventsCpu += cpu;
            this.totalEventsDuration += duration;
            data.totalCpu += cpu;
            if (data.maxCpu < cpu) {
                data.maxCpu = cpu;
            }
            data.totalDuration += duration;
            if (data.maxDuration >= duration) continue;
            data.maxDuration = duration;
        }
    }

    @Override
    public String getReportTitle() {
        return I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"GC Duration by Event Type");
    }

    @Override
    public GcReportNode getReport() {
        int i;
        long val;
        long othersSum;
        long val2;
        ArrayList<Map.Entry<GcEventType, StatData>> data = new ArrayList<Map.Entry<GcEventType, StatData>>(this.dataMap.entrySet());
        String[] headings = new String[]{I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"GC Event Type"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Total"), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Max."), I18n._ts((I18n.TextType)I18n.TextType.XCOL, (String)"Avg.")};
        int rows = data.size();
        int columns = headings.length;
        data.sort(this.SORT_BY_TOTAL_DURATION);
        int[] colAlignment = new int[columns];
        int[] headerAlignment = new int[columns];
        colAlignment[0] = -1;
        headerAlignment[0] = -1;
        for (int i2 = 1; i2 < columns; ++i2) {
            colAlignment[i2] = 1;
            headerAlignment[i2] = 0;
        }
        long onePercent = this.totalEventsDuration / 100L;
        int othersCount = 0;
        for (othersSum = 0L; rows - othersCount > 4 && othersSum < onePercent && (val2 = ((StatData)((Map.Entry)data.get((int)(rows - (othersCount + 1)))).getValue()).totalDuration) <= onePercent; othersSum += val2) {
            ++othersCount;
        }
        if (othersCount < 2) {
            othersCount = 0;
        }
        GcReportNode.PieChart durationPie = new GcReportNode.PieChart(I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"GC Duration by Event Type"));
        GcReportNode[][] content = new GcReportNode[rows][columns];
        long[] pieData = new long[GcEventType.values().length];
        StringBuilder pieAltTag = new StringBuilder(durationPie.getTitle());
        pieAltTag.append(": ");
        int row = 0;
        for (int i3 = 0; i3 < rows; ++i3) {
            Map.Entry entry = (Map.Entry)data.get(i3);
            GcReportNode[] line = new GcReportNode[columns];
            line[0] = new GcReportNode.Text(((GcEventType)entry.getKey()).getShortDescrDisplay());
            StatData value = (StatData)entry.getValue();
            long val3 = value.totalDuration;
            double percentage = this.totalEventsDuration == 0L ? 0.0 : (double)val3 / (double)this.totalEventsDuration;
            line[1] = new GcReportNode.MultiChildNode(new GcReportNode.Text(DataFormatter.getMicrosDurationText((long)val3)), new GcReportNode.Text(" "), new GcReportNode.PercentageBar(percentage, 12636400));
            line[2] = new GcReportNode.Text(DataFormatter.getMicrosDurationText((long)value.maxDuration));
            line[3] = new GcReportNode.Text(DataFormatter.getMicrosDurationText((long)(val3 / value.count)));
            content[row] = line;
            ++row;
            int legendColor = 0xB0B0B0;
            if (othersCount < 2 || i3 < rows - othersCount) {
                pieData[((GcEventType)entry.getKey()).ordinal()] = val3;
                legendColor = colors[((GcEventType)entry.getKey()).ordinal()];
            }
            GcReportNode.LegendBox colorNode = new GcReportNode.LegendBox(legendColor);
            line[0] = new GcReportNode.MultiChildNode(colorNode, new GcReportNode.Text(" "), line[0]);
        }
        boolean first = true;
        for (int i4 = 0; i4 < pieData.length; ++i4) {
            int index = eventTypeOrder[i4].ordinal();
            if (pieData[index] == 0L) continue;
            durationPie.addValue(pieData[index], eventTypeOrder[i4].getShortDescrDisplay(), colors[index]);
            if (!first) {
                pieAltTag.append(", ");
            }
            first = false;
            pieAltTag.append(eventTypeOrder[i4].getShortDescrDisplay());
            pieAltTag.append(" ");
            double percentage = (double)pieData[index] / (double)this.totalEventsDuration;
            pieAltTag.append(DataFormatter.getPercentage((double)percentage));
        }
        if (othersCount > 1) {
            durationPie.addValue(othersSum, I18n._s((String)"Others"), 0xB0B0B0);
            pieAltTag.append(", ");
            pieAltTag.append(I18n._s((String)"Others"));
            pieAltTag.append(" ");
            double percentage = (double)othersSum / (double)this.totalEventsDuration;
            pieAltTag.append(DataFormatter.getPercentage((double)percentage));
        }
        durationPie.setAltTag(pieAltTag.toString());
        GcReportNode.Table durationsTable = new GcReportNode.Table(headings, null, headerAlignment, colAlignment, true, false, -1, content);
        data.sort(this.SORT_BY_TOTAL_CPU);
        GcReportNode.PieChart cpuPie = new GcReportNode.PieChart(I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"CPU Time by Event Type"));
        onePercent = this.totalEventsCpu / 100L;
        othersCount = 0;
        for (othersSum = 0L; rows - othersCount > 4 && othersSum < onePercent && (val = ((StatData)((Map.Entry)data.get((int)(rows - (othersCount + 1)))).getValue()).totalCpu) <= onePercent; othersSum += val) {
            ++othersCount;
        }
        if (othersCount < 2) {
            othersCount = 0;
        }
        content = new GcReportNode[rows][columns];
        pieData = new long[GcEventType.values().length];
        pieAltTag = new StringBuilder(cpuPie.getTitle());
        pieAltTag.append(": ");
        row = 0;
        for (i = 0; i < rows; ++i) {
            Map.Entry entry = (Map.Entry)data.get(i);
            GcReportNode[] line = new GcReportNode[columns];
            line[0] = new GcReportNode.Text(((GcEventType)entry.getKey()).getShortDescrDisplay());
            StatData value = (StatData)entry.getValue();
            long val4 = value.totalCpu;
            double percentage = this.totalEventsCpu == 0L ? 0.0 : (double)val4 / (double)this.totalEventsCpu;
            line[1] = new GcReportNode.MultiChildNode(new GcReportNode.Text(DataFormatter.getMicrosDurationText((long)val4)), new GcReportNode.Text(" "), new GcReportNode.PercentageBar(percentage, 12636400));
            line[2] = new GcReportNode.Text(DataFormatter.getMicrosDurationText((long)value.maxCpu));
            line[3] = new GcReportNode.Text(DataFormatter.getMicrosDurationText((long)(val4 / value.count)));
            content[row] = line;
            ++row;
            int legendColor = 0xB0B0B0;
            if (othersCount < 2 || i < rows - othersCount) {
                pieData[((GcEventType)entry.getKey()).ordinal()] = val4;
                legendColor = colors[((GcEventType)entry.getKey()).ordinal()];
            }
            GcReportNode.LegendBox colorNode = new GcReportNode.LegendBox(legendColor);
            line[0] = new GcReportNode.MultiChildNode(colorNode, new GcReportNode.Text(" "), line[0]);
        }
        first = true;
        for (i = 0; i < pieData.length; ++i) {
            int index = eventTypeOrder[i].ordinal();
            if (pieData[index] == 0L) continue;
            cpuPie.addValue(pieData[index], eventTypeOrder[i].getShortDescrDisplay(), colors[index]);
            if (!first) {
                pieAltTag.append(", ");
            }
            first = false;
            pieAltTag.append(eventTypeOrder[i].getShortDescrDisplay());
            pieAltTag.append(" ");
            double percentage = (double)pieData[index] / (double)this.totalEventsCpu;
            pieAltTag.append(DataFormatter.getPercentage((double)percentage));
        }
        if (othersCount > 1) {
            cpuPie.addValue(othersSum, I18n._s((String)"Others"), 0xB0B0B0);
            pieAltTag.append(", ");
            pieAltTag.append(I18n._s((String)"Others"));
            pieAltTag.append(" ");
            double percentage = (double)othersSum / (double)this.totalEventsCpu;
            pieAltTag.append(DataFormatter.getPercentage((double)percentage));
        }
        cpuPie.setAltTag(pieAltTag.toString());
        GcReportNode.Table cpuTable = new GcReportNode.Table(headings, null, headerAlignment, colAlignment, true, false, -1, content);
        return new GcReportNode.MultiChildNode(durationPie, new GcReportNode.Paragraph(durationsTable), cpuPie, new GcReportNode.Paragraph(cpuTable));
    }

    @Override
    public GcReportBuilder.Severity getSeverity() {
        return GcReportBuilder.Severity.GREEN;
    }

    static {
        GcReportDurationByEventType.initColors();
    }

    private class StatData {
        long count;
        long maxDuration;
        long totalDuration;
        long maxCpu;
        long totalCpu;

        private StatData() {
        }
    }
}

