/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc.report;

import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventCmsFinalMarking;
import com.sap.jvm.profiling.memory.event.GcEventCmsInitialMarking;
import com.sap.jvm.profiling.memory.event.GcEventG1Cleanup;
import com.sap.jvm.profiling.memory.event.GcEventG1FinalMarking;
import com.sap.jvm.profiling.memory.event.GcEventG1InitialMarking;
import com.sap.jvm.profiling.memory.event.GcEventGenerational;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcStatisticConcMarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcStatisticG1Gc;
import com.sap.jvm.profiling.memory.event.GcStatisticParallelGc;
import com.sap.jvm.profiling.memory.event.GcStatisticParallelNewGc;
import com.sap.jvm.profiling.memory.event.GcStatisticParallelOldGc;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import java.util.ArrayList;

public class GcReportExcessiveSwapping
implements GcReportBuilder {
    private static final double FULL_GC_SYSTEM_OVERHEAD_THRESHOLD = 2.0;
    private static final double PARTIAL_GC_SYSTEM_OVERHEAD_THRESHOLD = 4.0;
    private static final double RED_PERCENTAGE = 20.0;
    private static final double YELLOW_PERCENTAGE = 10.0;
    private int fullGcsOverLimit = 0;
    private int partialGcsOverLimit = 0;
    private int gcCountInspected = 0;
    private int gcCountFull = 0;
    private int gcCountPartial = 0;
    private int withPageFaultsCount = 0;
    private long pageFaultsTotal = 0L;
    private long majorPageFaultsTotal = 0L;
    private long minorPageFaultsTotal = 0L;
    private ArrayList<Long> gcsOverLimitIds = new ArrayList();
    private double loadTotal;
    private double maxLoad;

    @Override
    public void handle(GcStatistic statistic) {
        long duration = statistic.getDuration();
        if (duration < 500000L) {
            return;
        }
        GcType type = statistic.getGcType();
        boolean isConcurrent = type == GcType.CONC_MARK_SWEEP_GC && ((GcStatisticConcMarkSweepGc)statistic).isConcurrent() || type == GcType.GARBAGE_FIRST_GC && ((GcStatisticG1Gc)statistic).isConcurrent();
        int threadCount = 1;
        if (isConcurrent || statistic.isFullGc() && type != GcType.PARALLEL_OLD_GC) {
            threadCount = 1;
        } else if (type == GcType.CONC_MARK_SWEEP_GC) {
            threadCount = ((GcStatisticConcMarkSweepGc)statistic).getNrOfThreads();
        } else if (type == GcType.GARBAGE_FIRST_GC) {
            threadCount = ((GcStatisticG1Gc)statistic).getNrOfScavengeThreads();
        } else if (type == GcType.PARALLEL_GC) {
            threadCount = ((GcStatisticParallelGc)statistic).getNrOfScavengeThreads();
        } else if (type == GcType.PARALLEL_NEW_GC) {
            threadCount = ((GcStatisticParallelNewGc)statistic).getNrOfScavengeThreads();
        } else if (type == GcType.PARALLEL_OLD_GC) {
            threadCount = ((GcStatisticParallelOldGc)statistic).getNrOfScavengeThreads();
        }
        long gcWorkTime = statistic.getCpuTime() / (long)threadCount;
        long gcDuration = statistic.getDuration();
        if (statistic.isFullGc()) {
            ++this.gcCountFull;
            if ((double)gcDuration > 2.0 * (double)gcWorkTime) {
                ++this.fullGcsOverLimit;
                this.updateStatsForOverLimit(statistic);
            }
        } else {
            ++this.gcCountPartial;
            if ((double)gcDuration > 4.0 * (double)gcWorkTime) {
                ++this.partialGcsOverLimit;
                this.updateStatsForOverLimit(statistic);
            }
        }
        ++this.gcCountInspected;
    }

    private void updateStatsForOverLimit(GcStatistic gc) {
        this.gcsOverLimitIds.add(gc.getGcNr());
        if (gc.getPageFaults() > 0L) {
            ++this.withPageFaultsCount;
            this.pageFaultsTotal += gc.getPageFaults();
        }
        this.majorPageFaultsTotal += gc.getMajorPageFaults();
        this.minorPageFaultsTotal += gc.getMinorPageFaults();
        for (GcEventBase event : gc.getEvents()) {
            double[] load = null;
            if (event instanceof GcEventGenerational) {
                load = ((GcEventGenerational)event).getSystemLoadAverage();
            } else if (event instanceof GcEventCmsFinalMarking) {
                load = ((GcEventCmsFinalMarking)event).getSystemLoadAverage();
            } else if (event instanceof GcEventCmsInitialMarking) {
                load = ((GcEventCmsInitialMarking)event).getSystemLoadAverage();
            } else if (event instanceof GcEventG1Cleanup) {
                load = ((GcEventG1Cleanup)event).getSystemLoadAverage();
            } else if (event instanceof GcEventG1FinalMarking) {
                load = ((GcEventG1FinalMarking)event).getSystemLoadAverage();
            } else if (event instanceof GcEventG1InitialMarking) {
                load = ((GcEventG1InitialMarking)event).getSystemLoadAverage();
            }
            if (load == null) continue;
            this.loadTotal += load[0];
            this.maxLoad = Math.max(load[0], this.maxLoad);
        }
    }

    @Override
    public String getReportTitle() {
        return I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"Excessive Swapping");
    }

    @Override
    public GcReportNode getReport() {
        ArrayList<GcReportNode> lines = new ArrayList<GcReportNode>();
        int overLimit = this.fullGcsOverLimit + this.partialGcsOverLimit;
        double percentageFull = this.gcCountFull == 0 ? 0.0 : 100.0 * (double)this.fullGcsOverLimit / (double)this.gcCountFull;
        double percentagePartial = this.gcCountPartial == 0 ? 0.0 : 100.0 * (double)this.partialGcsOverLimit / (double)this.gcCountPartial;
        double percentagePageFaults = overLimit == 0 ? 0.0 : 100.0 * (double)this.withPageFaultsCount / (double)overLimit;
        lines.add(new GcReportNode.ComposedText(I18n._ssn((String)"The elapsed time of {0} GC was much longer than expected.\nThis may be caused by swapping or high system load.", (String)"The elapsed time of {0} GCs was much longer than expected.\nThis may be caused by swapping or high system load.", (int)overLimit), GcReportNode.getNumber(overLimit, this.getSeverity() == GcReportBuilder.Severity.RED)));
        lines.add(new GcReportNode.ComposedText(I18n._s((String)"{0} of the inspected long running full GCs were affected."), GcReportNode.getPercentage(percentageFull, false)));
        lines.add(new GcReportNode.ComposedText(I18n._s((String)"{0} of the inspected long running partial GCs were affected."), GcReportNode.getPercentage(percentagePartial, false)));
        lines.add(new GcReportNode.Text(""));
        lines.add(new GcReportNode.ComposedText(I18n._s((String)"Page faults were triggered in {0} ({1}) of these {2} GCs."), GcReportNode.getNumber(this.withPageFaultsCount, false), GcReportNode.getPercentage(percentagePageFaults, false), GcReportNode.getNumber(overLimit, false)));
        if (this.majorPageFaultsTotal + this.minorPageFaultsTotal > 0L) {
            double majorAvg = (double)this.majorPageFaultsTotal / (double)this.withPageFaultsCount;
            double minorAvg = (double)this.minorPageFaultsTotal / (double)this.withPageFaultsCount;
            lines.add(new GcReportNode.ComposedText(I18n._s((String)"On average, there were {0} major and {1} minor page faults."), GcReportNode.getValueText(DataFormatter.getNumberText((double)majorAvg, (int)0), false), GcReportNode.getValueText(DataFormatter.getNumberText((double)minorAvg, (int)0), false)));
        } else if (this.pageFaultsTotal > 0L) {
            double faultAvg = (double)this.pageFaultsTotal / (double)this.withPageFaultsCount;
            lines.add(new GcReportNode.ComposedText(I18n._s((String)"On average, there were {0} page faults."), GcReportNode.getValueText(DataFormatter.getNumberText((double)faultAvg, (int)1), false)));
        }
        double loadAvg = this.loadTotal / (double)overLimit;
        lines.add(new GcReportNode.ComposedText(I18n._s((String)"During these GCs the average system load was {0}, maximum was {1}."), GcReportNode.getValueText(DataFormatter.getNumberText((double)loadAvg, (int)1), false), GcReportNode.getValueText(DataFormatter.getNumberText((double)this.maxLoad, (int)1), false)));
        lines.add(new GcReportNode.Text(""));
        lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"See the filtered {0} statistic for a list of suspicious GCs."), new GcReportNode.Link("gc_report_gc_statistic", GcReportNode.getOptionString(this.gcsOverLimitIds), new GcReportNode.Text("Garbage Collections"))));
        lines.add(new GcReportNode.Text(""));
        lines.add(new GcReportNode.MultiChildNode(new GcReportNode.FormattedText(I18n._s((String)"Explanation: "), true, true, -1, 0x808080), new GcReportNode.FormattedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"The expected elapsed time of a GC is the (user mode) CPU time reported for this GC divided by the number of GC threads.\nGCs are reported when their elapsed time is longer than {0} times the expected time (or {1} times for full GCs).\nThis suggests that the operating system was busy in kernel mode, e.g. handling page faults.", (Object[])new Object[]{4.0, 2.0}), false, true, -1, 0x808080)));
        return new GcReportNode.Paragraph(lines.toArray(new GcReportNode[lines.size()]));
    }

    @Override
    public GcReportBuilder.Severity getSeverity() {
        double percentage;
        int overLimit = this.fullGcsOverLimit + this.partialGcsOverLimit;
        if (this.gcCountInspected == 0 || overLimit == 0) {
            return GcReportBuilder.Severity.NOTHING;
        }
        if (overLimit < 5) {
            return this.gcCountInspected < overLimit * 2 ? GcReportBuilder.Severity.YELLOW : GcReportBuilder.Severity.GREEN;
        }
        double d = percentage = this.gcCountInspected == 0 ? 0.0 : 100.0 * (double)(this.fullGcsOverLimit + this.partialGcsOverLimit) / (double)this.gcCountInspected;
        return percentage > 20.0 ? GcReportBuilder.Severity.RED : (percentage > 10.0 ? GcReportBuilder.Severity.YELLOW : GcReportBuilder.Severity.GREEN);
    }
}

