/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc.report;

import com.sap.jvm.profiling.ProfilingSession;
import com.sap.jvm.profiling.core.event.SystemInfo;
import com.sap.jvm.profiling.i18n.DataFormatter;
import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshotProperties;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.regex.Pattern;

public class GcReportGcConfigurationIssues
implements GcReportBuilder {
    private SystemInfo systemInfo;
    private boolean hasMeta;
    private int nrOfStopTheWorldGcThreads;
    private int nrOfConcurrentGcThreads;
    private long javaHeapSize;
    private long youngSize;
    private long oldSize;
    private long permGenSize;
    private long maxCommittedMeta;
    private int nrOfCpus;
    private GcSnapshotProperties snapshotProperties;
    private HashSet<String> duplicateArguments = new HashSet();
    private HashSet<String> ambiguousArguments = new HashSet();
    private static Pattern[] patterns = new Pattern[]{GcReportGcConfigurationIssues.pref("-Xmn"), GcReportGcConfigurationIssues.pref("-Xms"), GcReportGcConfigurationIssues.pref("-Xmx"), GcReportGcConfigurationIssues.pref("-Xss"), GcReportGcConfigurationIssues.pref("-Xps"), GcReportGcConfigurationIssues.pref("-verbose:"), GcReportGcConfigurationIssues.pref("-Xloggc:"), GcReportGcConfigurationIssues.pref("-Xtrace"), GcReportGcConfigurationIssues.opt("GC"), GcReportGcConfigurationIssues.opt("CMS"), GcReportGcConfigurationIssues.opt("G1"), GcReportGcConfigurationIssues.opt("ParNew"), GcReportGcConfigurationIssues.opt("ParallelOld"), GcReportGcConfigurationIssues.opt("OldGen"), GcReportGcConfigurationIssues.opt("YoungGen"), GcReportGcConfigurationIssues.opt("PermGen"), GcReportGcConfigurationIssues.opt("Gen[01]"), GcReportGcConfigurationIssues.opt("Heap"), GcReportGcConfigurationIssues.opt("Mark"), GcReportGcConfigurationIssues.opt("Memory"), GcReportGcConfigurationIssues.opt("Meta"), GcReportGcConfigurationIssues.opt("Prefetch"), GcReportGcConfigurationIssues.opt("Size"), GcReportGcConfigurationIssues.opt("Scavenge"), GcReportGcConfigurationIssues.opt("SoftRef"), GcReportGcConfigurationIssues.opt("RefProc"), GcReportGcConfigurationIssues.opt("RefDiscovery"), GcReportGcConfigurationIssues.opt("Revisit"), GcReportGcConfigurationIssues.opt("Space"), GcReportGcConfigurationIssues.opt("Survivor"), GcReportGcConfigurationIssues.opt("Tenur"), GcReportGcConfigurationIssues.opt("Page"), GcReportGcConfigurationIssues.opt("Promot"), GcReportGcConfigurationIssues.opt("Adaptive"), GcReportGcConfigurationIssues.opt("FootPrint"), GcReportGcConfigurationIssues.opt("FLS"), GcReportGcConfigurationIssues.opt("NUMA"), GcReportGcConfigurationIssues.opt("PLAB"), GcReportGcConfigurationIssues.opt("RAM"), GcReportGcConfigurationIssues.opt("TLAB"), GcReportGcConfigurationIssues.opt("TLCA"), GcReportGcConfigurationIssues.opt("CompressedOops"), GcReportGcConfigurationIssues.opt("PausePadding"), GcReportGcConfigurationIssues.opt("ThresholdTolerance"), GcReportGcConfigurationIssues.opt("WorkStealing"), GcReportGcConfigurationIssues.opt("ServerClass"), GcReportGcConfigurationIssues.opt("PreTouch"), GcReportGcConfigurationIssues.opt("BlockOffsetArray"), GcReportGcConfigurationIssues.opt("RememberedSet"), GcReportGcConfigurationIssues.opt("ObjectStart")};

    private static Pattern pref(String prefix) {
        return Pattern.compile(prefix + ".*");
    }

    private static Pattern opt(String pattern) {
        return Pattern.compile("-XX:.*" + pattern + ".*");
    }

    public GcReportGcConfigurationIssues(ProfilingSession session, GcSnapshot snapshot) {
        this.systemInfo = session.getSystemInfo();
        this.snapshotProperties = snapshot.getProperties();
        this.hasMeta = this.systemInfo.hasMetaspace();
        this.nrOfStopTheWorldGcThreads = session.getNumberOfGCThreads();
        this.nrOfConcurrentGcThreads = session.getNumberOfConcurrentGCThreads();
        this.javaHeapSize = session.getReservedJavaHeapSize();
        if (this.javaHeapSize == -1L) {
            this.javaHeapSize = this.systemInfo.getMaxHeapSize();
        }
        this.permGenSize = session.getReservedPermGenSize();
        this.oldSize = this.snapshotProperties.getMaxOldGenSize();
        if (this.oldSize == -1L) {
            this.youngSize = this.snapshotProperties.getMaxYoungGenSize();
            if (this.youngSize != -1L) {
                this.oldSize = this.javaHeapSize - this.youngSize;
            }
        } else {
            this.youngSize = this.javaHeapSize - this.oldSize;
        }
        HashMap<String, String> foundKeyValues = new HashMap<String, String>();
        for (String option : this.systemInfo.getVmArguments()) {
            int equalsIndex;
            if (!this.isRelevant(option)) continue;
            if (option.startsWith("-XX:ParallelGCThreads")) {
                String valueString = option.substring(option.indexOf(61) + 1).trim();
                int configuredGcThreads = Integer.parseInt(valueString);
                if (this.nrOfStopTheWorldGcThreads == -1) {
                    this.nrOfStopTheWorldGcThreads = configuredGcThreads;
                }
                assert (this.nrOfStopTheWorldGcThreads == configuredGcThreads);
            }
            String key = null;
            key = this.isSwitch(option) ? this.getSwitchName(option) : ((equalsIndex = option.indexOf(61)) > 0 ? option.substring(0, equalsIndex) : option);
            String lastValue = (String)foundKeyValues.get(key);
            if (lastValue != null) {
                this.duplicateArguments.add(lastValue);
                if (lastValue.equals(option)) continue;
                this.ambiguousArguments.add(lastValue);
                this.ambiguousArguments.add(option);
                continue;
            }
            foundKeyValues.put(key, option);
        }
        this.nrOfCpus = this.systemInfo.getNrOfCpus();
    }

    @Override
    public void handle(GcStatistic statistic) {
        if (this.hasMeta) {
            this.maxCommittedMeta = Math.max(this.maxCommittedMeta, statistic.getCommittedBytesInPermBeforeGc());
        }
    }

    @Override
    public String getReportTitle() {
        return I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"GC Configuration");
    }

    @Override
    public GcReportNode getReport() {
        ArrayList<GcReportNode> lines = new ArrayList<GcReportNode>();
        if (this.snapshotProperties.getGcType() != GcType.GARBAGE_FIRST_GC) {
            lines.add(this.getMemoryLayoutBar());
        }
        lines.add(this.getConfigTable());
        ArrayList<GcReportNode> options = new ArrayList<GcReportNode>();
        for (String option : this.systemInfo.getVmArguments()) {
            if (!this.isRelevant(option)) continue;
            if (this.ambiguousArguments.contains(option)) {
                options.add(new GcReportNode.MultiChildNode(new GcReportNode.FormattedText(option, false, false, 0, 0xFF0000), new GcReportNode.FormattedText("   " + I18n._s((String)"(ambiguous!)"), true, false, 0, 0xFF0000)));
                continue;
            }
            if (this.duplicateArguments.contains(option)) {
                options.add(new GcReportNode.MultiChildNode(new GcReportNode.FormattedText(option, false, false, 0, 0xFF0000), new GcReportNode.FormattedText("   " + I18n._s((String)"(duplicate!)"), true, false, 0, 0xFF0000)));
                continue;
            }
            options.add(new GcReportNode.Text(option));
        }
        String noteTitle = I18n._s((String)"GC and memory related VM arguments:");
        GcReportNode.Note note = new GcReportNode.Note(noteTitle, options.toArray(new GcReportNode[options.size()]));
        lines.add(note);
        return new GcReportNode.MultiChildNode(lines.toArray(new GcReportNode[lines.size()]));
    }

    private GcReportNode.AccBarChart getMemoryLayoutBar() {
        String young = DataFormatter.getNrOfBytesText((long)this.youngSize);
        String old = DataFormatter.getNrOfBytesText((long)this.oldSize);
        long perm_meta_size = this.hasMeta ? this.maxCommittedMeta : this.permGenSize;
        String perm_meta = DataFormatter.getNrOfBytesText((long)perm_meta_size);
        String altTag = this.hasMeta ? I18n._s((String)"Memory Layout: young generation {0}, old generation {1}, maximum committed in meta space {2}.", (Object[])new Object[]{young, old, perm_meta}) : I18n._s((String)"Memory Layout: young generation {0}, old generation {1}, permanent generation {2}.", (Object[])new Object[]{young, old, perm_meta});
        GcReportNode.AccBarChart memLayoutBar = new GcReportNode.AccBarChart(I18n._s((String)"Memory Layout"), altTag, this.javaHeapSize + perm_meta_size, true);
        memLayoutBar.addValue(this.youngSize, null, I18n._s((String)"Young: {0}", (Object[])new Object[]{young}));
        memLayoutBar.addValue(this.oldSize, null, I18n._s((String)"Old: {0}", (Object[])new Object[]{old}));
        memLayoutBar.addValue(perm_meta_size, null, this.hasMeta ? I18n._s((String)"Meta: {0}", (Object[])new Object[]{perm_meta}) : I18n._s((String)"Perm: {0}", (Object[])new Object[]{perm_meta}));
        return memLayoutBar;
    }

    private GcReportNode getConfigTable() {
        String[] headings = null;
        double[] relativeWidths = new double[]{7.0, 2.0};
        int[] colAlignment = new int[]{-1, -1};
        int[] headerAlignment = new int[]{0, 0};
        int row = 0;
        int rows = 5;
        if (this.nrOfStopTheWorldGcThreads >= 0) {
            ++rows;
        }
        if (this.nrOfConcurrentGcThreads >= 0) {
            ++rows;
        }
        GcReportNode[][] content = new GcReportNode[rows][2];
        content[row][0] = new GcReportNode.Text(I18n._s((String)"VM Version"));
        content[row][1] = GcReportNode.getValueText(this.systemInfo.getVmName() + " " + this.systemInfo.getVmRelease(), false);
        content[++row][0] = new GcReportNode.Text(I18n._s((String)"GC Type"));
        GcType gcType = this.snapshotProperties.getGcType();
        content[row][1] = GcReportNode.getValueText(gcType != null ? gcType.getDisplayName() : I18n._s((String)"Unknown"), false);
        content[++row][0] = new GcReportNode.Text(I18n._s((String)"Maximum Java heap size"));
        content[row][1] = GcReportNode.getNrOfBytes(this.javaHeapSize, false);
        content[++row][0] = new GcReportNode.Text(this.hasMeta ? I18n._s((String)"Maximum Meta space size") : I18n._s((String)"Maximum Permanent generation size"));
        content[row][1] = GcReportNode.getNrOfBytes(this.permGenSize, false);
        content[++row][0] = new GcReportNode.Text(I18n._s((String)"Number of CPUs"));
        content[row][1] = new GcReportNode.FormattedText(DataFormatter.getNumberText((long)this.nrOfCpus), true, false, 0);
        ++row;
        if (this.nrOfStopTheWorldGcThreads >= 0) {
            content[row][0] = new GcReportNode.Text(I18n._s((String)"Configured number of parallel GC threads"));
            if (this.nrOfStopTheWorldGcThreads > this.nrOfCpus) {
                relativeWidths[1] = relativeWidths[0];
                content[row][1] = GcReportNode.getValueText(I18n._s((String)"{0} (this is larger than the number of available CPUs!)", (Object[])new Object[]{this.nrOfStopTheWorldGcThreads}), true);
            } else {
                content[row][1] = new GcReportNode.FormattedText(DataFormatter.getNumberText((long)this.nrOfStopTheWorldGcThreads), true, false, 0);
            }
            ++row;
        }
        if (this.nrOfConcurrentGcThreads >= 0) {
            content[row][0] = new GcReportNode.Text(I18n._s((String)"Number of GC worker threads used for concurrent garbage collection"));
            if (this.nrOfConcurrentGcThreads > this.nrOfCpus) {
                relativeWidths[1] = relativeWidths[0];
                content[row][1] = new GcReportNode.FormattedText(I18n._s((String)"{0} (this is larger than the number of available CPUs!)", (Object[])new Object[]{this.nrOfConcurrentGcThreads}), true, false, 0, 0xFF0000);
            } else {
                content[row][1] = new GcReportNode.FormattedText(DataFormatter.getNumberText((long)this.nrOfConcurrentGcThreads), true, false, 0);
            }
            ++row;
        }
        return new GcReportNode.Table(headings, null, headerAlignment, colAlignment, false, false, -1, content);
    }

    private boolean isRelevant(String option) {
        for (Pattern pattern : patterns) {
            if (!pattern.matcher(option).matches()) continue;
            return true;
        }
        return false;
    }

    private boolean isSwitch(String argument) {
        return argument.startsWith("-XX:+") || argument.startsWith("-XX:-");
    }

    private String getSwitchName(String argument) {
        assert (this.isSwitch(argument));
        return argument.substring(5);
    }

    @Override
    public GcReportBuilder.Severity getSeverity() {
        if (this.nrOfCpus < this.nrOfStopTheWorldGcThreads) {
            return GcReportBuilder.Severity.RED;
        }
        if (!this.ambiguousArguments.isEmpty()) {
            return GcReportBuilder.Severity.RED;
        }
        if (!this.duplicateArguments.isEmpty()) {
            return GcReportBuilder.Severity.YELLOW;
        }
        return GcReportBuilder.Severity.GREEN;
    }
}

