/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc.report;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.memory.event.GcStatisticConcMarkSweepGc;
import com.sap.jvm.profiling.memory.event.GcStatisticG1Gc;
import com.sap.jvm.profiling.memory.event.GcType;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshot;
import com.sap.jvm.profiling.snapshot.gc.GcSnapshotProperties;
import java.util.ArrayList;

public class GcReportLongRunningGcs
implements GcReportBuilder {
    public static final long RED_DURATION_THRESHOLD = 60000000L;
    public static final long YELLOW_DURATION_THRESHOLD = 30000000L;
    private GcSnapshotProperties snpProperties;
    private int redGCs = 0;
    private int yellowGCs = 0;

    public GcReportLongRunningGcs(GcSnapshot snapshot) {
        this.snpProperties = snapshot.getProperties();
    }

    @Override
    public void handle(GcStatistic statistic) {
        boolean isConcurrent;
        boolean bl = isConcurrent = statistic.getGcType() == GcType.CONC_MARK_SWEEP_GC && ((GcStatisticConcMarkSweepGc)statistic).isConcurrent() || statistic.getGcType() == GcType.GARBAGE_FIRST_GC && ((GcStatisticG1Gc)statistic).isConcurrent();
        if (!isConcurrent) {
            long duration = statistic.getDuration();
            if (duration > 60000000L) {
                ++this.redGCs;
            } else if (duration > 30000000L) {
                ++this.yellowGCs;
            }
        }
    }

    @Override
    public String getReportTitle() {
        return I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"Suspiciously Long Running GCs");
    }

    @Override
    public GcReportNode getReport() {
        ArrayList<GcReportNode.ComposedText> lines = new ArrayList<GcReportNode.ComposedText>();
        boolean red = this.redGCs > 0;
        long total = this.snpProperties.getNrOfGcsFull() + this.snpProperties.getNrOfGcsYoung();
        int count = red ? this.redGCs : this.yellowGCs;
        double percentage = 100.0 * (double)count / (double)total;
        GcReportNode threshold = GcReportNode.getDuration(red ? 60000000L : 30000000L, false);
        GcReportNode number = GcReportNode.getNumber(red ? (long)this.redGCs : (long)this.yellowGCs, red);
        GcReportNode percent = GcReportNode.getPercentage(percentage, false);
        lines.add(new GcReportNode.ComposedText(I18n._ssn((String)"{0} GC ({1}) was running longer than {2}.", (String)"{0} GCs ({1}) were running longer than {2}.", (int)count), number, percent, threshold));
        lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"See the {0} statistic for a list of GCs sorted by duration."), new GcReportNode.Link("gc_report_gc_statistic", null, new GcReportNode.Text("Garbage Collections"))));
        return new GcReportNode.Paragraph(lines.toArray(new GcReportNode[lines.size()]));
    }

    @Override
    public GcReportBuilder.Severity getSeverity() {
        if (this.redGCs > 0) {
            return GcReportBuilder.Severity.RED;
        }
        if (this.yellowGCs > 0) {
            return GcReportBuilder.Severity.YELLOW;
        }
        return GcReportBuilder.Severity.NOTHING;
    }
}

