/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc.report;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcCause;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import java.util.ArrayList;

public class GcReportMemoryShortage
implements GcReportBuilder {
    public static final int RED_SOFTREF_CLEAR_THRESHOLD = 1;
    public static final int YELLOW_SOFTREF_CLEAR_THRESHOLD = 0;
    private ArrayList<Long> gcsWithMemShortage = new ArrayList();
    private int memoryShortageCausedByJavaHeap;
    private int memoryShortageCausedByPermGen;
    private int memoryShortageCausedByMetaspace;
    private int fullGcCount;
    private int clusterCount;
    private int currentClusterSize;
    private int largestClusterSize;

    @Override
    public void handle(GcStatistic statistic) {
        if (statistic.isFullGc()) {
            ++this.fullGcCount;
            if (statistic.isForcedSoftRefClear()) {
                this.gcsWithMemShortage.add(statistic.getGcNr());
                if (statistic.getCause() != GcCause.FORCED_MAXIMUM_COMPACTION) {
                    if (statistic.getCause() == GcCause.PERMANENT_GENERATION_FULL) {
                        ++this.memoryShortageCausedByPermGen;
                    } else if (statistic.getCause() == GcCause.METASPACE_FULL || statistic.getCause() == GcCause.METADATA_GC_CLEAR_SOFT_REFS) {
                        ++this.memoryShortageCausedByMetaspace;
                    } else {
                        ++this.memoryShortageCausedByJavaHeap;
                    }
                }
                ++this.currentClusterSize;
                if (this.currentClusterSize == 2) {
                    ++this.clusterCount;
                }
                this.largestClusterSize = Math.max(this.largestClusterSize, this.currentClusterSize);
            } else {
                this.currentClusterSize = 0;
            }
        }
    }

    @Override
    public String getReportTitle() {
        return I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"Memory Shortage");
    }

    @Override
    public GcReportNode getReport() {
        int softRefClearCount = this.gcsWithMemShortage.size();
        ArrayList<GcReportNode> lines = new ArrayList<GcReportNode>();
        lines.add(new GcReportNode.ComposedText(I18n._ssn((String)"There was one full GC in this snapshot.", (String)"There were {0} full GCs in this snapshot.", (int)this.fullGcCount), GcReportNode.getNumber(this.fullGcCount, false)));
        if (this.fullGcCount > 1) {
            lines.add(new GcReportNode.ComposedText(I18n._ssn((String)"Clearing of soft references was forced in {0} full GC ({1}).", (String)"Clearing of soft references was forced in {0} full GCs ({1}).", (int)softRefClearCount), GcReportNode.getNumber(softRefClearCount, softRefClearCount > 1), GcReportNode.getPercentage(100.0 * (double)softRefClearCount / (double)this.fullGcCount, softRefClearCount > 1)));
        } else if (this.fullGcCount == 1 && softRefClearCount == 1) {
            lines.add(new GcReportNode.Text(I18n._s((String)"Clearing of soft references was forced for this full GC.")));
        }
        if (this.memoryShortageCausedByJavaHeap > 0) {
            if (this.memoryShortageCausedByPermGen == 0 && this.memoryShortageCausedByMetaspace == 0) {
                lines.add(new GcReportNode.Text(I18n._ssn((String)"The memory shortage was caused by insufficient Java heap.", (String)"All memory shortages were caused by insufficient Java heap.", (int)this.memoryShortageCausedByJavaHeap)));
            } else {
                lines.add(new GcReportNode.Text(I18n._ssn((String)"{0} memory shortage was caused by insufficient Java heap.", (String)"{0} memory shortages were caused by insufficient Java heap.", (int)this.memoryShortageCausedByJavaHeap, (Object[])new Object[]{this.memoryShortageCausedByJavaHeap})));
            }
        }
        if (this.memoryShortageCausedByPermGen > 0) {
            if (this.memoryShortageCausedByJavaHeap == 0) {
                lines.add(new GcReportNode.Text(I18n._ssn((String)"The memory shortage was caused by insufficient permanent generation space.", (String)"All memory shortages were caused by insufficient permanent generation space.", (int)this.memoryShortageCausedByJavaHeap)));
            } else {
                lines.add(new GcReportNode.Text(I18n._ssn((String)"{0} memory shortage was caused by insufficient permanent generation space.", (String)"{0} memory shortages were caused by insufficient permanent generation space.", (int)this.memoryShortageCausedByJavaHeap, (Object[])new Object[]{this.memoryShortageCausedByJavaHeap})));
            }
        }
        if (this.memoryShortageCausedByMetaspace > 0) {
            if (this.memoryShortageCausedByJavaHeap == 0) {
                lines.add(new GcReportNode.Text(I18n._ssn((String)"The memory shortage was caused by insufficient metaspace.", (String)"All memory shortages were caused by insufficient metaspace.", (int)this.memoryShortageCausedByJavaHeap)));
            } else {
                lines.add(new GcReportNode.Text(I18n._ssn((String)"{0} memory shortage was caused by insufficient metaspace.", (String)"{0} memory shortages were caused by insufficient metaspace.", (int)this.memoryShortageCausedByJavaHeap, (Object[])new Object[]{this.memoryShortageCausedByJavaHeap})));
            }
        }
        if (this.clusterCount == 1) {
            lines.add(new GcReportNode.Text(I18n._s((String)"{0} memory shortages occurred in a cluster, i.e. one directly after the other.", (Object[])new Object[]{this.largestClusterSize})));
        }
        if (this.clusterCount > 1) {
            lines.add(new GcReportNode.Text(I18n._s((String)"The memory shortages occurred in clusters, i.e. one directly after the other.\nThere were {0} clusters, the largest containing {1} successive GCs.", (Object[])new Object[]{this.clusterCount, this.largestClusterSize})));
        }
        if (softRefClearCount > 0) {
            lines.add(new GcReportNode.Text(""));
            lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"See the filtered {0} statistic for a list of full GCs with forced clearing of soft references."), new GcReportNode.Link("gc_report_gc_statistic", GcReportNode.getOptionString(this.gcsWithMemShortage), new GcReportNode.Text("Garbage Collections"))));
        }
        return new GcReportNode.Paragraph(lines.toArray(new GcReportNode[lines.size()]));
    }

    @Override
    public GcReportBuilder.Severity getSeverity() {
        if (this.fullGcCount == 0) {
            return GcReportBuilder.Severity.NOTHING;
        }
        return this.gcsWithMemShortage.size() > 1 ? GcReportBuilder.Severity.RED : (this.gcsWithMemShortage.size() > 0 ? GcReportBuilder.Severity.YELLOW : GcReportBuilder.Severity.GREEN);
    }
}

