/*
 * Decompiled with CFR 0.152.
 */
package com.sap.jvm.profiling.snapshot.impl.gc.report;

import com.sap.jvm.profiling.i18n.I18n;
import com.sap.jvm.profiling.memory.event.GcEventBase;
import com.sap.jvm.profiling.memory.event.GcEventYoungGenPromotionFailure;
import com.sap.jvm.profiling.memory.event.GcStatistic;
import com.sap.jvm.profiling.snapshot.gc.GcReportBuilder;
import com.sap.jvm.profiling.snapshot.gc.GcReportNode;
import java.util.ArrayList;

public class GcReportPromotionFailures
implements GcReportBuilder {
    public static final int RED_GCS_THRESHOLD = 1;
    public static final int YELLOW_GCS_THRESHOLD = 0;
    private int gcCount = 0;
    private int gcsWithPromotionFailure = 0;
    private long maxPause = 0L;

    @Override
    public void handle(GcStatistic statistic) {
        ++this.gcCount;
        for (GcEventBase event : statistic.getEvents()) {
            if (!(event instanceof GcEventYoungGenPromotionFailure)) continue;
            ++this.gcsWithPromotionFailure;
            this.maxPause = Math.max(this.maxPause, statistic.getDuration());
            break;
        }
    }

    @Override
    public String getReportTitle() {
        return I18n._ts((I18n.TextType)I18n.TextType.XTIT, (String)"Promotion Failures");
    }

    @Override
    public GcReportNode getReport() {
        ArrayList<GcReportNode.ComposedText> lines = new ArrayList<GcReportNode.ComposedText>();
        lines.add(new GcReportNode.ComposedText(I18n._s((String)"There were promotion failures in {0} of {1} GCs."), GcReportNode.getNumber(this.gcsWithPromotionFailure, this.gcsWithPromotionFailure > 1), GcReportNode.getNumber(this.gcCount, false)));
        if (this.gcCount > 0) {
            lines.add(new GcReportNode.ComposedText(I18n._s((String)"The maximum pause time of GCs with promotion failures was {0}."), GcReportNode.getDuration(this.maxPause, false)));
            lines.add(new GcReportNode.ComposedText(I18n._ts((I18n.TextType)I18n.TextType.YMSG, (String)"See the filtered {0} statistic for the list of GCs with promotion failures."), new GcReportNode.Link("gc_report_gc_statistic_promotion_failures", null, new GcReportNode.Text("Garbage Collections"))));
        }
        return new GcReportNode.Paragraph(lines.toArray(new GcReportNode[lines.size()]));
    }

    @Override
    public GcReportBuilder.Severity getSeverity() {
        return this.gcsWithPromotionFailure > 1 ? GcReportBuilder.Severity.RED : (this.gcsWithPromotionFailure > 0 ? GcReportBuilder.Severity.YELLOW : GcReportBuilder.Severity.NOTHING);
    }
}

